/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.population;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import zombie.ZomboidFileSystem;
import zombie.characters.HairOutfitDefinitions;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.population.BeardStyle;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.gameStates.ChooseGameInfo;

@XmlRootElement
public class BeardStyles {
    @XmlElement(name="style")
    public final ArrayList<BeardStyle> m_Styles = new ArrayList();
    @XmlTransient
    public static BeardStyles instance;

    public static void init() {
        instance = BeardStyles.Parse(ZomboidFileSystem.instance.base.getAbsolutePath() + File.separator + ZomboidFileSystem.processFilePath("media/hairStyles/beardStyles.xml", File.separatorChar));
        if (instance == null) {
            return;
        }
        BeardStyles.instance.m_Styles.add(0, new BeardStyle());
        for (String string : ZomboidFileSystem.instance.getModIDs()) {
            String string2;
            BeardStyles beardStyles;
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
            if (mod == null || (beardStyles = BeardStyles.Parse((string2 = ZomboidFileSystem.instance.getModDir(string)) + File.separator + ZomboidFileSystem.processFilePath("media/hairStyles/beardStyles.xml", File.separatorChar))) == null) continue;
            for (BeardStyle beardStyle : beardStyles.m_Styles) {
                BeardStyle beardStyle2 = instance.FindStyle(beardStyle.name);
                if (beardStyle2 == null) {
                    BeardStyles.instance.m_Styles.add(beardStyle);
                    continue;
                }
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.println("mod \"%s\" overrides beard \"%s\"", string, beardStyle.name);
                }
                int n = BeardStyles.instance.m_Styles.indexOf(beardStyle2);
                BeardStyles.instance.m_Styles.set(n, beardStyle);
            }
        }
    }

    public static void Reset() {
        if (instance == null) {
            return;
        }
        BeardStyles.instance.m_Styles.clear();
        instance = null;
    }

    public static BeardStyles Parse(String string) {
        try {
            return BeardStyles.parse(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | JAXBException throwable) {
            ExceptionLogger.logException(throwable);
        }
        return null;
    }

    public static BeardStyles parse(String string) throws JAXBException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{BeardStyles.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            BeardStyles beardStyles = (BeardStyles)unmarshaller.unmarshal((InputStream)fileInputStream);
            return beardStyles;
        }
    }

    public BeardStyle FindStyle(String string) {
        for (int i = 0; i < this.m_Styles.size(); ++i) {
            BeardStyle beardStyle = this.m_Styles.get(i);
            if (!beardStyle.name.equalsIgnoreCase(string)) continue;
            return beardStyle;
        }
        return null;
    }

    public String getRandomStyle(String string) {
        return HairOutfitDefinitions.instance.getRandomBeard(string, this.m_Styles);
    }

    public BeardStyles getInstance() {
        return instance;
    }

    public ArrayList<BeardStyle> getAllStyles() {
        return this.m_Styles;
    }
}

