/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model.jassimp;

import jassimp.AiBuiltInWrapperProvider;
import jassimp.AiMatrix4f;
import jassimp.AiMesh;
import jassimp.AiNode;
import jassimp.AiScene;
import jassimp.AiWrapperProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Matrix4f;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.model.AnimationAsset;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.VertexBufferObject;
import zombie.core.skinnedmodel.model.jassimp.ImportedSkeleton;
import zombie.core.skinnedmodel.model.jassimp.ImportedSkeletonParams;
import zombie.core.skinnedmodel.model.jassimp.ImportedSkinnedMesh;
import zombie.core.skinnedmodel.model.jassimp.ImportedStaticMesh;
import zombie.core.skinnedmodel.model.jassimp.JAssImpImporter;
import zombie.core.skinnedmodel.model.jassimp.ProcessedAiSceneParams;
import zombie.debug.DebugLog;
import zombie.util.StringUtils;

public final class ProcessedAiScene {
    private ImportedSkeleton skeleton;
    private ImportedSkinnedMesh skinnedMesh;
    private ImportedStaticMesh staticMesh;
    private Matrix4f transform = null;

    private ProcessedAiScene() {
    }

    public static ProcessedAiScene process(ProcessedAiSceneParams processedAiSceneParams) {
        ProcessedAiScene processedAiScene = new ProcessedAiScene();
        processedAiScene.processAiScene(processedAiSceneParams);
        return processedAiScene;
    }

    private void processAiScene(ProcessedAiSceneParams processedAiSceneParams) {
        ImportedSkeletonParams importedSkeletonParams;
        AiScene aiScene = processedAiSceneParams.scene;
        JAssImpImporter.LoadMode loadMode = processedAiSceneParams.mode;
        String string = processedAiSceneParams.meshName;
        AiMesh aiMesh = this.findMesh(aiScene, string);
        if (aiMesh == null) {
            DebugLog.General.error("No such mesh \"%s\"", string);
            return;
        }
        if (loadMode == JAssImpImporter.LoadMode.StaticMesh || !aiMesh.hasBones()) {
            this.staticMesh = new ImportedStaticMesh(aiMesh);
        } else {
            importedSkeletonParams = ImportedSkeletonParams.create(processedAiSceneParams, aiMesh);
            this.skeleton = ImportedSkeleton.process(importedSkeletonParams);
            if (loadMode != JAssImpImporter.LoadMode.AnimationOnly) {
                this.skinnedMesh = new ImportedSkinnedMesh(this.skeleton, aiMesh);
            }
        }
        if (this.staticMesh == null && this.skinnedMesh == null) {
            return;
        }
        importedSkeletonParams = new AiBuiltInWrapperProvider();
        AiNode aiNode = (AiNode)aiScene.getSceneRoot((AiWrapperProvider)importedSkeletonParams);
        AiNode aiNode2 = this.findParentNodeForMesh(aiScene.getMeshes().indexOf(aiMesh), aiNode);
        if (aiNode2 == null) {
            return;
        }
        this.transform = JAssImpImporter.getMatrixFromAiMatrix((AiMatrix4f)aiNode2.getTransform((AiWrapperProvider)importedSkeletonParams));
        for (AiNode aiNode3 = aiNode2.getParent(); aiNode3 != null; aiNode3 = aiNode3.getParent()) {
            Matrix4f matrix4f = JAssImpImporter.getMatrixFromAiMatrix((AiMatrix4f)aiNode3.getTransform((AiWrapperProvider)importedSkeletonParams));
            Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)this.transform, (Matrix4f)this.transform);
        }
    }

    private AiMesh findMesh(AiScene aiScene, String string) {
        AiMesh aiMesh3;
        if (aiScene.getNumMeshes() == 0) {
            return null;
        }
        if (StringUtils.isNullOrWhitespace(string)) {
            for (AiMesh aiMesh2 : aiScene.getMeshes()) {
                if (!aiMesh2.hasBones()) continue;
                return aiMesh2;
            }
            return (AiMesh)aiScene.getMeshes().get(0);
        }
        for (AiMesh aiMesh3 : aiScene.getMeshes()) {
            if (!aiMesh3.getName().equalsIgnoreCase(string)) continue;
            return aiMesh3;
        }
        AiBuiltInWrapperProvider aiBuiltInWrapperProvider = new AiBuiltInWrapperProvider();
        aiMesh3 = (AiNode)aiScene.getSceneRoot((AiWrapperProvider)aiBuiltInWrapperProvider);
        AiNode aiNode = JAssImpImporter.FindNode(string, (AiNode)aiMesh3);
        if (aiNode != null && aiNode.getNumMeshes() == 1) {
            int n = aiNode.getMeshes()[0];
            return (AiMesh)aiScene.getMeshes().get(n);
        }
        return null;
    }

    private AiNode findParentNodeForMesh(int n, AiNode aiNode) {
        for (int i = 0; i < aiNode.getNumMeshes(); ++i) {
            if (aiNode.getMeshes()[i] != n) continue;
            return aiNode;
        }
        for (AiNode aiNode2 : aiNode.getChildren()) {
            AiNode aiNode3 = this.findParentNodeForMesh(n, aiNode2);
            if (aiNode3 == null) continue;
            return aiNode3;
        }
        return null;
    }

    public void applyToMesh(ModelMesh modelMesh, JAssImpImporter.LoadMode loadMode, boolean bl, SkinningData skinningData) {
        Object object;
        Object object2;
        modelMesh.m_transform = null;
        if (this.transform != null) {
            modelMesh.m_transform = PZMath.convertMatrix(this.transform, new org.joml.Matrix4f());
        }
        if (this.staticMesh != null && !ModelManager.NoOpenGL) {
            modelMesh.minXYZ.set(this.staticMesh.minXYZ);
            modelMesh.maxXYZ.set(this.staticMesh.maxXYZ);
            modelMesh.m_bHasVBO = true;
            object2 = this.staticMesh.verticesUnskinned;
            object = this.staticMesh.elements;
            RenderThread.queueInvokeOnRenderContext(() -> ProcessedAiScene.lambda$applyToMesh$0(modelMesh, (VertexBufferObject.VertexArray)object2, (int[])object));
        }
        if (modelMesh.skinningData != null) {
            if (skinningData == null || modelMesh.skinningData.AnimationClips != skinningData.AnimationClips) {
                modelMesh.skinningData.AnimationClips.clear();
            }
            modelMesh.skinningData.InverseBindPose.clear();
            modelMesh.skinningData.BindPose.clear();
            modelMesh.skinningData.BoneOffset.clear();
            modelMesh.skinningData.BoneIndices.clear();
            modelMesh.skinningData.SkeletonHierarchy.clear();
            modelMesh.skinningData = null;
        }
        if (this.skeleton != null) {
            object2 = this.skeleton;
            object = ((ImportedSkeleton)object2).clips;
            if (skinningData != null) {
                ((ImportedSkeleton)object2).clips.clear();
                object = skinningData.AnimationClips;
            }
            JAssImpImporter.replaceHashMapKeys(((ImportedSkeleton)object2).boneIndices, "SkinningData.boneIndices");
            modelMesh.skinningData = new SkinningData((HashMap<String, AnimationClip>)object, (List<Matrix4f>)((ImportedSkeleton)object2).bindPose, (List<Matrix4f>)((ImportedSkeleton)object2).invBindPose, (List<Matrix4f>)((ImportedSkeleton)object2).skinOffsetMatrices, (List<Integer>)((ImportedSkeleton)object2).SkeletonHierarchy, ((ImportedSkeleton)object2).boneIndices);
        }
        if (this.skinnedMesh != null && !ModelManager.NoOpenGL) {
            modelMesh.m_bHasVBO = true;
            object2 = this.skinnedMesh.vertices;
            object = this.skinnedMesh.elements;
            RenderThread.queueInvokeOnRenderContext(() -> ProcessedAiScene.lambda$applyToMesh$1(modelMesh, (VertexBufferObject.VertexArray)object2, (int[])object, bl));
        }
        this.skeleton = null;
        this.skinnedMesh = null;
        this.staticMesh = null;
    }

    public void applyToAnimation(AnimationAsset animationAsset) {
        for (Map.Entry<String, AnimationClip> entry : this.skeleton.clips.entrySet()) {
            for (Keyframe keyframe : entry.getValue().getKeyframes()) {
                keyframe.BoneName = JAssImpImporter.getSharedString(keyframe.BoneName, "Keyframe.BoneName");
            }
        }
        animationAsset.AnimationClips = this.skeleton.clips;
        this.skeleton = null;
    }

    private static /* synthetic */ void lambda$applyToMesh$1(ModelMesh modelMesh, VertexBufferObject.VertexArray vertexArray, int[] nArray, boolean bl) {
        modelMesh.SetVertexBuffer(new VertexBufferObject(vertexArray, nArray, bl));
        if (ModelManager.instance.bCreateSoftwareMeshes) {
            modelMesh.softwareMesh.vb = modelMesh.vb;
        }
    }

    private static /* synthetic */ void lambda$applyToMesh$0(ModelMesh modelMesh, VertexBufferObject.VertexArray vertexArray, int[] nArray) {
        modelMesh.SetVertexBuffer(new VertexBufferObject(vertexArray, nArray));
        if (ModelManager.instance.bCreateSoftwareMeshes) {
            modelMesh.softwareMesh.vb = modelMesh.vb;
        }
    }
}

