/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model.jassimp;

import jassimp.AiMesh;
import org.joml.Vector3f;
import zombie.core.skinnedmodel.model.VertexBufferObject;

public final class ImportedStaticMesh {
    VertexBufferObject.VertexArray verticesUnskinned = null;
    int[] elements = null;
    final Vector3f minXYZ = new Vector3f(Float.MAX_VALUE);
    final Vector3f maxXYZ = new Vector3f(-3.4028235E38f);

    public ImportedStaticMesh(AiMesh aiMesh) {
        this.processAiScene(aiMesh);
    }

    private void processAiScene(AiMesh aiMesh) {
        int n;
        int n2 = aiMesh.getNumVertices();
        int n3 = 0;
        for (int i = 0; i < 8; ++i) {
            if (!aiMesh.hasTexCoords(i)) continue;
            ++n3;
        }
        VertexBufferObject.VertexFormat vertexFormat = new VertexBufferObject.VertexFormat(3 + n3);
        vertexFormat.setElement(0, VertexBufferObject.VertexType.VertexArray, 12);
        vertexFormat.setElement(1, VertexBufferObject.VertexType.NormalArray, 12);
        vertexFormat.setElement(2, VertexBufferObject.VertexType.TangentArray, 12);
        for (int i = 0; i < n3; ++i) {
            vertexFormat.setElement(3 + i, VertexBufferObject.VertexType.TextureCoordArray, 8);
        }
        vertexFormat.calculate();
        this.verticesUnskinned = new VertexBufferObject.VertexArray(vertexFormat, n2);
        Vector3f vector3f = new Vector3f();
        for (n = 0; n < n2; ++n) {
            float f = aiMesh.getPositionX(n);
            float f2 = aiMesh.getPositionY(n);
            float f3 = aiMesh.getPositionZ(n);
            this.minXYZ.min(vector3f.set(f, f2, f3));
            this.maxXYZ.max(vector3f.set(f, f2, f3));
            this.verticesUnskinned.setElement(n, 0, aiMesh.getPositionX(n), aiMesh.getPositionY(n), aiMesh.getPositionZ(n));
            if (aiMesh.hasNormals()) {
                this.verticesUnskinned.setElement(n, 1, aiMesh.getNormalX(n), aiMesh.getNormalY(n), aiMesh.getNormalZ(n));
            } else {
                this.verticesUnskinned.setElement(n, 1, 0.0f, 1.0f, 0.0f);
            }
            if (aiMesh.hasTangentsAndBitangents()) {
                this.verticesUnskinned.setElement(n, 2, aiMesh.getTangentX(n), aiMesh.getTangentY(n), aiMesh.getTangentZ(n));
            } else {
                this.verticesUnskinned.setElement(n, 2, 0.0f, 0.0f, 1.0f);
            }
            if (n3 <= 0) continue;
            int n4 = 0;
            for (int i = 0; i < 8; ++i) {
                if (!aiMesh.hasTexCoords(i)) continue;
                this.verticesUnskinned.setElement(n, 3 + n4, aiMesh.getTexCoordU(n, i), 1.0f - aiMesh.getTexCoordV(n, i));
                ++n4;
            }
        }
        n = aiMesh.getNumFaces();
        this.elements = new int[n * 3];
        for (int i = 0; i < n; ++i) {
            this.elements[i * 3 + 2] = aiMesh.getFaceVertex(i, 0);
            this.elements[i * 3 + 1] = aiMesh.getFaceVertex(i, 1);
            this.elements[i * 3 + 0] = aiMesh.getFaceVertex(i, 2);
        }
    }
}

