/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.ArrayList;
import java.util.List;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import zombie.core.Core;
import zombie.core.ImmutableColor;
import zombie.core.SpriteRenderer;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.WorldItemAtlas;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponPart;
import zombie.iso.IsoCamera;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.ModelWeaponPart;
import zombie.util.StringUtils;

public final class WorldItemModelDrawer
extends TextureDraw.GenericDrawer {
    private static final ObjectPool<WorldItemModelDrawer> s_modelDrawerPool = new ObjectPool<WorldItemModelDrawer>(WorldItemModelDrawer::new);
    private static final ObjectPool<WeaponPartParams> s_weaponPartParamPool = new ObjectPool<WeaponPartParams>(WeaponPartParams::new);
    private static final ArrayList<WeaponPart> s_tempWeaponPartList = new ArrayList();
    private static final ColorInfo tempColorInfo = new ColorInfo();
    private static final Matrix4f s_attachmentXfrm = new Matrix4f();
    private static final ImmutableColor ROTTEN_FOOD_COLOR = new ImmutableColor(0.5f, 0.5f, 0.5f);
    public static boolean NEW_WAY = true;
    private Model m_model;
    private ArrayList<WeaponPartParams> m_weaponParts;
    private float m_hue;
    private float m_tintR;
    private float m_tintG;
    private float m_tintB;
    private float m_x;
    private float m_y;
    private float m_z;
    private final Vector3f m_angle = new Vector3f();
    private final Matrix4f m_transform = new Matrix4f();
    private float m_ambientR;
    private float m_ambientG;
    private float m_ambientB;
    private float alpha = 1.0f;
    static final Vector3f tempVector3f = new Vector3f(0.0f, 5.0f, -2.0f);

    public static boolean renderMain(InventoryItem inventoryItem, IsoGridSquare isoGridSquare, float f, float f2, float f3, float f4) {
        return WorldItemModelDrawer.renderMain(inventoryItem, isoGridSquare, f, f2, f3, f4, -1.0f);
    }

    public static boolean renderMain(InventoryItem inventoryItem, IsoGridSquare isoGridSquare, float f, float f2, float f3, float f4, float f5) {
        String string;
        Object object;
        Object object2;
        if (inventoryItem == null || isoGridSquare == null) {
            return false;
        }
        Core.getInstance();
        if (!Core.Option3DGroundItem) {
            return false;
        }
        if (WorldItemModelDrawer.renderAtlasTexture(inventoryItem, isoGridSquare, f, f2, f3, f4, f5)) {
            return true;
        }
        if (!StringUtils.isNullOrEmpty(inventoryItem.getWorldStaticItem())) {
            object2 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem());
            if (object2 != null) {
                boolean bl;
                Object object3;
                object = ((ModelScript)object2).getMeshName();
                String string2 = ((ModelScript)object2).getTextureName();
                string = ((ModelScript)object2).getShaderName();
                var11_13 = ImmutableColor.white;
                float f6 = 1.0f;
                if (inventoryItem instanceof Food) {
                    if (((Food)inventoryItem).isCooked() && (object3 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem() + "Cooked")) != null) {
                        string2 = ((ModelScript)object3).getTextureName();
                        object = ((ModelScript)object3).getMeshName();
                        string = ((ModelScript)object3).getShaderName();
                        object2 = object3;
                    }
                    if (((Food)inventoryItem).isBurnt() && (object3 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem() + "Burnt")) != null) {
                        string2 = ((ModelScript)object3).getTextureName();
                        object = ((ModelScript)object3).getMeshName();
                        string = ((ModelScript)object3).getShaderName();
                        object2 = object3;
                    }
                    if (((Food)inventoryItem).isRotten()) {
                        object3 = ScriptManager.instance.getModelScript(inventoryItem.getWorldStaticItem() + "Rotten");
                        if (object3 != null) {
                            string2 = ((ModelScript)object3).getTextureName();
                            object = ((ModelScript)object3).getMeshName();
                            string = ((ModelScript)object3).getShaderName();
                            object2 = object3;
                        } else {
                            var11_13 = ROTTEN_FOOD_COLOR;
                        }
                    }
                }
                if (inventoryItem instanceof Clothing || inventoryItem.getClothingItem() != null) {
                    string2 = ((ModelScript)object2).getTextureName(true);
                    object3 = inventoryItem.getVisual();
                    var14_22 = inventoryItem.getClothingItem();
                    var11_13 = ((ItemVisual)object3).getTint((ClothingItem)var14_22);
                    if (string2 == null) {
                        string2 = ((ClothingItem)var14_22).textureChoices.isEmpty() ? ((ItemVisual)object3).getBaseTexture((ClothingItem)var14_22) : ((ItemVisual)object3).getTextureChoice((ClothingItem)var14_22);
                    }
                }
                if ((var14_22 = ModelManager.instance.tryGetLoadedModel((String)object, string2, bl = ((ModelScript)object2).bStatic, string, true)) == null) {
                    ModelManager.instance.loadAdditionalModel((String)object, string2, bl, string);
                }
                if ((var14_22 = ModelManager.instance.getLoadedModel((String)object, string2, bl, string)) != null && var14_22.isReady() && ((Model)var14_22).Mesh != null && ((Model)var14_22).Mesh.isReady()) {
                    WorldItemModelDrawer worldItemModelDrawer = s_modelDrawerPool.alloc();
                    worldItemModelDrawer.init(inventoryItem, isoGridSquare, f, f2, f3, (Model)var14_22, (ModelScript)object2, f6, (ImmutableColor)var11_13, f4, false);
                    if (((ModelScript)object2).scale != 1.0f) {
                        worldItemModelDrawer.m_transform.scale(((ModelScript)object2).scale);
                    }
                    if (inventoryItem.worldScale != 1.0f) {
                        worldItemModelDrawer.m_transform.scale(inventoryItem.worldScale);
                    }
                    worldItemModelDrawer.m_angle.x = 0.0f;
                    worldItemModelDrawer.m_angle.y = f5 < 0.0f ? (float)inventoryItem.worldZRotation : f5;
                    worldItemModelDrawer.m_angle.z = 0.0f;
                    if (Core.bDebug) {
                        // empty if block
                    }
                    SpriteRenderer.instance.drawGeneric(worldItemModelDrawer);
                    return true;
                }
            }
        } else if (inventoryItem instanceof Clothing) {
            boolean bl;
            object2 = inventoryItem.getClothingItem();
            object = inventoryItem.getVisual();
            if (object2 != null && object != null && "Bip01_Head".equalsIgnoreCase(((ClothingItem)object2).m_AttachBone) && (!((Clothing)inventoryItem).isCosmetic() || "Eyes".equals(inventoryItem.getBodyLocation())) && !StringUtils.isNullOrWhitespace(string = ((ClothingItem)object2).getModel(bl = false))) {
                String string3;
                boolean bl2;
                var11_13 = ((ItemVisual)object).getTextureChoice((ClothingItem)object2);
                var14_22 = ModelManager.instance.tryGetLoadedModel(string, (String)var11_13, bl2 = ((ClothingItem)object2).m_Static, string3 = ((ClothingItem)object2).m_Shader, false);
                if (var14_22 == null) {
                    ModelManager.instance.loadAdditionalModel(string, (String)var11_13, bl2, string3);
                }
                if ((var14_22 = ModelManager.instance.getLoadedModel(string, (String)var11_13, bl2, string3)) != null && var14_22.isReady() && ((Model)var14_22).Mesh != null && ((Model)var14_22).Mesh.isReady()) {
                    WorldItemModelDrawer worldItemModelDrawer = s_modelDrawerPool.alloc();
                    float f7 = ((ItemVisual)object).getHue((ClothingItem)object2);
                    ImmutableColor immutableColor = ((ItemVisual)object).getTint((ClothingItem)object2);
                    worldItemModelDrawer.init(inventoryItem, isoGridSquare, f, f2, f3, (Model)var14_22, null, f7, immutableColor, f4, false);
                    if (NEW_WAY) {
                        worldItemModelDrawer.m_angle.x = 180.0f + f4;
                        worldItemModelDrawer.m_angle.y = f5 < 0.0f ? (float)inventoryItem.worldZRotation : f5;
                        worldItemModelDrawer.m_angle.z = -90.0f;
                        if (Core.bDebug) {
                            // empty if block
                        }
                        worldItemModelDrawer.m_transform.translate(-0.08f, 0.0f, 0.05f);
                    }
                    SpriteRenderer.instance.drawGeneric(worldItemModelDrawer);
                    return true;
                }
            }
        }
        if (inventoryItem instanceof HandWeapon && (object2 = ScriptManager.instance.getModelScript(inventoryItem.getStaticModel())) != null) {
            boolean bl;
            String string4;
            object = ((ModelScript)object2).getMeshName();
            Model model = ModelManager.instance.tryGetLoadedModel((String)object, string4 = ((ModelScript)object2).getTextureName(), bl = ((ModelScript)object2).bStatic, string = ((ModelScript)object2).getShaderName(), false);
            if (model == null) {
                ModelManager.instance.loadAdditionalModel((String)object, string4, bl, string);
            }
            if ((model = ModelManager.instance.getLoadedModel((String)object, string4, bl, string)) != null && model.isReady() && model.Mesh != null && model.Mesh.isReady()) {
                WorldItemModelDrawer worldItemModelDrawer = s_modelDrawerPool.alloc();
                float f8 = 1.0f;
                ImmutableColor immutableColor = ImmutableColor.white;
                worldItemModelDrawer.init(inventoryItem, isoGridSquare, f, f2, f3, model, (ModelScript)object2, f8, immutableColor, f4, true);
                if (((ModelScript)object2).scale != 1.0f) {
                    worldItemModelDrawer.m_transform.scale(((ModelScript)object2).scale);
                }
                if (inventoryItem.worldScale != 1.0f) {
                    worldItemModelDrawer.m_transform.scale(inventoryItem.worldScale);
                }
                worldItemModelDrawer.m_angle.x = 0.0f;
                if (!NEW_WAY) {
                    worldItemModelDrawer.m_angle.y = 180.0f;
                }
                worldItemModelDrawer.m_angle.y = f5 < 0.0f ? (float)inventoryItem.worldZRotation : f5;
                if (!worldItemModelDrawer.initWeaponParts((HandWeapon)inventoryItem, (ModelScript)object2)) {
                    worldItemModelDrawer.reset();
                    s_modelDrawerPool.release(worldItemModelDrawer);
                    return false;
                }
                SpriteRenderer.instance.drawGeneric(worldItemModelDrawer);
                return true;
            }
        }
        return false;
    }

    private static boolean renderAtlasTexture(InventoryItem inventoryItem, IsoGridSquare isoGridSquare, float f, float f2, float f3, float f4, float f5) {
        boolean bl;
        if (f4 > 0.0f) {
            return false;
        }
        if (f5 >= 0.0f) {
            return false;
        }
        boolean bl2 = bl = !Core.bDebug || !GameKeyboard.isKeyDown(199);
        if (!bl) {
            return false;
        }
        if (inventoryItem.atlasTexture != null && !inventoryItem.atlasTexture.isStillValid(inventoryItem)) {
            inventoryItem.atlasTexture = null;
        }
        if (inventoryItem.atlasTexture == null) {
            inventoryItem.atlasTexture = WorldItemAtlas.instance.getItemTexture(inventoryItem);
        }
        if (inventoryItem.atlasTexture == null) {
            return false;
        }
        if (inventoryItem.atlasTexture.isTooBig()) {
            return false;
        }
        if (IsoSprite.globalOffsetX == -1.0f) {
            IsoSprite.globalOffsetX = -IsoCamera.frameState.OffX;
            IsoSprite.globalOffsetY = -IsoCamera.frameState.OffY;
        }
        float f6 = IsoUtils.XToScreen(f, f2, f3, 0);
        float f7 = IsoUtils.YToScreen(f, f2, f3, 0);
        isoGridSquare.interpolateLight(tempColorInfo, f % 1.0f, f2 % 1.0f);
        float f8 = IsoWorldInventoryObject.getSurfaceAlpha(isoGridSquare, f3 - (float)((int)f3));
        inventoryItem.atlasTexture.render(f6 += IsoSprite.globalOffsetX, f7 += IsoSprite.globalOffsetY, WorldItemModelDrawer.tempColorInfo.r, WorldItemModelDrawer.tempColorInfo.g, WorldItemModelDrawer.tempColorInfo.b, f8);
        WorldItemAtlas.instance.render();
        return inventoryItem.atlasTexture.isRenderMainOK();
    }

    private void init(InventoryItem inventoryItem, IsoGridSquare isoGridSquare, float f, float f2, float f3, Model model, ModelScript modelScript, float f4, ImmutableColor immutableColor, float f5, boolean bl) {
        this.m_model = model;
        if (this.m_weaponParts != null) {
            s_weaponPartParamPool.release((List<WeaponPartParams>)this.m_weaponParts);
            this.m_weaponParts.clear();
        }
        this.m_tintR = immutableColor.r;
        this.m_tintG = immutableColor.g;
        this.m_tintB = immutableColor.b;
        this.m_hue = f4;
        this.m_x = f;
        this.m_y = f2;
        this.m_z = f3;
        this.m_transform.rotationZ((90.0f + f5) * ((float)Math.PI / 180));
        if (inventoryItem instanceof Clothing) {
            float f6 = -0.08f;
            float f7 = 0.05f;
            this.m_transform.translate(f6, 0.0f, f7);
        }
        this.m_angle.x = 0.0f;
        this.m_angle.y = 525.0f;
        this.m_angle.z = 0.0f;
        if (NEW_WAY) {
            ModelAttachment modelAttachment;
            this.m_transform.identity();
            this.m_angle.y = 0.0f;
            if (bl) {
                this.m_transform.rotateXYZ(0.0f, (float)Math.PI, 1.5707964f);
            }
            if (modelScript != null && (modelAttachment = modelScript.getAttachmentById("world")) != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, s_attachmentXfrm);
                s_attachmentXfrm.invert();
                this.m_transform.mul(s_attachmentXfrm);
            }
            if (model.Mesh != null && model.Mesh.isReady() && model.Mesh.m_transform != null) {
                model.Mesh.m_transform.transpose();
                this.m_transform.mul(model.Mesh.m_transform);
                model.Mesh.m_transform.transpose();
            }
        }
        isoGridSquare.interpolateLight(tempColorInfo, this.m_x % 1.0f, this.m_y % 1.0f);
        if (GameServer.bServer && ServerGUI.isCreated()) {
            tempColorInfo.set(1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.m_ambientR = WorldItemModelDrawer.tempColorInfo.r;
        this.m_ambientG = WorldItemModelDrawer.tempColorInfo.g;
        this.m_ambientB = WorldItemModelDrawer.tempColorInfo.b;
        this.alpha = IsoWorldInventoryObject.getSurfaceAlpha(isoGridSquare, f3 - (float)((int)f3));
    }

    boolean initWeaponParts(HandWeapon handWeapon, ModelScript modelScript) {
        ArrayList<ModelWeaponPart> arrayList = handWeapon.getModelWeaponPart();
        if (arrayList == null) {
            return true;
        }
        ArrayList<WeaponPart> arrayList2 = handWeapon.getAllWeaponParts(s_tempWeaponPartList);
        block0: for (int i = 0; i < arrayList2.size(); ++i) {
            WeaponPart weaponPart = arrayList2.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                ModelWeaponPart modelWeaponPart = arrayList.get(j);
                if (!weaponPart.getFullType().equals(modelWeaponPart.partType)) continue;
                if (this.initWeaponPart(modelWeaponPart, modelScript)) continue block0;
                return false;
            }
        }
        return true;
    }

    boolean initWeaponPart(ModelWeaponPart modelWeaponPart, ModelScript modelScript) {
        String string;
        boolean bl;
        String string2;
        String string3 = StringUtils.discardNullOrWhitespace(modelWeaponPart.modelName);
        if (string3 == null) {
            return false;
        }
        ModelScript modelScript2 = ScriptManager.instance.getModelScript(string3);
        if (modelScript2 == null) {
            return false;
        }
        String string4 = modelScript2.getMeshName();
        Model model = ModelManager.instance.tryGetLoadedModel(string4, string2 = modelScript2.getTextureName(), bl = modelScript2.bStatic, string = modelScript2.getShaderName(), false);
        if (model == null) {
            ModelManager.instance.loadAdditionalModel(string4, string2, bl, string);
        }
        if ((model = ModelManager.instance.getLoadedModel(string4, string2, bl, string)) == null || !model.isReady() || model.Mesh == null || !model.Mesh.isReady()) {
            return false;
        }
        WeaponPartParams weaponPartParams = s_weaponPartParamPool.alloc();
        weaponPartParams.m_model = model;
        weaponPartParams.m_attachmentNameSelf = modelWeaponPart.attachmentNameSelf;
        weaponPartParams.m_attachmentNameParent = modelWeaponPart.attachmentParent;
        weaponPartParams.initTransform(modelScript, modelScript2);
        this.m_transform.mul(weaponPartParams.m_transform, weaponPartParams.m_transform);
        if (this.m_weaponParts == null) {
            this.m_weaponParts = new ArrayList();
        }
        this.m_weaponParts.add(weaponPartParams);
        return true;
    }

    @Override
    public void render() {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushClientAttrib((int)-1);
        Core.getInstance().DoPushIsoStuff(this.m_x, this.m_y, this.m_z, 0.0f, false);
        GL11.glRotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)this.m_angle.x, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)this.m_angle.y, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)this.m_angle.z, (double)0.0, (double)0.0, (double)1.0);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthFunc((int)513);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthRange((double)0.0, (double)1.0);
        GL11.glEnable((int)2929);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderModel(this.m_model, this.m_transform);
        if (this.m_weaponParts != null) {
            for (int i = 0; i < this.m_weaponParts.size(); ++i) {
                WeaponPartParams weaponPartParams = this.m_weaponParts.get(i);
                this.renderModel(weaponPartParams.m_model, weaponPartParams.m_transform);
            }
        }
        if (Core.bDebug && DebugOptions.instance.ModelRenderAxis.getValue()) {
            Model.debugDrawAxis(0.0f, 0.0f, 0.0f, 0.5f, 1.0f);
        }
        Core.getInstance().DoPopIsoStuff();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        SpriteRenderer.ringBuffer.restoreVBOs = true;
    }

    void renderModel(Model model, Matrix4f matrix4f) {
        Shader shader;
        if (!model.bStatic) {
            return;
        }
        if (model.Effect == null) {
            model.CreateShader("basicEffect");
        }
        if ((shader = model.Effect) == null || model.Mesh == null || !model.Mesh.isReady()) {
            return;
        }
        shader.Start();
        if (model.tex != null) {
            shader.setTexture(model.tex, "Texture", 0);
        }
        shader.setDepthBias(0.0f);
        shader.setAmbient(this.m_ambientR * 0.4f, this.m_ambientG * 0.4f, this.m_ambientB * 0.4f);
        shader.setLightingAmount(1.0f);
        shader.setHueShift(this.m_hue);
        shader.setTint(this.m_tintR, this.m_tintG, this.m_tintB);
        shader.setAlpha(this.alpha);
        for (int i = 0; i < 5; ++i) {
            shader.setLight(i, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
        }
        Vector3f vector3f = tempVector3f;
        vector3f.x = 0.0f;
        vector3f.y = 5.0f;
        vector3f.z = -2.0f;
        vector3f.rotateY((float)Math.toRadians(this.m_angle.y));
        float f = 1.5f;
        shader.setLight(4, vector3f.x, vector3f.z, vector3f.y, this.m_ambientR / 4.0f * f, this.m_ambientG / 4.0f * f, this.m_ambientB / 4.0f * f, 5000.0f, Float.NaN, 0.0f, 0.0f, 0.0f, null);
        shader.setTransformMatrix(matrix4f, false);
        model.Mesh.Draw(shader);
        shader.End();
    }

    @Override
    public void postRender() {
        this.reset();
        s_modelDrawerPool.release(this);
    }

    void reset() {
        if (this.m_weaponParts != null) {
            s_weaponPartParamPool.release((List<WeaponPartParams>)this.m_weaponParts);
            this.m_weaponParts.clear();
        }
    }

    private static final class WeaponPartParams {
        Model m_model;
        String m_attachmentNameSelf;
        String m_attachmentNameParent;
        final Matrix4f m_transform = new Matrix4f();

        private WeaponPartParams() {
        }

        void initTransform(ModelScript modelScript, ModelScript modelScript2) {
            this.m_transform.identity();
            Matrix4f matrix4f = s_attachmentXfrm;
            ModelAttachment modelAttachment = modelScript.getAttachmentById(this.m_attachmentNameParent);
            if (modelAttachment != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, matrix4f);
                this.m_transform.mul(matrix4f);
            }
            ModelAttachment modelAttachment2 = modelScript2.getAttachmentById(this.m_attachmentNameSelf);
            if (modelAttachment2 != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment2, matrix4f);
                matrix4f.invert();
                this.m_transform.mul(matrix4f);
            }
        }
    }
}

