/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;
import org.lwjglx.BufferUtils;
import zombie.core.VBO.IGLBufferObject;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.model.VertexPositionNormalTangentTexture;
import zombie.core.skinnedmodel.model.VertexPositionNormalTangentTextureSkin;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.debug.DebugOptions;
import zombie.util.list.PZArrayUtil;

public final class VertexBufferObject {
    public static IGLBufferObject funcs;
    int[] elements;
    Vbo _handle;
    private final VertexFormat m_vertexFormat;
    private BeginMode _beginMode;
    public boolean bStatic = false;

    public VertexBufferObject() {
        this.bStatic = false;
        this.m_vertexFormat = new VertexFormat(4);
        this.m_vertexFormat.setElement(0, VertexType.VertexArray, 12);
        this.m_vertexFormat.setElement(1, VertexType.NormalArray, 12);
        this.m_vertexFormat.setElement(2, VertexType.ColorArray, 4);
        this.m_vertexFormat.setElement(3, VertexType.TextureCoordArray, 8);
        this.m_vertexFormat.calculate();
        this._beginMode = BeginMode.Triangles;
    }

    @Deprecated
    public VertexBufferObject(VertexPositionNormalTangentTexture[] vertexPositionNormalTangentTextureArray2, int[] nArray2) {
        this.elements = nArray2;
        this.bStatic = true;
        RenderThread.invokeOnRenderContext(this, vertexPositionNormalTangentTextureArray2, nArray2, (vertexBufferObject, vertexPositionNormalTangentTextureArray, nArray) -> {
            vertexBufferObject._handle = this.LoadVBO((VertexPositionNormalTangentTexture[])vertexPositionNormalTangentTextureArray, (int[])nArray);
        });
        this.m_vertexFormat = new VertexFormat(4);
        this.m_vertexFormat.setElement(0, VertexType.VertexArray, 12);
        this.m_vertexFormat.setElement(1, VertexType.NormalArray, 12);
        this.m_vertexFormat.setElement(2, VertexType.TangentArray, 12);
        this.m_vertexFormat.setElement(3, VertexType.TextureCoordArray, 8);
        this.m_vertexFormat.calculate();
        this._beginMode = BeginMode.Triangles;
    }

    @Deprecated
    public VertexBufferObject(VertexPositionNormalTangentTextureSkin[] vertexPositionNormalTangentTextureSkinArray, int[] nArray, boolean bl) {
        this.elements = nArray;
        if (bl) {
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            for (int i = nArray.length - 1 - 2; i >= 0; i -= 3) {
                nArray2[n] = nArray[i];
                nArray2[n + 1] = nArray[i + 1];
                nArray2[n + 2] = nArray[i + 2];
                n += 3;
            }
            nArray = nArray2;
        }
        this.bStatic = false;
        this._handle = this.LoadVBO(vertexPositionNormalTangentTextureSkinArray, nArray);
        this.m_vertexFormat = new VertexFormat(6);
        this.m_vertexFormat.setElement(0, VertexType.VertexArray, 12);
        this.m_vertexFormat.setElement(1, VertexType.NormalArray, 12);
        this.m_vertexFormat.setElement(2, VertexType.TangentArray, 12);
        this.m_vertexFormat.setElement(3, VertexType.TextureCoordArray, 8);
        this.m_vertexFormat.setElement(4, VertexType.BlendWeightArray, 16);
        this.m_vertexFormat.setElement(5, VertexType.BlendIndexArray, 16);
        this.m_vertexFormat.calculate();
        this._beginMode = BeginMode.Triangles;
    }

    public VertexBufferObject(VertexArray vertexArray2, int[] nArray2) {
        this.m_vertexFormat = vertexArray2.m_format;
        this.elements = nArray2;
        this.bStatic = true;
        RenderThread.invokeOnRenderContext(this, vertexArray2, nArray2, (vertexBufferObject, vertexArray, nArray) -> {
            vertexBufferObject._handle = this.LoadVBO((VertexArray)vertexArray, (int[])nArray);
        });
        this._beginMode = BeginMode.Triangles;
    }

    public VertexBufferObject(VertexArray vertexArray, int[] nArray, boolean bl) {
        this.m_vertexFormat = vertexArray.m_format;
        if (bl) {
            int[] nArray2 = new int[nArray.length];
            int n = 0;
            for (int i = nArray.length - 1 - 2; i >= 0; i -= 3) {
                nArray2[n] = nArray[i];
                nArray2[n + 1] = nArray[i + 1];
                nArray2[n + 2] = nArray[i + 2];
                n += 3;
            }
            nArray = nArray2;
        }
        this.elements = nArray;
        this.bStatic = false;
        this._handle = this.LoadVBO(vertexArray, nArray);
        this._beginMode = BeginMode.Triangles;
    }

    @Deprecated
    private Vbo LoadVBO(VertexPositionNormalTangentTextureSkin[] vertexPositionNormalTangentTextureSkinArray, int[] nArray) {
        int n;
        Vbo vbo = new Vbo();
        int n2 = 0;
        int n3 = 76;
        vbo.FaceDataOnly = false;
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(vertexPositionNormalTangentTextureSkinArray.length * n3);
        ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(nArray.length * 4);
        for (n = 0; n < vertexPositionNormalTangentTextureSkinArray.length; ++n) {
            vertexPositionNormalTangentTextureSkinArray[n].put(byteBuffer);
        }
        for (n = 0; n < nArray.length; ++n) {
            byteBuffer2.putInt(nArray[n]);
        }
        byteBuffer.flip();
        byteBuffer2.flip();
        vbo.VboID = funcs.glGenBuffers();
        funcs.glBindBuffer(funcs.GL_ARRAY_BUFFER(), vbo.VboID);
        funcs.glBufferData(funcs.GL_ARRAY_BUFFER(), byteBuffer, funcs.GL_STATIC_DRAW());
        funcs.glGetBufferParameter(funcs.GL_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo.b);
        n2 = vbo.b.get();
        if (vertexPositionNormalTangentTextureSkinArray.length * n3 != n2) {
            throw new RuntimeException("Vertex data not uploaded correctly");
        }
        vbo.EboID = funcs.glGenBuffers();
        funcs.glBindBuffer(funcs.GL_ELEMENT_ARRAY_BUFFER(), vbo.EboID);
        funcs.glBufferData(funcs.GL_ELEMENT_ARRAY_BUFFER(), byteBuffer2, funcs.GL_STATIC_DRAW());
        vbo.b.clear();
        funcs.glGetBufferParameter(funcs.GL_ELEMENT_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo.b);
        n2 = vbo.b.get();
        if (nArray.length * 4 != n2) {
            throw new RuntimeException("Element data not uploaded correctly");
        }
        vbo.NumElements = nArray.length;
        vbo.VertexStride = n3;
        return vbo;
    }

    public Vbo LoadSoftwareVBO(ByteBuffer byteBuffer, Vbo vbo, int[] nArray) {
        Vbo vbo2 = vbo;
        boolean bl = false;
        ByteBuffer byteBuffer2 = null;
        if (vbo2 == null) {
            bl = true;
            vbo2 = new Vbo();
            vbo2.VboID = funcs.glGenBuffers();
            ByteBuffer byteBuffer3 = BufferUtils.createByteBuffer(nArray.length * 4);
            for (int i = 0; i < nArray.length; ++i) {
                byteBuffer3.putInt(nArray[i]);
            }
            byteBuffer3.flip();
            byteBuffer2 = byteBuffer3;
            vbo2.VertexStride = 36;
            vbo2.NumElements = nArray.length;
        } else {
            vbo2.b.clear();
        }
        vbo2.FaceDataOnly = false;
        funcs.glBindBuffer(funcs.GL_ARRAY_BUFFER(), vbo2.VboID);
        funcs.glBufferData(funcs.GL_ARRAY_BUFFER(), byteBuffer, funcs.GL_STATIC_DRAW());
        funcs.glGetBufferParameter(funcs.GL_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo2.b);
        if (byteBuffer2 != null) {
            vbo2.EboID = funcs.glGenBuffers();
            funcs.glBindBuffer(funcs.GL_ELEMENT_ARRAY_BUFFER(), vbo2.EboID);
            funcs.glBufferData(funcs.GL_ELEMENT_ARRAY_BUFFER(), byteBuffer2, funcs.GL_STATIC_DRAW());
        }
        return vbo2;
    }

    @Deprecated
    private Vbo LoadVBO(VertexPositionNormalTangentTexture[] vertexPositionNormalTangentTextureArray, int[] nArray) {
        int n;
        Vbo vbo = new Vbo();
        int n2 = 0;
        int n3 = 44;
        vbo.FaceDataOnly = false;
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(vertexPositionNormalTangentTextureArray.length * n3);
        ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(nArray.length * 4);
        for (n = 0; n < vertexPositionNormalTangentTextureArray.length; ++n) {
            vertexPositionNormalTangentTextureArray[n].put(byteBuffer);
        }
        for (n = 0; n < nArray.length; ++n) {
            byteBuffer2.putInt(nArray[n]);
        }
        byteBuffer.flip();
        byteBuffer2.flip();
        vbo.VboID = funcs.glGenBuffers();
        funcs.glBindBuffer(funcs.GL_ARRAY_BUFFER(), vbo.VboID);
        funcs.glBufferData(funcs.GL_ARRAY_BUFFER(), byteBuffer, funcs.GL_STATIC_DRAW());
        funcs.glGetBufferParameter(funcs.GL_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo.b);
        n2 = vbo.b.get();
        if (vertexPositionNormalTangentTextureArray.length * n3 != n2) {
            throw new RuntimeException("Vertex data not uploaded correctly");
        }
        vbo.EboID = funcs.glGenBuffers();
        funcs.glBindBuffer(funcs.GL_ELEMENT_ARRAY_BUFFER(), vbo.EboID);
        funcs.glBufferData(funcs.GL_ELEMENT_ARRAY_BUFFER(), byteBuffer2, funcs.GL_STATIC_DRAW());
        vbo.b.clear();
        funcs.glGetBufferParameter(funcs.GL_ELEMENT_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo.b);
        n2 = vbo.b.get();
        if (nArray.length * 4 != n2) {
            throw new RuntimeException("Element data not uploaded correctly");
        }
        vbo.NumElements = nArray.length;
        vbo.VertexStride = n3;
        return vbo;
    }

    private Vbo LoadVBO(VertexArray vertexArray, int[] nArray) {
        int n;
        Vbo vbo = new Vbo();
        vbo.FaceDataOnly = false;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(nArray.length * 4));
        for (n = 0; n < nArray.length; ++n) {
            byteBuffer.putInt(nArray[n]);
        }
        vertexArray.m_buffer.position(0);
        vertexArray.m_buffer.limit(vertexArray.m_numVertices * vertexArray.m_format.m_stride);
        byteBuffer.flip();
        vbo.VboID = funcs.glGenBuffers();
        funcs.glBindBuffer(funcs.GL_ARRAY_BUFFER(), vbo.VboID);
        funcs.glBufferData(funcs.GL_ARRAY_BUFFER(), vertexArray.m_buffer, funcs.GL_STATIC_DRAW());
        funcs.glGetBufferParameter(funcs.GL_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo.b);
        n = vbo.b.get();
        if (vertexArray.m_numVertices * vertexArray.m_format.m_stride != n) {
            throw new RuntimeException("Vertex data not uploaded correctly");
        }
        vbo.EboID = funcs.glGenBuffers();
        funcs.glBindBuffer(funcs.GL_ELEMENT_ARRAY_BUFFER(), vbo.EboID);
        funcs.glBufferData(funcs.GL_ELEMENT_ARRAY_BUFFER(), byteBuffer, funcs.GL_STATIC_DRAW());
        MemoryUtil.memFree((Buffer)byteBuffer);
        vbo.b.clear();
        funcs.glGetBufferParameter(funcs.GL_ELEMENT_ARRAY_BUFFER(), funcs.GL_BUFFER_SIZE(), vbo.b);
        n = vbo.b.get();
        if (nArray.length * 4 != n) {
            throw new RuntimeException("Element data not uploaded correctly");
        }
        vbo.NumElements = nArray.length;
        vbo.VertexStride = vertexArray.m_format.m_stride;
        return vbo;
    }

    public void clear() {
        if (this._handle == null) {
            return;
        }
        if (this._handle.VboID > 0) {
            funcs.glDeleteBuffers(this._handle.VboID);
            this._handle.VboID = -1;
        }
        if (this._handle.EboID > 0) {
            funcs.glDeleteBuffers(this._handle.EboID);
            this._handle.EboID = -1;
        }
        this._handle = null;
    }

    public void Draw(Shader shader) {
        VertexBufferObject.Draw(this._handle, this.m_vertexFormat, shader, 4);
    }

    public void DrawStrip(Shader shader) {
        VertexBufferObject.Draw(this._handle, this.m_vertexFormat, shader, 5);
    }

    private static void Draw(Vbo vbo, VertexFormat vertexFormat, Shader shader, int n) {
        int n2;
        if (vbo == null) {
            return;
        }
        if (DebugOptions.instance.DebugDraw_SkipVBODraw.getValue()) {
            return;
        }
        int n3 = 33984;
        boolean bl = false;
        if (!vbo.FaceDataOnly) {
            funcs.glBindBuffer(funcs.GL_ARRAY_BUFFER(), vbo.VboID);
            block9: for (n2 = 0; n2 < vertexFormat.m_elements.length; ++n2) {
                VertexElement vertexElement = vertexFormat.m_elements[n2];
                switch (vertexElement.m_type) {
                    case VertexArray: {
                        GL20.glVertexPointer((int)3, (int)5126, (int)vbo.VertexStride, (long)vertexElement.m_byteOffset);
                        GL20.glEnableClientState((int)32884);
                        continue block9;
                    }
                    case NormalArray: {
                        GL20.glNormalPointer((int)5126, (int)vbo.VertexStride, (long)vertexElement.m_byteOffset);
                        GL20.glEnableClientState((int)32885);
                        continue block9;
                    }
                    case ColorArray: {
                        GL20.glColorPointer((int)3, (int)5121, (int)vbo.VertexStride, (long)vertexElement.m_byteOffset);
                        GL20.glEnableClientState((int)32886);
                        continue block9;
                    }
                    case TextureCoordArray: {
                        GL20.glActiveTexture((int)n3);
                        GL20.glClientActiveTexture((int)n3);
                        GL20.glTexCoordPointer((int)2, (int)5126, (int)vbo.VertexStride, (long)vertexElement.m_byteOffset);
                        ++n3;
                        GL20.glEnableClientState((int)32888);
                        continue block9;
                    }
                    case TangentArray: {
                        continue block9;
                    }
                    case BlendWeightArray: {
                        int n4 = shader.BoneWeightsAttrib;
                        GL20.glVertexAttribPointer((int)n4, (int)4, (int)5126, (boolean)false, (int)vbo.VertexStride, (long)vertexElement.m_byteOffset);
                        GL20.glEnableVertexAttribArray((int)n4);
                        bl = true;
                        continue block9;
                    }
                    case BlendIndexArray: {
                        int n5 = shader.BoneIndicesAttrib;
                        GL20.glVertexAttribPointer((int)n5, (int)4, (int)5126, (boolean)false, (int)vbo.VertexStride, (long)vertexElement.m_byteOffset);
                        GL20.glEnableVertexAttribArray((int)n5);
                    }
                }
            }
        }
        funcs.glBindBuffer(funcs.GL_ELEMENT_ARRAY_BUFFER(), vbo.EboID);
        GL20.glDrawElements((int)n, (int)vbo.NumElements, (int)5125, (long)0L);
        GL20.glDisableClientState((int)32885);
        if (bl && shader != null) {
            n2 = shader.BoneWeightsAttrib;
            GL20.glDisableVertexAttribArray((int)n2);
            n2 = shader.BoneIndicesAttrib;
            GL20.glDisableVertexAttribArray((int)n2);
        }
    }

    public static final class VertexFormat {
        final VertexElement[] m_elements;
        int m_stride;

        public VertexFormat(int n) {
            this.m_elements = PZArrayUtil.newInstance(VertexElement.class, n, VertexElement::new);
        }

        public void setElement(int n, VertexType vertexType, int n2) {
            this.m_elements[n].m_type = vertexType;
            this.m_elements[n].m_byteSize = n2;
        }

        public void calculate() {
            this.m_stride = 0;
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].m_byteOffset = this.m_stride;
                this.m_stride += this.m_elements[i].m_byteSize;
            }
        }
    }

    public static enum VertexType {
        VertexArray,
        NormalArray,
        ColorArray,
        IndexArray,
        TextureCoordArray,
        TangentArray,
        BlendWeightArray,
        BlendIndexArray;

    }

    public static enum BeginMode {
        Triangles;

    }

    public static final class Vbo {
        public final IntBuffer b = BufferUtils.createIntBuffer(4);
        public int VboID;
        public int EboID;
        public int NumElements;
        public int VertexStride;
        public boolean FaceDataOnly;
    }

    public static final class VertexArray {
        public final VertexFormat m_format;
        public final int m_numVertices;
        public final ByteBuffer m_buffer;

        public VertexArray(VertexFormat vertexFormat, int n) {
            this.m_format = vertexFormat;
            this.m_numVertices = n;
            this.m_buffer = BufferUtils.createByteBuffer(this.m_numVertices * this.m_format.m_stride);
        }

        public void setElement(int n, int n2, float f, float f2) {
            int n3 = n * this.m_format.m_stride + this.m_format.m_elements[n2].m_byteOffset;
            this.m_buffer.putFloat(n3, f);
            this.m_buffer.putFloat(n3 += 4, f2);
        }

        public void setElement(int n, int n2, float f, float f2, float f3) {
            int n3 = n * this.m_format.m_stride + this.m_format.m_elements[n2].m_byteOffset;
            this.m_buffer.putFloat(n3, f);
            this.m_buffer.putFloat(n3 += 4, f2);
            this.m_buffer.putFloat(n3 += 4, f3);
        }

        public void setElement(int n, int n2, float f, float f2, float f3, float f4) {
            int n3 = n * this.m_format.m_stride + this.m_format.m_elements[n2].m_byteOffset;
            this.m_buffer.putFloat(n3, f);
            this.m_buffer.putFloat(n3 += 4, f2);
            this.m_buffer.putFloat(n3 += 4, f3);
            this.m_buffer.putFloat(n3 += 4, f4);
        }

        float getElementFloat(int n, int n2, int n3) {
            int n4 = n * this.m_format.m_stride + this.m_format.m_elements[n2].m_byteOffset + n3 * 4;
            return this.m_buffer.getFloat(n4);
        }
    }

    public static final class VertexElement {
        public VertexType m_type;
        public int m_byteSize;
        public int m_byteOffset;
    }
}

