/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.util.vector.Matrix4f;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningBoneHierarchy;

public final class SkinningData {
    public HashMap<String, AnimationClip> AnimationClips;
    public List<Matrix4f> BindPose;
    public List<Matrix4f> InverseBindPose;
    public List<Matrix4f> BoneOffset = new ArrayList<Matrix4f>();
    public List<Integer> SkeletonHierarchy;
    public HashMap<String, Integer> BoneIndices;
    private SkinningBoneHierarchy m_boneHieararchy = null;

    public SkinningData(HashMap<String, AnimationClip> hashMap, List<Matrix4f> list, List<Matrix4f> list2, List<Matrix4f> list3, List<Integer> list4, HashMap<String, Integer> hashMap2) {
        this.AnimationClips = hashMap;
        this.BindPose = list;
        this.InverseBindPose = list2;
        this.SkeletonHierarchy = list4;
        for (int i = 0; i < list4.size(); ++i) {
            Matrix4f matrix4f = list3.get(i);
            this.BoneOffset.add(matrix4f);
        }
        this.BoneIndices = hashMap2;
    }

    private void validateBoneHierarchy() {
        if (this.m_boneHieararchy == null) {
            this.m_boneHieararchy = new SkinningBoneHierarchy();
            this.m_boneHieararchy.buildBoneHiearchy(this);
        }
    }

    public int numBones() {
        return this.SkeletonHierarchy.size();
    }

    public int numRootBones() {
        return this.getBoneHieararchy().numRootBones();
    }

    public int getParentBoneIdx(int n) {
        return this.SkeletonHierarchy.get(n);
    }

    public SkinningBone getBoneAt(int n) {
        return this.getBoneHieararchy().getBoneAt(n);
    }

    public SkinningBone getBone(String string) {
        Integer n = this.BoneIndices.get(string);
        if (n == null) {
            return null;
        }
        return this.getBoneAt(n);
    }

    public SkinningBone getRootBoneAt(int n) {
        return this.getBoneHieararchy().getRootBoneAt(n);
    }

    public SkinningBoneHierarchy getBoneHieararchy() {
        this.validateBoneHierarchy();
        return this.m_boneHieararchy;
    }
}

