/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.Map;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.util.list.PZArrayUtil;

public final class SkinningBoneHierarchy {
    private boolean m_boneHieararchyValid = false;
    private SkinningBone[] m_allBones = null;
    private SkinningBone[] m_rootBones = null;

    public boolean isValid() {
        return this.m_boneHieararchyValid;
    }

    public void buildBoneHiearchy(SkinningData skinningData) {
        int n;
        this.m_rootBones = new SkinningBone[0];
        this.m_allBones = new SkinningBone[skinningData.numBones()];
        PZArrayUtil.arrayPopulate(this.m_allBones, SkinningBone::new);
        for (Map.Entry<String, Integer> object : skinningData.BoneIndices.entrySet()) {
            n = object.getValue();
            String string = object.getKey();
            SkinningBone skinningBone = this.m_allBones[n];
            skinningBone.Index = n;
            skinningBone.Name = string;
            skinningBone.Children = new SkinningBone[0];
        }
        for (int i = 0; i < skinningData.numBones(); ++i) {
            SkinningBone skinningBone = this.m_allBones[i];
            n = skinningData.getParentBoneIdx(i);
            if (n > -1) {
                skinningBone.Parent = this.m_allBones[n];
                skinningBone.Parent.Children = PZArrayUtil.add(skinningBone.Parent.Children, skinningBone);
                continue;
            }
            this.m_rootBones = PZArrayUtil.add(this.m_rootBones, skinningBone);
        }
        this.m_boneHieararchyValid = true;
    }

    public int numRootBones() {
        return this.m_rootBones.length;
    }

    public SkinningBone getBoneAt(int n) {
        return this.m_allBones[n];
    }

    public SkinningBone getRootBoneAt(int n) {
        return this.m_rootBones[n];
    }
}

