/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import zombie.GameProfiler;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderSettings;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.ModelInstanceRenderDataList;
import zombie.core.skinnedmodel.model.ModelInstanceTextureCreator;
import zombie.core.skinnedmodel.model.ModelInstanceTextureInitializer;
import zombie.core.skinnedmodel.model.ModelOutlines;
import zombie.core.skinnedmodel.model.ModelSlotDebugRenderData;
import zombie.core.skinnedmodel.model.VehicleModelInstance;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.iso.IsoCamera;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMovingObject;
import zombie.iso.Vector3;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.popman.ObjectPool;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.VehicleScript;
import zombie.util.Pool;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class ModelSlotRenderData
extends TextureDraw.GenericDrawer {
    public IsoGameCharacter character;
    public IsoMovingObject object;
    private ModelManager.ModelSlot modelSlot;
    public final ModelInstanceRenderDataList modelData = new ModelInstanceRenderDataList();
    private final ModelInstanceRenderDataList readyModelData = new ModelInstanceRenderDataList();
    public ModelInstanceTextureCreator textureCreator;
    public AnimationPlayer animPlayer;
    public float animPlayerAngle;
    public float x;
    public float y;
    public float z;
    public float ambientR;
    public float ambientG;
    public float ambientB;
    public boolean bOutside;
    public final Matrix4f vehicleTransform = new Matrix4f();
    public boolean bInVehicle;
    public float inVehicleX;
    public float inVehicleY;
    public float inVehicleZ;
    public float vehicleAngleX;
    public float vehicleAngleY;
    public float vehicleAngleZ;
    public float alpha;
    private boolean bRendered;
    private boolean bReady;
    public final ModelInstance.EffectLight[] effectLights = new ModelInstance.EffectLight[5];
    public float centerOfMassY;
    public boolean RENDER_TO_TEXTURE;
    private static Shader solidColor;
    private static Shader solidColorStatic;
    private boolean bCharacterOutline = false;
    private final ColorInfo outlineColor = new ColorInfo(1.0f, 0.0f, 0.0f, 1.0f);
    private ModelSlotDebugRenderData m_debugRenderData;
    private static final ObjectPool<ModelSlotRenderData> pool;

    public ModelSlotRenderData() {
        for (int i = 0; i < this.effectLights.length; ++i) {
            this.effectLights[i] = new ModelInstance.EffectLight();
        }
    }

    public ModelSlotRenderData init(ModelManager.ModelSlot modelSlot) {
        int n;
        Object object;
        Object object2;
        int n2 = IsoCamera.frameState.playerIndex;
        this.modelSlot = modelSlot;
        this.object = modelSlot.model.object;
        this.x = this.object.x;
        this.y = this.object.y;
        this.z = this.object.z;
        this.character = modelSlot.character;
        BaseVehicle baseVehicle = Type.tryCastTo(this.object, BaseVehicle.class);
        if (baseVehicle != null) {
            this.textureCreator = null;
            this.animPlayer = baseVehicle.getAnimationPlayer();
            this.animPlayerAngle = Float.NaN;
            this.centerOfMassY = baseVehicle.jniTransform.origin.y - BaseVehicle.CENTER_OF_MASS_MAGIC;
            if (BaseVehicle.RENDER_TO_TEXTURE) {
                this.centerOfMassY = 0.0f - BaseVehicle.CENTER_OF_MASS_MAGIC;
            }
            this.alpha = this.object.getAlpha(n2);
            object2 = (VehicleModelInstance)modelSlot.model;
            IsoLightSource[] isoLightSourceArray = ((VehicleModelInstance)object2).getLights();
            for (int i = 0; i < this.effectLights.length; ++i) {
                this.effectLights[i].set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0);
            }
            var6_11 = (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
            for (int i = 0; i < isoLightSourceArray.length; ++i) {
                object = isoLightSourceArray[i];
                if (object == null) continue;
                Vector3f vector3f = baseVehicle.getLocalPos((float)((IsoLightSource)object).x + 0.5f, (float)((IsoLightSource)object).y + 0.5f, (float)((IsoLightSource)object).z + 0.75f, (Vector3f)var6_11);
                baseVehicle.fixLightbarModelLighting((IsoLightSource)object, (Vector3f)var6_11);
                this.effectLights[i].set(vector3f.x, vector3f.y, vector3f.z, ((IsoLightSource)object).r, ((IsoLightSource)object).g, ((IsoLightSource)object).b, ((IsoLightSource)object).radius);
            }
            BaseVehicle.TL_vector3f_pool.get().release(var6_11);
            float f = 1.0f - org.joml.Math.min(RenderSettings.getInstance().getPlayerSettings(n2).getDarkness() * 0.6f, 0.8f);
            this.ambientG = this.ambientB = (f *= 0.9f);
            this.ambientR = this.ambientB;
            this.vehicleTransform.set(baseVehicle.vehicleTransform);
        } else {
            this.textureCreator = this.character.getTextureCreator();
            if (this.textureCreator != null && this.textureCreator.isRendered()) {
                this.textureCreator = null;
            }
            object2 = modelSlot.model.playerData[n2];
            this.animPlayer = this.character.getAnimationPlayer();
            this.animPlayerAngle = this.animPlayer.getRenderedAngle();
            for (int i = 0; i < this.effectLights.length; ++i) {
                var6_11 = ((ModelInstance.PlayerData)object2).effectLightsMain[i];
                this.effectLights[i].set(((ModelInstance.EffectLight)var6_11).x, ((ModelInstance.EffectLight)var6_11).y, ((ModelInstance.EffectLight)var6_11).z, ((ModelInstance.EffectLight)var6_11).r, ((ModelInstance.EffectLight)var6_11).g, ((ModelInstance.EffectLight)var6_11).b, ((ModelInstance.EffectLight)var6_11).radius);
            }
            this.ambientR = ((ModelInstance.PlayerData)object2).currentAmbient.x;
            this.ambientG = ((ModelInstance.PlayerData)object2).currentAmbient.y;
            this.ambientB = ((ModelInstance.PlayerData)object2).currentAmbient.z;
            this.bOutside = this.character.getCurrentSquare() != null && this.character.getCurrentSquare().isOutside();
            this.alpha = this.character.getAlpha(n2);
            if (Core.bDebug && DebugOptions.instance.DebugDraw_SkipWorldShading.getValue()) {
                this.ambientB = 1.0f;
                this.ambientG = 1.0f;
                this.ambientR = 1.0f;
            }
            if (GameServer.bServer && ServerGUI.isCreated()) {
                this.ambientB = 1.0f;
                this.ambientG = 1.0f;
                this.ambientR = 1.0f;
            }
            this.bCharacterOutline = this.character.bOutline[n2];
            if (this.bCharacterOutline) {
                this.outlineColor.set(this.character.outlineColor[n2]);
            }
            this.bInVehicle = this.character.isSeatedInVehicle();
            if (this.bInVehicle) {
                this.animPlayerAngle = 0.0f;
                BaseVehicle baseVehicle2 = this.character.getVehicle();
                this.centerOfMassY = baseVehicle2.jniTransform.origin.y - BaseVehicle.CENTER_OF_MASS_MAGIC;
                this.x = baseVehicle2.x;
                this.y = baseVehicle2.y;
                this.z = baseVehicle2.z;
                var6_11 = (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc();
                baseVehicle2.getPassengerLocalPos(baseVehicle2.getSeat(this.character), (Vector3f)var6_11);
                this.inVehicleX = ((Vector3f)var6_11).x;
                this.inVehicleY = ((Vector3f)var6_11).y;
                this.inVehicleZ = ((Vector3f)var6_11).z;
                BaseVehicle.TL_vector3f_pool.get().release(var6_11);
                Vector3f vector3f = baseVehicle2.vehicleTransform.getEulerAnglesZYX((Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc());
                this.vehicleAngleZ = (float)Math.toDegrees(vector3f.z);
                this.vehicleAngleY = (float)Math.toDegrees(vector3f.y);
                this.vehicleAngleX = (float)Math.toDegrees(vector3f.x);
                BaseVehicle.TL_vector3f_pool.get().release(vector3f);
            }
        }
        this.RENDER_TO_TEXTURE = BaseVehicle.RENDER_TO_TEXTURE;
        this.modelData.clear();
        object2 = null;
        if (modelSlot.model.model.isReady() && (modelSlot.model.AnimPlayer == null || modelSlot.model.AnimPlayer.isReady())) {
            object2 = ModelInstanceRenderData.alloc().init(modelSlot.model);
            this.modelData.add(object2);
            if (modelSlot.sub.size() != modelSlot.model.sub.size()) {
                boolean bl = true;
            }
        }
        this.initRenderData(modelSlot.model.sub, (ModelInstanceRenderData)object2);
        boolean bl = false;
        for (n = 0; n < this.modelData.size(); ++n) {
            ModelInstanceRenderData modelInstanceRenderData = (ModelInstanceRenderData)this.modelData.get(n);
            if (this.character != null && modelInstanceRenderData.modelInstance == this.character.primaryHandModel && this.character.isMuzzleFlash()) {
                modelInstanceRenderData.m_muzzleFlash = true;
            }
            if (modelInstanceRenderData.modelInstance == null || !modelInstanceRenderData.modelInstance.hasTextureCreator()) continue;
            bl = true;
        }
        if (this.textureCreator != null) {
            ++this.textureCreator.renderRefCount;
        }
        if (this.character != null && (this.textureCreator != null || bl)) {
            assert (this.readyModelData.isEmpty());
            ModelInstanceRenderData.release(this.readyModelData);
            this.readyModelData.clear();
            for (n = 0; n < this.character.getReadyModelData().size(); ++n) {
                ModelInstance modelInstance = this.character.getReadyModelData().get(n);
                object = ModelInstanceRenderData.alloc().init(modelInstance);
                ((ModelInstanceRenderData)object).transformToParent(this.getParentData(modelInstance));
                this.readyModelData.add(object);
            }
        }
        if (Core.bDebug) {
            this.m_debugRenderData = ModelSlotDebugRenderData.alloc().init(this);
        }
        this.bRendered = false;
        return this;
    }

    private ModelInstanceRenderData getParentData(ModelInstance modelInstance) {
        for (int i = 0; i < this.readyModelData.size(); ++i) {
            ModelInstanceRenderData modelInstanceRenderData = (ModelInstanceRenderData)this.readyModelData.get(i);
            if (modelInstanceRenderData.modelInstance != modelInstance.parent) continue;
            return modelInstanceRenderData;
        }
        return null;
    }

    private ModelInstanceRenderData initRenderData(ModelInstance modelInstance, ModelInstanceRenderData modelInstanceRenderData) {
        ModelInstanceRenderData modelInstanceRenderData2 = ModelInstanceRenderData.alloc().init(modelInstance);
        modelInstanceRenderData2.transformToParent(modelInstanceRenderData);
        this.modelData.add(modelInstanceRenderData2);
        this.initRenderData(modelInstance.sub, modelInstanceRenderData2);
        return modelInstanceRenderData2;
    }

    private void initRenderData(ArrayList<ModelInstance> arrayList, ModelInstanceRenderData modelInstanceRenderData) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ModelInstance modelInstance = arrayList.get(i);
            if (!modelInstance.model.isReady() || modelInstance.AnimPlayer != null && !modelInstance.AnimPlayer.isReady()) continue;
            this.initRenderData(modelInstance, modelInstanceRenderData);
        }
    }

    @Override
    public void render() {
        if (this.character == null) {
            this.renderVehicle();
        } else {
            this.renderCharacter();
        }
    }

    public void renderDebug() {
        if (this.m_debugRenderData != null) {
            this.m_debugRenderData.render();
        }
    }

    private void renderCharacter() {
        Object object;
        int n;
        this.bReady = true;
        if (this.textureCreator != null && !this.textureCreator.isRendered()) {
            this.textureCreator.render();
            if (!this.textureCreator.isRendered()) {
                this.bReady = false;
            }
        }
        for (n = 0; n < this.modelData.size(); ++n) {
            object = (ModelInstanceRenderData)this.modelData.get(n);
            ModelInstanceTextureInitializer modelInstanceTextureInitializer = ((ModelInstanceRenderData)object).modelInstance.getTextureInitializer();
            if (modelInstanceTextureInitializer == null || modelInstanceTextureInitializer.isRendered()) continue;
            modelInstanceTextureInitializer.render();
            if (modelInstanceTextureInitializer.isRendered()) continue;
            this.bReady = false;
        }
        if (!this.bReady && this.readyModelData.isEmpty()) {
            return;
        }
        if (this.bCharacterOutline) {
            ModelCamera.instance.bDepthMask = false;
            GameProfiler.getInstance().invokeAndMeasure("performRenderCharacterOutline", this, ModelSlotRenderData::performRenderCharacterOutline);
        }
        ModelCamera.instance.bDepthMask = true;
        GameProfiler.getInstance().invokeAndMeasure("renderCharacter", this, ModelSlotRenderData::performRenderCharacter);
        n = SpriteRenderer.instance.getRenderingPlayerIndex();
        object = Type.tryCastTo(this.character, IsoPlayer.class);
        if (object != null && !this.bCharacterOutline && object == IsoPlayer.players[n]) {
            ModelOutlines.instance.setPlayerRenderData(this);
        }
        this.bRendered = this.bReady;
    }

    private void renderVehicleDebug() {
        int n;
        Object object;
        Object object2;
        BaseVehicle baseVehicle;
        if (!Core.bDebug) {
            return;
        }
        Vector3 vector3 = Model.tempo;
        ModelCamera.instance.Begin();
        GL11.glMatrixMode((int)5888);
        GL11.glTranslatef((float)0.0f, (float)this.centerOfMassY, (float)0.0f);
        if (this.m_debugRenderData != null && !this.modelData.isEmpty()) {
            PZGLUtil.pushAndMultMatrix(5888, ((ModelInstanceRenderData)this.modelData.get((int)0)).xfrm);
            this.m_debugRenderData.render();
            PZGLUtil.popMatrix(5888);
        }
        if (DebugOptions.instance.ModelRenderAttachments.getValue()) {
            baseVehicle = (BaseVehicle)this.object;
            object2 = (ModelInstanceRenderData)this.modelData.get(0);
            PZGLUtil.pushAndMultMatrix(5888, this.vehicleTransform);
            float f = baseVehicle.getScript().getModelScale();
            float f2 = ((ModelInstanceRenderData)object2).modelInstance.scale;
            Matrix4f matrix4f = (Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
            matrix4f.scaling(1.0f / f);
            object = (Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
            for (n = 0; n < baseVehicle.getScript().getAttachmentCount(); ++n) {
                ModelAttachment modelAttachment = baseVehicle.getScript().getAttachment(n);
                ((ModelInstanceRenderData)object2).modelInstance.getAttachmentMatrix(modelAttachment, (Matrix4f)object);
                matrix4f.mul((Matrix4fc)object, (Matrix4f)object);
                PZGLUtil.pushAndMultMatrix(5888, (Matrix4f)object);
                Model.debugDrawAxis(0.0f, 0.0f, 0.0f, 1.0f, 2.0f);
                PZGLUtil.popMatrix(5888);
            }
            BaseVehicle.TL_matrix4f_pool.get().release(object);
            BaseVehicle.TL_matrix4f_pool.get().release(matrix4f);
            PZGLUtil.popMatrix(5888);
        }
        if (Core.bDebug && DebugOptions.instance.ModelRenderAxis.getValue() && !this.modelData.isEmpty()) {
            baseVehicle = (BaseVehicle)this.object;
            GL11.glMatrixMode((int)5888);
            object2 = this.vehicleTransform.getEulerAnglesZYX((Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc());
            GL11.glRotatef((float)((float)Math.toDegrees(((Vector3f)object2).z)), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)((float)Math.toDegrees(((Vector3f)object2).y)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)Math.toDegrees(((Vector3f)object2).x)), (float)1.0f, (float)0.0f, (float)0.0f);
            BaseVehicle.TL_vector3f_pool.get().release(object2);
            Model.debugDrawAxis(0.0f, 0.0f, 0.0f, 1.0f, 4.0f);
            for (int i = 1; i < this.modelData.size(); ++i) {
                VehicleSubModelInstance vehicleSubModelInstance = Type.tryCastTo(((ModelInstanceRenderData)this.modelData.get((int)i)).modelInstance, VehicleSubModelInstance.class);
                if (vehicleSubModelInstance == null || vehicleSubModelInstance.modelInfo.wheelIndex < 0) continue;
                float f = 1.0f;
                object = baseVehicle.getScript().getWheel(vehicleSubModelInstance.modelInfo.wheelIndex);
                n = -1;
                vector3.set(((VehicleScript.Wheel)object).offset.x * (float)n, baseVehicle.getScript().getModel().offset.y + ((VehicleScript.Wheel)object).offset.y + baseVehicle.getScript().getSuspensionRestLength(), ((VehicleScript.Wheel)object).offset.z);
                Model.debugDrawAxis(vector3.x / f, vector3.y / f, vector3.z / f, baseVehicle.getScript().getSuspensionRestLength() / f, 2.0f);
            }
        }
        ModelCamera.instance.End();
    }

    private void performRenderCharacter() {
        ModelInstanceRenderData modelInstanceRenderData;
        int n;
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3089);
        ModelInstanceRenderDataList modelInstanceRenderDataList = this.modelData;
        if (this.character != null && !this.bReady) {
            modelInstanceRenderDataList = this.readyModelData;
        }
        Model.CharacterModelCameraBegin(this);
        for (n = 0; n < modelInstanceRenderDataList.size(); ++n) {
            modelInstanceRenderData = (ModelInstanceRenderData)modelInstanceRenderDataList.get(n);
            modelInstanceRenderData.RenderCharacter(this);
        }
        if (Core.bDebug) {
            this.renderDebug();
            for (n = 0; n < modelInstanceRenderDataList.size(); ++n) {
                modelInstanceRenderData = (ModelInstanceRenderData)modelInstanceRenderDataList.get(n);
                modelInstanceRenderData.renderDebug();
            }
        }
        Model.CharacterModelCameraEnd();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        GL11.glEnable((int)3553);
        SpriteRenderer.ringBuffer.restoreVBOs = true;
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRenderCharacterOutline() {
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3089);
        ModelInstanceRenderDataList modelInstanceRenderDataList = this.modelData;
        if (this.character != null && !this.bReady) {
            modelInstanceRenderDataList = this.readyModelData;
        }
        if (solidColor == null) {
            solidColor = new Shader("aim_outline_solid", false);
            solidColorStatic = new Shader("aim_outline_solid", true);
        }
        solidColor.Start();
        solidColor.getShaderProgram().setVector4("u_color", this.outlineColor.r, this.outlineColor.g, this.outlineColor.b, this.outlineColor.a);
        solidColor.End();
        solidColorStatic.Start();
        solidColorStatic.getShaderProgram().setVector4("u_color", this.outlineColor.r, this.outlineColor.g, this.outlineColor.b, this.outlineColor.a);
        solidColorStatic.End();
        boolean bl = ModelOutlines.instance.beginRenderOutline(this.outlineColor);
        ModelOutlines.instance.m_fboA.startDrawing(bl, true);
        Model.CharacterModelCameraBegin(this);
        for (int i = 0; i < modelInstanceRenderDataList.size(); ++i) {
            ModelInstanceRenderData modelInstanceRenderData = (ModelInstanceRenderData)modelInstanceRenderDataList.get(i);
            Shader shader = modelInstanceRenderData.model.Effect;
            try {
                modelInstanceRenderData.model.Effect = modelInstanceRenderData.model.bStatic ? solidColorStatic : solidColor;
                modelInstanceRenderData.RenderCharacter(this);
                continue;
            }
            finally {
                modelInstanceRenderData.model.Effect = shader;
            }
        }
        Model.CharacterModelCameraEnd();
        ModelOutlines.instance.m_fboA.endDrawing();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        GL11.glEnable((int)3553);
        SpriteRenderer.ringBuffer.restoreVBOs = true;
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    private void renderVehicle() {
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        if (this.RENDER_TO_TEXTURE) {
            GL11.glClear((int)256);
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glDisable((int)3089);
        if (this.RENDER_TO_TEXTURE) {
            ModelManager.instance.bitmap.startDrawing(true, true);
            GL11.glViewport((int)0, (int)0, (int)ModelManager.instance.bitmap.getWidth(), (int)ModelManager.instance.bitmap.getHeight());
        }
        for (int i = 0; i < this.modelData.size(); ++i) {
            ModelInstanceRenderData modelInstanceRenderData = (ModelInstanceRenderData)this.modelData.get(i);
            modelInstanceRenderData.RenderVehicle(this);
        }
        this.renderVehicleDebug();
        if (this.RENDER_TO_TEXTURE) {
            ModelManager.instance.bitmap.endDrawing();
        }
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        GL11.glEnable((int)3553);
        SpriteRenderer.ringBuffer.restoreBoundTextures = true;
        SpriteRenderer.ringBuffer.restoreVBOs = true;
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    private void doneWithTextureCreator(ModelInstanceTextureCreator modelInstanceTextureCreator) {
        if (modelInstanceTextureCreator == null) {
            return;
        }
        if (modelInstanceTextureCreator.testNotReady > 0) {
            --modelInstanceTextureCreator.testNotReady;
        }
        if (modelInstanceTextureCreator.renderRefCount > 0) {
            return;
        }
        if (modelInstanceTextureCreator.isRendered()) {
            modelInstanceTextureCreator.postRender();
            if (modelInstanceTextureCreator == this.character.getTextureCreator()) {
                this.character.setTextureCreator(null);
            }
        } else if (modelInstanceTextureCreator != this.character.getTextureCreator()) {
            modelInstanceTextureCreator.postRender();
        }
    }

    @Override
    public void postRender() {
        assert (this.modelSlot.renderRefCount > 0);
        --this.modelSlot.renderRefCount;
        if (this.textureCreator != null) {
            --this.textureCreator.renderRefCount;
            this.doneWithTextureCreator(this.textureCreator);
            this.textureCreator = null;
        }
        ModelInstanceRenderData.release(this.readyModelData);
        this.readyModelData.clear();
        if (this.bRendered) {
            ModelManager.instance.derefModelInstances(this.character.getReadyModelData());
            this.character.getReadyModelData().clear();
            for (int i = 0; i < this.modelData.size(); ++i) {
                ModelInstance modelInstance = ((ModelInstanceRenderData)this.modelData.get((int)i)).modelInstance;
                ++modelInstance.renderRefCount;
                this.character.getReadyModelData().add(modelInstance);
            }
        }
        this.character = null;
        this.object = null;
        this.animPlayer = null;
        this.m_debugRenderData = Pool.tryRelease(this.m_debugRenderData);
        ModelInstanceRenderData.release(this.modelData);
        pool.release(this);
    }

    public static ModelSlotRenderData alloc() {
        return pool.alloc();
    }

    static {
        pool = new ObjectPool<ModelSlotRenderData>(ModelSlotRenderData::new);
    }
}

