/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import zombie.characters.EquippedTextureCreator;
import zombie.core.SpriteRenderer;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.popman.ObjectPool;
import zombie.util.Type;

public final class ModelInstanceTextureInitializer {
    private boolean m_bRendered;
    private ModelInstance m_modelInstance;
    private InventoryItem m_item;
    private float m_bloodLevel;
    private int m_changeNumberMain = 0;
    private int m_changeNumberThread = 0;
    private final RenderData[] m_renderData = new RenderData[3];
    private static final ObjectPool<ModelInstanceTextureInitializer> pool = new ObjectPool<ModelInstanceTextureInitializer>(ModelInstanceTextureInitializer::new);

    public void init(ModelInstance modelInstance, InventoryItem inventoryItem) {
        this.m_item = inventoryItem;
        this.m_modelInstance = modelInstance;
        HandWeapon handWeapon = Type.tryCastTo(inventoryItem, HandWeapon.class);
        this.m_bloodLevel = handWeapon == null ? 0.0f : handWeapon.getBloodLevel();
        this.setDirty();
    }

    public void init(ModelInstance modelInstance, float f) {
        this.m_item = null;
        this.m_modelInstance = modelInstance;
        this.m_bloodLevel = f;
        this.setDirty();
    }

    public void setDirty() {
        ++this.m_changeNumberMain;
        this.m_bRendered = false;
    }

    public boolean isDirty() {
        return !this.m_bRendered;
    }

    public void renderMain() {
        if (this.m_bRendered) {
            return;
        }
        int n = SpriteRenderer.instance.getMainStateIndex();
        if (this.m_renderData[n] == null) {
            this.m_renderData[n] = new RenderData();
        }
        RenderData renderData = this.m_renderData[n];
        if (renderData.m_textureCreator != null) {
            return;
        }
        renderData.m_changeNumber = this.m_changeNumberMain;
        renderData.m_textureCreator = EquippedTextureCreator.alloc();
        if (this.m_item == null) {
            renderData.m_textureCreator.init(this.m_modelInstance, this.m_bloodLevel);
        } else {
            renderData.m_textureCreator.init(this.m_modelInstance, this.m_item);
        }
        renderData.m_bRendered = false;
    }

    public void render() {
        int n = SpriteRenderer.instance.getRenderStateIndex();
        RenderData renderData = this.m_renderData[n];
        if (renderData == null) {
            return;
        }
        if (renderData.m_textureCreator == null) {
            return;
        }
        if (renderData.m_bRendered) {
            return;
        }
        if (renderData.m_changeNumber == this.m_changeNumberThread) {
            renderData.m_bRendered = true;
            return;
        }
        renderData.m_textureCreator.render();
        if (renderData.m_textureCreator.isRendered()) {
            this.m_changeNumberThread = renderData.m_changeNumber;
            renderData.m_bRendered = true;
        }
    }

    public void postRender() {
        int n = SpriteRenderer.instance.getMainStateIndex();
        RenderData renderData = this.m_renderData[n];
        if (renderData == null) {
            return;
        }
        if (renderData.m_textureCreator == null) {
            return;
        }
        if (renderData.m_textureCreator.isRendered() && renderData.m_changeNumber == this.m_changeNumberMain) {
            this.m_bRendered = true;
        }
        if (renderData.m_bRendered) {
            renderData.m_textureCreator.postRender();
            renderData.m_textureCreator = null;
        }
    }

    public boolean isRendered() {
        int n = SpriteRenderer.instance.getRenderStateIndex();
        RenderData renderData = this.m_renderData[n];
        if (renderData == null) {
            return true;
        }
        if (renderData.m_textureCreator == null) {
            return true;
        }
        return renderData.m_bRendered;
    }

    public static ModelInstanceTextureInitializer alloc() {
        return pool.alloc();
    }

    public void release() {
        pool.release(this);
    }

    private static final class RenderData {
        int m_changeNumber = 0;
        boolean m_bRendered;
        EquippedTextureCreator m_textureCreator;

        private RenderData() {
        }
    }
}

