/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL11;
import zombie.asset.Asset;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.CharacterSmartTexture;
import zombie.characterTextures.ItemSmartTexture;
import zombie.characters.IsoGameCharacter;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.characters.WornItems.BodyLocations;
import zombie.core.Core;
import zombie.core.ImmutableColor;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.population.ClothingDecal;
import zombie.core.skinnedmodel.population.ClothingDecals;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.PopTemplateManager;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureCombiner;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.popman.ObjectPool;
import zombie.util.Lambda;
import zombie.util.StringUtils;

public final class ModelInstanceTextureCreator
extends TextureDraw.GenericDrawer {
    private boolean bZombie;
    public int renderRefCount;
    private final CharacterMask mask = new CharacterMask();
    private final boolean[] holeMask = new boolean[BloodBodyPartType.MAX.index()];
    private final ItemVisuals itemVisuals = new ItemVisuals();
    private final CharacterData chrData = new CharacterData();
    private final ArrayList<ItemData> itemData = new ArrayList();
    private final CharacterSmartTexture characterSmartTexture = new CharacterSmartTexture();
    private final ItemSmartTexture itemSmartTexture = new ItemSmartTexture(null);
    private final ArrayList<Texture> tempTextures = new ArrayList();
    private boolean bRendered = false;
    private final ArrayList<Texture> texturesNotReady = new ArrayList();
    public int testNotReady = -1;
    private static final ObjectPool<ModelInstanceTextureCreator> pool = new ObjectPool<ModelInstanceTextureCreator>(ModelInstanceTextureCreator::new);

    public void init(IsoGameCharacter isoGameCharacter) {
        ModelManager.ModelSlot modelSlot = isoGameCharacter.legsSprite.modelSlot;
        HumanVisual humanVisual = ((IHumanVisual)((Object)isoGameCharacter)).getHumanVisual();
        isoGameCharacter.getItemVisuals(this.itemVisuals);
        this.init(humanVisual, this.itemVisuals, modelSlot.model);
        this.itemVisuals.clear();
    }

    public void init(BaseVisual baseVisual, ItemVisuals itemVisuals, ModelInstance modelInstance) {
        if (baseVisual instanceof HumanVisual) {
            this.init((HumanVisual)baseVisual, itemVisuals, modelInstance);
            return;
        }
        throw new IllegalArgumentException("unhandled BaseVisual " + baseVisual);
    }

    public void init(HumanVisual humanVisual, ItemVisuals itemVisuals, ModelInstance modelInstance) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n2;
        boolean bl = DebugLog.isEnabled(DebugType.Clothing);
        this.bRendered = false;
        this.bZombie = humanVisual.isZombie();
        CharacterMask characterMask = this.mask;
        characterMask.setAllVisible(true);
        String string2 = "media/textures/Body/Masks";
        Arrays.fill(this.holeMask, false);
        ItemData.pool.release((List<ItemData>)this.itemData);
        this.itemData.clear();
        this.texturesNotReady.clear();
        BodyLocationGroup bodyLocationGroup = BodyLocations.getGroup("Human");
        for (n2 = itemVisuals.size() - 1; n2 >= 0; --n2) {
            int n3;
            object6 = (ItemVisual)itemVisuals.get(n2);
            object5 = ((ItemVisual)object6).getClothingItem();
            if (object5 == null) {
                if (!bl) continue;
                DebugLog.Clothing.warn("ClothingItem not found for ItemVisual:" + (ItemVisual)object6);
                continue;
            }
            if (!((Asset)object5).isReady()) {
                if (!bl) continue;
                DebugLog.Clothing.warn("ClothingItem not ready for ItemVisual:" + (ItemVisual)object6);
                continue;
            }
            if (PopTemplateManager.instance.isItemModelHidden(bodyLocationGroup, itemVisuals, (ItemVisual)object6)) continue;
            object4 = this.findModelInstance(modelInstance.sub, (ItemVisual)object6);
            if (object4 == null && !StringUtils.isNullOrWhitespace((String)(object3 = ((ClothingItem)object5).getModel(humanVisual.isFemale())))) {
                if (!bl) continue;
                DebugLog.Clothing.warn("ModelInstance not found for ItemVisual:" + (ItemVisual)object6);
                continue;
            }
            this.addClothingItem((ModelInstance)object4, (ItemVisual)object6, (ClothingItem)object5, characterMask, string2);
            for (n3 = 0; n3 < BloodBodyPartType.MAX.index(); ++n3) {
                object2 = BloodBodyPartType.FromIndex(n3);
                if (!(((ItemVisual)object6).getHole((BloodBodyPartType)((Object)object2)) > 0.0f) || !characterMask.isBloodBodyPartVisible((BloodBodyPartType)((Object)object2))) continue;
                this.holeMask[n3] = true;
            }
            for (n3 = 0; n3 < ((ClothingItem)object5).m_Masks.size(); ++n3) {
                object2 = CharacterMask.Part.fromInt(((ClothingItem)object5).m_Masks.get(n3));
                object = ((CharacterMask.Part)((Object)object2)).getBloodBodyPartTypes();
                int n4 = ((BloodBodyPartType[])object).length;
                for (int i = 0; i < n4; ++i) {
                    BloodBodyPartType bloodBodyPartType = object[i];
                    if (!(((ItemVisual)object6).getHole(bloodBodyPartType) <= 0.0f)) continue;
                    this.holeMask[bloodBodyPartType.index()] = false;
                }
            }
            ((ItemVisual)object6).getClothingItemCombinedMask(characterMask);
            if (StringUtils.equalsIgnoreCase(((ClothingItem)object5).m_UnderlayMasksFolder, "media/textures/Body/Masks")) continue;
            string2 = ((ClothingItem)object5).m_UnderlayMasksFolder;
        }
        this.chrData.modelInstance = modelInstance;
        this.chrData.mask.copyFrom(characterMask);
        this.chrData.maskFolder = string2;
        this.chrData.baseTexture = "media/textures/Body/" + humanVisual.getSkinTexture() + ".png";
        Arrays.fill(this.chrData.blood, 0.0f);
        for (n2 = 0; n2 < BloodBodyPartType.MAX.index(); ++n2) {
            object6 = BloodBodyPartType.FromIndex(n2);
            this.chrData.blood[n2] = humanVisual.getBlood((BloodBodyPartType)((Object)object6));
            this.chrData.dirt[n2] = humanVisual.getDirt((BloodBodyPartType)((Object)object6));
        }
        Texture texture = ModelInstanceTextureCreator.getTextureWithFlags(this.chrData.baseTexture);
        if (texture != null && !texture.isReady()) {
            this.texturesNotReady.add(texture);
        }
        if (!this.chrData.mask.isAllVisible() && !this.chrData.mask.isNothingVisible()) {
            object6 = this.chrData.maskFolder;
            object5 = Lambda.consumer(object6, this.texturesNotReady, (part, string, arrayList) -> {
                Texture texture = ModelInstanceTextureCreator.getTextureWithFlags(string + "/" + part + ".png");
                if (texture != null && !texture.isReady()) {
                    arrayList.add(texture);
                }
            });
            this.chrData.mask.forEachVisible((Consumer<CharacterMask.Part>)object5);
        }
        if ((texture = ModelInstanceTextureCreator.getTextureWithFlags("media/textures/BloodTextures/BloodOverlay.png")) != null && !texture.isReady()) {
            this.texturesNotReady.add(texture);
        }
        if ((texture = ModelInstanceTextureCreator.getTextureWithFlags("media/textures/BloodTextures/GrimeOverlay.png")) != null && !texture.isReady()) {
            this.texturesNotReady.add(texture);
        }
        if ((texture = ModelInstanceTextureCreator.getTextureWithFlags("media/textures/patches/patchesmask.png")) != null && !texture.isReady()) {
            this.texturesNotReady.add(texture);
        }
        for (n = 0; n < BloodBodyPartType.MAX.index(); ++n) {
            String string3;
            object5 = BloodBodyPartType.FromIndex(n);
            object4 = "media/textures/BloodTextures/" + CharacterSmartTexture.MaskFiles[((BloodBodyPartType)((Object)object5)).index()] + ".png";
            texture = ModelInstanceTextureCreator.getTextureWithFlags((String)object4);
            if (texture != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if ((texture = ModelInstanceTextureCreator.getTextureWithFlags((String)(object3 = "media/textures/HoleTextures/" + CharacterSmartTexture.MaskFiles[((BloodBodyPartType)((Object)object5)).index()] + ".png"))) != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if ((texture = ModelInstanceTextureCreator.getTextureWithFlags((String)(object2 = "media/textures/patches/" + CharacterSmartTexture.BasicPatchesMaskFiles[((BloodBodyPartType)((Object)object5)).index()] + ".png"))) != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if ((texture = ModelInstanceTextureCreator.getTextureWithFlags((String)(object = "media/textures/patches/" + CharacterSmartTexture.DenimPatchesMaskFiles[((BloodBodyPartType)((Object)object5)).index()] + ".png"))) != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if ((texture = ModelInstanceTextureCreator.getTextureWithFlags(string3 = "media/textures/patches/" + CharacterSmartTexture.LeatherPatchesMaskFiles[((BloodBodyPartType)((Object)object5)).index()] + ".png")) == null || texture.isReady()) continue;
            this.texturesNotReady.add(texture);
        }
        characterMask.setAllVisible(true);
        string2 = "media/textures/Body/Masks";
        for (n = humanVisual.getBodyVisuals().size() - 1; n >= 0; --n) {
            object5 = (ItemVisual)humanVisual.getBodyVisuals().get(n);
            object4 = ((ItemVisual)object5).getClothingItem();
            if (object4 == null) {
                if (!bl) continue;
                DebugLog.Clothing.warn("ClothingItem not found for ItemVisual:" + (ItemVisual)object5);
                continue;
            }
            if (!((Asset)object4).isReady()) {
                if (!bl) continue;
                DebugLog.Clothing.warn("ClothingItem not ready for ItemVisual:" + (ItemVisual)object5);
                continue;
            }
            object3 = this.findModelInstance(modelInstance.sub, (ItemVisual)object5);
            if (object3 == null && !StringUtils.isNullOrWhitespace((String)(object2 = ((ClothingItem)object4).getModel(humanVisual.isFemale())))) {
                if (!bl) continue;
                DebugLog.Clothing.warn("ModelInstance not found for ItemVisual:" + (ItemVisual)object5);
                continue;
            }
            this.addClothingItem((ModelInstance)object3, (ItemVisual)object5, (ClothingItem)object4, characterMask, string2);
        }
    }

    private ModelInstance findModelInstance(ArrayList<ModelInstance> arrayList, ItemVisual itemVisual) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ModelInstance modelInstance = arrayList.get(i);
            ItemVisual itemVisual2 = modelInstance.getItemVisual();
            if (itemVisual2 == null || itemVisual2.getClothingItem() != itemVisual.getClothingItem()) continue;
            return modelInstance;
        }
        return null;
    }

    private void addClothingItem(ModelInstance modelInstance, ItemVisual itemVisual, ClothingItem clothingItem, CharacterMask characterMask, String string2) {
        Object object;
        String string3;
        String string4 = modelInstance == null ? itemVisual.getBaseTexture(clothingItem) : itemVisual.getTextureChoice(clothingItem);
        ImmutableColor immutableColor = itemVisual.getTint(clothingItem);
        float f = itemVisual.getHue(clothingItem);
        ItemData itemData = ItemData.pool.alloc();
        itemData.modelInstance = modelInstance;
        itemData.category = CharacterSmartTexture.ClothingItemCategory;
        itemData.mask.copyFrom(characterMask);
        itemData.maskFolder = clothingItem.m_MasksFolder;
        if (StringUtils.equalsIgnoreCase(itemData.maskFolder, "media/textures/Body/Masks")) {
            itemData.maskFolder = string2;
        }
        if (StringUtils.equalsIgnoreCase(itemData.maskFolder, "none")) {
            itemData.mask.setAllVisible(true);
        }
        if (itemData.maskFolder.contains("Clothes/Hat/Masks")) {
            itemData.mask.setAllVisible(true);
        }
        itemData.baseTexture = "media/textures/" + string4 + ".png";
        itemData.tint = immutableColor;
        itemData.hue = f;
        itemData.decalTexture = null;
        Arrays.fill(itemData.basicPatches, 0.0f);
        Arrays.fill(itemData.denimPatches, 0.0f);
        Arrays.fill(itemData.leatherPatches, 0.0f);
        Arrays.fill(itemData.blood, 0.0f);
        Arrays.fill(itemData.dirt, 0.0f);
        Arrays.fill(itemData.hole, 0.0f);
        int n = ModelManager.instance.getTextureFlags();
        Texture texture = Texture.getSharedTexture(itemData.baseTexture, n);
        if (texture != null && !texture.isReady()) {
            this.texturesNotReady.add(texture);
        }
        if (!itemData.mask.isAllVisible() && !itemData.mask.isNothingVisible()) {
            string3 = itemData.maskFolder;
            object = Lambda.consumer(string3, this.texturesNotReady, (part, string, arrayList) -> {
                Texture texture = ModelInstanceTextureCreator.getTextureWithFlags(string + "/" + part + ".png");
                if (texture != null && !texture.isReady()) {
                    arrayList.add(texture);
                }
            });
            itemData.mask.forEachVisible((Consumer<CharacterMask.Part>)object);
        }
        if (Core.getInstance().isOptionSimpleClothingTextures(this.bZombie)) {
            this.itemData.add(itemData);
            return;
        }
        string3 = itemVisual.getDecal(clothingItem);
        if (!StringUtils.isNullOrWhitespace(string3) && (object = ClothingDecals.instance.getDecal(string3)) != null && ((ClothingDecal)object).isValid()) {
            itemData.decalTexture = ((ClothingDecal)object).texture;
            itemData.decalX = ((ClothingDecal)object).x;
            itemData.decalY = ((ClothingDecal)object).y;
            itemData.decalWidth = ((ClothingDecal)object).width;
            itemData.decalHeight = ((ClothingDecal)object).height;
            texture = ModelInstanceTextureCreator.getTextureWithFlags("media/textures/" + itemData.decalTexture + ".png");
            if (texture != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
        }
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            String string5;
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            itemData.blood[i] = itemVisual.getBlood(bloodBodyPartType);
            itemData.dirt[i] = itemVisual.getDirt(bloodBodyPartType);
            itemData.basicPatches[i] = itemVisual.getBasicPatch(bloodBodyPartType);
            itemData.denimPatches[i] = itemVisual.getDenimPatch(bloodBodyPartType);
            itemData.leatherPatches[i] = itemVisual.getLeatherPatch(bloodBodyPartType);
            itemData.hole[i] = itemVisual.getHole(bloodBodyPartType);
            if (itemData.hole[i] > 0.0f && (texture = ModelInstanceTextureCreator.getTextureWithFlags(string5 = "media/textures/HoleTextures/" + CharacterSmartTexture.MaskFiles[bloodBodyPartType.index()] + ".png")) != null && !texture.isReady()) {
                this.texturesNotReady.add(texture);
            }
            if (itemData.hole[i] != 0.0f || !this.holeMask[i]) continue;
            itemData.hole[i] = -1.0f;
            if (!itemData.mask.isBloodBodyPartVisible(bloodBodyPartType)) continue;
        }
        this.itemData.add(itemData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        if (this.bRendered) {
            return;
        }
        for (int i = 0; i < this.texturesNotReady.size(); ++i) {
            Texture texture = this.texturesNotReady.get(i);
            if (texture.isReady()) continue;
            return;
        }
        GL11.glPushAttrib((int)2048);
        try {
            Object object;
            int n;
            this.tempTextures.clear();
            CharacterSmartTexture characterSmartTexture = this.createFullCharacterTexture();
            assert (characterSmartTexture == this.characterSmartTexture);
            if (!(this.chrData.modelInstance.tex instanceof CharacterSmartTexture)) {
                this.chrData.modelInstance.tex = new CharacterSmartTexture();
            }
            ((CharacterSmartTexture)this.chrData.modelInstance.tex).clear();
            this.applyCharacterTexture(characterSmartTexture.result, (CharacterSmartTexture)this.chrData.modelInstance.tex);
            characterSmartTexture.clear();
            this.tempTextures.add(characterSmartTexture.result);
            characterSmartTexture.result = null;
            characterSmartTexture = (CharacterSmartTexture)this.chrData.modelInstance.tex;
            for (n = this.itemData.size() - 1; n >= 0; --n) {
                ItemData itemData = this.itemData.get(n);
                if (this.isSimpleTexture(itemData)) {
                    int n2 = ModelManager.instance.getTextureFlags();
                    object = Texture.getSharedTexture(itemData.baseTexture, n2);
                    if (!this.isItemSmartTextureRequired(itemData)) {
                        itemData.modelInstance.tex = object;
                        continue;
                    }
                } else {
                    ItemSmartTexture itemSmartTexture = this.createFullItemTexture(itemData);
                    assert (itemSmartTexture == this.itemSmartTexture);
                    object = itemSmartTexture.result;
                    this.tempTextures.add(itemSmartTexture.result);
                    itemSmartTexture.result = null;
                }
                if (itemData.modelInstance == null) {
                    this.applyItemTexture(itemData, (Texture)object, characterSmartTexture);
                    continue;
                }
                if (!(itemData.modelInstance.tex instanceof ItemSmartTexture)) {
                    itemData.modelInstance.tex = new ItemSmartTexture(null);
                }
                ((ItemSmartTexture)itemData.modelInstance.tex).clear();
                this.applyItemTexture(itemData, (Texture)object, (ItemSmartTexture)itemData.modelInstance.tex);
                ((ItemSmartTexture)itemData.modelInstance.tex).calculate();
                ((ItemSmartTexture)itemData.modelInstance.tex).clear();
            }
            characterSmartTexture.calculate();
            characterSmartTexture.clear();
            this.itemSmartTexture.clear();
            for (n = 0; n < this.tempTextures.size(); ++n) {
                for (int i = 0; i < this.itemData.size(); ++i) {
                    object = this.itemData.get((int)i).modelInstance;
                    if (object != null && this.tempTextures.get(n) == ((ModelInstance)object).tex) assert (false);
                }
                TextureCombiner.instance.releaseTexture(this.tempTextures.get(n));
            }
            this.tempTextures.clear();
        }
        finally {
            GL11.glPopAttrib();
        }
        this.bRendered = true;
    }

    private CharacterSmartTexture createFullCharacterTexture() {
        CharacterSmartTexture characterSmartTexture = this.characterSmartTexture;
        characterSmartTexture.clear();
        characterSmartTexture.addTexture(this.chrData.baseTexture, CharacterSmartTexture.BodyCategory, ImmutableColor.white, 0.0f);
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            if (this.chrData.dirt[i] > 0.0f) {
                characterSmartTexture.addDirt(bloodBodyPartType, this.chrData.dirt[i], null);
            }
            if (!(this.chrData.blood[i] > 0.0f)) continue;
            characterSmartTexture.addBlood(bloodBodyPartType, this.chrData.blood[i], null);
        }
        characterSmartTexture.calculate();
        return characterSmartTexture;
    }

    private void applyCharacterTexture(Texture texture, CharacterSmartTexture characterSmartTexture) {
        characterSmartTexture.addMaskedTexture(this.chrData.mask, this.chrData.maskFolder, texture, CharacterSmartTexture.BodyCategory, ImmutableColor.white, 0.0f);
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            if (!this.holeMask[i]) continue;
            characterSmartTexture.removeHole(texture, bloodBodyPartType);
        }
    }

    private boolean isSimpleTexture(ItemData itemData) {
        if (itemData.hue != 0.0f) {
            return false;
        }
        ImmutableColor immutableColor = itemData.tint;
        if (itemData.modelInstance != null) {
            immutableColor = ImmutableColor.white;
        }
        if (!immutableColor.equals(ImmutableColor.white)) {
            return false;
        }
        if (itemData.decalTexture != null) {
            return false;
        }
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            if (itemData.blood[i] > 0.0f) {
                return false;
            }
            if (itemData.dirt[i] > 0.0f) {
                return false;
            }
            if (itemData.hole[i] > 0.0f) {
                return false;
            }
            if (itemData.basicPatches[i] > 0.0f) {
                return false;
            }
            if (itemData.denimPatches[i] > 0.0f) {
                return false;
            }
            if (!(itemData.leatherPatches[i] > 0.0f)) continue;
            return false;
        }
        return true;
    }

    private ItemSmartTexture createFullItemTexture(ItemData itemData) {
        BloodBodyPartType bloodBodyPartType;
        int n;
        ItemSmartTexture itemSmartTexture = this.itemSmartTexture;
        itemSmartTexture.clear();
        ImmutableColor immutableColor = itemData.tint;
        if (itemData.modelInstance != null) {
            itemData.modelInstance.tintB = 1.0f;
            itemData.modelInstance.tintG = 1.0f;
            itemData.modelInstance.tintR = 1.0f;
        }
        itemSmartTexture.addTexture(itemData.baseTexture, itemData.category, immutableColor, itemData.hue);
        if (itemData.decalTexture != null) {
            itemSmartTexture.addRect("media/textures/" + itemData.decalTexture + ".png", itemData.decalX, itemData.decalY, itemData.decalWidth, itemData.decalHeight);
        }
        for (n = 0; n < BloodBodyPartType.MAX.index(); ++n) {
            if (itemData.blood[n] > 0.0f) {
                bloodBodyPartType = BloodBodyPartType.FromIndex(n);
                itemSmartTexture.addBlood("media/textures/BloodTextures/BloodOverlay.png", bloodBodyPartType, itemData.blood[n]);
            }
            if (itemData.dirt[n] > 0.0f) {
                bloodBodyPartType = BloodBodyPartType.FromIndex(n);
                itemSmartTexture.addDirt("media/textures/BloodTextures/GrimeOverlay.png", bloodBodyPartType, itemData.dirt[n]);
            }
            if (itemData.basicPatches[n] > 0.0f) {
                bloodBodyPartType = BloodBodyPartType.FromIndex(n);
                itemSmartTexture.setBasicPatches(bloodBodyPartType);
            }
            if (itemData.denimPatches[n] > 0.0f) {
                bloodBodyPartType = BloodBodyPartType.FromIndex(n);
                itemSmartTexture.setDenimPatches(bloodBodyPartType);
            }
            if (!(itemData.leatherPatches[n] > 0.0f)) continue;
            bloodBodyPartType = BloodBodyPartType.FromIndex(n);
            itemSmartTexture.setLeatherPatches(bloodBodyPartType);
        }
        for (n = 0; n < BloodBodyPartType.MAX.index(); ++n) {
            if (!(itemData.hole[n] > 0.0f)) continue;
            bloodBodyPartType = BloodBodyPartType.FromIndex(n);
            Texture texture = itemSmartTexture.addHole(bloodBodyPartType);
            assert (texture != itemSmartTexture.result);
            this.tempTextures.add(texture);
        }
        itemSmartTexture.calculate();
        return itemSmartTexture;
    }

    private boolean isItemSmartTextureRequired(ItemData itemData) {
        if (itemData.modelInstance == null) {
            return true;
        }
        if (itemData.modelInstance.tex instanceof ItemSmartTexture) {
            return true;
        }
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            if (!(itemData.hole[i] < 0.0f)) continue;
            return true;
        }
        return !itemData.mask.isAllVisible();
    }

    private void applyItemTexture(ItemData itemData, Texture texture, SmartTexture smartTexture) {
        smartTexture.addMaskedTexture(itemData.mask, itemData.maskFolder, texture, itemData.category, ImmutableColor.white, 0.0f);
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            if (!(itemData.hole[i] < 0.0f)) continue;
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(i);
            smartTexture.removeHole(texture, bloodBodyPartType);
        }
    }

    @Override
    public void postRender() {
        int n;
        if (!this.bRendered) {
            n = this.chrData.modelInstance.character == null ? 1 : 1;
        }
        for (n = 0; n < this.itemData.size(); ++n) {
            this.itemData.get((int)n).modelInstance = null;
        }
        this.chrData.modelInstance = null;
        this.texturesNotReady.clear();
        ItemData.pool.release((List<ItemData>)this.itemData);
        this.itemData.clear();
        pool.release(this);
    }

    public boolean isRendered() {
        if (this.testNotReady > 0) {
            return false;
        }
        return this.bRendered;
    }

    private static Texture getTextureWithFlags(String string) {
        return Texture.getSharedTexture(string, ModelManager.instance.getTextureFlags());
    }

    public static ModelInstanceTextureCreator alloc() {
        return pool.alloc();
    }

    private static final class CharacterData {
        ModelInstance modelInstance;
        final CharacterMask mask = new CharacterMask();
        String maskFolder;
        String baseTexture;
        final float[] blood = new float[BloodBodyPartType.MAX.index()];
        final float[] dirt = new float[BloodBodyPartType.MAX.index()];

        private CharacterData() {
        }
    }

    private static final class ItemData {
        ModelInstance modelInstance;
        final CharacterMask mask = new CharacterMask();
        String maskFolder;
        String baseTexture;
        int category;
        ImmutableColor tint;
        float hue;
        String decalTexture;
        int decalX;
        int decalY;
        int decalWidth;
        int decalHeight;
        final float[] blood = new float[BloodBodyPartType.MAX.index()];
        final float[] dirt = new float[BloodBodyPartType.MAX.index()];
        final float[] basicPatches = new float[BloodBodyPartType.MAX.index()];
        final float[] denimPatches = new float[BloodBodyPartType.MAX.index()];
        final float[] leatherPatches = new float[BloodBodyPartType.MAX.index()];
        final float[] hole = new float[BloodBodyPartType.MAX.index()];
        static final ObjectPool<ItemData> pool = new ObjectPool<ItemData>(ItemData::new);

        private ItemData() {
        }
    }
}

