/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.model;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjglx.BufferUtils;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceDebugRenderData;
import zombie.core.skinnedmodel.model.ModelSlotRenderData;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.SoftwareModelMeshInstance;
import zombie.core.skinnedmodel.model.VehicleModelInstance;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.popman.ObjectPool;
import zombie.scripting.objects.ModelAttachment;
import zombie.util.Pool;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class ModelInstanceRenderData {
    private static final Vector3f tempVector3f = new Vector3f();
    public Model model;
    public Texture tex;
    public float depthBias;
    public float hue;
    public float tintR;
    public float tintG;
    public float tintB;
    public int parentBone;
    public FloatBuffer matrixPalette;
    public final org.joml.Matrix4f xfrm = new org.joml.Matrix4f();
    public SoftwareModelMeshInstance softwareMesh;
    public ModelInstance modelInstance;
    public boolean m_muzzleFlash = false;
    protected ModelInstanceDebugRenderData m_debugRenderData;
    private static final ObjectPool<ModelInstanceRenderData> pool = new ObjectPool<ModelInstanceRenderData>(ModelInstanceRenderData::new);

    public ModelInstanceRenderData init(ModelInstance modelInstance) {
        Object object;
        this.model = modelInstance.model;
        this.tex = modelInstance.tex;
        this.depthBias = modelInstance.depthBias;
        this.hue = modelInstance.hue;
        this.parentBone = modelInstance.parentBone;
        assert (modelInstance.character == null || modelInstance.AnimPlayer != null);
        this.m_muzzleFlash = false;
        this.xfrm.identity();
        if (modelInstance.AnimPlayer != null && !this.model.bStatic) {
            object = (SkinningData)this.model.Tag;
            if (Core.bDebug && object == null) {
                DebugLog.General.warn("skinningData is null, matrixPalette may be invalid");
            }
            Matrix4f[] matrix4fArray = modelInstance.AnimPlayer.getSkinTransforms((SkinningData)object);
            if (this.matrixPalette == null || this.matrixPalette.capacity() < matrix4fArray.length * 16) {
                this.matrixPalette = BufferUtils.createFloatBuffer(matrix4fArray.length * 16);
            }
            this.matrixPalette.clear();
            for (int i = 0; i < matrix4fArray.length; ++i) {
                matrix4fArray[i].store(this.matrixPalette);
            }
            this.matrixPalette.flip();
        }
        object = Type.tryCastTo(modelInstance, VehicleSubModelInstance.class);
        if (modelInstance instanceof VehicleModelInstance || object != null) {
            if (modelInstance instanceof VehicleModelInstance) {
                this.xfrm.set(((BaseVehicle)modelInstance.object).renderTransform);
            } else {
                this.xfrm.set(((VehicleSubModelInstance)object).modelInfo.renderTransform);
            }
            if (modelInstance.model.Mesh != null && modelInstance.model.Mesh.isReady() && modelInstance.model.Mesh.m_transform != null) {
                modelInstance.model.Mesh.m_transform.transpose();
                this.xfrm.mul(modelInstance.model.Mesh.m_transform);
                modelInstance.model.Mesh.m_transform.transpose();
            }
        }
        this.softwareMesh = modelInstance.softwareMesh;
        this.modelInstance = modelInstance;
        ++modelInstance.renderRefCount;
        if (modelInstance.getTextureInitializer() != null) {
            modelInstance.getTextureInitializer().renderMain();
        }
        return this;
    }

    public void renderDebug() {
        if (this.m_debugRenderData != null) {
            this.m_debugRenderData.render();
        }
    }

    public void RenderCharacter(ModelSlotRenderData modelSlotRenderData) {
        this.tintR = this.modelInstance.tintR;
        this.tintG = this.modelInstance.tintG;
        this.tintB = this.modelInstance.tintB;
        this.tex = this.modelInstance.tex;
        if (this.tex == null && this.modelInstance.model.tex == null) {
            return;
        }
        this.model.DrawChar(modelSlotRenderData, this);
    }

    public void RenderVehicle(ModelSlotRenderData modelSlotRenderData) {
        this.tintR = this.modelInstance.tintR;
        this.tintG = this.modelInstance.tintG;
        this.tintB = this.modelInstance.tintB;
        this.tex = this.modelInstance.tex;
        if (this.tex == null && this.modelInstance.model.tex == null) {
            return;
        }
        this.model.DrawVehicle(modelSlotRenderData, this);
    }

    public static org.joml.Matrix4f makeAttachmentTransform(ModelAttachment modelAttachment, org.joml.Matrix4f matrix4f) {
        matrix4f.translation(modelAttachment.getOffset());
        org.joml.Vector3f vector3f = modelAttachment.getRotate();
        matrix4f.rotateXYZ(vector3f.x * ((float)Math.PI / 180), vector3f.y * ((float)Math.PI / 180), vector3f.z * ((float)Math.PI / 180));
        return matrix4f;
    }

    public static void applyBoneTransform(ModelInstance modelInstance, String string, org.joml.Matrix4f matrix4f) {
        if (modelInstance == null || modelInstance.AnimPlayer == null) {
            return;
        }
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        int n = modelInstance.AnimPlayer.getSkinningBoneIndex(string, -1);
        if (n == -1) {
            return;
        }
        Matrix4f matrix4f2 = modelInstance.AnimPlayer.GetPropBoneMatrix(n);
        org.joml.Matrix4f matrix4f3 = (org.joml.Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
        PZMath.convertMatrix(matrix4f2, matrix4f3);
        matrix4f3.transpose();
        matrix4f.mul(matrix4f3);
        BaseVehicle.TL_matrix4f_pool.get().release(matrix4f3);
    }

    public ModelInstanceRenderData transformToParent(ModelInstanceRenderData modelInstanceRenderData) {
        ModelAttachment modelAttachment;
        if (this.modelInstance instanceof VehicleModelInstance || this.modelInstance instanceof VehicleSubModelInstance) {
            return this;
        }
        if (modelInstanceRenderData == null) {
            return this;
        }
        this.xfrm.set(modelInstanceRenderData.xfrm);
        this.xfrm.transpose();
        org.joml.Matrix4f matrix4f = (org.joml.Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
        ModelAttachment modelAttachment2 = modelInstanceRenderData.modelInstance.getAttachmentById(this.modelInstance.attachmentNameParent);
        if (modelAttachment2 == null) {
            if (this.modelInstance.parentBoneName != null && modelInstanceRenderData.modelInstance.AnimPlayer != null) {
                ModelInstanceRenderData.applyBoneTransform(modelInstanceRenderData.modelInstance, this.modelInstance.parentBoneName, this.xfrm);
            }
        } else {
            ModelInstanceRenderData.applyBoneTransform(modelInstanceRenderData.modelInstance, modelAttachment2.getBone(), this.xfrm);
            ModelInstanceRenderData.makeAttachmentTransform(modelAttachment2, matrix4f);
            this.xfrm.mul(matrix4f);
        }
        if ((modelAttachment = this.modelInstance.getAttachmentById(this.modelInstance.attachmentNameSelf)) != null) {
            ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, matrix4f);
            matrix4f.invert();
            this.xfrm.mul(matrix4f);
        }
        if (this.modelInstance.model.Mesh != null && this.modelInstance.model.Mesh.isReady() && this.modelInstance.model.Mesh.m_transform != null) {
            this.xfrm.mul(this.modelInstance.model.Mesh.m_transform);
        }
        if (this.modelInstance.scale != 1.0f) {
            this.xfrm.scale(this.modelInstance.scale);
        }
        this.xfrm.transpose();
        BaseVehicle.TL_matrix4f_pool.get().release(matrix4f);
        return this;
    }

    private void testOnBackItem(ModelInstance modelInstance) {
        ModelAttachment modelAttachment;
        if (modelInstance.parent == null || modelInstance.parent.m_modelScript == null) {
            return;
        }
        AnimationPlayer animationPlayer = modelInstance.parent.AnimPlayer;
        ModelAttachment modelAttachment2 = null;
        for (int i = 0; i < modelInstance.parent.m_modelScript.getAttachmentCount(); ++i) {
            modelAttachment = modelInstance.parent.getAttachment(i);
            if (modelAttachment.getBone() == null || this.parentBone != animationPlayer.getSkinningBoneIndex(modelAttachment.getBone(), 0)) continue;
            modelAttachment2 = modelAttachment;
            break;
        }
        if (modelAttachment2 == null) {
            return;
        }
        org.joml.Matrix4f matrix4f = (org.joml.Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
        ModelInstanceRenderData.makeAttachmentTransform(modelAttachment2, matrix4f);
        this.xfrm.transpose();
        this.xfrm.mul(matrix4f);
        this.xfrm.transpose();
        modelAttachment = modelInstance.getAttachmentById(modelAttachment2.getId());
        if (modelAttachment != null) {
            ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, matrix4f);
            matrix4f.invert();
            this.xfrm.transpose();
            this.xfrm.mul(matrix4f);
            this.xfrm.transpose();
        }
        BaseVehicle.TL_matrix4f_pool.get().release(matrix4f);
    }

    public static ModelInstanceRenderData alloc() {
        return pool.alloc();
    }

    public static void release(ArrayList<ModelInstanceRenderData> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ModelInstanceRenderData modelInstanceRenderData = arrayList.get(i);
            if (modelInstanceRenderData.modelInstance.getTextureInitializer() != null) {
                modelInstanceRenderData.modelInstance.getTextureInitializer().postRender();
            }
            ModelManager.instance.derefModelInstance(modelInstanceRenderData.modelInstance);
            modelInstanceRenderData.modelInstance = null;
            modelInstanceRenderData.model = null;
            modelInstanceRenderData.tex = null;
            modelInstanceRenderData.softwareMesh = null;
            modelInstanceRenderData.m_debugRenderData = Pool.tryRelease(modelInstanceRenderData.m_debugRenderData);
        }
        pool.release((List<ModelInstanceRenderData>)arrayList);
    }
}

