/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation.debug;

import java.util.List;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.debug.GenericNameWeightRecordingFrame;
import zombie.iso.Vector2;

public final class AnimationTrackRecordingFrame
extends GenericNameWeightRecordingFrame {
    private Vector2 m_deferredMovement = new Vector2();

    public AnimationTrackRecordingFrame(String string) {
        super(string);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_deferredMovement.set(0.0f, 0.0f);
    }

    public void logAnimWeights(List<AnimationTrack> list, int[] nArray, float[] fArray, Vector2 vector22) {
        int n;
        for (int i = 0; i < nArray.length && (n = nArray[i]) >= 0; ++i) {
            float f = fArray[i];
            AnimationTrack animationTrack = list.get(n);
            String string = animationTrack.name;
            int n2 = animationTrack.getLayerIdx();
            this.logWeight(string, n2, f);
        }
        this.m_deferredMovement.set(vector22);
    }

    public Vector2 getDeferredMovement() {
        return this.m_deferredMovement;
    }

    @Override
    public void writeHeader(StringBuilder stringBuilder) {
        stringBuilder.append(",");
        stringBuilder.append("dm.x").append(",").append("dm.y");
        super.writeHeader(stringBuilder);
    }

    @Override
    protected void writeData(StringBuilder stringBuilder) {
        stringBuilder.append(",");
        stringBuilder.append(this.getDeferredMovement().x).append(",").append(this.getDeferredMovement().y);
        super.writeData(stringBuilder);
    }
}

