/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector3f;
import zombie.core.PerformanceSettings;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.HelperFunctions;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.Keyframe;

@Deprecated
public class StaticAnimation {
    private int framesPerSecond;
    public String name;
    public Matrix4f[][] Matrices;
    private Matrix4f[] RootMotion;
    public AnimationClip Clip;
    private int currentKeyframe = 0;
    private float currentTimeValue = 0.0f;
    private Keyframe[] Pose;
    private Keyframe[] PrevPose;
    private float lastTime = 0.0f;

    public StaticAnimation(AnimationClip animationClip) {
        this.Clip = animationClip;
        this.framesPerSecond = PerformanceSettings.BaseStaticAnimFramerate;
        this.Matrices = new Matrix4f[(int)((float)this.framesPerSecond * this.Clip.Duration)][60];
        this.RootMotion = new Matrix4f[(int)((float)this.framesPerSecond * this.Clip.Duration)];
        this.Pose = new Keyframe[60];
        this.PrevPose = new Keyframe[60];
        this.Create();
        Arrays.fill(this.Pose, null);
        this.Pose = null;
        Arrays.fill(this.PrevPose, null);
        this.PrevPose = null;
    }

    private Keyframe getNextKeyFrame(int n, int n2, Keyframe keyframe) {
        Keyframe[] keyframeArray = this.Clip.getKeyframes();
        for (int i = n2; i < keyframeArray.length; ++i) {
            Keyframe keyframe2 = keyframeArray[i];
            if (keyframe2.Bone != n || !(keyframe2.Time > this.currentTimeValue) || keyframe == keyframe2) continue;
            return keyframe2;
        }
        return null;
    }

    public Quaternion getRotation(Quaternion quaternion, int n) {
        if (this.PrevPose[n] == null || !PerformanceSettings.InterpolateAnims) {
            quaternion.set((ReadableVector4f)this.Pose[n].Rotation);
            return quaternion;
        }
        float f = (this.currentTimeValue - this.PrevPose[n].Time) / (this.Pose[n].Time - this.PrevPose[n].Time);
        if (this.Pose[n].Time - this.PrevPose[n].Time == 0.0f) {
            f = 0.0f;
        }
        return PZMath.slerp(quaternion, this.PrevPose[n].Rotation, this.Pose[n].Rotation, f);
    }

    public Vector3f getPosition(Vector3f vector3f, int n) {
        if (this.PrevPose[n] == null || !PerformanceSettings.InterpolateAnims) {
            vector3f.set((ReadableVector3f)this.Pose[n].Position);
            return vector3f;
        }
        float f = (this.currentTimeValue - this.PrevPose[n].Time) / (this.Pose[n].Time - this.PrevPose[n].Time);
        if (this.Pose[n].Time - this.PrevPose[n].Time == 0.0f) {
            f = 0.0f;
        }
        PZMath.lerp(vector3f, this.PrevPose[n].Position, this.Pose[n].Position, f);
        return vector3f;
    }

    public void getPose() {
        Keyframe[] keyframeArray = this.Clip.getKeyframes();
        this.currentKeyframe = 0;
        while (this.currentKeyframe < keyframeArray.length) {
            Keyframe keyframe = keyframeArray[this.currentKeyframe];
            if (this.currentKeyframe == keyframeArray.length - 1 || !(keyframe.Time <= this.currentTimeValue)) {
                if (!PerformanceSettings.InterpolateAnims) break;
                for (int i = 0; i < 60; ++i) {
                    if (this.Pose[i] != null && !(this.currentTimeValue >= this.Pose[i].Time)) continue;
                    Keyframe keyframe2 = this.getNextKeyFrame(i, this.currentKeyframe, this.Pose[i]);
                    if (keyframe2 != null) {
                        this.PrevPose[keyframe2.Bone] = this.Pose[keyframe2.Bone];
                        this.Pose[keyframe2.Bone] = keyframe2;
                        continue;
                    }
                    this.PrevPose[i] = null;
                }
                break;
            }
            if (keyframe.Bone >= 0) {
                this.Pose[keyframe.Bone] = keyframe;
            }
            this.lastTime = keyframe.Time;
            ++this.currentKeyframe;
        }
    }

    public void Create() {
        float f = this.Matrices.length;
        double d = (double)this.Clip.Duration / (double)f;
        double d2 = 0.0;
        int n = 0;
        Matrix4f matrix4f = new Matrix4f();
        while ((float)n < f) {
            this.currentTimeValue = (float)d2;
            this.getPose();
            for (int i = 0; i < 60; ++i) {
                Matrix4f matrix4f2;
                if (this.Pose[i] == null) {
                    this.Matrices[n][i] = matrix4f;
                    continue;
                }
                Quaternion quaternion = new Quaternion();
                this.getRotation(quaternion, i);
                Vector3f vector3f = new Vector3f();
                this.getPosition(vector3f, i);
                this.Matrices[n][i] = matrix4f2 = HelperFunctions.CreateFromQuaternionPositionScale(vector3f, quaternion, new Vector3f(1.0f, 1.0f, 1.0f), new Matrix4f());
            }
            d2 += d;
            ++n;
        }
    }

    public Keyframe interpolate(List<Keyframe> list, float f) {
        Keyframe keyframe = null;
        Keyframe keyframe2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Keyframe keyframe3;
            keyframe2 = keyframe3 = list.get(i);
            if (keyframe2.Time > f && keyframe.Time <= f) {
                Quaternion quaternion = new Quaternion();
                Vector3f vector3f = new Vector3f();
                float f2 = (f - keyframe.Time) / (keyframe2.Time - keyframe.Time);
                PZMath.slerp(quaternion, keyframe.Rotation, keyframe2.Rotation, f2);
                PZMath.lerp(vector3f, keyframe.Position, keyframe2.Position, f2);
                Keyframe keyframe4 = new Keyframe();
                keyframe4.Position = vector3f;
                keyframe4.Rotation = quaternion;
                keyframe4.Scale = new Vector3f(1.0f, 1.0f, 1.0f);
                keyframe4.Time = keyframe.Time + (keyframe2.Time - keyframe.Time) * f2;
                return keyframe4;
            }
            keyframe = keyframe3;
        }
        return list.get(list.size() - 1);
    }

    public void interpolate(List<Keyframe> list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get((int)0).Position.equals((Object)list.get((int)(list.size() - 1)).Position)) {
            return;
        }
        float f = this.Matrices.length + 1;
        double d = (double)this.Clip.Duration / (double)f;
        double d2 = 0.0;
        ArrayList<Keyframe> arrayList = new ArrayList<Keyframe>();
        int n = 0;
        while ((float)n < f - 1.0f) {
            Keyframe keyframe = this.interpolate(list, (float)d2);
            arrayList.add(keyframe);
            ++n;
            d2 += d;
        }
        list.clear();
        list.addAll(arrayList);
    }

    public void doRootMotion(List<Keyframe> list) {
        float f = this.Matrices.length;
        if (list.size() <= 3) {
            return;
        }
        for (int i = 0; (float)i < f && i < list.size(); ++i) {
            Matrix4f matrix4f;
            Keyframe keyframe = list.get(i);
            Quaternion quaternion = keyframe.Rotation;
            Vector3f vector3f = keyframe.Position;
            this.RootMotion[i] = matrix4f = HelperFunctions.CreateFromQuaternionPositionScale(vector3f, quaternion, keyframe.Scale, new Matrix4f());
        }
    }
}

