/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector3f;
import zombie.core.math.PZMath;

public final class Keyframe {
    public Quaternion Rotation;
    public Vector3f Position;
    public Vector3f Scale = new Vector3f(1.0f, 1.0f, 1.0f);
    public int Bone;
    public String BoneName;
    public float Time = -1.0f;

    public Keyframe() {
    }

    public Keyframe(Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        this.Position = new Vector3f((ReadableVector3f)vector3f);
        this.Rotation = new Quaternion((ReadableVector4f)quaternion);
        this.Scale = new Vector3f((ReadableVector3f)vector3f2);
    }

    public void set(Keyframe keyframe) {
        if (keyframe.Position != null) {
            this.setPosition(keyframe.Position);
        }
        if (keyframe.Rotation != null) {
            this.setRotation(keyframe.Rotation);
        }
        if (keyframe.Scale != null) {
            this.setScale(keyframe.Scale);
        }
        this.Time = keyframe.Time;
        this.Bone = keyframe.Bone;
        this.BoneName = keyframe.BoneName;
    }

    public void get(Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        Keyframe.setIfNotNull(vector3f, this.Position, 0.0f, 0.0f, 0.0f);
        Keyframe.setIfNotNull(quaternion, this.Rotation);
        Keyframe.setIfNotNull(vector3f2, this.Scale, 1.0f, 1.0f, 1.0f);
    }

    private void setScale(Vector3f vector3f) {
        if (this.Scale == null) {
            this.Scale = new Vector3f();
        }
        this.Scale.set((ReadableVector3f)vector3f);
    }

    private void setRotation(Quaternion quaternion) {
        if (this.Rotation == null) {
            this.Rotation = new Quaternion();
        }
        this.Rotation.set((ReadableVector4f)quaternion);
    }

    private void setPosition(Vector3f vector3f) {
        if (this.Position == null) {
            this.Position = new Vector3f();
        }
        this.Position.set((ReadableVector3f)vector3f);
    }

    public void clear() {
        this.Time = -1.0f;
        this.Position = null;
        this.Rotation = null;
    }

    public void setIdentity() {
        Keyframe.setIdentity(this.Position, this.Rotation, this.Scale);
    }

    public static void setIdentity(Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        Keyframe.setIfNotNull(vector3f, 0.0f, 0.0f, 0.0f);
        Keyframe.setIdentityIfNotNull(quaternion);
        Keyframe.setIfNotNull(vector3f2, 1.0f, 1.0f, 1.0f);
    }

    public static Keyframe lerp(Keyframe keyframe, Keyframe keyframe2, float f, Keyframe keyframe3) {
        Keyframe.lerp(keyframe, keyframe2, f, keyframe3.Position, keyframe3.Rotation, keyframe3.Scale);
        keyframe3.Bone = keyframe2.Bone;
        keyframe3.BoneName = keyframe2.BoneName;
        keyframe3.Time = f;
        return keyframe3;
    }

    public static void setIfNotNull(Vector3f vector3f, Vector3f vector3f2, float f, float f2, float f3) {
        if (vector3f != null) {
            if (vector3f2 != null) {
                vector3f.set((ReadableVector3f)vector3f2);
            } else {
                vector3f.set(f, f2, f3);
            }
        }
    }

    public static void setIfNotNull(Vector3f vector3f, float f, float f2, float f3) {
        if (vector3f != null) {
            vector3f.set(f, f2, f3);
        }
    }

    public static void setIfNotNull(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion != null) {
            if (quaternion2 != null) {
                quaternion.set((ReadableVector4f)quaternion2);
            } else {
                quaternion.setIdentity();
            }
        }
    }

    public static void setIdentityIfNotNull(Quaternion quaternion) {
        if (quaternion != null) {
            quaternion.setIdentity();
        }
    }

    public static void lerp(Keyframe keyframe, Keyframe keyframe2, float f, Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        if (keyframe2.Time == keyframe.Time) {
            keyframe2.get(vector3f, quaternion, vector3f2);
            return;
        }
        float f2 = (f - keyframe.Time) / (keyframe2.Time - keyframe.Time);
        if (vector3f != null) {
            PZMath.lerp(vector3f, keyframe.Position, keyframe2.Position, f2);
        }
        if (quaternion != null) {
            PZMath.slerp(quaternion, keyframe.Rotation, keyframe2.Rotation, f2);
        }
        if (vector3f2 != null) {
            PZMath.lerp(vector3f2, keyframe.Scale, keyframe2.Scale, f2);
        }
    }
}

