/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;
import zombie.GameProfiler;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.core.math.PZMath;
import zombie.core.math.Vector3;
import zombie.core.skinnedmodel.HelperFunctions;
import zombie.core.skinnedmodel.advancedanimation.AdvancedAnimator;
import zombie.core.skinnedmodel.animation.AnimationBoneBinding;
import zombie.core.skinnedmodel.animation.AnimationBoneBindingPair;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.AnimationMultiTrack;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.BoneTransform;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.animation.ModelTransformSampler;
import zombie.core.skinnedmodel.animation.TwistableBoneTransform;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.core.skinnedmodel.animation.sharedskele.SharedSkeleAnimationRepository;
import zombie.core.skinnedmodel.animation.sharedskele.SharedSkeleAnimationTrack;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.Vector2;
import zombie.network.MPStatistic;
import zombie.util.IPooledObject;
import zombie.util.Lambda;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public final class AnimationPlayer
extends PooledObject {
    private Model model;
    private final Matrix4f propTransforms = new Matrix4f();
    private boolean m_boneTransformsNeedFirstFrame = true;
    private TwistableBoneTransform[] m_boneTransforms;
    public Matrix4f[] modelTransforms;
    private SkinTransformData m_skinTransformData = null;
    private SkinTransformData m_skinTransformDataPool = null;
    private SkinningData m_skinningData;
    private SharedSkeleAnimationRepository m_sharedSkeleAnimationRepo = null;
    private SharedSkeleAnimationTrack m_currentSharedTrack;
    private AnimationClip m_currentSharedTrackClip;
    private float m_angle;
    private float m_targetAngle;
    private float m_twistAngle;
    private float m_shoulderTwistAngle;
    private float m_targetTwistAngle;
    private float m_maxTwistAngle = PZMath.degToRad(70.0f);
    private float m_excessTwist = 0.0f;
    private static final float angleStepBase = 0.15f;
    public float angleStepDelta = 1.0f;
    public float angleTwistDelta = 1.0f;
    public boolean bDoBlending = true;
    public boolean bUpdateBones = true;
    private final Vector2 m_lastSetDir = new Vector2();
    private final ArrayList<AnimationBoneBindingPair> m_reparentedBoneBindings = new ArrayList();
    private final List<AnimationBoneBinding> m_twistBones = new ArrayList<AnimationBoneBinding>();
    private AnimationBoneBinding m_counterRotationBone = null;
    public final ArrayList<Integer> dismembered = new ArrayList();
    private final float m_minimumValidAnimWeight = 0.001f;
    private final int m_animBlendIndexCacheSize = 32;
    private final int[] m_animBlendIndices = new int[32];
    private final float[] m_animBlendWeights = new float[32];
    private final int[] m_animBlendLayers = new int[32];
    private final int[] m_animBlendPriorities = new int[32];
    private final int m_maxLayers = 4;
    private final int[] m_layerBlendCounts = new int[4];
    private final float[] m_layerWeightTotals = new float[4];
    private int m_totalAnimBlendCount = 0;
    public AnimationPlayer parentPlayer;
    private final Vector2 m_deferredMovement = new Vector2();
    private float m_deferredRotationWeight = 0.0f;
    private float m_deferredAngleDelta = 0.0f;
    private AnimationPlayerRecorder m_recorder = null;
    private static final AnimationTrack[] tempTracks = new AnimationTrack[0];
    private static final Vector2 tempo = new Vector2();
    private static final Pool<AnimationPlayer> s_pool = new Pool<AnimationPlayer>(AnimationPlayer::new);
    private final AnimationMultiTrack m_multiTrack = new AnimationMultiTrack();

    private AnimationPlayer() {
    }

    public static AnimationPlayer alloc(Model model) {
        AnimationPlayer animationPlayer = s_pool.alloc();
        animationPlayer.setModel(model);
        return animationPlayer;
    }

    public static float lerpBlendWeight(float f, float f2, float f3) {
        if (PZMath.equal(f, f2, 1.0E-4f)) {
            return f2;
        }
        float f4 = 1.0f / f3;
        float f5 = GameTime.getInstance().getTimeDelta();
        float f6 = f2 - f;
        float f7 = PZMath.sign(f6);
        float f8 = f + f7 * f4 * f5;
        float f9 = f2 - f8;
        float f10 = PZMath.sign(f9);
        if (f10 != f7) {
            f8 = f2;
        }
        return f8;
    }

    public void setModel(Model model) {
        Objects.requireNonNull(model);
        if (model == this.model) {
            return;
        }
        this.model = model;
        this.initSkinningData();
    }

    public Model getModel() {
        return this.model;
    }

    private void initSkinningData() {
        if (!this.model.isReady()) {
            return;
        }
        SkinningData skinningData = (SkinningData)this.model.Tag;
        if (skinningData == null) {
            return;
        }
        if (this.m_skinningData == skinningData) {
            return;
        }
        if (this.m_skinningData != null) {
            this.m_skinningData = null;
            this.m_multiTrack.reset();
        }
        this.m_skinningData = skinningData;
        Lambda.forEachFrom(PZArrayUtil::forEach, this.m_reparentedBoneBindings, this.m_skinningData, AnimationBoneBindingPair::setSkinningData);
        Lambda.forEachFrom(PZArrayUtil::forEach, this.m_twistBones, this.m_skinningData, AnimationBoneBinding::setSkinningData);
        if (this.m_counterRotationBone != null) {
            this.m_counterRotationBone.setSkinningData(this.m_skinningData);
        }
        int n = skinningData.numBones();
        this.modelTransforms = PZArrayUtil.newInstance(Matrix4f.class, this.modelTransforms, n, Matrix4f::new);
        this.m_boneTransforms = PZArrayUtil.newInstance(TwistableBoneTransform.class, this.m_boneTransforms, n);
        for (int i = 0; i < n; ++i) {
            if (this.m_boneTransforms[i] == null) {
                this.m_boneTransforms[i] = TwistableBoneTransform.alloc();
            }
            this.m_boneTransforms[i].setIdentity();
        }
        this.m_boneTransformsNeedFirstFrame = true;
    }

    public boolean isReady() {
        this.initSkinningData();
        return this.hasSkinningData();
    }

    public boolean hasSkinningData() {
        return this.m_skinningData != null;
    }

    public void addBoneReparent(String string, String string2) {
        if (PZArrayUtil.contains(this.m_reparentedBoneBindings, Lambda.predicate(string, string2, AnimationBoneBindingPair::matches))) {
            return;
        }
        AnimationBoneBindingPair animationBoneBindingPair = new AnimationBoneBindingPair(string, string2);
        animationBoneBindingPair.setSkinningData(this.m_skinningData);
        this.m_reparentedBoneBindings.add(animationBoneBindingPair);
    }

    public void setTwistBones(String ... stringArray) {
        ArrayList<String> arrayList = L_setTwistBones.boneNames;
        PZArrayUtil.listConvert(this.m_twistBones, arrayList, animationBoneBinding -> animationBoneBinding.boneName);
        if (PZArrayUtil.sequenceEqual(stringArray, arrayList, PZArrayUtil.Comparators::equalsIgnoreCase)) {
            return;
        }
        this.m_twistBones.clear();
        Lambda.forEachFrom(PZArrayUtil::forEach, stringArray, this, (object, animationPlayer) -> {
            AnimationBoneBinding animationBoneBinding = new AnimationBoneBinding((String)object);
            animationBoneBinding.setSkinningData(animationPlayer.m_skinningData);
            animationPlayer.m_twistBones.add(animationBoneBinding);
        });
    }

    public void setCounterRotationBone(String string) {
        if (this.m_counterRotationBone == null || StringUtils.equals(this.m_counterRotationBone.boneName, string)) {
            // empty if block
        }
        this.m_counterRotationBone = new AnimationBoneBinding(string);
        this.m_counterRotationBone.setSkinningData(this.m_skinningData);
    }

    public AnimationBoneBinding getCounterRotationBone() {
        return this.m_counterRotationBone;
    }

    public void reset() {
        this.m_multiTrack.reset();
    }

    @Override
    public void onReleased() {
        this.model = null;
        this.m_skinningData = null;
        this.propTransforms.setIdentity();
        this.m_boneTransformsNeedFirstFrame = true;
        IPooledObject.tryReleaseAndBlank(this.m_boneTransforms);
        PZArrayUtil.forEach(this.modelTransforms, Matrix::setIdentity);
        this.resetSkinTransforms();
        this.setAngle(0.0f);
        this.setTargetAngle(0.0f);
        this.m_twistAngle = 0.0f;
        this.m_shoulderTwistAngle = 0.0f;
        this.m_targetTwistAngle = 0.0f;
        this.m_maxTwistAngle = PZMath.degToRad(70.0f);
        this.m_excessTwist = 0.0f;
        this.angleStepDelta = 1.0f;
        this.angleTwistDelta = 1.0f;
        this.bDoBlending = true;
        this.bUpdateBones = true;
        this.m_lastSetDir.set(0.0f, 0.0f);
        this.m_reparentedBoneBindings.clear();
        this.m_twistBones.clear();
        this.m_counterRotationBone = null;
        this.dismembered.clear();
        Arrays.fill(this.m_animBlendIndices, 0);
        Arrays.fill(this.m_animBlendWeights, 0.0f);
        Arrays.fill(this.m_animBlendLayers, 0);
        Arrays.fill(this.m_layerBlendCounts, 0);
        Arrays.fill(this.m_layerWeightTotals, 0.0f);
        this.m_totalAnimBlendCount = 0;
        this.parentPlayer = null;
        this.m_deferredMovement.set(0.0f, 0.0f);
        this.m_deferredRotationWeight = 0.0f;
        this.m_deferredAngleDelta = 0.0f;
        this.m_recorder = null;
        this.m_multiTrack.reset();
    }

    public SkinningData getSkinningData() {
        return this.m_skinningData;
    }

    public HashMap<String, Integer> getSkinningBoneIndices() {
        if (this.m_skinningData != null) {
            return this.m_skinningData.BoneIndices;
        }
        return null;
    }

    public int getSkinningBoneIndex(String string, int n) {
        HashMap<String, Integer> hashMap = this.getSkinningBoneIndices();
        if (hashMap != null) {
            return hashMap.get(string);
        }
        return n;
    }

    private synchronized SkinTransformData getSkinTransformData(SkinningData skinningData) {
        SkinTransformData skinTransformData = this.m_skinTransformData;
        while (skinTransformData != null) {
            if (skinningData == skinTransformData.m_skinnedTo) {
                return skinTransformData;
            }
            skinTransformData = skinTransformData.m_next;
        }
        if (this.m_skinTransformDataPool != null) {
            skinTransformData = this.m_skinTransformDataPool;
            skinTransformData.setSkinnedTo(skinningData);
            skinTransformData.dirty = true;
            this.m_skinTransformDataPool = this.m_skinTransformDataPool.m_next;
        } else {
            skinTransformData = SkinTransformData.alloc(skinningData);
        }
        skinTransformData.m_next = this.m_skinTransformData;
        this.m_skinTransformData = skinTransformData;
        return skinTransformData;
    }

    private synchronized void resetSkinTransforms() {
        GameProfiler.getInstance().invokeAndMeasure("resetSkinTransforms", this, AnimationPlayer::resetSkinTransformsInternal);
    }

    private void resetSkinTransformsInternal() {
        if (this.m_skinTransformDataPool != null) {
            SkinTransformData skinTransformData = this.m_skinTransformDataPool;
            while (skinTransformData.m_next != null) {
                skinTransformData = skinTransformData.m_next;
            }
            skinTransformData.m_next = this.m_skinTransformData;
        } else {
            this.m_skinTransformDataPool = this.m_skinTransformData;
        }
        this.m_skinTransformData = null;
    }

    public Matrix4f GetPropBoneMatrix(int n) {
        this.propTransforms.load(this.modelTransforms[n]);
        return this.propTransforms;
    }

    private AnimationTrack startClip(AnimationClip animationClip, boolean bl) {
        if (animationClip == null) {
            throw new NullPointerException("Supplied clip is null.");
        }
        AnimationTrack animationTrack = AnimationTrack.alloc();
        animationTrack.startClip(animationClip, bl);
        animationTrack.name = animationClip.Name;
        animationTrack.IsPlaying = true;
        this.m_multiTrack.addTrack(animationTrack);
        return animationTrack;
    }

    public static void releaseTracks(List<AnimationTrack> list) {
        AnimationTrack[] animationTrackArray = list.toArray(tempTracks);
        PZArrayUtil.forEach(animationTrackArray, PooledObject::release);
    }

    public AnimationTrack play(String string, boolean bl) {
        if (this.m_skinningData == null) {
            return null;
        }
        AnimationClip animationClip = this.m_skinningData.AnimationClips.get(string);
        if (animationClip == null) {
            DebugLog.General.warn("Anim Clip not found: %s", string);
            return null;
        }
        AnimationTrack animationTrack = this.startClip(animationClip, bl);
        return animationTrack;
    }

    public void Update() {
        this.Update(GameTime.instance.getTimeDelta());
    }

    public void Update(float f) {
        MPStatistic.getInstance().AnimationPlayerUpdate.Start();
        GameProfiler.getInstance().invokeAndMeasure("AnimationPlayer.Update", this, Float.valueOf(f), AnimationPlayer::updateInternal);
        MPStatistic.getInstance().AnimationPlayerUpdate.End();
    }

    private void updateInternal(float f) {
        if (!this.isReady()) {
            return;
        }
        this.m_multiTrack.Update(f);
        if (!this.bUpdateBones) {
            this.updateAnimation_NonVisualOnly();
            return;
        }
        if (this.m_multiTrack.getTrackCount() <= 0) {
            return;
        }
        SharedSkeleAnimationTrack sharedSkeleAnimationTrack = this.determineCurrentSharedSkeleTrack();
        if (sharedSkeleAnimationTrack != null) {
            float f2 = this.m_multiTrack.getTrackAt(0).getCurrentTime();
            this.updateAnimation_SharedSkeleTrack(sharedSkeleAnimationTrack, f2);
            return;
        }
        this.updateAnimation_StandardAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedSkeleAnimationTrack determineCurrentSharedSkeleTrack() {
        if (this.m_sharedSkeleAnimationRepo == null) {
            return null;
        }
        if (this.bDoBlending) {
            return null;
        }
        if (!DebugOptions.instance.Animation.SharedSkeles.Enabled.getValue()) {
            return null;
        }
        if (this.m_multiTrack.getTrackCount() != 1) {
            return null;
        }
        if (!PZMath.equal(this.m_twistAngle, 0.0f, 114.59155f)) {
            return null;
        }
        if (this.parentPlayer != null) {
            return null;
        }
        AnimationTrack animationTrack = this.m_multiTrack.getTrackAt(0);
        float f = animationTrack.blendFieldWeight;
        if (!PZMath.equal(f, 0.0f, 0.1f)) {
            return null;
        }
        AnimationClip animationClip = animationTrack.getClip();
        if (animationClip == this.m_currentSharedTrackClip) {
            return this.m_currentSharedTrack;
        }
        SharedSkeleAnimationTrack sharedSkeleAnimationTrack = this.m_sharedSkeleAnimationRepo.getTrack(animationClip);
        if (sharedSkeleAnimationTrack == null) {
            DebugLog.Animation.debugln("Caching SharedSkeleAnimationTrack: %s", animationTrack.name);
            sharedSkeleAnimationTrack = new SharedSkeleAnimationTrack();
            ModelTransformSampler modelTransformSampler = ModelTransformSampler.alloc(this, animationTrack);
            try {
                sharedSkeleAnimationTrack.set(modelTransformSampler, 5.0f);
            }
            finally {
                modelTransformSampler.release();
            }
            this.m_sharedSkeleAnimationRepo.setTrack(animationClip, sharedSkeleAnimationTrack);
        }
        this.m_currentSharedTrackClip = animationClip;
        this.m_currentSharedTrack = sharedSkeleAnimationTrack;
        return sharedSkeleAnimationTrack;
    }

    private void updateAnimation_NonVisualOnly() {
        this.updateMultiTrackBoneTransforms_DeferredMovementOnly();
        this.DoAngles();
        this.calculateDeferredMovement();
    }

    public void setSharedAnimRepo(SharedSkeleAnimationRepository sharedSkeleAnimationRepository) {
        this.m_sharedSkeleAnimationRepo = sharedSkeleAnimationRepository;
    }

    private void updateAnimation_SharedSkeleTrack(SharedSkeleAnimationTrack sharedSkeleAnimationTrack, float f) {
        this.updateMultiTrackBoneTransforms_DeferredMovementOnly();
        this.DoAngles();
        this.calculateDeferredMovement();
        sharedSkeleAnimationTrack.moveToTime(f);
        for (int i = 0; i < this.modelTransforms.length; ++i) {
            sharedSkeleAnimationTrack.getBoneMatrix(i, this.modelTransforms[i]);
        }
        this.UpdateSkinTransforms();
    }

    private void updateAnimation_StandardAnimation() {
        if (this.parentPlayer == null) {
            this.updateMultiTrackBoneTransforms();
        } else {
            this.copyBoneTransformsFromParentPlayer();
        }
        this.DoAngles();
        this.calculateDeferredMovement();
        this.updateTwistBone();
        this.applyBoneReParenting();
        this.updateModelTransforms();
        this.UpdateSkinTransforms();
    }

    private void copyBoneTransformsFromParentPlayer() {
        this.m_boneTransformsNeedFirstFrame = false;
        for (int i = 0; i < this.m_boneTransforms.length; ++i) {
            this.m_boneTransforms[i].set(this.parentPlayer.m_boneTransforms[i]);
        }
    }

    public static float calculateAnimPlayerAngle(Vector2 vector22) {
        return vector22.getDirection();
    }

    public void SetDir(Vector2 vector22) {
        if (this.m_lastSetDir.x != vector22.x || this.m_lastSetDir.y != vector22.y) {
            this.setTargetAngle(AnimationPlayer.calculateAnimPlayerAngle(vector22));
            this.m_targetTwistAngle = PZMath.getClosestAngle(this.m_angle, this.m_targetAngle);
            float f = PZMath.clamp(this.m_targetTwistAngle, -this.m_maxTwistAngle, this.m_maxTwistAngle);
            this.m_excessTwist = PZMath.getClosestAngle(f, this.m_targetTwistAngle);
            this.m_lastSetDir.set(vector22);
        }
    }

    public void SetForceDir(Vector2 vector22) {
        this.setTargetAngle(AnimationPlayer.calculateAnimPlayerAngle(vector22));
        this.setAngleToTarget();
        this.m_targetTwistAngle = 0.0f;
        this.m_lastSetDir.set(vector22);
    }

    public void UpdateDir(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter != null) {
            this.SetDir(isoGameCharacter.getForwardDirection());
        }
    }

    public void DoAngles() {
        GameProfiler.getInstance().invokeAndMeasure("AnimationPlayer.doAngles", this, AnimationPlayer::doAnglesInternal);
    }

    private void doAnglesInternal() {
        float f = 0.15f * GameTime.instance.getMultiplier();
        this.interpolateBodyAngle(f);
        this.interpolateBodyTwist(f);
        this.interpolateShoulderTwist(f);
    }

    private void interpolateBodyAngle(float f) {
        float f2 = PZMath.getClosestAngle(this.m_angle, this.m_targetAngle);
        if (PZMath.equal(f2, 0.0f, 0.001f)) {
            this.setAngleToTarget();
            this.m_targetTwistAngle = 0.0f;
            return;
        }
        float f3 = PZMath.sign(f2);
        float f4 = f * f3 * this.angleStepDelta;
        float f5 = DebugOptions.instance.Character.Debug.Animate.DeferredRotationOnly.getValue() ? this.m_deferredAngleDelta : (this.m_deferredRotationWeight > 0.0f ? this.m_deferredAngleDelta : f4);
        float f6 = PZMath.sign(f5);
        float f7 = this.m_angle;
        float f8 = f7 + f5;
        float f9 = PZMath.getClosestAngle(f8, this.m_targetAngle);
        float f10 = PZMath.sign(f9);
        if (f10 == f3 || f6 != f3) {
            this.setAngle(f8);
            this.m_targetTwistAngle = f9;
        } else {
            this.setAngleToTarget();
            this.m_targetTwistAngle = 0.0f;
        }
    }

    private void interpolateBodyTwist(float f) {
        float f2 = PZMath.wrap(this.m_targetTwistAngle, (float)(-Math.PI), (float)Math.PI);
        float f3 = PZMath.clamp(f2, -this.m_maxTwistAngle, this.m_maxTwistAngle);
        this.m_excessTwist = PZMath.getClosestAngle(f3, f2);
        float f4 = PZMath.getClosestAngle(this.m_twistAngle, f3);
        if (PZMath.equal(f4, 0.0f, 0.001f)) {
            this.m_twistAngle = f3;
            return;
        }
        float f5 = this.m_twistAngle;
        float f6 = PZMath.sign(f4);
        float f7 = f * f6 * this.angleTwistDelta;
        float f8 = f5 + f7;
        float f9 = PZMath.getClosestAngle(f8, f3);
        float f10 = PZMath.sign(f9);
        this.m_twistAngle = f10 == f6 ? f8 : f3;
    }

    private void interpolateShoulderTwist(float f) {
        float f2 = PZMath.wrap(this.m_twistAngle, (float)(-Math.PI), (float)Math.PI);
        float f3 = PZMath.getClosestAngle(this.m_shoulderTwistAngle, f2);
        if (PZMath.equal(f3, 0.0f, 0.001f)) {
            this.m_shoulderTwistAngle = f2;
            return;
        }
        float f4 = this.m_shoulderTwistAngle;
        float f5 = PZMath.sign(f3);
        float f6 = f * f5 * this.angleTwistDelta * 0.55f;
        float f7 = f4 + f6;
        float f8 = PZMath.getClosestAngle(f7, f2);
        float f9 = PZMath.sign(f8);
        this.m_shoulderTwistAngle = f9 == f5 ? f7 : f2;
    }

    private void updateTwistBone() {
        GameProfiler.getInstance().invokeAndMeasure("updateTwistBone", this, AnimationPlayer::updateTwistBoneInternal);
    }

    private void updateTwistBoneInternal() {
        if (this.m_twistBones.isEmpty()) {
            return;
        }
        float f = PZMath.degToRad(1.0f);
        if (PZMath.equal(this.m_twistAngle, 0.0f, f)) {
            return;
        }
        if (DebugOptions.instance.Character.Debug.Animate.NoBoneTwists.getValue()) {
            return;
        }
        int n = this.m_twistBones.size();
        int n2 = n - 1;
        float f2 = -this.m_shoulderTwistAngle;
        float f3 = f2 / (float)n2;
        for (int i = 0; i < n2; ++i) {
            SkinningBone skinningBone = this.m_twistBones.get(i).getBone();
            this.applyTwistBone(skinningBone, f3);
        }
        float f4 = -this.m_twistAngle;
        float f5 = PZMath.getClosestAngle(f2, f4);
        if (PZMath.abs(f5) > 1.0E-4f) {
            SkinningBone skinningBone = this.m_twistBones.get(n2).getBone();
            this.applyTwistBone(skinningBone, f5);
        }
    }

    private void applyTwistBone(SkinningBone skinningBone, float f) {
        if (skinningBone == null) {
            return;
        }
        int n = skinningBone.Index;
        int n2 = skinningBone.Parent.Index;
        Matrix4f matrix4f = this.getBoneModelTransform(n2, L_applyTwistBone.twistParentBoneTrans);
        Matrix4f matrix4f2 = Matrix4f.invert((Matrix4f)matrix4f, (Matrix4f)L_applyTwistBone.twistParentBoneTransInv);
        if (matrix4f2 == null) {
            return;
        }
        Matrix4f matrix4f3 = this.getBoneModelTransform(n, L_applyTwistBone.twistBoneTrans);
        Quaternion quaternion = L_applyTwistBone.twistBoneTargetRot;
        Matrix4f matrix4f4 = L_applyTwistBone.twistRotDiffTrans;
        matrix4f4.setIdentity();
        L_applyTwistBone.twistRotDiffTransAxis.set(0.0f, 1.0f, 0.0f);
        float f2 = PZMath.getClosestAngle(this.m_boneTransforms[n].Twist, f);
        this.m_boneTransforms[n].Twist = f;
        matrix4f4.rotate(f2, L_applyTwistBone.twistRotDiffTransAxis);
        Matrix4f matrix4f5 = L_applyTwistBone.twistBoneTargetTrans;
        Matrix4f.mul((Matrix4f)matrix4f3, (Matrix4f)matrix4f4, (Matrix4f)matrix4f5);
        HelperFunctions.getRotation(matrix4f5, quaternion);
        matrix4f4 = L_applyTwistBone.twistBoneNewRot;
        matrix4f4.set((ReadableVector4f)quaternion);
        Vector3f vector3f = HelperFunctions.getPosition(matrix4f3, L_applyTwistBone.twistBonePos);
        matrix4f5 = L_applyTwistBone.twistBoneScale;
        matrix4f5.set(1.0f, 1.0f, 1.0f);
        Matrix4f matrix4f6 = L_applyTwistBone.twistBoneNewTrans;
        HelperFunctions.CreateFromQuaternionPositionScale(vector3f, (Quaternion)matrix4f4, (Vector3f)matrix4f5, matrix4f6);
        this.m_boneTransforms[n].mul(matrix4f6, matrix4f2);
    }

    public void resetBoneModelTransforms() {
        if (this.m_skinningData == null || this.modelTransforms == null) {
            return;
        }
        this.m_boneTransformsNeedFirstFrame = true;
        int n = this.m_boneTransforms.length;
        for (int i = 0; i < n; ++i) {
            this.m_boneTransforms[i].BlendWeight = 0.0f;
            this.m_boneTransforms[i].setIdentity();
            this.modelTransforms[i].setIdentity();
        }
    }

    public boolean isBoneTransformsNeedFirstFrame() {
        return this.m_boneTransformsNeedFirstFrame;
    }

    private void updateMultiTrackBoneTransforms() {
        GameProfiler.getInstance().invokeAndMeasure("updateMultiTrackBoneTransforms", this, AnimationPlayer::updateMultiTrackBoneTransformsInternal);
    }

    private void updateMultiTrackBoneTransformsInternal() {
        int n;
        for (n = 0; n < this.modelTransforms.length; ++n) {
            this.modelTransforms[n].setIdentity();
        }
        this.updateLayerBlendWeightings();
        if (this.m_totalAnimBlendCount == 0) {
            return;
        }
        if (this.isRecording()) {
            this.m_recorder.logAnimWeights(this.m_multiTrack.getTracks(), this.m_animBlendIndices, this.m_animBlendWeights, this.m_deferredMovement);
        }
        for (n = 0; n < this.m_boneTransforms.length; ++n) {
            if (this.isBoneReparented(n)) continue;
            this.updateBoneAnimationTransform(n, null);
        }
        this.m_boneTransformsNeedFirstFrame = false;
    }

    private void updateLayerBlendWeightings() {
        int n;
        int n2;
        float f;
        int n3;
        List<AnimationTrack> list = this.m_multiTrack.getTracks();
        int n4 = list.size();
        PZArrayUtil.arraySet(this.m_animBlendIndices, -1);
        PZArrayUtil.arraySet(this.m_animBlendWeights, 0.0f);
        PZArrayUtil.arraySet(this.m_animBlendLayers, -1);
        PZArrayUtil.arraySet(this.m_animBlendPriorities, 0);
        for (n3 = 0; n3 < n4; ++n3) {
            AnimationTrack animationTrack = list.get(n3);
            f = animationTrack.BlendDelta;
            n2 = animationTrack.getLayerIdx();
            n = animationTrack.getPriority();
            if (n2 < 0 || n2 >= 4) {
                DebugLog.General.error("Layer index is out of range: %d. Range: 0 - %d", n2, 3);
                continue;
            }
            if (f < 0.001f || n2 > 0 && animationTrack.isFinished()) continue;
            int n5 = -1;
            for (int i = 0; i < this.m_animBlendIndices.length; ++i) {
                if (this.m_animBlendIndices[i] == -1) {
                    n5 = i;
                    break;
                }
                if (n2 > this.m_animBlendLayers[i]) continue;
                if (n2 < this.m_animBlendLayers[i]) {
                    n5 = i;
                    break;
                }
                if (n > this.m_animBlendPriorities[i]) continue;
                if (n < this.m_animBlendPriorities[i]) {
                    n5 = i;
                    break;
                }
                if (!(f < this.m_animBlendWeights[i])) continue;
                n5 = i;
                break;
            }
            if (n5 < 0) {
                DebugLog.General.error("Buffer overflow. Insufficient anim blends in cache. More than %d animations are being blended at once. Will be truncated to %d.", this.m_animBlendIndices.length, this.m_animBlendIndices.length);
                continue;
            }
            PZArrayUtil.insertAt(this.m_animBlendIndices, n5, n3);
            PZArrayUtil.insertAt(this.m_animBlendWeights, n5, f);
            PZArrayUtil.insertAt(this.m_animBlendLayers, n5, n2);
            PZArrayUtil.insertAt(this.m_animBlendPriorities, n5, n);
        }
        PZArrayUtil.arraySet(this.m_layerBlendCounts, 0);
        PZArrayUtil.arraySet(this.m_layerWeightTotals, 0.0f);
        this.m_totalAnimBlendCount = 0;
        for (n3 = 0; n3 < this.m_animBlendIndices.length && this.m_animBlendIndices[n3] >= 0; ++n3) {
            int n6;
            int n7 = n6 = this.m_animBlendLayers[n3];
            this.m_layerWeightTotals[n7] = this.m_layerWeightTotals[n7] + this.m_animBlendWeights[n3];
            int n8 = n6;
            this.m_layerBlendCounts[n8] = this.m_layerBlendCounts[n8] + 1;
            ++this.m_totalAnimBlendCount;
        }
        if (this.m_totalAnimBlendCount == 0) {
            return;
        }
        if (this.m_boneTransformsNeedFirstFrame) {
            n3 = this.m_animBlendLayers[0];
            int n9 = this.m_layerBlendCounts[0];
            f = this.m_layerWeightTotals[0];
            if (f < 1.0f) {
                for (n2 = 0; n2 < this.m_totalAnimBlendCount && (n = this.m_animBlendLayers[n2]) == n3; ++n2) {
                    if (f > 0.0f) {
                        int n10 = n2;
                        this.m_animBlendWeights[n10] = this.m_animBlendWeights[n10] / f;
                        continue;
                    }
                    this.m_animBlendWeights[n2] = 1.0f / (float)n9;
                }
            }
        }
    }

    private void calculateDeferredMovement() {
        GameProfiler.getInstance().invokeAndMeasure("calculateDeferredMovement", this, AnimationPlayer::calculateDeferredMovementInternal);
    }

    private void calculateDeferredMovementInternal() {
        List<AnimationTrack> list = this.m_multiTrack.getTracks();
        this.m_deferredMovement.set(0.0f, 0.0f);
        this.m_deferredAngleDelta = 0.0f;
        this.m_deferredRotationWeight = 0.0f;
        float f = 1.0f;
        for (int i = this.m_totalAnimBlendCount - 1; i >= 0 && !(f <= 0.001f); --i) {
            float f2;
            float f3;
            int n = this.m_animBlendIndices[i];
            AnimationTrack animationTrack = list.get(n);
            if (animationTrack.isFinished() || (f3 = animationTrack.getDeferredBoneWeight()) <= 0.001f || (f2 = this.m_animBlendWeights[i] * f3) <= 0.001f) continue;
            float f4 = PZMath.clamp(f2, 0.0f, f);
            f -= f2;
            f = org.joml.Math.max(0.0f, f);
            Vector2.addScaled(this.m_deferredMovement, animationTrack.getDeferredMovementDiff(tempo), f4, this.m_deferredMovement);
            if (!animationTrack.getUseDeferredRotation()) continue;
            this.m_deferredAngleDelta += animationTrack.getDeferredRotationDiff() * f4;
            this.m_deferredRotationWeight += f4;
        }
        this.applyRotationToDeferredMovement(this.m_deferredMovement);
        this.m_deferredMovement.x *= AdvancedAnimator.s_MotionScale;
        this.m_deferredMovement.y *= AdvancedAnimator.s_MotionScale;
        this.m_deferredAngleDelta *= AdvancedAnimator.s_RotationScale;
    }

    private void applyRotationToDeferredMovement(Vector2 vector22) {
        float f = vector22.normalize();
        float f2 = this.getRenderedAngle();
        vector22.rotate(f2);
        vector22.setLength(-f);
    }

    private void applyBoneReParenting() {
        GameProfiler.getInstance().invokeAndMeasure("applyBoneReParenting", this, AnimationPlayer::applyBoneReParentingInternal);
    }

    private void applyBoneReParentingInternal() {
        int n = this.m_reparentedBoneBindings.size();
        for (int i = 0; i < n; ++i) {
            AnimationBoneBindingPair animationBoneBindingPair = this.m_reparentedBoneBindings.get(i);
            if (!animationBoneBindingPair.isValid()) {
                DebugLog.Animation.warn("Animation binding pair is not valid: %s", animationBoneBindingPair);
                continue;
            }
            this.updateBoneAnimationTransform(animationBoneBindingPair.getBoneIdxA(), animationBoneBindingPair);
        }
    }

    private void updateBoneAnimationTransform(int n, AnimationBoneBindingPair animationBoneBindingPair) {
        this.updateBoneAnimationTransform_Internal(n, animationBoneBindingPair);
    }

    private void updateBoneAnimationTransform_Internal(int n, AnimationBoneBindingPair animationBoneBindingPair) {
        List<AnimationTrack> list = this.m_multiTrack.getTracks();
        Vector3f vector3f = L_updateBoneAnimationTransform.pos;
        Quaternion quaternion = L_updateBoneAnimationTransform.rot;
        Vector3f vector3f2 = L_updateBoneAnimationTransform.scale;
        Keyframe keyframe = L_updateBoneAnimationTransform.key;
        int n2 = this.m_totalAnimBlendCount;
        AnimationBoneBinding animationBoneBinding = this.m_counterRotationBone;
        boolean bl = animationBoneBinding != null && animationBoneBinding.getBone() != null && animationBoneBinding.getBone().Index == n;
        keyframe.setIdentity();
        float f = 0.0f;
        boolean bl2 = true;
        float f2 = 1.0f;
        for (int i = n2 - 1; i >= 0 && f2 > 0.0f && !(f2 <= 0.001f); --i) {
            boolean bl3;
            Vector3f vector3f3;
            float f3;
            int n3 = this.m_animBlendIndices[i];
            AnimationTrack animationTrack = list.get(n3);
            float f4 = animationTrack.getBoneWeight(n);
            if (f4 <= 0.001f || (f3 = this.m_animBlendWeights[i] * f4) <= 0.001f) continue;
            float f5 = PZMath.clamp(f3, 0.0f, f2);
            f2 -= f3;
            f2 = org.joml.Math.max(0.0f, f2);
            this.getTrackTransform(n, animationTrack, animationBoneBindingPair, vector3f, quaternion, vector3f2);
            if (bl && animationTrack.getUseDeferredRotation()) {
                if (DebugOptions.instance.Character.Debug.Animate.ZeroCounterRotationBone.getValue()) {
                    Vector3f vector3f4 = L_updateBoneAnimationTransform.rotAxis;
                    vector3f3 = L_updateBoneAnimationTransform.rotMat;
                    vector3f3.setIdentity();
                    vector3f4.set(0.0f, 1.0f, 0.0f);
                    vector3f3.rotate(-1.5707964f, vector3f4);
                    vector3f4.set(1.0f, 0.0f, 0.0f);
                    vector3f3.rotate(-1.5707964f, vector3f4);
                    HelperFunctions.getRotation((Matrix4f)vector3f3, quaternion);
                } else {
                    Vector3f vector3f5 = HelperFunctions.ToEulerAngles(quaternion, L_updateBoneAnimationTransform.rotEulers);
                    HelperFunctions.ToQuaternion(vector3f5.x, vector3f5.y, 1.5707963705062866, quaternion);
                }
            }
            boolean bl4 = bl3 = animationTrack.getDeferredMovementBoneIdx() == n;
            if (bl3) {
                vector3f3 = animationTrack.getCurrentDeferredCounterPosition(L_updateBoneAnimationTransform.deferredPos);
                vector3f.x += vector3f3.x;
                vector3f.y += vector3f3.y;
                vector3f.z += vector3f3.z;
            }
            if (bl2) {
                Vector3.setScaled(vector3f, f5, keyframe.Position);
                keyframe.Rotation.set((ReadableVector4f)quaternion);
                f = f5;
                bl2 = false;
                continue;
            }
            float f6 = f5 / (f5 + f);
            f += f5;
            Vector3.addScaled(keyframe.Position, vector3f, f5, keyframe.Position);
            PZMath.slerp(keyframe.Rotation, keyframe.Rotation, quaternion, f6);
        }
        if (f2 > 0.0f && !this.m_boneTransformsNeedFirstFrame) {
            this.m_boneTransforms[n].getPRS(vector3f, quaternion, vector3f2);
            Vector3.addScaled(keyframe.Position, vector3f, f2, keyframe.Position);
            PZMath.slerp(keyframe.Rotation, quaternion, keyframe.Rotation, f);
            PZMath.lerp(keyframe.Scale, vector3f2, keyframe.Scale, f);
        }
        this.m_boneTransforms[n].set(keyframe.Position, keyframe.Rotation, keyframe.Scale);
        this.m_boneTransforms[n].BlendWeight = f;
        this.m_boneTransforms[n].Twist *= 1.0f - f;
    }

    private void getTrackTransform(int n, AnimationTrack animationTrack, AnimationBoneBindingPair animationBoneBindingPair, Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2) {
        if (animationBoneBindingPair == null) {
            animationTrack.get(n, vector3f, quaternion, vector3f2);
            return;
        }
        Matrix4f matrix4f = L_getTrackTransform.result;
        SkinningBone skinningBone = animationBoneBindingPair.getBoneA();
        Matrix4f matrix4f2 = AnimationPlayer.getUnweightedBoneTransform(animationTrack, skinningBone.Index, L_getTrackTransform.Pa);
        SkinningBone skinningBone2 = skinningBone.Parent;
        SkinningBone skinningBone3 = animationBoneBindingPair.getBoneB();
        Matrix4f matrix4f3 = this.getBoneModelTransform(skinningBone2.Index, L_getTrackTransform.mA);
        Matrix4f matrix4f4 = Matrix4f.invert((Matrix4f)matrix4f3, (Matrix4f)L_getTrackTransform.mAinv);
        Matrix4f matrix4f5 = this.getBoneModelTransform(skinningBone3.Index, L_getTrackTransform.mB);
        Matrix4f matrix4f6 = this.getUnweightedModelTransform(animationTrack, skinningBone2.Index, L_getTrackTransform.umA);
        Matrix4f matrix4f7 = this.getUnweightedModelTransform(animationTrack, skinningBone3.Index, L_getTrackTransform.umB);
        Matrix4f matrix4f8 = Matrix4f.invert((Matrix4f)matrix4f7, (Matrix4f)L_getTrackTransform.umBinv);
        Matrix4f.mul((Matrix4f)matrix4f2, (Matrix4f)matrix4f6, (Matrix4f)matrix4f);
        Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)matrix4f8, (Matrix4f)matrix4f);
        Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)matrix4f5, (Matrix4f)matrix4f);
        Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)matrix4f4, (Matrix4f)matrix4f);
        HelperFunctions.getPosition(matrix4f, vector3f);
        HelperFunctions.getRotation(matrix4f, quaternion);
        vector3f2.set(1.0f, 1.0f, 1.0f);
    }

    public boolean isBoneReparented(int n2) {
        return PZArrayUtil.contains(this.m_reparentedBoneBindings, Lambda.predicate(n2, (animationBoneBindingPair, n) -> animationBoneBindingPair.getBoneIdxA() == n.intValue()));
    }

    public void updateMultiTrackBoneTransforms_DeferredMovementOnly() {
        int n;
        this.m_deferredMovement.set(0.0f, 0.0f);
        if (this.parentPlayer != null) {
            return;
        }
        this.updateLayerBlendWeightings();
        if (this.m_totalAnimBlendCount == 0) {
            return;
        }
        int[] nArray = updateMultiTrackBoneTransforms_DeferredMovementOnly.boneIndices;
        int n2 = 0;
        List<AnimationTrack> list = this.m_multiTrack.getTracks();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            AnimationTrack animationTrack = list.get(n);
            int n4 = animationTrack.getDeferredMovementBoneIdx();
            if (n4 == -1 || PZArrayUtil.contains(nArray, n2, n4)) continue;
            nArray[n2++] = n4;
        }
        for (n = 0; n < n2; ++n) {
            this.updateBoneAnimationTransform(nArray[n], null);
        }
    }

    public boolean isRecording() {
        return this.m_recorder != null && this.m_recorder.isRecording();
    }

    public void setRecorder(AnimationPlayerRecorder animationPlayerRecorder) {
        this.m_recorder = animationPlayerRecorder;
    }

    public AnimationPlayerRecorder getRecorder() {
        return this.m_recorder;
    }

    public void dismember(int n) {
        this.dismembered.add(n);
    }

    private void updateModelTransforms() {
        GameProfiler.getInstance().invokeAndMeasure("updateModelTransforms", this, AnimationPlayer::updateModelTransformsInternal);
    }

    private void updateModelTransformsInternal() {
        this.m_boneTransforms[0].getMatrix(this.modelTransforms[0]);
        for (int i = 1; i < this.modelTransforms.length; ++i) {
            SkinningBone skinningBone = this.m_skinningData.getBoneAt(i);
            SkinningBone skinningBone2 = skinningBone.Parent;
            BoneTransform.mul(this.m_boneTransforms[skinningBone.Index], this.modelTransforms[skinningBone2.Index], this.modelTransforms[skinningBone.Index]);
        }
    }

    public Matrix4f getBoneModelTransform(int n, Matrix4f matrix4f) {
        SkinningBone skinningBone;
        Matrix4f matrix4f2 = L_getBoneModelTransform.boneTransform;
        matrix4f.setIdentity();
        SkinningBone skinningBone2 = skinningBone = this.m_skinningData.getBoneAt(n);
        while (skinningBone2 != null) {
            this.getBoneTransform(skinningBone2.Index, matrix4f2);
            Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)matrix4f2, (Matrix4f)matrix4f);
            skinningBone2 = skinningBone2.Parent;
        }
        return matrix4f;
    }

    public Matrix4f getBoneTransform(int n, Matrix4f matrix4f) {
        this.m_boneTransforms[n].getMatrix(matrix4f);
        return matrix4f;
    }

    public Matrix4f getUnweightedModelTransform(AnimationTrack animationTrack, int n, Matrix4f matrix4f) {
        SkinningBone skinningBone;
        Matrix4f matrix4f2 = L_getUnweightedModelTransform.boneTransform;
        matrix4f2.setIdentity();
        matrix4f.setIdentity();
        SkinningBone skinningBone2 = skinningBone = this.m_skinningData.getBoneAt(n);
        while (skinningBone2 != null) {
            AnimationPlayer.getUnweightedBoneTransform(animationTrack, skinningBone2.Index, matrix4f2);
            Matrix4f.mul((Matrix4f)matrix4f, (Matrix4f)matrix4f2, (Matrix4f)matrix4f);
            skinningBone2 = skinningBone2.Parent;
        }
        return matrix4f;
    }

    public static Matrix4f getUnweightedBoneTransform(AnimationTrack animationTrack, int n, Matrix4f matrix4f) {
        Vector3f vector3f = L_getUnweightedBoneTransform.pos;
        Quaternion quaternion = L_getUnweightedBoneTransform.rot;
        Vector3f vector3f2 = L_getUnweightedBoneTransform.scale;
        animationTrack.get(n, vector3f, quaternion, vector3f2);
        HelperFunctions.CreateFromQuaternionPositionScale(vector3f, quaternion, vector3f2, matrix4f);
        return matrix4f;
    }

    public void UpdateSkinTransforms() {
        this.resetSkinTransforms();
    }

    public Matrix4f[] getSkinTransforms(SkinningData skinningData) {
        if (skinningData == null) {
            return this.modelTransforms;
        }
        SkinTransformData skinTransformData = this.getSkinTransformData(skinningData);
        Matrix4f[] matrix4fArray = skinTransformData.transforms;
        if (skinTransformData.dirty) {
            for (int i = 0; i < this.modelTransforms.length; ++i) {
                if (skinningData.BoneOffset != null && skinningData.BoneOffset.get(i) != null) {
                    Matrix4f.mul((Matrix4f)skinningData.BoneOffset.get(i), (Matrix4f)this.modelTransforms[i], (Matrix4f)matrix4fArray[i]);
                    continue;
                }
                matrix4fArray[i].setIdentity();
            }
            skinTransformData.dirty = false;
        }
        return matrix4fArray;
    }

    public void getDeferredMovement(Vector2 vector22) {
        vector22.set(this.m_deferredMovement);
    }

    public float getDeferredAngleDelta() {
        return this.m_deferredAngleDelta;
    }

    public float getDeferredRotationWeight() {
        return this.m_deferredRotationWeight;
    }

    public AnimationMultiTrack getMultiTrack() {
        return this.m_multiTrack;
    }

    public void setRecording(boolean bl) {
        this.m_recorder.setRecording(bl);
    }

    public void discardRecording() {
        if (this.m_recorder != null) {
            this.m_recorder.discardRecording();
        }
    }

    public float getRenderedAngle() {
        return this.m_angle + 1.5707964f;
    }

    public float getAngle() {
        return this.m_angle;
    }

    public void setAngle(float f) {
        this.m_angle = f;
    }

    public void setAngleToTarget() {
        this.setAngle(this.getTargetAngle());
    }

    public void setTargetToAngle() {
        float f = this.getAngle();
        this.setTargetAngle(f);
    }

    public float getTargetAngle() {
        return this.m_targetAngle;
    }

    public void setTargetAngle(float f) {
        this.m_targetAngle = f;
    }

    public float getMaxTwistAngle() {
        return this.m_maxTwistAngle;
    }

    public void setMaxTwistAngle(float f) {
        this.m_maxTwistAngle = f;
    }

    public float getExcessTwistAngle() {
        return this.m_excessTwist;
    }

    public float getTwistAngle() {
        return this.m_twistAngle;
    }

    public float getShoulderTwistAngle() {
        return this.m_shoulderTwistAngle;
    }

    public float getTargetTwistAngle() {
        return this.m_targetTwistAngle;
    }

    private static class SkinTransformData
    extends PooledObject {
        public Matrix4f[] transforms;
        private SkinningData m_skinnedTo;
        public boolean dirty;
        private SkinTransformData m_next;
        private static Pool<SkinTransformData> s_pool = new Pool<SkinTransformData>(SkinTransformData::new);

        private SkinTransformData() {
        }

        public void setSkinnedTo(SkinningData skinningData) {
            if (this.m_skinnedTo == skinningData) {
                return;
            }
            this.dirty = true;
            this.m_skinnedTo = skinningData;
            this.transforms = PZArrayUtil.newInstance(Matrix4f.class, this.transforms, skinningData.numBones(), Matrix4f::new);
        }

        public static SkinTransformData alloc(SkinningData skinningData) {
            SkinTransformData skinTransformData = s_pool.alloc();
            skinTransformData.setSkinnedTo(skinningData);
            skinTransformData.dirty = true;
            return skinTransformData;
        }
    }

    private static final class L_setTwistBones {
        static final ArrayList<String> boneNames = new ArrayList();

        private L_setTwistBones() {
        }
    }

    private static class L_applyTwistBone {
        static final Matrix4f twistParentBoneTrans = new Matrix4f();
        static final Matrix4f twistParentBoneTransInv = new Matrix4f();
        static final Matrix4f twistBoneTrans = new Matrix4f();
        static final Quaternion twistBoneRot = new Quaternion();
        static final Quaternion twistBoneTargetRot = new Quaternion();
        static final Matrix4f twistRotDiffTrans = new Matrix4f();
        static final Vector3f twistRotDiffTransAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        static final Matrix4f twistBoneTargetTrans = new Matrix4f();
        static final Quaternion twistBoneNewRot = new Quaternion();
        static final Vector3f twistBonePos = new Vector3f();
        static final Vector3f twistBoneScale = new Vector3f();
        static final Matrix4f twistBoneNewTrans = new Matrix4f();

        private L_applyTwistBone() {
        }
    }

    private static final class L_updateBoneAnimationTransform {
        static final Quaternion rot = new Quaternion();
        static final Vector3f pos = new Vector3f();
        static final Vector3f scale = new Vector3f();
        static final Keyframe key = new Keyframe(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        static final Matrix4f boneMat = new Matrix4f();
        static final Matrix4f rotMat = new Matrix4f();
        static final Vector3f rotAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        static final Quaternion crRot = new Quaternion();
        static final Vector4f crRotAA = new Vector4f();
        static final Matrix4f crMat = new Matrix4f();
        static final Vector3f rotEulers = new Vector3f();
        static final Vector3f deferredPos = new Vector3f();

        private L_updateBoneAnimationTransform() {
        }
    }

    private static final class L_getTrackTransform {
        static final Matrix4f Pa = new Matrix4f();
        static final Matrix4f mA = new Matrix4f();
        static final Matrix4f mB = new Matrix4f();
        static final Matrix4f umA = new Matrix4f();
        static final Matrix4f umB = new Matrix4f();
        static final Matrix4f mAinv = new Matrix4f();
        static final Matrix4f umBinv = new Matrix4f();
        static final Matrix4f result = new Matrix4f();

        private L_getTrackTransform() {
        }
    }

    private static final class updateMultiTrackBoneTransforms_DeferredMovementOnly {
        static int[] boneIndices = new int[60];

        private updateMultiTrackBoneTransforms_DeferredMovementOnly() {
        }
    }

    private static class L_getBoneModelTransform {
        static final Matrix4f boneTransform = new Matrix4f();

        private L_getBoneModelTransform() {
        }
    }

    private static class L_getUnweightedModelTransform {
        static final Matrix4f boneTransform = new Matrix4f();

        private L_getUnweightedModelTransform() {
        }
    }

    private static class L_getUnweightedBoneTransform {
        static final Vector3f pos = new Vector3f();
        static final Quaternion rot = new Quaternion();
        static final Vector3f scale = new Vector3f();

        private L_getUnweightedBoneTransform() {
        }
    }
}

