/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import java.util.ArrayList;
import java.util.List;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.AnimationTrack;

public final class AnimationMultiTrack {
    private final ArrayList<AnimationTrack> m_tracks = new ArrayList();
    private static final ArrayList<AnimationTrack> tempTracks = new ArrayList();

    public AnimationTrack findTrack(String string) {
        int n = this.m_tracks.size();
        for (int i = 0; i < n; ++i) {
            AnimationTrack animationTrack = this.m_tracks.get(i);
            if (!animationTrack.name.equals(string)) continue;
            return animationTrack;
        }
        return null;
    }

    public void addTrack(AnimationTrack animationTrack) {
        this.m_tracks.add(animationTrack);
    }

    public void removeTrack(AnimationTrack animationTrack) {
        int n = this.getIndexOfTrack(animationTrack);
        if (n > -1) {
            this.removeTrackAt(n);
        }
    }

    public void removeTracks(List<AnimationTrack> list) {
        tempTracks.clear();
        tempTracks.addAll(list);
        for (int i = 0; i < tempTracks.size(); ++i) {
            this.removeTrack(tempTracks.get(i));
        }
    }

    public void removeTrackAt(int n) {
        this.m_tracks.remove(n).release();
    }

    public int getIndexOfTrack(AnimationTrack animationTrack) {
        if (animationTrack == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.m_tracks.size(); ++i) {
            AnimationTrack animationTrack2 = this.m_tracks.get(i);
            if (animationTrack2 != animationTrack) continue;
            n = i;
            break;
        }
        return n;
    }

    public void Update(float f) {
        for (int i = 0; i < this.m_tracks.size(); ++i) {
            AnimationTrack animationTrack = this.m_tracks.get(i);
            animationTrack.Update(f);
            if (animationTrack.CurrentClip != null) continue;
            this.removeTrackAt(i);
            --i;
        }
    }

    public float getDuration() {
        float f = 0.0f;
        for (int i = 0; i < this.m_tracks.size(); ++i) {
            AnimationTrack animationTrack = this.m_tracks.get(i);
            float f2 = animationTrack.getDuration();
            if (animationTrack.CurrentClip == null || !(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public void reset() {
        int n = this.m_tracks.size();
        for (int i = 0; i < n; ++i) {
            AnimationTrack animationTrack = this.m_tracks.get(i);
            animationTrack.reset();
        }
        AnimationPlayer.releaseTracks(this.m_tracks);
        this.m_tracks.clear();
    }

    public List<AnimationTrack> getTracks() {
        return this.m_tracks;
    }

    public int getTrackCount() {
        return this.m_tracks.size();
    }

    public AnimationTrack getTrackAt(int n) {
        return this.m_tracks.get(n);
    }
}

