/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.animation;

import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Quaternion;
import zombie.core.skinnedmodel.animation.BoneAxis;
import zombie.core.skinnedmodel.animation.Keyframe;
import zombie.core.skinnedmodel.animation.StaticAnimation;

public final class AnimationClip {
    public final String Name;
    public StaticAnimation staticClip;
    private final KeyframeByBoneIndexElement[] m_KeyFramesByBoneIndex;
    public float Duration;
    private final List<Keyframe> m_rootMotionKeyframes = new ArrayList<Keyframe>();
    private final Keyframe[] KeyframeArray;
    private static final Quaternion orientation = new Quaternion(-0.07107f, 0.0f, 0.0f, 0.07107f);

    public AnimationClip(float f, List<Keyframe> list, String string, boolean bl) {
        this.Duration = f;
        this.KeyframeArray = list.toArray(new Keyframe[0]);
        this.Name = string;
        this.m_KeyFramesByBoneIndex = new KeyframeByBoneIndexElement[60];
        ArrayList<Keyframe> arrayList = new ArrayList<Keyframe>();
        int n = this.KeyframeArray.length - (bl ? 0 : 1);
        for (int i = 0; i < 60; ++i) {
            arrayList.clear();
            for (int j = 0; j < n; ++j) {
                Keyframe keyframe = this.KeyframeArray[j];
                if (keyframe.Bone != i) continue;
                arrayList.add(keyframe);
            }
            this.m_KeyFramesByBoneIndex[i] = new KeyframeByBoneIndexElement(arrayList);
        }
    }

    public Keyframe[] getBoneFramesAt(int n) {
        return this.m_KeyFramesByBoneIndex[n].m_keyframes;
    }

    public int getRootMotionFrameCount() {
        return this.m_rootMotionKeyframes.size();
    }

    public Keyframe getRootMotionFrameAt(int n) {
        return this.m_rootMotionKeyframes.get(n);
    }

    public Keyframe[] getKeyframes() {
        return this.KeyframeArray;
    }

    public float getTranslationLength(BoneAxis boneAxis) {
        float f = this.KeyframeArray[this.KeyframeArray.length - 1].Position.x - this.KeyframeArray[0].Position.x;
        float f2 = boneAxis == BoneAxis.Y ? -this.KeyframeArray[this.KeyframeArray.length - 1].Position.z + this.KeyframeArray[0].Position.z : this.KeyframeArray[this.KeyframeArray.length - 1].Position.y - this.KeyframeArray[0].Position.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    private static class KeyframeByBoneIndexElement {
        final Keyframe[] m_keyframes;

        KeyframeByBoneIndexElement(List<Keyframe> list) {
            this.m_keyframes = list.toArray(new Keyframe[0]);
        }
    }
}

