/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import zombie.characters.IsoGameCharacter;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.skinnedmodel.advancedanimation.AnimLayer;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.LiveAnimNode;
import zombie.core.skinnedmodel.animation.AnimationTrack;

public final class AnimatorDebugMonitor {
    private static final ArrayList<String> knownVariables = new ArrayList();
    private static boolean knownVarsDirty = false;
    private String currentState = "null";
    private MonitoredLayer[] monitoredLayers;
    private final HashMap<String, MonitoredVar> monitoredVariables = new HashMap();
    private final ArrayList<String> customVariables = new ArrayList();
    private final LinkedList<MonitorLogLine> logLines = new LinkedList();
    private final Queue<MonitorLogLine> logLineQueue = new LinkedList<MonitorLogLine>();
    private boolean floatsListDirty = false;
    private boolean hasFilterChanges = false;
    private boolean hasLogUpdates = false;
    private String logString = "";
    private static final int maxLogSize = 1028;
    private static final int maxOutputLines = 128;
    private static final int maxFloatCache = 1024;
    private final ArrayList<Float> floatsOut = new ArrayList();
    private MonitoredVar selectedVariable;
    private int tickCount = 0;
    private boolean doTickStamps = false;
    private static final int tickStampLength = 10;
    private static final Color col_curstate = Colors.Cyan;
    private static final Color col_layer_nodename = Colors.CornFlowerBlue;
    private static final Color col_layer_activated = Colors.DarkTurquoise;
    private static final Color col_layer_deactivated = Colors.Orange;
    private static final Color col_track_activated = Colors.SandyBrown;
    private static final Color col_track_deactivated = Colors.Salmon;
    private static final Color col_node_activated = Colors.Pink;
    private static final Color col_node_deactivated = Colors.Plum;
    private static final Color col_var_activated = Colors.Chartreuse;
    private static final Color col_var_changed = Colors.LimeGreen;
    private static final Color col_var_deactivated = Colors.Gold;
    private static final String TAG_VAR = "[variable]";
    private static final String TAG_LAYER = "[layer]";
    private static final String TAG_NODE = "[active_nodes]";
    private static final String TAG_TRACK = "[anim_tracks]";
    private boolean[] logFlags = new boolean[LogType.MAX.value()];

    public AnimatorDebugMonitor(IsoGameCharacter isoGameCharacter) {
        int n;
        this.logFlags[LogType.DEFAULT.value()] = true;
        for (n = 0; n < this.logFlags.length; ++n) {
            this.logFlags[n] = true;
        }
        for (n = 0; n < 1024; ++n) {
            this.floatsOut.add(Float.valueOf(0.0f));
        }
        this.initCustomVars();
        if (isoGameCharacter != null && isoGameCharacter.advancedAnimator != null) {
            ArrayList<String> arrayList = isoGameCharacter.advancedAnimator.debugGetVariables();
            for (String string : arrayList) {
                AnimatorDebugMonitor.registerVariable(string);
            }
        }
    }

    private void initCustomVars() {
        this.addCustomVariable("aim");
        this.addCustomVariable("bdead");
        this.addCustomVariable("bfalling");
        this.addCustomVariable("baimatfloor");
        this.addCustomVariable("battackfrombehind");
        this.addCustomVariable("attacktype");
        this.addCustomVariable("bundervehicle");
        this.addCustomVariable("reanimatetimer");
        this.addCustomVariable("isattacking");
        this.addCustomVariable("canclimbdownrope");
        this.addCustomVariable("frombehind");
        this.addCustomVariable("fallonfront");
        this.addCustomVariable("hashitreaction");
        this.addCustomVariable("hitreaction");
        this.addCustomVariable("collided");
        this.addCustomVariable("collidetype");
        this.addCustomVariable("intrees");
    }

    public void addCustomVariable(String string) {
        String string2 = string.toLowerCase();
        if (!this.customVariables.contains(string2)) {
            this.customVariables.add(string2);
        }
        AnimatorDebugMonitor.registerVariable(string);
    }

    public void removeCustomVariable(String string) {
        String string2 = string.toLowerCase();
        this.customVariables.remove(string2);
    }

    public void setFilter(int n, boolean bl) {
        if (n >= 0 && n < LogType.MAX.value()) {
            this.logFlags[n] = bl;
            this.hasFilterChanges = true;
        }
    }

    public boolean getFilter(int n) {
        if (n >= 0 && n < LogType.MAX.value()) {
            return this.logFlags[n];
        }
        return false;
    }

    public boolean isDoTickStamps() {
        return this.doTickStamps;
    }

    public void setDoTickStamps(boolean bl) {
        if (this.doTickStamps != bl) {
            this.doTickStamps = bl;
            this.hasFilterChanges = true;
        }
    }

    private void queueLogLine(String string) {
        this.addLogLine(LogType.DEFAULT, string, null, true);
    }

    private void queueLogLine(String string, Color color) {
        this.addLogLine(LogType.DEFAULT, string, color, true);
    }

    private void queueLogLine(LogType logType, String string, Color color) {
        this.addLogLine(logType, string, color, true);
    }

    private void addLogLine(String string) {
        this.addLogLine(LogType.DEFAULT, string, null, false);
    }

    private void addLogLine(String string, Color color) {
        this.addLogLine(LogType.DEFAULT, string, color, false);
    }

    private void addLogLine(String string, Color color, boolean bl) {
        this.addLogLine(LogType.DEFAULT, string, color, bl);
    }

    private void addLogLine(LogType logType, String string, Color color) {
        this.addLogLine(logType, string, color, false);
    }

    private void addLogLine(LogType logType, String string, Color color, boolean bl) {
        MonitorLogLine monitorLogLine = new MonitorLogLine();
        monitorLogLine.line = string;
        monitorLogLine.color = color;
        monitorLogLine.type = logType;
        monitorLogLine.tick = this.tickCount;
        if (bl) {
            this.logLineQueue.add(monitorLogLine);
        } else {
            this.log(monitorLogLine);
        }
    }

    private void log(MonitorLogLine monitorLogLine) {
        this.logLines.addFirst(monitorLogLine);
        if (this.logLines.size() > 1028) {
            this.logLines.removeLast();
        }
        this.hasLogUpdates = true;
    }

    private void processQueue() {
        while (this.logLineQueue.size() > 0) {
            MonitorLogLine monitorLogLine = this.logLineQueue.poll();
            this.log(monitorLogLine);
        }
    }

    private void preUpdate() {
        for (Map.Entry<String, MonitoredVar> object : this.monitoredVariables.entrySet()) {
            object.getValue().updated = false;
        }
        for (int i = 0; i < this.monitoredLayers.length; ++i) {
            MonitoredLayer monitoredLayer = this.monitoredLayers[i];
            monitoredLayer.updated = false;
            for (Map.Entry<String, MonitoredNode> entry : monitoredLayer.activeNodes.entrySet()) {
                entry.getValue().updated = false;
            }
            for (Map.Entry<String, Object> entry : monitoredLayer.animTracks.entrySet()) {
                ((MonitoredTrack)entry.getValue()).updated = false;
            }
        }
    }

    private void postUpdate() {
        for (Map.Entry<String, MonitoredVar> object : this.monitoredVariables.entrySet()) {
            if (!object.getValue().active || object.getValue().updated) continue;
            this.addLogLine(LogType.VAR, "[variable] : removed -> '" + object.getKey() + "', last value: '" + object.getValue().value + "'.", col_var_deactivated);
            object.getValue().active = false;
        }
        for (int i = 0; i < this.monitoredLayers.length; ++i) {
            MonitoredLayer monitoredLayer = this.monitoredLayers[i];
            for (Map.Entry<String, MonitoredNode> entry : monitoredLayer.activeNodes.entrySet()) {
                if (!entry.getValue().active || entry.getValue().updated) continue;
                this.addLogLine(LogType.NODE, "[layer][" + monitoredLayer.index + "] [active_nodes] : deactivated -> '" + entry.getValue().name + "'.", col_node_deactivated);
                entry.getValue().active = false;
            }
            for (Map.Entry<String, Object> entry : monitoredLayer.animTracks.entrySet()) {
                if (!((MonitoredTrack)entry.getValue()).active || ((MonitoredTrack)entry.getValue()).updated) continue;
                this.addLogLine(LogType.TRACK, "[layer][" + monitoredLayer.index + "] [anim_tracks] : deactivated -> '" + ((MonitoredTrack)entry.getValue()).name + "'.", col_track_deactivated);
                ((MonitoredTrack)entry.getValue()).active = false;
            }
            if (!monitoredLayer.active || monitoredLayer.updated) continue;
            this.addLogLine(LogType.LAYER, "[layer][" + i + "] : deactivated (last animstate: '" + monitoredLayer.nodeName + "').", col_layer_deactivated);
            monitoredLayer.active = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update(IsoGameCharacter isoGameCharacter, AnimLayer[] animLayerArray) {
        void var4_7;
        if (isoGameCharacter == null) {
            return;
        }
        this.ensureLayers(animLayerArray);
        this.preUpdate();
        for (IAnimationVariableSlot object : isoGameCharacter.getGameVariables()) {
            this.updateVariable(object.getKey(), object.getValueString());
        }
        for (String string : this.customVariables) {
            String string2 = isoGameCharacter.getVariableString(string);
            if (string2 == null) continue;
            this.updateVariable(string, string2);
        }
        this.updateCurrentState(isoGameCharacter.getCurrentState() == null ? "null" : isoGameCharacter.getCurrentState().getClass().getSimpleName());
        boolean bl = false;
        while (var4_7 < animLayerArray.length) {
            if (animLayerArray[var4_7] != null) {
                this.updateLayer((int)var4_7, animLayerArray[var4_7]);
            }
            ++var4_7;
        }
        this.postUpdate();
        this.processQueue();
        ++this.tickCount;
    }

    private void updateCurrentState(String string) {
        if (!this.currentState.equals(string)) {
            this.queueLogLine("Character.currentState changed from '" + this.currentState + "' to: '" + string + "'.", col_curstate);
            this.currentState = string;
        }
    }

    private void updateLayer(int n, AnimLayer animLayer) {
        MonitoredLayer monitoredLayer = this.monitoredLayers[n];
        String string = animLayer.getDebugNodeName();
        if (!monitoredLayer.active) {
            monitoredLayer.active = true;
            this.queueLogLine(LogType.LAYER, "[layer][" + n + "] activated -> animstate: '" + string + "'.", col_layer_activated);
        }
        if (!monitoredLayer.nodeName.equals(string)) {
            this.queueLogLine(LogType.LAYER, "[layer][" + n + "] changed -> animstate from '" + monitoredLayer.nodeName + "' to: '" + string + "'.", col_layer_nodename);
            monitoredLayer.nodeName = string;
        }
        for (LiveAnimNode pooledObject : animLayer.getLiveAnimNodes()) {
            this.updateActiveNode(monitoredLayer, pooledObject.getSourceNode().m_Name);
        }
        if (animLayer.getAnimationTrack() != null) {
            for (AnimationTrack animationTrack : animLayer.getAnimationTrack().getTracks()) {
                if (animationTrack.getLayerIdx() != n) continue;
                this.updateAnimTrack(monitoredLayer, animationTrack.name, animationTrack.BlendDelta);
            }
        }
        monitoredLayer.updated = true;
    }

    private void updateActiveNode(MonitoredLayer monitoredLayer, String string) {
        MonitoredNode monitoredNode = monitoredLayer.activeNodes.get(string);
        if (monitoredNode == null) {
            monitoredNode = new MonitoredNode();
            monitoredNode.name = string;
            monitoredLayer.activeNodes.put(string, monitoredNode);
        }
        if (!monitoredNode.active) {
            monitoredNode.active = true;
            this.queueLogLine(LogType.NODE, "[layer][" + monitoredLayer.index + "] [active_nodes] : activated -> '" + string + "'.", col_node_activated);
        }
        monitoredNode.updated = true;
    }

    private void updateAnimTrack(MonitoredLayer monitoredLayer, String string, float f) {
        MonitoredTrack monitoredTrack = monitoredLayer.animTracks.get(string);
        if (monitoredTrack == null) {
            monitoredTrack = new MonitoredTrack();
            monitoredTrack.name = string;
            monitoredTrack.blendDelta = f;
            monitoredLayer.animTracks.put(string, monitoredTrack);
        }
        if (!monitoredTrack.active) {
            monitoredTrack.active = true;
            this.queueLogLine(LogType.TRACK, "[layer][" + monitoredLayer.index + "] [anim_tracks] : activated -> '" + string + "'.", col_track_activated);
        }
        if (monitoredTrack.blendDelta != f) {
            monitoredTrack.blendDelta = f;
        }
        monitoredTrack.updated = true;
    }

    private void updateVariable(String string, String string2) {
        MonitoredVar monitoredVar = this.monitoredVariables.get(string);
        boolean bl = false;
        if (monitoredVar == null) {
            monitoredVar = new MonitoredVar();
            this.monitoredVariables.put(string, monitoredVar);
            bl = true;
        }
        if (!monitoredVar.active) {
            monitoredVar.active = true;
            monitoredVar.key = string;
            monitoredVar.value = string2;
            this.queueLogLine(LogType.VAR, "[variable] : added -> '" + string + "', value: '" + string2 + "'.", col_var_activated);
            if (bl) {
                AnimatorDebugMonitor.registerVariable(string);
            }
        } else if (string2 == null) {
            if (monitoredVar.isFloat) {
                monitoredVar.isFloat = false;
                this.floatsListDirty = true;
            }
            monitoredVar.value = null;
        } else if (monitoredVar.value == null || !monitoredVar.value.equals(string2)) {
            block12: {
                try {
                    float f = Float.parseFloat(string2);
                    monitoredVar.logFloat(f);
                    if (!monitoredVar.isFloat) {
                        monitoredVar.isFloat = true;
                        this.floatsListDirty = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!monitoredVar.isFloat) break block12;
                    monitoredVar.isFloat = false;
                    this.floatsListDirty = true;
                }
            }
            if (!monitoredVar.isFloat) {
                this.queueLogLine(LogType.VAR, "[variable] : updated -> '" + string + "' changed from '" + monitoredVar.value + "' to: '" + string2 + "'.", col_var_changed);
            }
            monitoredVar.value = string2;
        }
        monitoredVar.updated = true;
    }

    private void buildLogString() {
        Object object;
        ListIterator<MonitorLogLine> listIterator = this.logLines.listIterator(0);
        int n = 0;
        int n2 = 0;
        while (listIterator.hasNext()) {
            object = listIterator.next();
            ++n2;
            if (!this.logFlags[((MonitorLogLine)object).type.value()] || ++n < 128) continue;
            break;
        }
        if (n2 == 0) {
            this.logString = "";
            return;
        }
        listIterator = this.logLines.listIterator(n2);
        object = new StringBuilder();
        while (listIterator.hasPrevious()) {
            MonitorLogLine monitorLogLine = listIterator.previous();
            if (!this.logFlags[monitorLogLine.type.value()]) continue;
            ((StringBuilder)object).append(" <TEXT> ");
            if (this.doTickStamps) {
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(String.format("%010d", monitorLogLine.tick));
                ((StringBuilder)object).append("]");
            }
            if (monitorLogLine.color != null) {
                ((StringBuilder)object).append(" <RGB:");
                ((StringBuilder)object).append(monitorLogLine.color.r);
                ((StringBuilder)object).append(",");
                ((StringBuilder)object).append(monitorLogLine.color.g);
                ((StringBuilder)object).append(",");
                ((StringBuilder)object).append(monitorLogLine.color.b);
                ((StringBuilder)object).append("> ");
            }
            ((StringBuilder)object).append(monitorLogLine.line);
            ((StringBuilder)object).append(" <LINE> ");
        }
        this.logString = ((StringBuilder)object).toString();
        this.hasLogUpdates = false;
        this.hasFilterChanges = false;
    }

    public boolean IsDirty() {
        return this.hasLogUpdates || this.hasFilterChanges;
    }

    public String getLogString() {
        if (this.hasLogUpdates || this.hasFilterChanges) {
            this.buildLogString();
        }
        return this.logString;
    }

    public boolean IsDirtyFloatList() {
        return this.floatsListDirty;
    }

    public ArrayList<String> getFloatNames() {
        this.floatsListDirty = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, MonitoredVar> entry : this.monitoredVariables.entrySet()) {
            if (!entry.getValue().isFloat) continue;
            arrayList.add(entry.getValue().key);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static boolean isKnownVarsDirty() {
        return knownVarsDirty;
    }

    public static List<String> getKnownVariables() {
        knownVarsDirty = false;
        Collections.sort(knownVariables);
        return knownVariables;
    }

    public void setSelectedVariable(String string) {
        this.selectedVariable = string == null ? null : this.monitoredVariables.get(string);
    }

    public String getSelectedVariable() {
        if (this.selectedVariable != null) {
            return this.selectedVariable.key;
        }
        return null;
    }

    public float getSelectedVariableFloat() {
        if (this.selectedVariable != null) {
            return this.selectedVariable.valFloat;
        }
        return 0.0f;
    }

    public String getSelectedVarMinFloat() {
        if (this.selectedVariable != null && this.selectedVariable.isFloat && this.selectedVariable.f_min != -1.0f) {
            return "" + this.selectedVariable.f_min;
        }
        return "-1.0";
    }

    public String getSelectedVarMaxFloat() {
        if (this.selectedVariable != null && this.selectedVariable.isFloat && this.selectedVariable.f_max != -1.0f) {
            return "" + this.selectedVariable.f_max;
        }
        return "1.0";
    }

    public ArrayList<Float> getSelectedVarFloatList() {
        if (this.selectedVariable != null && this.selectedVariable.isFloat) {
            MonitoredVar monitoredVar = this.selectedVariable;
            int n = monitoredVar.f_index - 1;
            if (n < 0) {
                n = 0;
            }
            float f = monitoredVar.f_max - monitoredVar.f_min;
            for (int i = 0; i < 1024; ++i) {
                float f2 = (monitoredVar.f_floats[n--] - monitoredVar.f_min) / f;
                this.floatsOut.set(i, Float.valueOf(f2));
                if (n >= 0) continue;
                n = monitoredVar.f_floats.length - 1;
            }
            return this.floatsOut;
        }
        return null;
    }

    public static void registerVariable(String string) {
        if (string == null) {
            return;
        }
        if (!knownVariables.contains(string = string.toLowerCase())) {
            knownVariables.add(string);
            knownVarsDirty = true;
        }
    }

    private void ensureLayers(AnimLayer[] animLayerArray) {
        int n = animLayerArray.length;
        if (this.monitoredLayers == null || this.monitoredLayers.length != n) {
            this.monitoredLayers = new MonitoredLayer[n];
            for (int i = 0; i < n; ++i) {
                this.monitoredLayers[i] = new MonitoredLayer(i);
            }
        }
    }

    private static enum LogType {
        DEFAULT(0),
        LAYER(1),
        NODE(2),
        TRACK(3),
        VAR(4),
        MAX(5);

        private final int val;

        private LogType(int n2) {
            this.val = n2;
        }

        public int value() {
            return this.val;
        }
    }

    private class MonitorLogLine {
        String line;
        Color color = null;
        LogType type = LogType.DEFAULT;
        int tick;

        private MonitorLogLine() {
        }
    }

    private class MonitoredVar {
        String key = "";
        String value = "";
        boolean isFloat = false;
        float valFloat;
        boolean active = false;
        boolean updated = false;
        float[] f_floats;
        int f_index = 0;
        float f_min = -1.0f;
        float f_max = 1.0f;

        private MonitoredVar() {
        }

        public void logFloat(float f) {
            if (this.f_floats == null) {
                this.f_floats = new float[1024];
            }
            if (f == this.valFloat) {
                return;
            }
            this.valFloat = f;
            this.f_floats[this.f_index++] = f;
            if (f < this.f_min) {
                this.f_min = f;
            }
            if (f > this.f_max) {
                this.f_max = f;
            }
            if (this.f_index >= 1024) {
                this.f_index = 0;
            }
        }
    }

    private class MonitoredLayer {
        int index;
        String nodeName = "";
        HashMap<String, MonitoredNode> activeNodes = new HashMap();
        HashMap<String, MonitoredTrack> animTracks = new HashMap();
        boolean active = false;
        boolean updated = false;

        public MonitoredLayer(int n) {
            this.index = n;
        }
    }

    private class MonitoredNode {
        String name = "";
        boolean active = false;
        boolean updated = false;

        private MonitoredNode() {
        }
    }

    private class MonitoredTrack {
        String name = "";
        float blendDelta;
        boolean active = false;
        boolean updated = false;

        private MonitoredTrack() {
        }
    }
}

