/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.ArrayList;
import java.util.List;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.AnimBoneWeight;
import zombie.core.skinnedmodel.advancedanimation.AnimCondition;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimLayer;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimTransition;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.BoneAxis;
import zombie.core.skinnedmodel.animation.IAnimListener;
import zombie.debug.DebugOptions;
import zombie.util.Lambda;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

public class LiveAnimNode
extends PooledObject
implements IAnimListener {
    private AnimNode m_sourceNode;
    private AnimLayer m_animLayer;
    private boolean m_active;
    private boolean m_wasActive;
    boolean m_TransitioningOut;
    private float m_Weight;
    private float m_RawWeight;
    private boolean m_isNew;
    private int m_layerIdx;
    private final TransitionIn m_transitionIn = new TransitionIn();
    final List<AnimationTrack> m_AnimationTracks = new ArrayList<AnimationTrack>();
    float m_NodeAnimTime;
    float m_PrevNodeAnimTime;
    private boolean m_blendingIn;
    private boolean m_blendingOut;
    private AnimTransition m_transitionOut;
    private static final Pool<LiveAnimNode> s_pool = new Pool<LiveAnimNode>(LiveAnimNode::new);

    protected LiveAnimNode() {
    }

    public static LiveAnimNode alloc(AnimLayer animLayer, AnimNode animNode, int n) {
        LiveAnimNode liveAnimNode = s_pool.alloc();
        liveAnimNode.reset();
        liveAnimNode.m_sourceNode = animNode;
        liveAnimNode.m_animLayer = animLayer;
        liveAnimNode.m_layerIdx = n;
        return liveAnimNode;
    }

    private void reset() {
        this.m_sourceNode = null;
        this.m_animLayer = null;
        this.m_active = false;
        this.m_wasActive = false;
        this.m_TransitioningOut = false;
        this.m_Weight = 0.0f;
        this.m_RawWeight = 0.0f;
        this.m_isNew = true;
        this.m_layerIdx = -1;
        this.m_transitionIn.reset();
        this.m_AnimationTracks.clear();
        this.m_NodeAnimTime = 0.0f;
        this.m_PrevNodeAnimTime = 0.0f;
        this.m_blendingIn = false;
        this.m_blendingOut = false;
        this.m_transitionOut = null;
    }

    @Override
    public void onReleased() {
        this.reset();
    }

    public String getName() {
        return this.m_sourceNode.m_Name;
    }

    public boolean isTransitioningIn() {
        return this.m_transitionIn.m_active && this.m_transitionIn.m_track != null;
    }

    public void startTransitionIn(LiveAnimNode liveAnimNode, AnimTransition animTransition, AnimationTrack animationTrack) {
        this.startTransitionIn(liveAnimNode.getSourceNode(), animTransition, animationTrack);
    }

    public void startTransitionIn(AnimNode animNode, AnimTransition animTransition, AnimationTrack animationTrack) {
        this.m_transitionIn.m_active = animationTrack != null;
        this.m_transitionIn.m_transitionedFrom = animNode.m_Name;
        this.m_transitionIn.m_data = animTransition;
        this.m_transitionIn.m_track = animationTrack;
        this.m_transitionIn.m_weight = 0.0f;
        this.m_transitionIn.m_rawWeight = 0.0f;
        this.m_transitionIn.m_blendingIn = true;
        this.m_transitionIn.m_blendingOut = false;
        this.m_transitionIn.m_time = 0.0f;
        if (this.m_transitionIn.m_track != null) {
            this.m_transitionIn.m_track.addListener(this);
        }
        this.setMainTracksPlaying(false);
    }

    public void setTransitionOut(AnimTransition animTransition) {
        this.m_transitionOut = animTransition;
    }

    public void update(float f) {
        boolean bl;
        boolean bl2;
        this.m_isNew = false;
        if (this.m_active != this.m_wasActive) {
            this.m_blendingIn = this.m_active;
            boolean bl3 = this.m_blendingOut = !this.m_active;
            if (this.m_transitionIn.m_active) {
                this.m_transitionIn.m_blendingIn = this.m_active;
                this.m_transitionIn.m_blendingOut = !this.m_active;
            }
            this.m_wasActive = this.m_active;
        }
        boolean bl4 = this.isMainAnimActive();
        if (this.isTransitioningIn()) {
            this.updateTransitioningIn(f);
        }
        if (bl2 = this.isMainAnimActive()) {
            if (this.m_blendingOut && this.m_sourceNode.m_StopAnimOnExit) {
                this.setMainTracksPlaying(false);
            } else {
                this.setMainTracksPlaying(true);
            }
        } else {
            this.setMainTracksPlaying(false);
        }
        if (!bl2) {
            return;
        }
        boolean bl5 = bl = !bl4;
        if (bl && this.isLooped()) {
            float f2 = this.getMainInitialRewindTime();
            PZArrayUtil.forEach(this.m_AnimationTracks, Lambda.consumer(Float.valueOf(f2), AnimationTrack::scaledRewind));
        }
        if (this.m_blendingIn) {
            this.updateBlendingIn(f);
        } else if (this.m_blendingOut) {
            this.updateBlendingOut(f);
        }
        this.m_PrevNodeAnimTime = this.m_NodeAnimTime;
        this.m_NodeAnimTime += f;
        if (!this.m_transitionIn.m_active && this.m_transitionIn.m_track != null && this.m_transitionIn.m_track.BlendDelta <= 0.0f) {
            this.m_animLayer.getAnimationTrack().removeTrack(this.m_transitionIn.m_track);
            this.m_transitionIn.reset();
        }
    }

    private void updateTransitioningIn(float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        float f6 = this.m_transitionIn.m_track.SpeedDelta;
        float f7 = this.m_transitionIn.m_track.getDuration();
        this.m_transitionIn.m_time = this.m_transitionIn.m_track.getCurrentTimeValue();
        if (this.m_transitionIn.m_time >= f7) {
            this.m_transitionIn.m_active = false;
            this.m_transitionIn.m_weight = 0.0f;
            return;
        }
        if (!this.m_transitionIn.m_blendingOut && !(bl = AnimCondition.pass(this.m_animLayer.getVariableSource(), this.m_transitionIn.m_data.m_Conditions))) {
            this.m_transitionIn.m_blendingIn = false;
            this.m_transitionIn.m_blendingOut = true;
        }
        if (this.m_transitionIn.m_time >= f7 - (f5 = this.getTransitionInBlendOutTime() * f6)) {
            this.m_transitionIn.m_blendingIn = false;
            this.m_transitionIn.m_blendingOut = true;
        }
        if (this.m_transitionIn.m_blendingIn) {
            f4 = this.getTransitionInBlendInTime() * f6;
            f3 = this.incrementBlendTime(this.m_transitionIn.m_rawWeight, f4, f * f6);
            this.m_transitionIn.m_rawWeight = f2 = PZMath.clamp(f3 / f4, 0.0f, 1.0f);
            this.m_transitionIn.m_weight = PZMath.lerpFunc_EaseOutInQuad(f2);
            this.m_transitionIn.m_blendingIn = f3 < f4;
            boolean bl2 = this.m_transitionIn.m_active = f3 < f7;
        }
        if (this.m_transitionIn.m_blendingOut) {
            f4 = this.getTransitionInBlendOutTime() * f6;
            f3 = this.incrementBlendTime(1.0f - this.m_transitionIn.m_rawWeight, f4, f * f6);
            this.m_transitionIn.m_rawWeight = f2 = PZMath.clamp(1.0f - f3 / f4, 0.0f, 1.0f);
            this.m_transitionIn.m_weight = PZMath.lerpFunc_EaseOutInQuad(f2);
            this.m_transitionIn.m_active = this.m_transitionIn.m_blendingOut = f3 < f4;
        }
    }

    public void addMainTrack(AnimationTrack animationTrack) {
        float f;
        if (!this.isLooped() && !this.m_sourceNode.m_StopAnimOnExit && this.m_sourceNode.m_EarlyTransitionOut && (f = this.getBlendOutTime()) > 0.0f && Float.isFinite(f)) {
            animationTrack.earlyBlendOutTime = f;
            animationTrack.triggerOnNonLoopedAnimFadeOutEvent = true;
        }
        this.m_AnimationTracks.add(animationTrack);
    }

    private void setMainTracksPlaying(boolean bl2) {
        Lambda.forEachFrom(PZArrayUtil::forEach, this.m_AnimationTracks, Boolean.valueOf(bl2), (animationTrack, bl) -> {
            animationTrack.IsPlaying = bl;
        });
    }

    private void updateBlendingIn(float f) {
        float f2;
        float f3 = this.getBlendInTime();
        if (f3 <= 0.0f) {
            this.m_Weight = 1.0f;
            this.m_RawWeight = 1.0f;
            this.m_blendingIn = false;
            return;
        }
        float f4 = this.incrementBlendTime(this.m_RawWeight, f3, f);
        this.m_RawWeight = f2 = PZMath.clamp(f4 / f3, 0.0f, 1.0f);
        this.m_Weight = PZMath.lerpFunc_EaseOutInQuad(f2);
        this.m_blendingIn = f4 < f3;
    }

    private void updateBlendingOut(float f) {
        float f2;
        float f3 = this.getBlendOutTime();
        if (f3 <= 0.0f) {
            this.m_Weight = 0.0f;
            this.m_RawWeight = 0.0f;
            this.m_blendingOut = false;
            return;
        }
        float f4 = this.incrementBlendTime(1.0f - this.m_RawWeight, f3, f);
        this.m_RawWeight = f2 = PZMath.clamp(1.0f - f4 / f3, 0.0f, 1.0f);
        this.m_Weight = PZMath.lerpFunc_EaseOutInQuad(f2);
        this.m_blendingOut = f4 < f3;
    }

    private float incrementBlendTime(float f, float f2, float f3) {
        float f4 = f * f2;
        return f4 + f3;
    }

    public float getTransitionInBlendInTime() {
        if (this.m_transitionIn.m_data != null && this.m_transitionIn.m_data.m_blendInTime != Float.POSITIVE_INFINITY) {
            return this.m_transitionIn.m_data.m_blendInTime;
        }
        return 0.0f;
    }

    public float getMainInitialRewindTime() {
        float f;
        float f2 = 0.0f;
        if (this.m_sourceNode.m_randomAdvanceFraction > 0.0f) {
            f = Rand.Next(0.0f, this.m_sourceNode.m_randomAdvanceFraction);
            f2 = f * this.getMaxDuration();
        }
        if (this.m_transitionIn.m_data == null) {
            return 0.0f - f2;
        }
        f = this.getTransitionInBlendOutTime();
        float f3 = this.m_transitionIn.m_data.m_SyncAdjustTime;
        if (this.m_transitionIn.m_track != null) {
            return f - f3;
        }
        return f - f3 - f2;
    }

    private float getMaxDuration() {
        float f = 0.0f;
        int n = this.m_AnimationTracks.size();
        for (int i = 0; i < n; ++i) {
            AnimationTrack animationTrack = this.m_AnimationTracks.get(i);
            float f2 = animationTrack.getDuration();
            f = PZMath.max(f2, f);
        }
        return f;
    }

    public float getTransitionInBlendOutTime() {
        return this.getBlendInTime();
    }

    public float getBlendInTime() {
        if (this.m_transitionIn.m_data == null) {
            return this.m_sourceNode.m_BlendTime;
        }
        if (this.m_transitionIn.m_track != null && this.m_transitionIn.m_data.m_blendOutTime != Float.POSITIVE_INFINITY) {
            return this.m_transitionIn.m_data.m_blendOutTime;
        }
        if (this.m_transitionIn.m_track == null) {
            if (this.m_transitionIn.m_data.m_blendInTime != Float.POSITIVE_INFINITY) {
                return this.m_transitionIn.m_data.m_blendInTime;
            }
            if (this.m_transitionIn.m_data.m_blendOutTime != Float.POSITIVE_INFINITY) {
                return this.m_transitionIn.m_data.m_blendOutTime;
            }
        }
        return this.m_sourceNode.m_BlendTime;
    }

    public float getBlendOutTime() {
        if (this.m_transitionOut == null) {
            return this.m_sourceNode.getBlendOutTime();
        }
        if (!StringUtils.isNullOrWhitespace(this.m_transitionOut.m_AnimName) && this.m_transitionOut.m_blendInTime != Float.POSITIVE_INFINITY) {
            return this.m_transitionOut.m_blendInTime;
        }
        if (StringUtils.isNullOrWhitespace(this.m_transitionOut.m_AnimName)) {
            if (this.m_transitionOut.m_blendOutTime != Float.POSITIVE_INFINITY) {
                return this.m_transitionOut.m_blendOutTime;
            }
            if (this.m_transitionOut.m_blendInTime != Float.POSITIVE_INFINITY) {
                return this.m_transitionOut.m_blendInTime;
            }
        }
        return this.m_sourceNode.getBlendOutTime();
    }

    @Override
    public void onAnimStarted(AnimationTrack animationTrack) {
        this.invokeAnimStartTimeEvent();
    }

    @Override
    public void onLoopedAnim(AnimationTrack animationTrack) {
        if (this.m_TransitioningOut) {
            return;
        }
        this.invokeAnimEndTimeEvent();
    }

    @Override
    public void onNonLoopedAnimFadeOut(AnimationTrack animationTrack) {
        if (!DebugOptions.instance.Animation.AllowEarlyTransitionOut.getValue()) {
            return;
        }
        this.invokeAnimEndTimeEvent();
        this.m_TransitioningOut = true;
    }

    @Override
    public void onNonLoopedAnimFinished(AnimationTrack animationTrack) {
        if (this.m_TransitioningOut) {
            return;
        }
        this.invokeAnimEndTimeEvent();
    }

    @Override
    public void onTrackDestroyed(AnimationTrack animationTrack) {
        this.m_AnimationTracks.remove(animationTrack);
        if (this.m_transitionIn.m_track == animationTrack) {
            this.m_transitionIn.m_track = null;
            this.m_transitionIn.m_active = false;
            this.m_transitionIn.m_weight = 0.0f;
            this.setMainTracksPlaying(true);
        }
    }

    private void invokeAnimStartTimeEvent() {
        this.invokeAnimTimeEvent(AnimEvent.AnimEventTime.Start);
    }

    private void invokeAnimEndTimeEvent() {
        this.invokeAnimTimeEvent(AnimEvent.AnimEventTime.End);
    }

    private void invokeAnimTimeEvent(AnimEvent.AnimEventTime animEventTime) {
        List<AnimEvent> list = this.getSourceNode().m_Events;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AnimEvent animEvent = list.get(i);
            if (animEvent.m_Time != animEventTime) continue;
            this.m_animLayer.invokeAnimEvent(animEvent);
        }
    }

    public AnimNode getSourceNode() {
        return this.m_sourceNode;
    }

    public boolean isIdleAnimActive() {
        return this.m_active && this.m_sourceNode.isIdleAnim();
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean bl) {
        this.m_active = bl;
    }

    public boolean isLooped() {
        return this.m_sourceNode.m_Looped;
    }

    public float getWeight() {
        return this.m_Weight;
    }

    public float getTransitionInWeight() {
        return this.m_transitionIn.m_weight;
    }

    public boolean wasActivated() {
        return this.m_active != this.m_wasActive && this.m_active;
    }

    public boolean wasDeactivated() {
        return this.m_active != this.m_wasActive && this.m_wasActive;
    }

    public boolean isNew() {
        return this.m_isNew;
    }

    public int getPlayingTrackCount() {
        int n = 0;
        if (this.isMainAnimActive()) {
            n += this.m_AnimationTracks.size();
        }
        if (this.isTransitioningIn()) {
            ++n;
        }
        return n;
    }

    public boolean isMainAnimActive() {
        return !this.isTransitioningIn() || this.m_transitionIn.m_blendingOut;
    }

    public AnimationTrack getPlayingTrackAt(int n) {
        int n2 = this.getPlayingTrackCount();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("TrackIdx out of bounds 0 - " + this.getPlayingTrackCount());
        }
        if (this.isTransitioningIn() && n == n2 - 1) {
            return this.m_transitionIn.m_track;
        }
        return this.m_AnimationTracks.get(n);
    }

    public String getTransitionFrom() {
        return this.m_transitionIn.m_transitionedFrom;
    }

    public void setTransitionInBlendDelta(float f) {
        if (this.m_transitionIn.m_track != null) {
            this.m_transitionIn.m_track.BlendDelta = f;
        }
    }

    public AnimationTrack getTransitionInTrack() {
        return this.m_transitionIn.m_track;
    }

    public int getTransitionLayerIdx() {
        return this.m_transitionIn.m_track != null ? this.m_transitionIn.m_track.getLayerIdx() : -1;
    }

    public int getLayerIdx() {
        return this.m_layerIdx;
    }

    public int getPriority() {
        return this.m_sourceNode.getPriority();
    }

    public String getDeferredBoneName() {
        return this.m_sourceNode.getDeferredBoneName();
    }

    public BoneAxis getDeferredBoneAxis() {
        return this.m_sourceNode.getDeferredBoneAxis();
    }

    public List<AnimBoneWeight> getSubStateBoneWeights() {
        return this.m_sourceNode.m_SubStateBoneWeights;
    }

    public AnimTransition findTransitionTo(IAnimationVariableSource iAnimationVariableSource, String string) {
        return this.m_sourceNode.findTransitionTo(iAnimationVariableSource, string);
    }

    public float getSpeedScale(IAnimationVariableSource iAnimationVariableSource) {
        return this.m_sourceNode.getSpeedScale(iAnimationVariableSource);
    }

    private static class TransitionIn {
        private float m_time;
        private String m_transitionedFrom;
        private boolean m_active;
        private AnimationTrack m_track;
        private AnimTransition m_data;
        private float m_weight;
        private float m_rawWeight;
        private boolean m_blendingIn;
        private boolean m_blendingOut;

        private TransitionIn() {
        }

        private void reset() {
            this.m_time = 0.0f;
            this.m_transitionedFrom = null;
            this.m_active = false;
            this.m_track = null;
            this.m_data = null;
            this.m_weight = 0.0f;
            this.m_rawWeight = 0.0f;
            this.m_blendingIn = false;
            this.m_blendingOut = false;
        }
    }
}

