/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import zombie.core.skinnedmodel.advancedanimation.BlendType;

public class BlendInfo {
    public String name;
    public BlendType Type;
    public String mulDec;
    public String mulInc;
    public float dec;
    public float inc;

    public static class BlendInstance {
        public float current = -1.0f;
        public float target;
        BlendInfo info;

        public String GetDebug() {
            String string = "Blend: " + this.info.name;
            switch (this.info.Type) {
                case Linear: {
                    string = string + ", Linear ";
                    break;
                }
                case InverseExponential: {
                    string = string + ", InverseExponential ";
                }
            }
            string = string + ", Current " + this.current;
            return string;
        }

        public BlendInstance(BlendInfo blendInfo) {
            this.info = blendInfo;
        }

        public void set(float f) {
            this.target = f;
            if (this.current == -1.0f) {
                this.current = this.target;
            }
        }

        public void update() {
            float f = 0.0f;
            if (this.current < this.target) {
                float f2 = 1.0f;
                switch (this.info.Type) {
                    case Linear: {
                        break;
                    }
                    case InverseExponential: {
                        f2 = this.current / 1.0f;
                        f2 = 1.0f - f2;
                        if (!(f2 < 0.1f)) break;
                        f2 = 0.1f;
                    }
                }
                f = this.info.inc * f2;
                this.current += f;
                if (this.current > this.target) {
                    this.current = this.target;
                }
            } else if (this.current > this.target) {
                float f3 = 1.0f;
                switch (this.info.Type) {
                    case Linear: {
                        break;
                    }
                    case InverseExponential: {
                        f3 = this.current / 1.0f;
                        f3 = 1.0f - f3;
                        if (!(f3 < 0.1f)) break;
                        f3 = 0.1f;
                    }
                }
                f = -this.info.dec * f3;
                this.current += f;
                if (this.current < this.target) {
                    this.current = this.target;
                }
            }
        }
    }
}

