/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlot;
import zombie.debug.DebugLog;

public abstract class AnimationVariableSlotCallback<VariableType>
extends AnimationVariableSlot {
    private final CallbackGet<VariableType> m_callbackGet;
    private final CallbackSet<VariableType> m_callbackSet;

    protected AnimationVariableSlotCallback(String string, CallbackGet<VariableType> callbackGet) {
        this(string, callbackGet, null);
    }

    protected AnimationVariableSlotCallback(String string, CallbackGet<VariableType> callbackGet, CallbackSet<VariableType> callbackSet) {
        super(string);
        this.m_callbackGet = callbackGet;
        this.m_callbackSet = callbackSet;
    }

    public VariableType getValue() {
        return this.m_callbackGet.call();
    }

    public abstract VariableType getDefaultValue();

    public boolean trySetValue(VariableType VariableType) {
        if (this.isReadOnly()) {
            DebugLog.General.warn("Trying to set read-only variable \"%s\"", super.getKey());
            return false;
        }
        this.m_callbackSet.call(VariableType);
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_callbackSet == null;
    }

    @Override
    public void clear() {
        if (!this.isReadOnly()) {
            this.trySetValue(this.getDefaultValue());
        }
    }

    public static interface CallbackGet<VariableType> {
        public VariableType call();
    }

    public static interface CallbackSet<VariableType> {
        public void call(VariableType var1);
    }
}

