/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotBool;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotFloat;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotString;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableType;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.debug.DebugLog;

public final class AnimationVariableGenericSlot
extends AnimationVariableSlot {
    private AnimationVariableType m_type = AnimationVariableType.Void;
    private IAnimationVariableSlot m_valueSlot;

    public AnimationVariableGenericSlot(String string) {
        super(string);
    }

    @Override
    public String getValueString() {
        return this.m_valueSlot != null ? this.m_valueSlot.getValueString() : null;
    }

    @Override
    public float getValueFloat() {
        return this.m_valueSlot != null ? this.m_valueSlot.getValueFloat() : 0.0f;
    }

    @Override
    public boolean getValueBool() {
        return this.m_valueSlot != null && this.m_valueSlot.getValueBool();
    }

    @Override
    public void setValue(String string) {
        if (this.m_valueSlot == null || !this.m_valueSlot.canConvertFrom(string)) {
            this.m_valueSlot = new AnimationVariableSlotString(this.getKey());
            this.setType(this.m_valueSlot.getType());
        }
        this.m_valueSlot.setValue(string);
    }

    @Override
    public void setValue(float f) {
        if (this.m_valueSlot == null || this.m_type != AnimationVariableType.Float) {
            this.m_valueSlot = new AnimationVariableSlotFloat(this.getKey());
            this.setType(this.m_valueSlot.getType());
        }
        this.m_valueSlot.setValue(f);
    }

    @Override
    public void setValue(boolean bl) {
        if (this.m_valueSlot == null || this.m_type != AnimationVariableType.Boolean) {
            this.m_valueSlot = new AnimationVariableSlotBool(this.getKey());
            this.setType(this.m_valueSlot.getType());
        }
        this.m_valueSlot.setValue(bl);
    }

    @Override
    public AnimationVariableType getType() {
        return this.m_type;
    }

    private void setType(AnimationVariableType animationVariableType) {
        if (this.m_type == animationVariableType) {
            return;
        }
        if (this.m_type != AnimationVariableType.Void) {
            DebugLog.General.printf("Variable %s converting from %s to %s\n", new Object[]{this.getKey(), this.m_type, animationVariableType});
        }
        this.m_type = animationVariableType;
    }

    @Override
    public boolean canConvertFrom(String string) {
        return true;
    }

    @Override
    public void clear() {
        this.m_type = AnimationVariableType.Void;
        this.m_valueSlot = null;
    }
}

