/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.joml.Math;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjglx.BufferUtils;
import zombie.GameProfiler;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.characters.AttachedItems.AttachedModelName;
import zombie.characters.AttachedItems.AttachedModelNames;
import zombie.characters.IsoGameCharacter;
import zombie.characters.SurvivorDesc;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.action.ActionContext;
import zombie.characters.action.ActionGroup;
import zombie.characters.action.IActionStateChanged;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.ImmutableColor;
import zombie.core.SpriteRenderer;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AdvancedAnimator;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimLayer;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSource;
import zombie.core.skinnedmodel.advancedanimation.IAnimEventCallback;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.core.skinnedmodel.model.CharacterMask;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceRenderData;
import zombie.core.skinnedmodel.model.ModelInstanceTextureCreator;
import zombie.core.skinnedmodel.model.ModelInstanceTextureInitializer;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.VehicleModelInstance;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.core.skinnedmodel.population.BeardStyle;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.HairStyle;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.PopTemplateManager;
import zombie.core.skinnedmodel.shader.Shader;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.iso.IsoGridSquare;
import zombie.iso.Vector2;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.ModelScript;
import zombie.ui.UIManager;
import zombie.util.Lambda;
import zombie.util.Pool;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;

public final class AnimatedModel
extends AnimationVariableSource
implements IAnimatable,
IAnimEventCallback,
IActionStateChanged,
IHumanVisual {
    private String animSetName = "player-avatar";
    private String outfitName;
    private IsoGameCharacter character;
    private HumanVisual baseVisual = null;
    private final ItemVisuals itemVisuals = new ItemVisuals();
    private String primaryHandModelName;
    private String secondaryHandModelName;
    private final AttachedModelNames attachedModelNames = new AttachedModelNames();
    private ModelInstance modelInstance;
    private boolean bFemale = false;
    private boolean bZombie = false;
    private boolean bSkeleton = false;
    private String state;
    private final Vector2 angle = new Vector2();
    private final Vector3f offset = new Vector3f(0.0f, -0.45f, 0.0f);
    private boolean bIsometric = true;
    private boolean flipY = false;
    private float m_alpha = 1.0f;
    private AnimationPlayer animPlayer = null;
    private final ActionContext actionContext = new ActionContext(this);
    private final AdvancedAnimator advancedAnimator = new AdvancedAnimator();
    private float trackTime = 0.0f;
    private final String m_UID;
    private float lightsOriginX;
    private float lightsOriginY;
    private float lightsOriginZ;
    private final IsoGridSquare.ResultLight[] lights = new IsoGridSquare.ResultLight[5];
    private final ColorInfo ambient = new ColorInfo();
    private boolean bOutside = true;
    private boolean bRoom = false;
    private boolean bUpdateTextures;
    private boolean bClothingChanged;
    private boolean bAnimate = true;
    private ModelInstanceTextureCreator textureCreator;
    private final StateInfo[] stateInfos = new StateInfo[3];
    private boolean bReady;
    private static final ObjectPool<AnimatedModelInstanceRenderData> instDataPool = new ObjectPool<AnimatedModelInstanceRenderData>(AnimatedModelInstanceRenderData::new);
    private final UIModelCamera uiModelCamera = new UIModelCamera();
    private static final WorldModelCamera worldModelCamera = new WorldModelCamera();

    public AnimatedModel() {
        int n;
        this.m_UID = String.format("%s-%s", this.getClass().getSimpleName(), UUID.randomUUID().toString());
        this.advancedAnimator.init(this);
        this.advancedAnimator.animCallbackHandlers.add(this);
        this.actionContext.onStateChanged.add(this);
        for (n = 0; n < this.lights.length; ++n) {
            this.lights[n] = new IsoGridSquare.ResultLight();
        }
        for (n = 0; n < this.stateInfos.length; ++n) {
            this.stateInfos[n] = new StateInfo();
        }
    }

    public void setVisual(HumanVisual humanVisual) {
        this.baseVisual = humanVisual;
    }

    public BaseVisual getVisual() {
        return this.baseVisual;
    }

    @Override
    public HumanVisual getHumanVisual() {
        return Type.tryCastTo(this.baseVisual, HumanVisual.class);
    }

    @Override
    public void getItemVisuals(ItemVisuals itemVisuals) {
        itemVisuals.clear();
    }

    @Override
    public boolean isFemale() {
        return this.bFemale;
    }

    @Override
    public boolean isZombie() {
        return this.bZombie;
    }

    @Override
    public boolean isSkeleton() {
        return this.bSkeleton;
    }

    public void setAnimSetName(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("invalid AnimSet \"" + string + "\"");
        }
        this.animSetName = string;
    }

    public void setOutfitName(String string, boolean bl, boolean bl2) {
        this.outfitName = string;
        this.bFemale = bl;
        this.bZombie = bl2;
    }

    public void setCharacter(IsoGameCharacter isoGameCharacter) {
        this.outfitName = null;
        if (this.baseVisual != null) {
            this.baseVisual.clear();
        }
        this.itemVisuals.clear();
        if (!(isoGameCharacter instanceof IHumanVisual)) {
            return;
        }
        isoGameCharacter.getItemVisuals(this.itemVisuals);
        this.character = isoGameCharacter;
        if (isoGameCharacter.getAttachedItems() != null) {
            this.attachedModelNames.initFrom(isoGameCharacter.getAttachedItems());
        }
        this.setModelData(((IHumanVisual)((Object)isoGameCharacter)).getHumanVisual(), this.itemVisuals);
    }

    public void setSurvivorDesc(SurvivorDesc survivorDesc) {
        this.outfitName = null;
        if (this.baseVisual != null) {
            this.baseVisual.clear();
        }
        this.itemVisuals.clear();
        survivorDesc.getWornItems().getItemVisuals(this.itemVisuals);
        this.attachedModelNames.clear();
        this.setModelData(survivorDesc.getHumanVisual(), this.itemVisuals);
    }

    public void setPrimaryHandModelName(String string) {
        this.primaryHandModelName = string;
    }

    public void setSecondaryHandModelName(String string) {
        this.secondaryHandModelName = string;
    }

    public void setAttachedModelNames(AttachedModelNames attachedModelNames) {
        this.attachedModelNames.copyFrom(attachedModelNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelData(HumanVisual humanVisual, ItemVisuals itemVisuals) {
        Object object;
        Model model;
        AnimationPlayer animationPlayer = this.animPlayer;
        Model model2 = model = this.animPlayer == null ? null : animationPlayer.getModel();
        if (this.baseVisual != humanVisual) {
            if (this.baseVisual == null) {
                this.baseVisual = new HumanVisual(this);
            }
            this.baseVisual.copyFrom(humanVisual);
        }
        if (this.itemVisuals != itemVisuals) {
            this.itemVisuals.clear();
            this.itemVisuals.addAll(itemVisuals);
        }
        if (this.baseVisual != humanVisual) {
            this.bFemale = false;
            this.bZombie = false;
            this.bSkeleton = false;
            if (humanVisual != null) {
                this.bFemale = humanVisual.isFemale();
                this.bZombie = humanVisual.isZombie();
                this.bSkeleton = humanVisual.isSkeleton();
            }
        }
        if (this.modelInstance != null) {
            ModelManager.instance.resetModelInstanceRecurse(this.modelInstance, this);
        }
        Model model3 = humanVisual.getModel();
        this.getAnimationPlayer().setModel(model3);
        this.modelInstance = ModelManager.instance.newInstance(model3, null, this.getAnimationPlayer());
        this.modelInstance.m_modelScript = humanVisual.getModelScript();
        this.modelInstance.setOwner(this);
        this.populateCharacterModelSlot();
        this.DoCharacterModelEquipped();
        boolean bl = false;
        if (this.bAnimate) {
            object = AnimationSet.GetAnimationSet(this.GetAnimSetName(), false);
            if (object != this.advancedAnimator.animSet || animationPlayer != this.getAnimationPlayer() || model != model3) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.advancedAnimator.OnAnimDataChanged(false);
        }
        if (this.bAnimate) {
            object = ActionGroup.getActionGroup(this.GetAnimSetName());
            if (object != this.actionContext.getGroup()) {
                this.actionContext.setGroup((ActionGroup)object);
            }
            this.advancedAnimator.SetState(this.actionContext.getCurrentStateName(), PZArrayUtil.listConvert(this.actionContext.getChildStates(), actionState -> actionState.name));
        } else if (!StringUtils.isNullOrWhitespace(this.state)) {
            this.advancedAnimator.SetState(this.state);
        }
        if (bl) {
            float f = GameTime.getInstance().FPSMultiplier;
            GameTime.getInstance().FPSMultiplier = 100.0f;
            try {
                this.advancedAnimator.update();
            }
            finally {
                GameTime.getInstance().FPSMultiplier = f;
            }
        }
        if (Core.bDebug && !this.bAnimate && this.stateInfoMain().readyData.isEmpty()) {
            this.getAnimationPlayer().resetBoneModelTransforms();
        }
        this.trackTime = 0.0f;
        this.stateInfoMain().bModelsReady = this.isReadyToRender();
    }

    public void setAmbient(ColorInfo colorInfo, boolean bl, boolean bl2) {
        this.ambient.set(colorInfo.r, colorInfo.g, colorInfo.b, 1.0f);
        this.bOutside = bl;
        this.bRoom = bl2;
    }

    public void setLights(IsoGridSquare.ResultLight[] resultLightArray, float f, float f2, float f3) {
        this.lightsOriginX = f;
        this.lightsOriginY = f2;
        this.lightsOriginZ = f3;
        for (int i = 0; i < resultLightArray.length; ++i) {
            this.lights[i].copyFrom(resultLightArray[i]);
        }
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getState() {
        return this.state;
    }

    public void setAngle(Vector2 vector22) {
        this.angle.set(vector22);
    }

    public void setOffset(float f, float f2, float f3) {
        this.offset.set(f, f2, f3);
    }

    public void setIsometric(boolean bl) {
        this.bIsometric = bl;
    }

    public boolean isIsometric() {
        return this.bIsometric;
    }

    public void setFlipY(boolean bl) {
        this.flipY = bl;
    }

    public void setAlpha(float f) {
        this.m_alpha = f;
    }

    public void setTrackTime(float f) {
        this.trackTime = f;
    }

    public void clothingItemChanged(String string) {
        this.bClothingChanged = true;
    }

    public void setAnimate(boolean bl) {
        this.bAnimate = bl;
    }

    private void initOutfit() {
        String string = this.outfitName;
        this.outfitName = null;
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        ModelManager.instance.create();
        this.baseVisual.dressInNamedOutfit(string, this.itemVisuals);
        this.setModelData(this.baseVisual, this.itemVisuals);
    }

    private void populateCharacterModelSlot() {
        ClothingItem clothingItem;
        ItemVisual itemVisual;
        int n;
        HumanVisual humanVisual = this.getHumanVisual();
        if (humanVisual == null) {
            this.bUpdateTextures = true;
            return;
        }
        CharacterMask characterMask = HumanVisual.GetMask(this.itemVisuals);
        if (characterMask.isPartVisible(CharacterMask.Part.Head)) {
            this.addHeadHair(this.itemVisuals.findHat());
        }
        for (n = this.itemVisuals.size() - 1; n >= 0; --n) {
            itemVisual = (ItemVisual)this.itemVisuals.get(n);
            clothingItem = itemVisual.getClothingItem();
            if (clothingItem == null || !clothingItem.isReady() || this.isItemModelHidden(this.itemVisuals, itemVisual)) continue;
            this.addClothingItem(itemVisual, clothingItem);
        }
        for (n = humanVisual.getBodyVisuals().size() - 1; n >= 0; --n) {
            itemVisual = (ItemVisual)humanVisual.getBodyVisuals().get(n);
            clothingItem = itemVisual.getClothingItem();
            if (clothingItem == null || !clothingItem.isReady()) continue;
            this.addClothingItem(itemVisual, clothingItem);
        }
        this.bUpdateTextures = true;
        Lambda.forEachFrom(PZArrayUtil::forEach, this.modelInstance.sub, this.modelInstance, (modelInstance, modelInstance2) -> {
            modelInstance.AnimPlayer = modelInstance2.AnimPlayer;
        });
    }

    private void addHeadHair(ItemVisual itemVisual) {
        HumanVisual humanVisual = this.getHumanVisual();
        ImmutableColor immutableColor = humanVisual.getHairColor();
        ImmutableColor immutableColor2 = humanVisual.getBeardColor();
        if (this.isFemale()) {
            HairStyle hairStyle = HairStyles.instance.FindFemaleStyle(humanVisual.getHairModel());
            if (hairStyle != null && itemVisual != null && itemVisual.getClothingItem() != null) {
                hairStyle = HairStyles.instance.getAlternateForHat(hairStyle, itemVisual.getClothingItem().m_HatCategory);
            }
            if (hairStyle != null && hairStyle.isValid()) {
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.debugln("  Adding female hair: " + hairStyle.name);
                }
                this.addHeadHairItem(hairStyle.model, hairStyle.texture, immutableColor);
            }
        } else {
            BeardStyle beardStyle;
            HairStyle hairStyle = HairStyles.instance.FindMaleStyle(humanVisual.getHairModel());
            if (hairStyle != null && itemVisual != null && itemVisual.getClothingItem() != null) {
                hairStyle = HairStyles.instance.getAlternateForHat(hairStyle, itemVisual.getClothingItem().m_HatCategory);
            }
            if (hairStyle != null && hairStyle.isValid()) {
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.debugln("  Adding male hair: " + hairStyle.name);
                }
                this.addHeadHairItem(hairStyle.model, hairStyle.texture, immutableColor);
            }
            if ((beardStyle = BeardStyles.instance.FindStyle(humanVisual.getBeardModel())) != null && beardStyle.isValid()) {
                if (itemVisual != null && itemVisual.getClothingItem() != null && !StringUtils.isNullOrEmpty(itemVisual.getClothingItem().m_HatCategory) && itemVisual.getClothingItem().m_HatCategory.contains("nobeard")) {
                    return;
                }
                if (DebugLog.isEnabled(DebugType.Clothing)) {
                    DebugLog.Clothing.debugln("  Adding beard: " + beardStyle.name);
                }
                this.addHeadHairItem(beardStyle.model, beardStyle.texture, immutableColor2);
            }
        }
    }

    private void addHeadHairItem(String string, String string2, ImmutableColor immutableColor) {
        if (StringUtils.isNullOrWhitespace(string)) {
            if (DebugLog.isEnabled(DebugType.Clothing)) {
                DebugLog.Clothing.warn("No model specified.");
            }
            return;
        }
        ModelInstance modelInstance = ModelManager.instance.newAdditionalModelInstance(string = this.processModelFileName(string), string2, null, this.modelInstance.AnimPlayer, null);
        if (modelInstance == null) {
            return;
        }
        this.postProcessNewItemInstance(this.modelInstance, modelInstance, immutableColor);
    }

    private void addClothingItem(ItemVisual itemVisual, ClothingItem clothingItem) {
        String string = clothingItem.getModel(this.bFemale);
        if (StringUtils.isNullOrWhitespace(string)) {
            if (DebugLog.isEnabled(DebugType.Clothing)) {
                DebugLog.Clothing.debugln("No model specified by item: " + clothingItem.m_Name);
            }
            return;
        }
        string = this.processModelFileName(string);
        String string2 = itemVisual.getTextureChoice(clothingItem);
        ImmutableColor immutableColor = itemVisual.getTint(clothingItem);
        String string3 = clothingItem.m_AttachBone;
        String string4 = clothingItem.m_Shader;
        ModelInstance modelInstance = string3 != null && string3.length() > 0 ? this.addStatic(string, string2, string3, string4) : ModelManager.instance.newAdditionalModelInstance(string, string2, null, this.modelInstance.AnimPlayer, string4);
        if (modelInstance == null) {
            return;
        }
        this.postProcessNewItemInstance(this.modelInstance, modelInstance, immutableColor);
        modelInstance.setItemVisual(itemVisual);
    }

    private boolean isItemModelHidden(ItemVisuals itemVisuals, ItemVisual itemVisual) {
        BodyLocationGroup bodyLocationGroup = BodyLocations.getGroup("Human");
        return PopTemplateManager.instance.isItemModelHidden(bodyLocationGroup, itemVisuals, itemVisual);
    }

    private String processModelFileName(String string) {
        string = string.replaceAll("\\\\", "/");
        string = string.toLowerCase(Locale.ENGLISH);
        return string;
    }

    private void postProcessNewItemInstance(ModelInstance modelInstance, ModelInstance modelInstance2, ImmutableColor immutableColor) {
        modelInstance2.depthBias = 0.0f;
        modelInstance2.matrixModel = this.modelInstance;
        modelInstance2.tintR = immutableColor.r;
        modelInstance2.tintG = immutableColor.g;
        modelInstance2.tintB = immutableColor.b;
        modelInstance2.AnimPlayer = this.modelInstance.AnimPlayer;
        modelInstance.sub.add(modelInstance2);
        modelInstance2.setOwner(this);
    }

    private void DoCharacterModelEquipped() {
        ModelInstance modelInstance;
        if (!StringUtils.isNullOrWhitespace(this.primaryHandModelName)) {
            modelInstance = this.addStatic(this.primaryHandModelName, "Bip01_Prop1");
            this.postProcessNewItemInstance(this.modelInstance, modelInstance, ImmutableColor.white);
        }
        if (!StringUtils.isNullOrWhitespace(this.secondaryHandModelName)) {
            modelInstance = this.addStatic(this.secondaryHandModelName, "Bip01_Prop2");
            this.postProcessNewItemInstance(this.modelInstance, modelInstance, ImmutableColor.white);
        }
        for (int i = 0; i < this.attachedModelNames.size(); ++i) {
            AttachedModelName attachedModelName = this.attachedModelNames.get(i);
            ModelInstance modelInstance2 = ModelManager.instance.addStatic(null, attachedModelName.modelName, attachedModelName.attachmentNameSelf, attachedModelName.attachmentNameParent);
            this.postProcessNewItemInstance(this.modelInstance, modelInstance2, ImmutableColor.white);
            if (attachedModelName.bloodLevel > 0.0f && !Core.getInstance().getOptionSimpleWeaponTextures()) {
                ModelInstanceTextureInitializer modelInstanceTextureInitializer = ModelInstanceTextureInitializer.alloc();
                modelInstanceTextureInitializer.init(modelInstance2, attachedModelName.bloodLevel);
                modelInstance2.setTextureInitializer(modelInstanceTextureInitializer);
            }
            for (int j = 0; j < attachedModelName.getChildCount(); ++j) {
                AttachedModelName attachedModelName2 = attachedModelName.getChildByIndex(j);
                ModelInstance modelInstance3 = ModelManager.instance.addStatic(modelInstance2, attachedModelName2.modelName, attachedModelName2.attachmentNameSelf, attachedModelName2.attachmentNameParent);
                modelInstance2.sub.remove(modelInstance3);
                this.postProcessNewItemInstance(modelInstance2, modelInstance3, ImmutableColor.white);
            }
        }
    }

    private ModelInstance addStatic(String string, String string2) {
        String string3 = string;
        String string4 = string;
        String string5 = null;
        ModelScript modelScript = ScriptManager.instance.getModelScript(string);
        if (modelScript != null) {
            string3 = modelScript.getMeshName();
            string4 = modelScript.getTextureName();
            string5 = modelScript.getShaderName();
        }
        return this.addStatic(string3, string4, string2, string5);
    }

    private ModelInstance addStatic(String string, String string2, String string3, String string4) {
        Model model;
        if (DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.debugln("Adding Static Model:" + string);
        }
        if ((model = ModelManager.instance.tryGetLoadedModel(string, string2, true, string4, false)) == null) {
            ModelManager.instance.loadStaticModel(string.toLowerCase(), string2, string4);
            model = ModelManager.instance.getLoadedModel(string, string2, true, string4);
            if (model == null) {
                DebugLog.General.error("ModelManager.addStatic> Model not found. model:" + string + " tex:" + string2);
                return null;
            }
        }
        ModelInstance modelInstance = ModelManager.instance.newInstance(model, null, this.modelInstance.AnimPlayer);
        modelInstance.parent = this.modelInstance;
        if (this.modelInstance.AnimPlayer != null) {
            modelInstance.parentBone = this.modelInstance.AnimPlayer.getSkinningBoneIndex(string3, modelInstance.parentBone);
            modelInstance.parentBoneName = string3;
        }
        return modelInstance;
    }

    private StateInfo stateInfoMain() {
        int n = SpriteRenderer.instance.getMainStateIndex();
        return this.stateInfos[n];
    }

    private StateInfo stateInfoRender() {
        int n = SpriteRenderer.instance.getRenderStateIndex();
        return this.stateInfos[n];
    }

    public void update() {
        GameProfiler.getInstance().invokeAndMeasure("AnimatedModel.Update", this, AnimatedModel::updateInternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternal() {
        this.initOutfit();
        if (this.bClothingChanged) {
            this.bClothingChanged = false;
            this.setModelData(this.baseVisual, this.itemVisuals);
        }
        this.modelInstance.SetForceDir(this.angle);
        GameTime gameTime = GameTime.getInstance();
        float f = gameTime.FPSMultiplier;
        if (this.bAnimate) {
            ModelInstance modelInstance;
            if (UIManager.useUIFBO) {
                gameTime.FPSMultiplier *= GameWindow.averageFPS / (float)Core.OptionUIRenderFPS;
            }
            this.actionContext.update();
            this.advancedAnimator.update();
            this.animPlayer.Update();
            int n = SpriteRenderer.instance.getMainStateIndex();
            StateInfo stateInfo = this.stateInfos[n];
            if (!stateInfo.readyData.isEmpty() && (modelInstance = stateInfo.readyData.get((int)0).modelInstance) != this.modelInstance && modelInstance.AnimPlayer != this.modelInstance.AnimPlayer) {
                modelInstance.Update();
            }
            gameTime.FPSMultiplier = f;
        } else {
            gameTime.FPSMultiplier = 100.0f;
            try {
                this.advancedAnimator.update();
            }
            finally {
                gameTime.FPSMultiplier = f;
            }
            if (this.trackTime > 0.0f && this.animPlayer.getMultiTrack().getTrackCount() > 0) {
                this.animPlayer.getMultiTrack().getTracks().get(0).setCurrentTimeValue(this.trackTime);
            }
            this.animPlayer.Update(0.0f);
        }
    }

    private boolean isModelInstanceReady(ModelInstance modelInstance) {
        if (modelInstance.model == null || !modelInstance.model.isReady()) {
            return false;
        }
        if (!modelInstance.model.Mesh.isReady() || modelInstance.model.Mesh.vb == null) {
            return false;
        }
        for (int i = 0; i < modelInstance.sub.size(); ++i) {
            ModelInstance modelInstance2 = modelInstance.sub.get(i);
            if (this.isModelInstanceReady(modelInstance2)) continue;
            return false;
        }
        return true;
    }

    private void incrementRefCount(ModelInstance modelInstance) {
        ++modelInstance.renderRefCount;
        for (int i = 0; i < modelInstance.sub.size(); ++i) {
            ModelInstance modelInstance2 = modelInstance.sub.get(i);
            this.incrementRefCount(modelInstance2);
        }
    }

    private void initRenderData(StateInfo stateInfo, AnimatedModelInstanceRenderData animatedModelInstanceRenderData, ModelInstance modelInstance) {
        AnimatedModelInstanceRenderData animatedModelInstanceRenderData2 = instDataPool.alloc().init(modelInstance);
        stateInfo.instData.add(animatedModelInstanceRenderData2);
        animatedModelInstanceRenderData2.transformToParent(animatedModelInstanceRenderData);
        for (int i = 0; i < modelInstance.sub.size(); ++i) {
            ModelInstance modelInstance2 = modelInstance.sub.get(i);
            this.initRenderData(stateInfo, animatedModelInstanceRenderData2, modelInstance2);
        }
    }

    public boolean isReadyToRender() {
        if (!this.animPlayer.isReady()) {
            return false;
        }
        return this.isModelInstanceReady(this.modelInstance);
    }

    public int renderMain() {
        StateInfo stateInfo = this.stateInfoMain();
        if (this.modelInstance != null) {
            if (this.bUpdateTextures) {
                this.bUpdateTextures = false;
                this.textureCreator = ModelInstanceTextureCreator.alloc();
                this.textureCreator.init(this.getVisual(), this.itemVisuals, this.modelInstance);
            }
            this.incrementRefCount(this.modelInstance);
            instDataPool.release((List<AnimatedModelInstanceRenderData>)stateInfo.instData);
            stateInfo.instData.clear();
            if (!stateInfo.bModelsReady && this.isReadyToRender()) {
                float f = GameTime.getInstance().FPSMultiplier;
                GameTime.getInstance().FPSMultiplier = 100.0f;
                try {
                    this.advancedAnimator.update();
                }
                finally {
                    GameTime.getInstance().FPSMultiplier = f;
                }
                this.animPlayer.Update(0.0f);
                stateInfo.bModelsReady = true;
            }
            this.initRenderData(stateInfo, null, this.modelInstance);
        }
        stateInfo.modelInstance = this.modelInstance;
        stateInfo.textureCreator = this.textureCreator != null && !this.textureCreator.isRendered() ? this.textureCreator : null;
        for (int i = 0; i < stateInfo.readyData.size(); ++i) {
            AnimatedModelInstanceRenderData animatedModelInstanceRenderData = stateInfo.readyData.get(i);
            animatedModelInstanceRenderData.init(animatedModelInstanceRenderData.modelInstance);
            animatedModelInstanceRenderData.transformToParent(stateInfo.getParentData(animatedModelInstanceRenderData.modelInstance));
        }
        stateInfo.bRendered = false;
        return SpriteRenderer.instance.getMainStateIndex();
    }

    public boolean isRendered() {
        return this.stateInfoRender().bRendered;
    }

    private void doneWithTextureCreator(ModelInstanceTextureCreator modelInstanceTextureCreator) {
        if (modelInstanceTextureCreator == null) {
            return;
        }
        for (int i = 0; i < this.stateInfos.length; ++i) {
            if (this.stateInfos[i].textureCreator != modelInstanceTextureCreator) continue;
            return;
        }
        if (modelInstanceTextureCreator.isRendered()) {
            modelInstanceTextureCreator.postRender();
            if (modelInstanceTextureCreator == this.textureCreator) {
                this.textureCreator = null;
            }
        } else if (modelInstanceTextureCreator != this.textureCreator) {
            modelInstanceTextureCreator.postRender();
        }
    }

    private void release(ArrayList<AnimatedModelInstanceRenderData> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            AnimatedModelInstanceRenderData animatedModelInstanceRenderData = arrayList.get(i);
            if (animatedModelInstanceRenderData.modelInstance.getTextureInitializer() != null) {
                animatedModelInstanceRenderData.modelInstance.getTextureInitializer().postRender();
            }
            ModelManager.instance.derefModelInstance(animatedModelInstanceRenderData.modelInstance);
        }
        instDataPool.release((List<AnimatedModelInstanceRenderData>)arrayList);
    }

    public void postRender(boolean bl) {
        int n = SpriteRenderer.instance.getMainStateIndex();
        StateInfo stateInfo = this.stateInfos[n];
        ModelInstanceTextureCreator modelInstanceTextureCreator = stateInfo.textureCreator;
        stateInfo.textureCreator = null;
        this.doneWithTextureCreator(modelInstanceTextureCreator);
        stateInfo.modelInstance = null;
        if (this.bAnimate && stateInfo.bRendered) {
            this.release(stateInfo.readyData);
            stateInfo.readyData.clear();
            stateInfo.readyData.addAll(stateInfo.instData);
            stateInfo.instData.clear();
        } else if (!this.bAnimate) {
            // empty if block
        }
        this.release(stateInfo.instData);
        stateInfo.instData.clear();
    }

    public void DoRender(ModelCamera modelCamera) {
        int n = SpriteRenderer.instance.getRenderStateIndex();
        StateInfo stateInfo = this.stateInfos[n];
        this.bReady = true;
        ModelInstanceTextureCreator modelInstanceTextureCreator = stateInfo.textureCreator;
        if (modelInstanceTextureCreator != null && !modelInstanceTextureCreator.isRendered()) {
            modelInstanceTextureCreator.render();
            if (!modelInstanceTextureCreator.isRendered()) {
                this.bReady = false;
            }
        }
        if (!this.isModelInstanceReady(this.modelInstance)) {
            this.bReady = false;
        }
        for (int i = 0; i < stateInfo.instData.size(); ++i) {
            AnimatedModelInstanceRenderData animatedModelInstanceRenderData = stateInfo.instData.get(i);
            ModelInstanceTextureInitializer modelInstanceTextureInitializer = animatedModelInstanceRenderData.modelInstance.getTextureInitializer();
            if (modelInstanceTextureInitializer == null || modelInstanceTextureInitializer.isRendered()) continue;
            modelInstanceTextureInitializer.render();
            if (modelInstanceTextureInitializer.isRendered()) continue;
            this.bReady = false;
        }
        if (this.bReady && !stateInfo.bModelsReady) {
            this.bReady = false;
        }
        if (!this.bReady && stateInfo.readyData.isEmpty()) {
            return;
        }
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        modelCamera.Begin();
        this.StartCharacter();
        this.Render();
        this.EndCharacter();
        modelCamera.End();
        GL11.glDepthFunc((int)519);
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        SpriteRenderer.ringBuffer.restoreVBOs = true;
        stateInfo.bRendered = this.bReady;
    }

    public void DoRender(int n, int n2, int n3, int n4, float f, float f2) {
        GL11.glClear((int)256);
        this.uiModelCamera.x = n;
        this.uiModelCamera.y = n2;
        this.uiModelCamera.w = n3;
        this.uiModelCamera.h = n4;
        this.uiModelCamera.sizeV = f;
        this.uiModelCamera.m_animPlayerAngle = f2;
        this.DoRender(this.uiModelCamera);
    }

    public void DoRenderToWorld(float f, float f2, float f3, float f4) {
        AnimatedModel.worldModelCamera.x = f;
        AnimatedModel.worldModelCamera.y = f2;
        AnimatedModel.worldModelCamera.z = f3;
        AnimatedModel.worldModelCamera.angle = f4;
        this.DoRender(worldModelCamera);
    }

    private void debugDrawAxes() {
        if (Core.bDebug && DebugOptions.instance.ModelRenderAxis.getValue()) {
            Model.debugDrawAxis(0.0f, 0.0f, 0.0f, 1.0f, 4.0f);
        }
    }

    private void StartCharacter() {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        if (UIManager.useUIFBO) {
            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glDisable((int)3089);
        GL11.glDepthMask((boolean)true);
    }

    private void EndCharacter() {
        GL11.glDepthMask((boolean)false);
        GL11.glViewport((int)0, (int)0, (int)Core.width, (int)Core.height);
    }

    private void Render() {
        int n = SpriteRenderer.instance.getRenderStateIndex();
        StateInfo stateInfo = this.stateInfos[n];
        ModelInstance modelInstance = stateInfo.modelInstance;
        if (modelInstance == null) {
            boolean bl = true;
        } else {
            ArrayList<AnimatedModelInstanceRenderData> arrayList = this.bReady ? stateInfo.instData : stateInfo.readyData;
            for (int i = 0; i < arrayList.size(); ++i) {
                AnimatedModelInstanceRenderData animatedModelInstanceRenderData = arrayList.get(i);
                this.DrawChar(animatedModelInstanceRenderData);
            }
        }
        this.debugDrawAxes();
    }

    private void DrawChar(AnimatedModelInstanceRenderData animatedModelInstanceRenderData) {
        Object object;
        Shader shader;
        ModelInstance modelInstance = animatedModelInstanceRenderData.modelInstance;
        FloatBuffer floatBuffer = animatedModelInstanceRenderData.matrixPalette;
        if (modelInstance == null) {
            return;
        }
        if (modelInstance.AnimPlayer == null) {
            return;
        }
        if (!modelInstance.AnimPlayer.hasSkinningData()) {
            return;
        }
        if (modelInstance.model == null) {
            return;
        }
        if (!modelInstance.model.isReady()) {
            return;
        }
        if (modelInstance.tex == null && modelInstance.model.tex == null) {
            return;
        }
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1028);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glDepthFunc((int)513);
        GL11.glDepthRange((double)0.0, (double)1.0);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        if (modelInstance.model.Effect == null) {
            modelInstance.model.CreateShader("basicEffect");
        }
        if ((shader = modelInstance.model.Effect) != null) {
            shader.Start();
            if (modelInstance.model.bStatic) {
                shader.setTransformMatrix(animatedModelInstanceRenderData.xfrm, true);
            } else {
                shader.setMatrixPalette(floatBuffer, true);
            }
            shader.setLight(0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, modelInstance);
            shader.setLight(1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, modelInstance);
            shader.setLight(2, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, modelInstance);
            shader.setLight(3, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, modelInstance);
            shader.setLight(4, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, modelInstance);
            float f = 0.7f;
            for (int i = 0; i < this.lights.length; ++i) {
                object = this.lights[i];
                if (((IsoGridSquare.ResultLight)object).radius <= 0) continue;
                shader.setLight(i, (float)((IsoGridSquare.ResultLight)object).x + 0.5f, (float)((IsoGridSquare.ResultLight)object).y + 0.5f, (float)((IsoGridSquare.ResultLight)object).z + 0.5f, ((IsoGridSquare.ResultLight)object).r * f, ((IsoGridSquare.ResultLight)object).g * f, ((IsoGridSquare.ResultLight)object).b * f, ((IsoGridSquare.ResultLight)object).radius, animatedModelInstanceRenderData.m_animPlayerAngle, this.lightsOriginX, this.lightsOriginY, this.lightsOriginZ, null);
            }
            if (modelInstance.tex != null) {
                shader.setTexture(modelInstance.tex, "Texture", 0);
            } else if (modelInstance.model.tex != null) {
                shader.setTexture(modelInstance.model.tex, "Texture", 0);
            }
            if (this.bOutside) {
                float f2 = ModelInstance.MODEL_LIGHT_MULT_OUTSIDE;
                shader.setLight(3, this.lightsOriginX - 2.0f, this.lightsOriginY - 2.0f, this.lightsOriginZ + 1.0f, this.ambient.r * f2 / 4.0f, this.ambient.g * f2 / 4.0f, this.ambient.b * f2 / 4.0f, 5000.0f, animatedModelInstanceRenderData.m_animPlayerAngle, this.lightsOriginX, this.lightsOriginY, this.lightsOriginZ, null);
                shader.setLight(4, this.lightsOriginX + 2.0f, this.lightsOriginY + 2.0f, this.lightsOriginZ + 1.0f, this.ambient.r * f2 / 4.0f, this.ambient.g * f2 / 4.0f, this.ambient.b * f2 / 4.0f, 5000.0f, animatedModelInstanceRenderData.m_animPlayerAngle, this.lightsOriginX, this.lightsOriginY, this.lightsOriginZ, null);
            } else if (this.bRoom) {
                float f3 = ModelInstance.MODEL_LIGHT_MULT_ROOM;
                shader.setLight(4, this.lightsOriginX + 2.0f, this.lightsOriginY + 2.0f, this.lightsOriginZ + 1.0f, this.ambient.r * f3 / 4.0f, this.ambient.g * f3 / 4.0f, this.ambient.b * f3 / 4.0f, 5000.0f, animatedModelInstanceRenderData.m_animPlayerAngle, this.lightsOriginX, this.lightsOriginY, this.lightsOriginZ, null);
            }
            shader.setDepthBias(modelInstance.depthBias / 50.0f);
            shader.setAmbient(this.ambient.r * 0.45f, this.ambient.g * 0.45f, this.ambient.b * 0.45f);
            shader.setLightingAmount(1.0f);
            shader.setHueShift(modelInstance.hue);
            shader.setTint(modelInstance.tintR, modelInstance.tintG, modelInstance.tintB);
            shader.setAlpha(this.m_alpha);
        }
        modelInstance.model.Mesh.Draw(shader);
        if (shader != null) {
            shader.End();
        }
        if (Core.bDebug && DebugOptions.instance.ModelRenderLights.getValue() && modelInstance.parent == null) {
            if (this.lights[0].radius > 0) {
                Model cfr_ignored_0 = modelInstance.model;
                Model.debugDrawLightSource(this.lights[0].x, this.lights[0].y, this.lights[0].z, 0.0f, 0.0f, 0.0f, -animatedModelInstanceRenderData.m_animPlayerAngle);
            }
            if (this.lights[1].radius > 0) {
                Model cfr_ignored_1 = modelInstance.model;
                Model.debugDrawLightSource(this.lights[1].x, this.lights[1].y, this.lights[1].z, 0.0f, 0.0f, 0.0f, -animatedModelInstanceRenderData.m_animPlayerAngle);
            }
            if (this.lights[2].radius > 0) {
                Model cfr_ignored_2 = modelInstance.model;
                Model.debugDrawLightSource(this.lights[2].x, this.lights[2].y, this.lights[2].z, 0.0f, 0.0f, 0.0f, -animatedModelInstanceRenderData.m_animPlayerAngle);
            }
        }
        if (Core.bDebug && DebugOptions.instance.ModelRenderBones.getValue()) {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)1.0f);
            GL11.glBegin((int)1);
            for (int i = 0; i < modelInstance.AnimPlayer.modelTransforms.length; ++i) {
                int n = modelInstance.AnimPlayer.getSkinningData().SkeletonHierarchy.get(i);
                if (n < 0) continue;
                object = Model.debugDrawColours[i % Model.debugDrawColours.length];
                GL11.glColor3f((float)((Color)object).r, (float)((Color)object).g, (float)((Color)object).b);
                Matrix4f matrix4f = modelInstance.AnimPlayer.modelTransforms[i];
                GL11.glVertex3f((float)matrix4f.m03, (float)matrix4f.m13, (float)matrix4f.m23);
                matrix4f = modelInstance.AnimPlayer.modelTransforms[n];
                GL11.glVertex3f((float)matrix4f.m03, (float)matrix4f.m13, (float)matrix4f.m23);
            }
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2929);
        }
    }

    public void releaseAnimationPlayer() {
        if (this.animPlayer != null) {
            this.animPlayer = Pool.tryRelease(this.animPlayer);
        }
    }

    @Override
    public void OnAnimEvent(AnimLayer animLayer, AnimEvent animEvent) {
        if (StringUtils.isNullOrWhitespace(animEvent.m_EventName)) {
            return;
        }
        int n = animLayer.getDepth();
        this.actionContext.reportEvent(n, animEvent.m_EventName);
    }

    @Override
    public AnimationPlayer getAnimationPlayer() {
        Model model = this.getVisual().getModel();
        if (this.animPlayer != null && this.animPlayer.getModel() != model) {
            this.animPlayer = Pool.tryRelease(this.animPlayer);
        }
        if (this.animPlayer == null) {
            this.animPlayer = AnimationPlayer.alloc(model);
        }
        return this.animPlayer;
    }

    @Override
    public void actionStateChanged(ActionContext actionContext) {
        this.advancedAnimator.SetState(actionContext.getCurrentStateName(), PZArrayUtil.listConvert(actionContext.getChildStates(), actionState -> actionState.name));
    }

    @Override
    public AnimationPlayerRecorder getAnimationPlayerRecorder() {
        return null;
    }

    @Override
    public boolean isAnimationRecorderActive() {
        return false;
    }

    @Override
    public ActionContext getActionContext() {
        return this.actionContext;
    }

    @Override
    public AdvancedAnimator getAdvancedAnimator() {
        return this.advancedAnimator;
    }

    @Override
    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public String GetAnimSetName() {
        return this.animSetName;
    }

    @Override
    public String getUID() {
        return this.m_UID;
    }

    public static final class StateInfo {
        ModelInstance modelInstance;
        ModelInstanceTextureCreator textureCreator;
        final ArrayList<AnimatedModelInstanceRenderData> instData = new ArrayList();
        final ArrayList<AnimatedModelInstanceRenderData> readyData = new ArrayList();
        boolean bModelsReady;
        boolean bRendered;

        AnimatedModelInstanceRenderData getParentData(ModelInstance modelInstance) {
            for (int i = 0; i < this.readyData.size(); ++i) {
                AnimatedModelInstanceRenderData animatedModelInstanceRenderData = this.readyData.get(i);
                if (animatedModelInstanceRenderData.modelInstance != modelInstance.parent) continue;
                return animatedModelInstanceRenderData;
            }
            return null;
        }
    }

    private final class UIModelCamera
    extends ModelCamera {
        int x;
        int y;
        int w;
        int h;
        float sizeV;
        float m_animPlayerAngle;

        private UIModelCamera() {
        }

        @Override
        public void Begin() {
            GL11.glViewport((int)this.x, (int)this.y, (int)this.w, (int)this.h);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            float f = (float)this.w / (float)this.h;
            if (AnimatedModel.this.flipY) {
                GL11.glOrtho((double)(-this.sizeV * f), (double)(this.sizeV * f), (double)this.sizeV, (double)(-this.sizeV), (double)-100.0, (double)100.0);
            } else {
                GL11.glOrtho((double)(-this.sizeV * f), (double)(this.sizeV * f), (double)(-this.sizeV), (double)this.sizeV, (double)-100.0, (double)100.0);
            }
            float f2 = Math.sqrt(2048.0f);
            GL11.glScalef((float)(-f2), (float)f2, (float)f2);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            if (AnimatedModel.this.bIsometric) {
                GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotated((double)(this.m_animPlayerAngle * 57.295776f + 45.0f), (double)0.0, (double)1.0, (double)0.0);
            } else {
                GL11.glRotated((double)(this.m_animPlayerAngle * 57.295776f), (double)0.0, (double)1.0, (double)0.0);
            }
            GL11.glTranslatef((float)AnimatedModel.this.offset.x(), (float)AnimatedModel.this.offset.y(), (float)AnimatedModel.this.offset.z());
        }

        @Override
        public void End() {
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
        }
    }

    private static final class AnimatedModelInstanceRenderData {
        ModelInstance modelInstance;
        FloatBuffer matrixPalette;
        public final org.joml.Matrix4f xfrm = new org.joml.Matrix4f();
        float m_animPlayerAngle;

        private AnimatedModelInstanceRenderData() {
        }

        AnimatedModelInstanceRenderData init(ModelInstance modelInstance) {
            this.modelInstance = modelInstance;
            this.xfrm.identity();
            this.m_animPlayerAngle = Float.NaN;
            if (modelInstance.AnimPlayer != null) {
                this.m_animPlayerAngle = modelInstance.AnimPlayer.getRenderedAngle();
                if (!modelInstance.model.bStatic) {
                    SkinningData skinningData = (SkinningData)modelInstance.model.Tag;
                    if (Core.bDebug && skinningData == null) {
                        DebugLog.General.warn("skinningData is null, matrixPalette may be invalid");
                    }
                    Matrix4f[] matrix4fArray = modelInstance.AnimPlayer.getSkinTransforms(skinningData);
                    if (this.matrixPalette == null || this.matrixPalette.capacity() < matrix4fArray.length * 16) {
                        this.matrixPalette = BufferUtils.createFloatBuffer(matrix4fArray.length * 16);
                    }
                    this.matrixPalette.clear();
                    for (int i = 0; i < matrix4fArray.length; ++i) {
                        matrix4fArray[i].store(this.matrixPalette);
                    }
                    this.matrixPalette.flip();
                }
            }
            if (modelInstance.getTextureInitializer() != null) {
                modelInstance.getTextureInitializer().renderMain();
            }
            return this;
        }

        public AnimatedModelInstanceRenderData transformToParent(AnimatedModelInstanceRenderData animatedModelInstanceRenderData) {
            ModelAttachment modelAttachment;
            if (this.modelInstance instanceof VehicleModelInstance || this.modelInstance instanceof VehicleSubModelInstance) {
                return this;
            }
            if (animatedModelInstanceRenderData == null) {
                return this;
            }
            this.xfrm.set(animatedModelInstanceRenderData.xfrm);
            this.xfrm.transpose();
            org.joml.Matrix4f matrix4f = (org.joml.Matrix4f)BaseVehicle.TL_matrix4f_pool.get().alloc();
            ModelAttachment modelAttachment2 = animatedModelInstanceRenderData.modelInstance.getAttachmentById(this.modelInstance.attachmentNameParent);
            if (modelAttachment2 == null) {
                if (this.modelInstance.parentBoneName != null && animatedModelInstanceRenderData.modelInstance.AnimPlayer != null) {
                    ModelInstanceRenderData.applyBoneTransform(animatedModelInstanceRenderData.modelInstance, this.modelInstance.parentBoneName, this.xfrm);
                }
            } else {
                ModelInstanceRenderData.applyBoneTransform(animatedModelInstanceRenderData.modelInstance, modelAttachment2.getBone(), this.xfrm);
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment2, matrix4f);
                this.xfrm.mul(matrix4f);
            }
            if ((modelAttachment = this.modelInstance.getAttachmentById(this.modelInstance.attachmentNameSelf)) != null) {
                ModelInstanceRenderData.makeAttachmentTransform(modelAttachment, matrix4f);
                matrix4f.invert();
                this.xfrm.mul(matrix4f);
            }
            if (this.modelInstance.model.Mesh != null && this.modelInstance.model.Mesh.isReady() && this.modelInstance.model.Mesh.m_transform != null) {
                this.xfrm.mul(this.modelInstance.model.Mesh.m_transform);
            }
            if (this.modelInstance.scale != 1.0f) {
                this.xfrm.scale(this.modelInstance.scale);
            }
            this.xfrm.transpose();
            BaseVehicle.TL_matrix4f_pool.get().release(matrix4f);
            return this;
        }
    }

    private static final class WorldModelCamera
    extends ModelCamera {
        float x;
        float y;
        float z;
        float angle;

        private WorldModelCamera() {
        }

        @Override
        public void Begin() {
            Core.getInstance().DoPushIsoStuff(this.x, this.y, this.z, this.angle, false);
            GL11.glDepthMask((boolean)true);
        }

        @Override
        public void End() {
            Core.getInstance().DoPopIsoStuff();
        }
    }
}

