/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import zombie.ZomboidFileSystem;
import zombie.asset.AssetPath;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimNodeAsset;
import zombie.core.skinnedmodel.advancedanimation.AnimNodeAssetManager;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.util.StringUtils;

public final class AnimState {
    public String m_Name = "";
    public final List<AnimNode> m_Nodes = new ArrayList<AnimNode>();
    public int m_DefaultIndex = 0;
    public AnimationSet m_Set = null;
    private static final boolean s_bDebugLog_NodeConditions = false;

    public List<AnimNode> getAnimNodes(IAnimationVariableSource iAnimationVariableSource, List<AnimNode> list) {
        list.clear();
        if (this.m_Nodes.size() <= 0) {
            return list;
        }
        if (DebugOptions.instance.Animation.AnimLayer.AllowAnimNodeOverride.getValue() && iAnimationVariableSource.getVariableBoolean("dbgForceAnim") && iAnimationVariableSource.isVariable("dbgForceAnimStateName", this.m_Name)) {
            String string = iAnimationVariableSource.getVariableString("dbgForceAnimNodeName");
            int n = this.m_Nodes.size();
            for (int i = 0; i < n; ++i) {
                AnimNode animNode = this.m_Nodes.get(i);
                if (!StringUtils.equalsIgnoreCase(animNode.m_Name, string)) continue;
                list.add(animNode);
                break;
            }
            return list;
        }
        int n = -1;
        int n2 = this.m_Nodes.size();
        for (int i = 0; i < n2; ++i) {
            AnimNode animNode = this.m_Nodes.get(i);
            if (animNode.isAbstract() || animNode.m_Conditions.size() < n || !animNode.checkConditions(iAnimationVariableSource)) continue;
            if (n < animNode.m_Conditions.size()) {
                list.clear();
                n = animNode.m_Conditions.size();
            }
            list.add(animNode);
        }
        if (!list.isEmpty()) {
            // empty if block
        }
        return list;
    }

    public static AnimState Parse(String string, String string2) {
        String[] stringArray;
        boolean bl = DebugLog.isEnabled(DebugType.Animation);
        AnimState animState = new AnimState();
        animState.m_Name = string;
        if (bl) {
            DebugLog.Animation.println("Loading AnimState: " + string);
        }
        for (String string3 : stringArray = ZomboidFileSystem.instance.resolveAllFiles(string2, file -> file.getName().endsWith(".xml"), true)) {
            String string4;
            AnimNodeAsset animNodeAsset;
            File file2 = new File(string3);
            String string5 = file2.getName().split(".xml")[0].toLowerCase();
            if (bl) {
                DebugLog.Animation.println(string + " -> AnimNode: " + string5);
            }
            if (!(animNodeAsset = (AnimNodeAsset)AnimNodeAssetManager.instance.load(new AssetPath(string4 = ZomboidFileSystem.instance.resolveFileOrGUID(string3)))).isReady()) continue;
            AnimNode animNode = animNodeAsset.m_animNode;
            animNode.m_State = animState;
            animState.m_Nodes.add(animNode);
        }
        return animState;
    }

    public String toString() {
        return "AnimState{" + this.m_Name + ", NodeCount:" + this.m_Nodes.size() + ", DefaultIndex:" + this.m_DefaultIndex + "}";
    }

    public static String getStateName(AnimState animState) {
        return animState != null ? animState.m_Name : null;
    }

    protected void clear() {
        this.m_Nodes.clear();
        this.m_Set = null;
    }

    private static /* synthetic */ String lambda$getAnimNodes$0(AnimNode animNode) {
        return String.format("%s: %s", animNode.m_Name, animNode.getConditionsString());
    }
}

