/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlend;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlendPicker;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlendTriangle;
import zombie.core.skinnedmodel.advancedanimation.AnimBoneWeight;
import zombie.core.skinnedmodel.advancedanimation.AnimCondition;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.advancedanimation.AnimTransition;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;
import zombie.core.skinnedmodel.animation.BoneAxis;
import zombie.core.skinnedmodel.model.jassimp.JAssImpImporter;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;

@XmlRootElement
public final class AnimNode {
    private static final Comparator<AnimEvent> s_eventsComparator = (animEvent, animEvent2) -> Float.compare(animEvent.m_TimePc, animEvent2.m_TimePc);
    public String m_Name = "";
    public int m_Priority = 5;
    public String m_AnimName = "";
    public String m_DeferredBoneName = "";
    public BoneAxis m_deferredBoneAxis = BoneAxis.Y;
    public boolean m_useDeferedRotation = false;
    public boolean m_Looped = true;
    public float m_BlendTime = 0.0f;
    public float m_BlendOutTime = -1.0f;
    public boolean m_StopAnimOnExit = false;
    public boolean m_EarlyTransitionOut = false;
    public String m_SpeedScale = "1.00";
    public String m_SpeedScaleVariable = null;
    public float m_SpeedScaleRandomMultiplierMin = 1.0f;
    public float m_SpeedScaleRandomMultiplierMax = 1.0f;
    @XmlTransient
    private float m_SpeedScaleF = Float.POSITIVE_INFINITY;
    public float m_randomAdvanceFraction = 0.0f;
    public float m_maxTorsoTwist = 15.0f;
    public String m_Scalar = "";
    public String m_Scalar2 = "";
    public boolean m_AnimReverse = false;
    public boolean m_SyncTrackingEnabled = true;
    public List<Anim2DBlend> m_2DBlends = new ArrayList<Anim2DBlend>();
    public List<AnimCondition> m_Conditions = new ArrayList<AnimCondition>();
    public List<AnimEvent> m_Events = new ArrayList<AnimEvent>();
    public List<Anim2DBlendTriangle> m_2DBlendTri = new ArrayList<Anim2DBlendTriangle>();
    public List<AnimTransition> m_Transitions = new ArrayList<AnimTransition>();
    public List<AnimBoneWeight> m_SubStateBoneWeights = new ArrayList<AnimBoneWeight>();
    @XmlTransient
    public Anim2DBlendPicker m_picker;
    @XmlTransient
    public AnimState m_State = null;
    @XmlTransient
    private AnimTransition m_transitionOut;

    public static AnimNode Parse(String string) {
        try {
            Object object;
            int n;
            AnimNode animNode = PZXmlUtil.parse(AnimNode.class, string);
            if (animNode.m_2DBlendTri.size() > 0) {
                animNode.m_picker = new Anim2DBlendPicker();
                animNode.m_picker.SetPickTriangles(animNode.m_2DBlendTri);
            }
            PZArrayUtil.forEach(animNode.m_Events, animEvent -> {
                String[] stringArray;
                if ("SetVariable".equalsIgnoreCase(animEvent.m_EventName) && (stringArray = animEvent.m_ParameterValue.split("=")).length == 2) {
                    animEvent.m_SetVariable1 = stringArray[0];
                    animEvent.m_SetVariable2 = stringArray[1];
                }
            });
            animNode.m_Events.sort(s_eventsComparator);
            try {
                animNode.m_SpeedScaleF = Float.parseFloat(animNode.m_SpeedScale);
            }
            catch (NumberFormatException numberFormatException) {
                animNode.m_SpeedScaleVariable = animNode.m_SpeedScale;
            }
            if (animNode.m_SubStateBoneWeights.isEmpty()) {
                animNode.m_SubStateBoneWeights.add(new AnimBoneWeight("Bip01_Spine1", 0.5f));
                animNode.m_SubStateBoneWeights.add(new AnimBoneWeight("Bip01_Neck", 1.0f));
                animNode.m_SubStateBoneWeights.add(new AnimBoneWeight("Bip01_BackPack", 1.0f));
                animNode.m_SubStateBoneWeights.add(new AnimBoneWeight("Bip01_Prop1", 1.0f));
                animNode.m_SubStateBoneWeights.add(new AnimBoneWeight("Bip01_Prop2", 1.0f));
            }
            for (n = 0; n < animNode.m_SubStateBoneWeights.size(); ++n) {
                object = animNode.m_SubStateBoneWeights.get(n);
                ((AnimBoneWeight)object).boneName = JAssImpImporter.getSharedString(((AnimBoneWeight)object).boneName, "AnimBoneWeight.boneName");
            }
            animNode.m_transitionOut = null;
            for (n = 0; n < animNode.m_Transitions.size(); ++n) {
                object = animNode.m_Transitions.get(n);
                if (!StringUtils.isNullOrWhitespace(((AnimTransition)object).m_Target)) continue;
                animNode.m_transitionOut = object;
            }
            return animNode;
        }
        catch (PZXmlParserException pZXmlParserException) {
            System.err.println("AnimNode.Parse threw an exception reading file: " + string);
            ExceptionLogger.logException(pZXmlParserException);
            return null;
        }
    }

    public boolean checkConditions(IAnimationVariableSource iAnimationVariableSource) {
        List<AnimCondition> list = this.m_Conditions;
        return AnimCondition.pass(iAnimationVariableSource, list);
    }

    public float getSpeedScale(IAnimationVariableSource iAnimationVariableSource) {
        if (this.m_SpeedScaleF != Float.POSITIVE_INFINITY) {
            return this.m_SpeedScaleF;
        }
        return iAnimationVariableSource.getVariableFloat(this.m_SpeedScale, 1.0f);
    }

    public boolean isIdleAnim() {
        return this.m_Name.contains("Idle");
    }

    public AnimTransition findTransitionTo(IAnimationVariableSource iAnimationVariableSource, String string) {
        AnimTransition animTransition = null;
        int n = this.m_Transitions.size();
        for (int i = 0; i < n; ++i) {
            AnimTransition animTransition2 = this.m_Transitions.get(i);
            if (!StringUtils.equalsIgnoreCase(animTransition2.m_Target, string) || !AnimCondition.pass(iAnimationVariableSource, animTransition2.m_Conditions)) continue;
            animTransition = animTransition2;
            break;
        }
        return animTransition;
    }

    public String toString() {
        return String.format("AnimNode{ Name: %s, AnimName: %s, Conditions: %s }", this.m_Name, this.m_AnimName, this.getConditionsString());
    }

    public String getConditionsString() {
        return PZArrayUtil.arrayToString(this.m_Conditions, AnimCondition::getConditionString, "( ", " )", ", ");
    }

    public boolean isAbstract() {
        if (!StringUtils.isNullOrWhitespace(this.m_AnimName)) {
            return false;
        }
        return this.m_2DBlends.isEmpty();
    }

    public float getBlendOutTime() {
        if (this.m_transitionOut != null) {
            return this.m_transitionOut.m_blendOutTime;
        }
        if (this.m_BlendOutTime >= 0.0f) {
            return this.m_BlendOutTime;
        }
        return this.m_BlendTime;
    }

    public String getDeferredBoneName() {
        if (StringUtils.isNullOrWhitespace(this.m_DeferredBoneName)) {
            return "Translation_Data";
        }
        return this.m_DeferredBoneName;
    }

    public BoneAxis getDeferredBoneAxis() {
        return this.m_deferredBoneAxis;
    }

    public int getPriority() {
        return this.m_Priority;
    }
}

