/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.ArrayList;
import java.util.List;
import org.joml.Math;
import zombie.GameProfiler;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlend;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlendPicker;
import zombie.core.skinnedmodel.advancedanimation.AnimBoneWeight;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.advancedanimation.AnimTransition;
import zombie.core.skinnedmodel.advancedanimation.IAnimEventCallback;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;
import zombie.core.skinnedmodel.advancedanimation.LiveAnimNode;
import zombie.core.skinnedmodel.animation.AnimationMultiTrack;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.BoneAxis;
import zombie.core.skinnedmodel.animation.IAnimListener;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.core.skinnedmodel.model.SkinningBone;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.util.Pool;
import zombie.util.PooledObject;
import zombie.util.StringUtils;

public final class AnimLayer
implements IAnimListener {
    private final AnimLayer m_parentLayer;
    private final IAnimatable m_Character;
    private AnimState m_State = null;
    private AnimNode m_CurrentNode = null;
    private IAnimEventCallback m_AnimEventsCallback;
    private LiveAnimNode m_currentSyncNode;
    private AnimationTrack m_currentSyncTrack;
    private final List<AnimNode> m_reusableAnimNodes = new ArrayList<AnimNode>();
    private final List<LiveAnimNode> m_liveAnimNodes = new ArrayList<LiveAnimNode>();
    private static final AnimEvent s_activeAnimLoopedEvent = new AnimEvent();
    private static final AnimEvent s_activeNonLoopedAnimFadeOutEvent;
    private static final AnimEvent s_activeAnimFinishingEvent;
    private static final AnimEvent s_activeNonLoopedAnimFinishedEvent;

    public AnimLayer(IAnimatable iAnimatable, IAnimEventCallback iAnimEventCallback) {
        this(null, iAnimatable, iAnimEventCallback);
    }

    public AnimLayer(AnimLayer animLayer, IAnimatable iAnimatable, IAnimEventCallback iAnimEventCallback) {
        this.m_parentLayer = animLayer;
        this.m_Character = iAnimatable;
        this.m_AnimEventsCallback = iAnimEventCallback;
    }

    public String getCurrentStateName() {
        return this.m_State == null ? null : this.m_State.m_Name;
    }

    public boolean hasState() {
        return this.m_State != null;
    }

    public boolean isStateless() {
        return this.m_State == null;
    }

    public boolean isSubLayer() {
        return this.m_parentLayer != null;
    }

    public boolean isCurrentState(String string) {
        return this.m_State != null && StringUtils.equals(this.m_State.m_Name, string);
    }

    public AnimationMultiTrack getAnimationTrack() {
        if (this.m_Character == null) {
            return null;
        }
        AnimationPlayer animationPlayer = this.m_Character.getAnimationPlayer();
        if (animationPlayer == null) {
            return null;
        }
        return animationPlayer.getMultiTrack();
    }

    public IAnimationVariableSource getVariableSource() {
        return this.m_Character;
    }

    public LiveAnimNode getCurrentSyncNode() {
        return this.m_currentSyncNode;
    }

    public AnimationTrack getCurrentSyncTrack() {
        return this.m_currentSyncTrack;
    }

    @Override
    public void onAnimStarted(AnimationTrack animationTrack) {
    }

    @Override
    public void onLoopedAnim(AnimationTrack animationTrack) {
        this.invokeAnimEvent(animationTrack, s_activeAnimLoopedEvent, false);
    }

    @Override
    public void onNonLoopedAnimFadeOut(AnimationTrack animationTrack) {
        this.invokeAnimEvent(animationTrack, s_activeAnimFinishingEvent, true);
        this.invokeAnimEvent(animationTrack, s_activeNonLoopedAnimFadeOutEvent, true);
    }

    @Override
    public void onNonLoopedAnimFinished(AnimationTrack animationTrack) {
        this.invokeAnimEvent(animationTrack, s_activeAnimFinishingEvent, false);
        this.invokeAnimEvent(animationTrack, s_activeNonLoopedAnimFinishedEvent, true);
    }

    @Override
    public void onTrackDestroyed(AnimationTrack animationTrack) {
    }

    protected void invokeAnimEvent(AnimationTrack animationTrack, AnimEvent animEvent, boolean bl) {
        if (this.m_AnimEventsCallback == null) {
            return;
        }
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
            if (liveAnimNode.m_TransitioningOut && !bl || liveAnimNode.getSourceNode().m_State != this.m_State || !liveAnimNode.m_AnimationTracks.contains(animationTrack)) continue;
            this.invokeAnimEvent(animEvent);
            break;
        }
    }

    protected void invokeAnimEvent(AnimEvent animEvent) {
        if (this.m_AnimEventsCallback == null) {
            DebugLog.Animation.warn("invokeAnimEvent. No listener. %s", animEvent.toDetailsString());
            return;
        }
        this.m_AnimEventsCallback.OnAnimEvent(this, animEvent);
    }

    public String GetDebugString() {
        Object object = this.m_Character.getAdvancedAnimator().animSet.m_Name;
        if (this.m_State != null) {
            object = (String)object + "/" + this.m_State.m_Name;
            if (this.m_CurrentNode != null) {
                object = (String)object + "/" + this.m_CurrentNode.m_Name + ": " + this.m_CurrentNode.m_AnimName;
            }
        }
        String string = "State: " + (String)object;
        for (LiveAnimNode object2 : this.m_liveAnimNodes) {
            string = string + "\n  Node: " + object2.getSourceNode().m_Name;
        }
        AnimationMultiTrack animationMultiTrack = this.getAnimationTrack();
        if (animationMultiTrack != null) {
            string = string + "\n  AnimTrack:";
            for (AnimationTrack animationTrack : animationMultiTrack.getTracks()) {
                string = string + "\n    Anim: " + animationTrack.name + " Weight: " + animationTrack.BlendDelta;
            }
        }
        return string;
    }

    public void Reset() {
        AnimationMultiTrack animationMultiTrack = this.getAnimationTrack();
        for (int i = this.m_liveAnimNodes.size() - 1; i >= 0; --i) {
            LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
            liveAnimNode.setActive(false);
            if (animationMultiTrack != null) {
                animationMultiTrack.removeTracks(liveAnimNode.m_AnimationTracks);
            }
            this.m_liveAnimNodes.remove(i).release();
        }
        this.m_State = null;
    }

    public boolean TransitionTo(AnimState animState, boolean bl) {
        Object object;
        AnimationMultiTrack animationMultiTrack = this.getAnimationTrack();
        if (animationMultiTrack == null) {
            if (this.m_Character == null) {
                DebugLog.General.error("AnimationTrack is null. Character is null.");
                this.m_State = null;
                return false;
            }
            if (this.m_Character.getAnimationPlayer() == null) {
                DebugLog.General.error("AnimationTrack is null. Character ModelInstance.AnimPlayer is null.");
                this.m_State = null;
                return false;
            }
            DebugLog.General.error("AnimationTrack is null. Unknown reason.");
            return false;
        }
        if (animState == this.m_State && !bl) {
            return true;
        }
        if (DebugOptions.instance.Animation.AnimLayer.LogStateChanges.getValue()) {
            String string = this.m_parentLayer == null ? "" : AnimState.getStateName(this.m_parentLayer.m_State) + " | ";
            object = String.format("State: %s%s => %s", string, AnimState.getStateName(this.m_State), AnimState.getStateName(animState));
            DebugLog.General.debugln((String)object);
            if (this.m_Character instanceof IsoGameCharacter) {
                ((IsoGameCharacter)this.m_Character).setSayLine((String)object);
            }
        }
        this.m_State = animState;
        for (int i = 0; i < this.m_liveAnimNodes.size(); ++i) {
            object = this.m_liveAnimNodes.get(i);
            ((LiveAnimNode)object).m_TransitioningOut = true;
        }
        return true;
    }

    public void Update() {
        GameProfiler.getInstance().invokeAndMeasure("AnimLayer.Update", this, AnimLayer::updateInternal);
    }

    private void updateInternal() {
        AnimationTrack animationTrack;
        LiveAnimNode liveAnimNode;
        LiveAnimNode liveAnimNode2;
        float f = GameTime.instance.getTimeDelta();
        this.removeFadedOutNodes();
        this.updateNodeActiveFlags();
        this.m_currentSyncNode = liveAnimNode2 = this.getHighestLiveNode();
        this.m_currentSyncTrack = null;
        if (liveAnimNode2 == null) {
            return;
        }
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            liveAnimNode = this.m_liveAnimNodes.get(i);
            liveAnimNode.update(f);
        }
        IAnimatable iAnimatable = this.m_Character;
        this.updateMaximumTwist(iAnimatable);
        n = DebugOptions.instance.Animation.AnimLayer.AllowAnimNodeOverride.getValue() && iAnimatable.getVariableBoolean("dbgForceAnim") && iAnimatable.getVariableBoolean("dbgForceAnimScalars") ? 1 : 0;
        liveAnimNode = n != 0 ? iAnimatable.getVariableString("dbgForceAnimNodeName") : null;
        this.m_currentSyncTrack = animationTrack = this.findSyncTrack(liveAnimNode2);
        float f2 = animationTrack != null ? animationTrack.getCurrentTimeFraction() : -1.0f;
        int n2 = this.m_liveAnimNodes.size();
        for (int i = 0; i < n2; ++i) {
            List<AnimEvent> list;
            int n3;
            LiveAnimNode liveAnimNode3 = this.m_liveAnimNodes.get(i);
            float f3 = 1.0f;
            int n4 = liveAnimNode3.getPlayingTrackCount();
            for (n3 = 0; n3 < n4; ++n3) {
                list = liveAnimNode3.getPlayingTrackAt(n3);
                if (!((AnimationTrack)((Object)list)).IsPlaying) continue;
                if (animationTrack != null && ((AnimationTrack)((Object)list)).SyncTrackingEnabled && ((AnimationTrack)((Object)list)).isLooping() && list != animationTrack) {
                    ((AnimationTrack)((Object)list)).moveCurrentTimeValueToFraction(f2);
                }
                if (!((AnimationTrack)((Object)list)).name.equals(liveAnimNode3.getSourceNode().m_AnimName)) continue;
                f3 = ((AnimationTrack)((Object)list)).getDuration();
                liveAnimNode3.m_NodeAnimTime = ((AnimationTrack)((Object)list)).getCurrentTimeValue();
            }
            if (this.m_AnimEventsCallback != null && liveAnimNode3.getSourceNode().m_Events.size() > 0) {
                float f4 = liveAnimNode3.m_NodeAnimTime / f3;
                float f5 = liveAnimNode3.m_PrevNodeAnimTime / f3;
                list = liveAnimNode3.getSourceNode().m_Events;
                int n5 = list.size();
                for (int j = 0; j < n5; ++j) {
                    AnimEvent animEvent = list.get(j);
                    if (animEvent.m_Time != AnimEvent.AnimEventTime.Percentage) continue;
                    float f6 = animEvent.m_TimePc;
                    if (f5 < f6 && f6 <= f4) {
                        this.invokeAnimEvent(animEvent);
                        continue;
                    }
                    if (!liveAnimNode3.isLooped() && f4 < f6) break;
                    if (!liveAnimNode3.isLooped() || !(f5 > f4)) continue;
                    if (f5 < f6 && f6 <= f4 + 1.0f) {
                        this.invokeAnimEvent(animEvent);
                        continue;
                    }
                    if (!(f5 > f6) || !(f6 <= f4)) continue;
                    this.invokeAnimEvent(animEvent);
                }
            }
            if (liveAnimNode3.getPlayingTrackCount() == 0) continue;
            n3 = n != 0 && StringUtils.equalsIgnoreCase(liveAnimNode3.getSourceNode().m_Name, (String)((Object)liveAnimNode)) ? 1 : 0;
            String string = n3 != 0 ? "dbgForceScalar" : liveAnimNode3.getSourceNode().m_Scalar;
            list = n3 != 0 ? "dbgForceScalar2" : liveAnimNode3.getSourceNode().m_Scalar2;
            float f7 = liveAnimNode3.getTransitionInWeight();
            liveAnimNode3.setTransitionInBlendDelta(f7);
            if (liveAnimNode3.m_AnimationTracks.size() > 1) {
                f7 = iAnimatable.getVariableFloat(string, 0.0f);
                float f8 = iAnimatable.getVariableFloat((String)((Object)list), 0.0f);
                this.applyBlendField(liveAnimNode3, f7, f8);
                continue;
            }
            if (liveAnimNode3.m_AnimationTracks.isEmpty()) continue;
            f7 = liveAnimNode3.getWeight();
            float f9 = iAnimatable.getVariableFloat(string, 1.0f);
            liveAnimNode3.m_AnimationTracks.get((int)0).BlendDelta = f7 * Math.abs(f9);
        }
        if (this.isRecording()) {
            this.logBlendWeights();
            this.logCurrentState();
        }
    }

    private void updateMaximumTwist(IAnimationVariableSource iAnimationVariableSource) {
        IAnimationVariableSlot iAnimationVariableSlot = iAnimationVariableSource.getVariable("maxTwist");
        if (iAnimationVariableSlot == null) {
            return;
        }
        float f = iAnimationVariableSlot.getValueFloat();
        float f2 = 0.0f;
        float f3 = 1.0f;
        for (int i = this.m_liveAnimNodes.size() - 1; i >= 0; --i) {
            LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
            float f4 = liveAnimNode.getWeight();
            if (f3 <= 0.0f) break;
            float f5 = PZMath.clamp(f4, 0.0f, f3);
            f3 -= f5;
            float f6 = PZMath.clamp(liveAnimNode.getSourceNode().m_maxTorsoTwist, 0.0f, 70.0f);
            f2 += f6 * f5;
        }
        if (f3 > 0.0f) {
            f2 += f * f3;
        }
        iAnimationVariableSlot.setValue(f2);
    }

    public void updateNodeActiveFlags() {
        Object object;
        for (int i = 0; i < this.m_liveAnimNodes.size(); ++i) {
            object = this.m_liveAnimNodes.get(i);
            ((LiveAnimNode)object).setActive(false);
        }
        AnimState animState = this.m_State;
        object = this.m_Character;
        if (animState != null && !object.getVariableBoolean("AnimLocked")) {
            List<AnimNode> list = animState.getAnimNodes((IAnimationVariableSource)object, this.m_reusableAnimNodes);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AnimNode animNode = list.get(i);
                this.getOrCreateLiveNode(animNode);
            }
        }
        this.updateNewNodeTransitions();
    }

    private void updateNewNodeTransitions() {
        GameProfiler.getInstance().invokeAndMeasure("updateNewNodeTransitions", this, AnimLayer::updateNewNodeTransitionsInternal);
    }

    private void updateNewNodeTransitionsInternal() {
        IAnimatable iAnimatable = this.m_Character;
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            LiveAnimNode liveAnimNode;
            LiveAnimNode liveAnimNode2 = this.m_liveAnimNodes.get(i);
            if (!liveAnimNode2.isNew() || !liveAnimNode2.wasActivated() || (liveAnimNode = this.findTransitionToNewNode(liveAnimNode2, false)) == null) continue;
            AnimTransition animTransition = liveAnimNode.findTransitionTo(iAnimatable, liveAnimNode2.getName());
            float f = animTransition.m_speedScale;
            if (f == Float.POSITIVE_INFINITY) {
                f = liveAnimNode2.getSpeedScale(this.m_Character);
            }
            AnimationTrack animationTrack = null;
            if (!StringUtils.isNullOrWhitespace(animTransition.m_AnimName)) {
                StartAnimTrackParameters startAnimTrackParameters = StartAnimTrackParameters.alloc();
                startAnimTrackParameters.subLayerBoneWeights = liveAnimNode.getSubStateBoneWeights();
                startAnimTrackParameters.speedScale = f;
                startAnimTrackParameters.deferredBoneName = liveAnimNode.getDeferredBoneName();
                startAnimTrackParameters.deferredBoneAxis = liveAnimNode.getDeferredBoneAxis();
                startAnimTrackParameters.priority = liveAnimNode.getPriority();
                animationTrack = this.startAnimTrack(animTransition.m_AnimName, startAnimTrackParameters);
                startAnimTrackParameters.release();
                if (animationTrack == null) {
                    if (!DebugLog.isEnabled(DebugType.Animation)) continue;
                    DebugLog.Animation.println("  TransitionTo failed to play transition track: %s -> %s -> %s", liveAnimNode.getName(), animTransition.m_AnimName, liveAnimNode2.getName());
                    continue;
                }
                if (DebugLog.isEnabled(DebugType.Animation)) {
                    DebugLog.Animation.println("  TransitionTo found: %s -> %s -> %s", liveAnimNode.getName(), animTransition.m_AnimName, liveAnimNode2.getName());
                }
            } else if (DebugLog.isEnabled(DebugType.Animation)) {
                DebugLog.Animation.println("  TransitionTo found: %s -> <no anim> -> %s", liveAnimNode.getName(), liveAnimNode2.getName());
            }
            liveAnimNode2.startTransitionIn(liveAnimNode, animTransition, animationTrack);
            liveAnimNode.setTransitionOut(animTransition);
        }
    }

    public LiveAnimNode findTransitionToNewNode(LiveAnimNode liveAnimNode, boolean bl) {
        LiveAnimNode liveAnimNode2 = null;
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            AnimNode animNode;
            AnimTransition animTransition;
            LiveAnimNode liveAnimNode3 = this.m_liveAnimNodes.get(i);
            if (liveAnimNode3 == liveAnimNode || !bl && !liveAnimNode3.wasDeactivated() || (animTransition = (animNode = liveAnimNode3.getSourceNode()).findTransitionTo(this.m_Character, liveAnimNode.getName())) == null) continue;
            liveAnimNode2 = liveAnimNode3;
            break;
        }
        if (liveAnimNode2 == null && this.isSubLayer()) {
            liveAnimNode2 = this.m_parentLayer.findTransitionToNewNode(liveAnimNode, true);
        }
        return liveAnimNode2;
    }

    public void removeFadedOutNodes() {
        for (int i = this.m_liveAnimNodes.size() - 1; i >= 0; --i) {
            LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
            if (liveAnimNode.isActive() || liveAnimNode.isTransitioningIn() && liveAnimNode.getTransitionInWeight() > 0.01f || liveAnimNode.getWeight() > 0.01f) continue;
            this.removeLiveNodeAt(i);
        }
    }

    public void render() {
        IAnimatable iAnimatable = this.m_Character;
        boolean bl = DebugOptions.instance.Animation.AnimLayer.AllowAnimNodeOverride.getValue() && iAnimatable.getVariableBoolean("dbgForceAnim") && iAnimatable.getVariableBoolean("dbgForceAnimScalars");
        String string = bl ? iAnimatable.getVariableString("dbgForceAnimNodeName") : null;
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
            if (liveAnimNode.m_AnimationTracks.size() <= 1) continue;
            boolean bl2 = bl && StringUtils.equalsIgnoreCase(liveAnimNode.getSourceNode().m_Name, string);
            String string2 = bl2 ? "dbgForceScalar" : liveAnimNode.getSourceNode().m_Scalar;
            String string3 = bl2 ? "dbgForceScalar2" : liveAnimNode.getSourceNode().m_Scalar2;
            float f = iAnimatable.getVariableFloat(string2, 0.0f);
            float f2 = iAnimatable.getVariableFloat(string3, 0.0f);
            if (!liveAnimNode.isActive()) continue;
            liveAnimNode.getSourceNode().m_picker.render(f, f2);
        }
    }

    private void logBlendWeights() {
        AnimationPlayerRecorder animationPlayerRecorder = this.m_Character.getAnimationPlayer().getRecorder();
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
            animationPlayerRecorder.logAnimNode(liveAnimNode);
        }
    }

    private void logCurrentState() {
        AnimationPlayerRecorder animationPlayerRecorder = this.m_Character.getAnimationPlayer().getRecorder();
        animationPlayerRecorder.logAnimState(this.m_State);
    }

    private void removeLiveNodeAt(int n) {
        LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(n);
        AnimationMultiTrack animationMultiTrack = this.getAnimationTrack();
        animationMultiTrack.removeTracks(liveAnimNode.m_AnimationTracks);
        animationMultiTrack.removeTrack(liveAnimNode.getTransitionInTrack());
        this.m_liveAnimNodes.remove(n).release();
    }

    private void applyBlendField(LiveAnimNode liveAnimNode, float f, float f2) {
        Object object;
        if (liveAnimNode.isActive()) {
            AnimNode animNode = liveAnimNode.getSourceNode();
            Anim2DBlendPicker anim2DBlendPicker = animNode.m_picker;
            object = anim2DBlendPicker.Pick(f, f2);
            Anim2DBlend anim2DBlend = ((Anim2DBlendPicker.PickResults)object).node1;
            Anim2DBlend anim2DBlend2 = ((Anim2DBlendPicker.PickResults)object).node2;
            Anim2DBlend anim2DBlend3 = ((Anim2DBlendPicker.PickResults)object).node3;
            if (Float.isNaN(((Anim2DBlendPicker.PickResults)object).scale1)) {
                ((Anim2DBlendPicker.PickResults)object).scale1 = 0.5f;
            }
            if (Float.isNaN(((Anim2DBlendPicker.PickResults)object).scale2)) {
                ((Anim2DBlendPicker.PickResults)object).scale2 = 0.5f;
            }
            if (Float.isNaN(((Anim2DBlendPicker.PickResults)object).scale3)) {
                ((Anim2DBlendPicker.PickResults)object).scale3 = 0.5f;
            }
            float f3 = ((Anim2DBlendPicker.PickResults)object).scale1;
            float f4 = ((Anim2DBlendPicker.PickResults)object).scale2;
            float f5 = ((Anim2DBlendPicker.PickResults)object).scale3;
            for (int i = 0; i < liveAnimNode.m_AnimationTracks.size(); ++i) {
                Anim2DBlend anim2DBlend4 = animNode.m_2DBlends.get(i);
                AnimationTrack animationTrack = liveAnimNode.m_AnimationTracks.get(i);
                animationTrack.blendFieldWeight = anim2DBlend4 == anim2DBlend ? AnimationPlayer.lerpBlendWeight(animationTrack.blendFieldWeight, f3, 0.15f) : (anim2DBlend4 == anim2DBlend2 ? AnimationPlayer.lerpBlendWeight(animationTrack.blendFieldWeight, f4, 0.15f) : (anim2DBlend4 == anim2DBlend3 ? AnimationPlayer.lerpBlendWeight(animationTrack.blendFieldWeight, f5, 0.15f) : AnimationPlayer.lerpBlendWeight(animationTrack.blendFieldWeight, 0.0f, 0.15f)));
                if (animationTrack.blendFieldWeight < 1.0E-4f) {
                    animationTrack.blendFieldWeight = 0.0f;
                }
                animationTrack.blendFieldWeight = PZMath.clamp(animationTrack.blendFieldWeight, 0.0f, 1.0f);
            }
        }
        float f6 = liveAnimNode.getWeight();
        for (int i = 0; i < liveAnimNode.m_AnimationTracks.size(); ++i) {
            object = liveAnimNode.m_AnimationTracks.get(i);
            ((AnimationTrack)object).BlendDelta = ((AnimationTrack)object).blendFieldWeight * f6;
        }
    }

    private void getOrCreateLiveNode(AnimNode animNode) {
        LiveAnimNode liveAnimNode = this.findLiveNode(animNode);
        if (liveAnimNode != null) {
            liveAnimNode.setActive(true);
            return;
        }
        liveAnimNode = LiveAnimNode.alloc(this, animNode, this.getDepth());
        if (animNode.m_2DBlends.size() > 0) {
            int n = animNode.m_2DBlends.size();
            for (int i = 0; i < n; ++i) {
                Anim2DBlend anim2DBlend = animNode.m_2DBlends.get(i);
                this.startAnimTrack(anim2DBlend.m_AnimName, liveAnimNode);
            }
        } else {
            this.startAnimTrack(animNode.m_AnimName, liveAnimNode);
        }
        liveAnimNode.setActive(true);
        this.m_liveAnimNodes.add(liveAnimNode);
    }

    private LiveAnimNode findLiveNode(AnimNode animNode) {
        LiveAnimNode liveAnimNode = null;
        int n = this.m_liveAnimNodes.size();
        for (int i = 0; i < n; ++i) {
            LiveAnimNode liveAnimNode2 = this.m_liveAnimNodes.get(i);
            if (liveAnimNode2.m_TransitioningOut) continue;
            if (liveAnimNode2.getSourceNode() == animNode) {
                liveAnimNode = liveAnimNode2;
                break;
            }
            if (liveAnimNode2.getSourceNode().m_State != animNode.m_State || !liveAnimNode2.getSourceNode().m_Name.equals(animNode.m_Name)) continue;
            liveAnimNode = liveAnimNode2;
            break;
        }
        return liveAnimNode;
    }

    private void startAnimTrack(String string, LiveAnimNode liveAnimNode) {
        AnimNode animNode = liveAnimNode.getSourceNode();
        float f = animNode.getSpeedScale(this.m_Character);
        float f2 = Rand.Next(0.0f, 1.0f);
        float f3 = animNode.m_SpeedScaleRandomMultiplierMin;
        float f4 = animNode.m_SpeedScaleRandomMultiplierMax;
        float f5 = PZMath.lerp(f3, f4, f2);
        StartAnimTrackParameters startAnimTrackParameters = StartAnimTrackParameters.alloc();
        startAnimTrackParameters.subLayerBoneWeights = animNode.m_SubStateBoneWeights;
        startAnimTrackParameters.syncTrackingEnabled = animNode.m_SyncTrackingEnabled;
        startAnimTrackParameters.speedScale = f * f5;
        startAnimTrackParameters.initialWeight = liveAnimNode.getWeight();
        startAnimTrackParameters.isLooped = liveAnimNode.isLooped();
        startAnimTrackParameters.isReversed = animNode.m_AnimReverse;
        startAnimTrackParameters.deferredBoneName = animNode.getDeferredBoneName();
        startAnimTrackParameters.deferredBoneAxis = animNode.getDeferredBoneAxis();
        startAnimTrackParameters.useDeferredRotation = animNode.m_useDeferedRotation;
        startAnimTrackParameters.priority = animNode.getPriority();
        AnimationTrack animationTrack = this.startAnimTrack(string, startAnimTrackParameters);
        startAnimTrackParameters.release();
        if (animationTrack != null) {
            animationTrack.addListener(liveAnimNode);
            liveAnimNode.addMainTrack(animationTrack);
        }
    }

    private AnimationTrack startAnimTrack(String string, StartAnimTrackParameters startAnimTrackParameters) {
        AnimationPlayer animationPlayer = this.m_Character.getAnimationPlayer();
        if (!animationPlayer.isReady()) {
            return null;
        }
        AnimationTrack animationTrack = animationPlayer.play(string, startAnimTrackParameters.isLooped);
        if (animationTrack == null) {
            return null;
        }
        SkinningData skinningData = animationPlayer.getSkinningData();
        if (this.isSubLayer()) {
            animationTrack.setBoneWeights(startAnimTrackParameters.subLayerBoneWeights);
            animationTrack.initBoneWeights(skinningData);
        } else {
            animationTrack.setBoneWeights(null);
        }
        SkinningBone skinningBone = skinningData.getBone(startAnimTrackParameters.deferredBoneName);
        if (skinningBone == null) {
            DebugLog.Animation.error("Deferred bone not found: \"%s\"", startAnimTrackParameters.deferredBoneName);
        }
        animationTrack.SpeedDelta = startAnimTrackParameters.speedScale;
        animationTrack.SyncTrackingEnabled = startAnimTrackParameters.syncTrackingEnabled;
        animationTrack.setDeferredBone(skinningBone, startAnimTrackParameters.deferredBoneAxis);
        animationTrack.setUseDeferredRotation(startAnimTrackParameters.useDeferredRotation);
        animationTrack.BlendDelta = startAnimTrackParameters.initialWeight;
        animationTrack.setLayerIdx(this.getDepth());
        animationTrack.reverse = startAnimTrackParameters.isReversed;
        animationTrack.priority = startAnimTrackParameters.priority;
        animationTrack.addListener(this);
        return animationTrack;
    }

    public int getDepth() {
        if (this.m_parentLayer != null) {
            return this.m_parentLayer.getDepth() + 1;
        }
        return 0;
    }

    private LiveAnimNode getHighestLiveNode() {
        if (this.m_liveAnimNodes.isEmpty()) {
            return null;
        }
        LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(0);
        for (int i = this.m_liveAnimNodes.size() - 1; i >= 0; --i) {
            LiveAnimNode liveAnimNode2 = this.m_liveAnimNodes.get(i);
            if (!(liveAnimNode2.getWeight() > liveAnimNode.getWeight())) continue;
            liveAnimNode = liveAnimNode2;
        }
        return liveAnimNode;
    }

    private AnimationTrack findSyncTrack(LiveAnimNode liveAnimNode) {
        AnimationTrack animationTrack = null;
        if (this.m_parentLayer != null && (animationTrack = this.m_parentLayer.getCurrentSyncTrack()) != null) {
            return animationTrack;
        }
        int n = liveAnimNode.getPlayingTrackCount();
        for (int i = 0; i < n; ++i) {
            AnimationTrack animationTrack2 = liveAnimNode.getPlayingTrackAt(i);
            if (!animationTrack2.SyncTrackingEnabled || !animationTrack2.hasClip() || animationTrack != null && !(animationTrack2.BlendDelta > animationTrack.BlendDelta)) continue;
            animationTrack = animationTrack2;
        }
        return animationTrack;
    }

    public String getDebugNodeName() {
        Object object = this.m_Character.getAdvancedAnimator().animSet.m_Name;
        if (this.m_State != null) {
            object = (String)object + "/" + this.m_State.m_Name;
            if (this.m_CurrentNode != null) {
                object = (String)object + "/" + this.m_CurrentNode.m_Name + ": " + this.m_CurrentNode.m_AnimName;
            } else if (!this.m_liveAnimNodes.isEmpty()) {
                for (int i = 0; i < this.m_liveAnimNodes.size(); ++i) {
                    LiveAnimNode liveAnimNode = this.m_liveAnimNodes.get(i);
                    if (!this.m_State.m_Nodes.contains(liveAnimNode.getSourceNode())) continue;
                    object = (String)object + "/" + liveAnimNode.getName();
                    break;
                }
            }
        }
        return object;
    }

    public List<LiveAnimNode> getLiveAnimNodes() {
        return this.m_liveAnimNodes;
    }

    public boolean isRecording() {
        return this.m_Character.getAdvancedAnimator().isRecording();
    }

    static {
        AnimLayer.s_activeAnimLoopedEvent.m_TimePc = 1.0f;
        AnimLayer.s_activeAnimLoopedEvent.m_EventName = "ActiveAnimLooped";
        s_activeNonLoopedAnimFadeOutEvent = new AnimEvent();
        AnimLayer.s_activeNonLoopedAnimFadeOutEvent.m_TimePc = 1.0f;
        AnimLayer.s_activeNonLoopedAnimFadeOutEvent.m_EventName = "NonLoopedAnimFadeOut";
        s_activeAnimFinishingEvent = new AnimEvent();
        AnimLayer.s_activeAnimFinishingEvent.m_Time = AnimEvent.AnimEventTime.End;
        AnimLayer.s_activeAnimFinishingEvent.m_EventName = "ActiveAnimFinishing";
        s_activeNonLoopedAnimFinishedEvent = new AnimEvent();
        AnimLayer.s_activeNonLoopedAnimFinishedEvent.m_Time = AnimEvent.AnimEventTime.End;
        AnimLayer.s_activeNonLoopedAnimFinishedEvent.m_EventName = "ActiveAnimFinished";
    }

    private static class StartAnimTrackParameters
    extends PooledObject {
        public int priority;
        List<AnimBoneWeight> subLayerBoneWeights;
        boolean syncTrackingEnabled;
        float speedScale;
        float initialWeight;
        boolean isLooped;
        boolean isReversed;
        String deferredBoneName;
        BoneAxis deferredBoneAxis;
        boolean useDeferredRotation;
        private static final Pool<StartAnimTrackParameters> s_pool = new Pool<StartAnimTrackParameters>(StartAnimTrackParameters::new);

        private void reset() {
            this.priority = 0;
            this.subLayerBoneWeights = null;
            this.syncTrackingEnabled = false;
            this.speedScale = 1.0f;
            this.initialWeight = 0.0f;
            this.isLooped = false;
            this.isReversed = false;
            this.deferredBoneName = null;
            this.deferredBoneAxis = BoneAxis.Y;
            this.useDeferredRotation = false;
        }

        @Override
        public void onReleased() {
            this.reset();
        }

        protected StartAnimTrackParameters() {
        }

        public static StartAnimTrackParameters alloc() {
            return s_pool.alloc();
        }
    }
}

