/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.List;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableHandle;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSource;

public final class AnimCondition {
    public String m_Name = "";
    public Type m_Type = Type.STRING;
    public float m_FloatValue = 0.0f;
    public boolean m_BoolValue = false;
    public String m_StringValue = "";
    private AnimationVariableHandle m_variableHandle;

    public String toString() {
        return String.format("AnimCondition{name:%s type:%s value:%s }", this.m_Name, this.m_Type.toString(), this.getValueString());
    }

    public String getConditionString() {
        if (this.m_Type == Type.OR) {
            return "OR";
        }
        return String.format("( %s %s %s )", this.m_Name, this.m_Type.toString(), this.getValueString());
    }

    public String getValueString() {
        switch (this.m_Type) {
            case EQU: 
            case NEQ: 
            case LESS: 
            case GTR: {
                return String.valueOf(this.m_FloatValue);
            }
            case BOOL: {
                return this.m_BoolValue ? "true" : "false";
            }
            case STRING: 
            case STRNEQ: {
                return this.m_StringValue;
            }
            case OR: {
                return " -- OR -- ";
            }
        }
        throw new RuntimeException("Unexpected internal type:" + this.m_Type);
    }

    public boolean check(IAnimationVariableSource iAnimationVariableSource) {
        return this.checkInternal(iAnimationVariableSource);
    }

    private boolean checkInternal(IAnimationVariableSource iAnimationVariableSource) {
        Type type = this.m_Type;
        if (type == Type.OR) {
            return false;
        }
        if (this.m_variableHandle == null) {
            this.m_variableHandle = AnimationVariableHandle.alloc(this.m_Name);
        }
        IAnimationVariableSlot iAnimationVariableSlot = iAnimationVariableSource.getVariable(this.m_variableHandle);
        switch (type) {
            case EQU: {
                return iAnimationVariableSlot != null && this.m_FloatValue == iAnimationVariableSlot.getValueFloat();
            }
            case NEQ: {
                return iAnimationVariableSlot != null && this.m_FloatValue != iAnimationVariableSlot.getValueFloat();
            }
            case LESS: {
                return iAnimationVariableSlot != null && iAnimationVariableSlot.getValueFloat() < this.m_FloatValue;
            }
            case GTR: {
                return iAnimationVariableSlot != null && iAnimationVariableSlot.getValueFloat() > this.m_FloatValue;
            }
            case BOOL: {
                return (iAnimationVariableSlot != null && iAnimationVariableSlot.getValueBool()) == this.m_BoolValue;
            }
            case STRING: {
                return this.m_StringValue.equalsIgnoreCase(iAnimationVariableSlot != null ? iAnimationVariableSlot.getValueString() : "");
            }
            case STRNEQ: {
                return !this.m_StringValue.equalsIgnoreCase(iAnimationVariableSlot != null ? iAnimationVariableSlot.getValueString() : "");
            }
            case OR: {
                return false;
            }
        }
        throw new RuntimeException("Unexpected internal type:" + this.m_Type);
    }

    public static boolean pass(IAnimationVariableSource iAnimationVariableSource, List<AnimCondition> list) {
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            AnimCondition animCondition = list.get(i);
            if (animCondition.m_Type == Type.OR) {
                if (bl) break;
                bl = true;
                continue;
            }
            bl = bl && animCondition.check(iAnimationVariableSource);
        }
        return bl;
    }

    public static enum Type {
        STRING,
        STRNEQ,
        BOOL,
        EQU,
        NEQ,
        LESS,
        GTR,
        OR;

    }
}

