/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel.advancedanimation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlend;
import zombie.core.skinnedmodel.advancedanimation.Anim2DBlendTriangle;

public final class Anim2DBlendPicker {
    private List<Anim2DBlendTriangle> m_tris;
    private List<Anim2DBlend> m_hull;
    private HullComparer m_hullComparer;

    public void SetPickTriangles(List<Anim2DBlendTriangle> list) {
        this.m_tris = list;
        this.BuildHull();
    }

    private void BuildHull() {
        HashMap<Edge, Counter> hashMap = new HashMap<Edge, Counter>();
        Counter counter2 = new Counter();
        for (Anim2DBlendTriangle object2 : this.m_tris) {
            Counter f = hashMap.putIfAbsent(new Edge(object2.node1, object2.node2), counter2);
            if (f == null) {
                f = counter2;
                counter2 = new Counter();
            }
            f.Increment();
            f = hashMap.putIfAbsent(new Edge(object2.node2, object2.node3), counter2);
            if (f == null) {
                f = counter2;
                counter2 = new Counter();
            }
            f.Increment();
            f = hashMap.putIfAbsent(new Edge(object2.node3, object2.node1), counter2);
            if (f == null) {
                f = counter2;
                counter2 = new Counter();
            }
            f.Increment();
        }
        HashSet hashSet = new HashSet();
        hashMap.forEach((edge, counter) -> {
            if (counter.count == 1) {
                hashSet.add(edge.a);
                hashSet.add(edge.b);
            }
        });
        ArrayList<Anim2DBlend> arrayList = new ArrayList<Anim2DBlend>(hashSet);
        float f = 0.0f;
        float f2 = 0.0f;
        for (Anim2DBlend anim2DBlend : arrayList) {
            f += anim2DBlend.m_XPos;
            f2 += anim2DBlend.m_YPos;
        }
        this.m_hullComparer = new HullComparer(f /= (float)arrayList.size(), f2 /= (float)arrayList.size());
        arrayList.sort(this.m_hullComparer);
        this.m_hull = arrayList;
    }

    static <T> int LowerBoundIdx(List<T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size();
        while (n != n2) {
            int n3 = (n + n2) / 2;
            if (comparator.compare(t, list.get(n3)) < 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    private static float ProjectPointToLine(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f - f3;
        float f8 = f2 - f4;
        float f9 = f5 - f3;
        float f10 = f6 - f4;
        return (f9 * f7 + f10 * f8) / (f9 * f9 + f10 * f10);
    }

    public PickResults Pick(float f, float f2) {
        PickResults pickResults = new PickResults();
        for (Anim2DBlendTriangle anim2DBlendTriangle : this.m_tris) {
            if (!anim2DBlendTriangle.Contains(f, f2)) continue;
            pickResults.numNodes = 3;
            pickResults.node1 = anim2DBlendTriangle.node1;
            pickResults.node2 = anim2DBlendTriangle.node2;
            pickResults.node3 = anim2DBlendTriangle.node3;
            float f3 = pickResults.node1.m_XPos;
            float f4 = pickResults.node1.m_YPos;
            float f5 = pickResults.node2.m_XPos;
            float f6 = pickResults.node2.m_YPos;
            float f7 = pickResults.node3.m_XPos;
            float f8 = pickResults.node3.m_YPos;
            pickResults.scale1 = ((f6 - f8) * (f - f7) + (f7 - f5) * (f2 - f8)) / ((f6 - f8) * (f3 - f7) + (f7 - f5) * (f4 - f8));
            pickResults.scale2 = ((f8 - f4) * (f - f7) + (f3 - f7) * (f2 - f8)) / ((f6 - f8) * (f3 - f7) + (f7 - f5) * (f4 - f8));
            pickResults.scale3 = 1.0f - pickResults.scale1 - pickResults.scale2;
            return pickResults;
        }
        Anim2DBlend anim2DBlend = new Anim2DBlend();
        anim2DBlend.m_XPos = f *= 1.1f;
        anim2DBlend.m_YPos = f2 *= 1.1f;
        int n = Anim2DBlendPicker.LowerBoundIdx(this.m_hull, anim2DBlend, this.m_hullComparer);
        if (n == this.m_hull.size()) {
            n = 0;
        }
        int n2 = n > 0 ? n - 1 : this.m_hull.size() - 1;
        Anim2DBlend anim2DBlend2 = this.m_hull.get(n);
        Anim2DBlend anim2DBlend3 = this.m_hull.get(n2);
        float f9 = Anim2DBlendPicker.ProjectPointToLine(f, f2, anim2DBlend2.m_XPos, anim2DBlend2.m_YPos, anim2DBlend3.m_XPos, anim2DBlend3.m_YPos);
        if (f9 < 0.0f) {
            pickResults.numNodes = 1;
            pickResults.node1 = anim2DBlend2;
            pickResults.scale1 = 1.0f;
        } else if (f9 > 1.0f) {
            pickResults.numNodes = 1;
            pickResults.node1 = anim2DBlend3;
            pickResults.scale1 = 1.0f;
        } else {
            pickResults.numNodes = 2;
            pickResults.node1 = anim2DBlend2;
            pickResults.node2 = anim2DBlend3;
            pickResults.scale1 = 1.0f - f9;
            pickResults.scale2 = f9;
        }
        return pickResults;
    }

    void render(float f, float f2) {
        Object object;
        int n = 200;
        int n2 = Core.getInstance().getScreenWidth() - n - 100;
        int n3 = Core.getInstance().getScreenHeight() - n - 100;
        SpriteRenderer.instance.renderi(null, n2 - 20, n3 - 20, n + 40, n + 40, 1.0f, 1.0f, 1.0f, 1.0f, null);
        for (int i = 0; i < this.m_tris.size(); ++i) {
            object = this.m_tris.get(i);
            SpriteRenderer.instance.renderline(null, (int)((float)(n2 + n / 2) + ((Anim2DBlendTriangle)object).node1.m_XPos * (float)n / 2.0f), (int)((float)(n3 + n / 2) - ((Anim2DBlendTriangle)object).node1.m_YPos * (float)n / 2.0f), (int)((float)(n2 + n / 2) + ((Anim2DBlendTriangle)object).node2.m_XPos * (float)n / 2.0f), (int)((float)(n3 + n / 2) - ((Anim2DBlendTriangle)object).node2.m_YPos * (float)n / 2.0f), 0.5f, 0.5f, 0.5f, 1.0f);
            SpriteRenderer.instance.renderline(null, (int)((float)(n2 + n / 2) + ((Anim2DBlendTriangle)object).node2.m_XPos * (float)n / 2.0f), (int)((float)(n3 + n / 2) - ((Anim2DBlendTriangle)object).node2.m_YPos * (float)n / 2.0f), (int)((float)(n2 + n / 2) + ((Anim2DBlendTriangle)object).node3.m_XPos * (float)n / 2.0f), (int)((float)(n3 + n / 2) - ((Anim2DBlendTriangle)object).node3.m_YPos * (float)n / 2.0f), 0.5f, 0.5f, 0.5f, 1.0f);
            SpriteRenderer.instance.renderline(null, (int)((float)(n2 + n / 2) + ((Anim2DBlendTriangle)object).node3.m_XPos * (float)n / 2.0f), (int)((float)(n3 + n / 2) - ((Anim2DBlendTriangle)object).node3.m_YPos * (float)n / 2.0f), (int)((float)(n2 + n / 2) + ((Anim2DBlendTriangle)object).node1.m_XPos * (float)n / 2.0f), (int)((float)(n3 + n / 2) - ((Anim2DBlendTriangle)object).node1.m_YPos * (float)n / 2.0f), 0.5f, 0.5f, 0.5f, 1.0f);
        }
        float f3 = 8.0f;
        object = this.Pick(f, f2);
        if (((PickResults)object).node1 != null) {
            SpriteRenderer.instance.render(null, (float)(n2 + n / 2) + ((PickResults)object).node1.m_XPos * (float)n / 2.0f - f3 / 2.0f, (float)(n3 + n / 2) - ((PickResults)object).node1.m_YPos * (float)n / 2.0f - f3 / 2.0f, f3, f3, 0.0f, 1.0f, 0.0f, 1.0f, null);
        }
        if (((PickResults)object).node2 != null) {
            SpriteRenderer.instance.render(null, (float)(n2 + n / 2) + ((PickResults)object).node2.m_XPos * (float)n / 2.0f - f3 / 2.0f, (float)(n3 + n / 2) - ((PickResults)object).node2.m_YPos * (float)n / 2.0f - f3 / 2.0f, f3, f3, 0.0f, 1.0f, 0.0f, 1.0f, null);
        }
        if (((PickResults)object).node3 != null) {
            SpriteRenderer.instance.render(null, (float)(n2 + n / 2) + ((PickResults)object).node3.m_XPos * (float)n / 2.0f - f3 / 2.0f, (float)(n3 + n / 2) - ((PickResults)object).node3.m_YPos * (float)n / 2.0f - f3 / 2.0f, f3, f3, 0.0f, 1.0f, 0.0f, 1.0f, null);
        }
        f3 = 4.0f;
        SpriteRenderer.instance.render(null, (float)(n2 + n / 2) + f * (float)n / 2.0f - f3 / 2.0f, (float)(n3 + n / 2) - f2 * (float)n / 2.0f - f3 / 2.0f, f3, f3, 0.0f, 0.0f, 1.0f, 1.0f, null);
    }

    static class Counter {
        public int count = 0;

        Counter() {
        }

        public int Increment() {
            return ++this.count;
        }
    }

    static class Edge {
        public Anim2DBlend a;
        public Anim2DBlend b;

        public Edge(Anim2DBlend anim2DBlend, Anim2DBlend anim2DBlend2) {
            boolean bl;
            if (anim2DBlend.m_XPos != anim2DBlend2.m_XPos) {
                bl = anim2DBlend.m_XPos > anim2DBlend2.m_XPos;
            } else {
                boolean bl2 = bl = anim2DBlend.m_YPos > anim2DBlend2.m_YPos;
            }
            if (bl) {
                this.a = anim2DBlend2;
                this.b = anim2DBlend;
            } else {
                this.a = anim2DBlend;
                this.b = anim2DBlend2;
            }
        }

        public int hashCode() {
            int n = this.a.hashCode();
            int n2 = this.b.hashCode();
            return (n << 5) + n ^ n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Edge) {
                return this.a == ((Edge)object).a && this.b == ((Edge)object).b;
            }
            return false;
        }
    }

    static class HullComparer
    implements Comparator<Anim2DBlend> {
        private int centerX;
        private int centerY;

        public HullComparer(float f, float f2) {
            this.centerX = (int)(f * 1000.0f);
            this.centerY = (int)(f2 * 1000.0f);
        }

        public boolean isLessThan(Anim2DBlend anim2DBlend, Anim2DBlend anim2DBlend2) {
            int n = (int)(anim2DBlend.m_XPos * 1000.0f);
            int n2 = (int)(anim2DBlend.m_YPos * 1000.0f);
            int n3 = (int)(anim2DBlend2.m_XPos * 1000.0f);
            int n4 = (int)(anim2DBlend2.m_YPos * 1000.0f);
            int n5 = n - this.centerX;
            int n6 = n2 - this.centerY;
            int n7 = n3 - this.centerX;
            int n8 = n4 - this.centerY;
            if (n6 == 0 && n5 > 0) {
                return true;
            }
            if (n8 == 0 && n7 > 0) {
                return false;
            }
            if (n6 > 0 && n8 < 0) {
                return true;
            }
            if (n6 < 0 && n8 > 0) {
                return false;
            }
            int n9 = n5 * n8 - n6 * n7;
            return n9 > 0;
        }

        @Override
        public int compare(Anim2DBlend anim2DBlend, Anim2DBlend anim2DBlend2) {
            if (this.isLessThan(anim2DBlend, anim2DBlend2)) {
                return -1;
            }
            if (this.isLessThan(anim2DBlend2, anim2DBlend)) {
                return 1;
            }
            return 0;
        }
    }

    public static class PickResults {
        public int numNodes;
        public Anim2DBlend node1;
        public Anim2DBlend node2;
        public Anim2DBlend node3;
        public float scale1;
        public float scale2;
        public float scale3;
    }
}

