/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.Util;
import zombie.DebugFileWatcher;
import zombie.GameWindow;
import zombie.PredicatedFileWatcher;
import zombie.ZomboidFileSystem;
import zombie.asset.Asset;
import zombie.asset.AssetPath;
import zombie.characters.AttachedItems.AttachedItem;
import zombie.characters.AttachedItems.AttachedModels;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.skinnedmodel.advancedanimation.AdvancedAnimator;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.SoftwareSkinnedModelAnim;
import zombie.core.skinnedmodel.animation.StaticAnimation;
import zombie.core.skinnedmodel.model.AnimationAsset;
import zombie.core.skinnedmodel.model.AnimationAssetManager;
import zombie.core.skinnedmodel.model.MeshAssetManager;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelAssetManager;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceTextureInitializer;
import zombie.core.skinnedmodel.model.ModelMesh;
import zombie.core.skinnedmodel.model.SkinningData;
import zombie.core.skinnedmodel.model.VehicleModelInstance;
import zombie.core.skinnedmodel.model.VehicleSubModelInstance;
import zombie.core.skinnedmodel.population.PopTemplateManager;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;
import zombie.core.textures.TextureID;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.gameStates.ChooseGameInfo;
import zombie.interfaces.ITexture;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponPart;
import zombie.iso.FireShader;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWater;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LosUtil;
import zombie.iso.ParticlesFire;
import zombie.iso.PlayerCamera;
import zombie.iso.PuddlesShader;
import zombie.iso.SmokeShader;
import zombie.iso.Vector2;
import zombie.iso.WaterShader;
import zombie.iso.sprite.SkyBox;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.AnimationsMesh;
import zombie.scripting.objects.ItemReplacement;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.ModelWeaponPart;
import zombie.scripting.objects.VehicleScript;
import zombie.util.Lambda;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;

public final class ModelManager {
    public static boolean NoOpenGL = false;
    public static final ModelManager instance = new ModelManager();
    private final HashMap<String, Model> m_modelMap = new HashMap();
    public Model m_maleModel;
    public Model m_femaleModel;
    public Model m_skeletonMaleModel;
    public Model m_skeletonFemaleModel;
    public TextureFBO bitmap;
    private boolean m_bCreated = false;
    public boolean bDebugEnableModels = true;
    public boolean bCreateSoftwareMeshes = false;
    public final HashMap<String, SoftwareSkinnedModelAnim> SoftwareMeshAnims = new HashMap();
    private final ArrayList<ModelSlot> m_modelSlots = new ArrayList();
    private final ObjectPool<ModelInstance> m_modelInstancePool = new ObjectPool<ModelInstance>(ModelInstance::new);
    private final ArrayList<WeaponPart> m_tempWeaponPartList = new ArrayList();
    private ModelMesh m_animModel;
    private final HashMap<String, AnimationAsset> m_animationAssets = new HashMap();
    private final ModAnimations m_gameAnimations = new ModAnimations("game");
    private final HashMap<String, ModAnimations> m_modAnimations = new HashMap();
    private final ArrayList<StaticAnimation> m_cachedAnims = new ArrayList();
    private final HashSet<IsoGameCharacter> m_contains = new HashSet();
    private final ArrayList<IsoGameCharacter.TorchInfo> m_torches = new ArrayList();
    private final Stack<IsoLightSource> m_freeLights = new Stack();
    private final ArrayList<IsoLightSource> m_torchLights = new ArrayList();
    private final ArrayList<IsoGameCharacter> ToRemove = new ArrayList();
    private final ArrayList<IsoGameCharacter> ToResetNextFrame = new ArrayList();
    private final ArrayList<IsoGameCharacter> ToResetEquippedNextFrame = new ArrayList();
    private final ArrayList<ModelSlot> m_resetAfterRender = new ArrayList();
    private final Stack<IsoLightSource> m_lights = new Stack();
    private final Stack<IsoLightSource> m_lightsTemp = new Stack();
    private final Vector2 m_tempVec2 = new Vector2();
    private final Vector2 m_tempVec2_2 = new Vector2();
    private static final TreeMap<String, ModelMetaData> modelMetaData = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    static String basicEffect = "basicEffect";
    static String isStaticTrue = ";isStatic=true";
    static String shaderEquals = "shader=";
    static String texA = ";tex=";
    static String amp = "&";
    static HashMap<String, String> toLower = new HashMap();
    static HashMap<String, String> toLowerTex = new HashMap();
    static HashMap<String, String> toLowerKeyRoot = new HashMap();
    static StringBuilder builder = new StringBuilder();

    public boolean isCreated() {
        return this.m_bCreated;
    }

    public void create() {
        Object object;
        Object object2;
        if (this.m_bCreated) {
            return;
        }
        if (!GameServer.bServer || ServerGUI.isCreated()) {
            object2 = new Texture(1024, 1024, 16);
            PerformanceSettings.UseFBOs = false;
            try {
                this.bitmap = new TextureFBO((ITexture)object2, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                PerformanceSettings.UseFBOs = false;
                DebugLog.Animation.error("FBO not compatible with gfx card at this time.");
                return;
            }
        }
        DebugLog.Animation.println("Loading 3D models");
        this.initAnimationMeshes(false);
        this.m_modAnimations.put(this.m_gameAnimations.m_modID, this.m_gameAnimations);
        object2 = ScriptManager.instance.getAnimationsMesh("Human");
        ModelMesh modelMesh = ((AnimationsMesh)object2).modelMesh;
        if (!NoOpenGL && this.bCreateSoftwareMeshes) {
            object = new SoftwareSkinnedModelAnim(this.m_cachedAnims.toArray(new StaticAnimation[0]), modelMesh.softwareMesh, modelMesh.skinningData);
            this.SoftwareMeshAnims.put(modelMesh.getPath().getPath(), (SoftwareSkinnedModelAnim)object);
        }
        object = this.loadModel("skinned/malebody", null, modelMesh);
        Model model = this.loadModel("skinned/femalebody", null, modelMesh);
        Model model2 = this.loadModel("skinned/Male_Skeleton", null, modelMesh);
        Model model3 = this.loadModel("skinned/Female_Skeleton", null, modelMesh);
        this.m_animModel = modelMesh;
        this.loadModAnimations();
        ((Asset)object).addDependency(this.getAnimationAssetRequired("bob/bob_idle"));
        ((Asset)object).addDependency(this.getAnimationAssetRequired("bob/bob_walk"));
        ((Asset)object).addDependency(this.getAnimationAssetRequired("bob/bob_run"));
        model.addDependency(this.getAnimationAssetRequired("bob/bob_idle"));
        model.addDependency(this.getAnimationAssetRequired("bob/bob_walk"));
        model.addDependency(this.getAnimationAssetRequired("bob/bob_run"));
        this.m_maleModel = object;
        this.m_femaleModel = model;
        this.m_skeletonMaleModel = model2;
        this.m_skeletonFemaleModel = model3;
        this.m_bCreated = true;
        AdvancedAnimator.systemInit();
        PopTemplateManager.instance.init();
    }

    public void loadAdditionalModel(String string, String string2, boolean bl, String string3) {
        boolean bl2 = this.bCreateSoftwareMeshes;
        if (DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.debugln("createSoftwareMesh: %B, model: %s", bl2, string);
        }
        Model model = this.loadModelInternal(string, string2, string3, this.m_animModel, bl);
        if (bl2) {
            SoftwareSkinnedModelAnim softwareSkinnedModelAnim = new SoftwareSkinnedModelAnim(this.m_cachedAnims.toArray(new StaticAnimation[0]), model.softwareMesh, (SkinningData)model.Tag);
            this.SoftwareMeshAnims.put(string.toLowerCase(), softwareSkinnedModelAnim);
        }
    }

    public ModelInstance newAdditionalModelInstance(String string, String string2, IsoGameCharacter isoGameCharacter, AnimationPlayer animationPlayer, String string3) {
        Model model = this.tryGetLoadedModel(string, string2, false, string3, false);
        if (model == null) {
            boolean bl = false;
            instance.loadAdditionalModel(string, string2, bl, string3);
        }
        model = this.getLoadedModel(string, string2, false, string3);
        return this.newInstance(model, isoGameCharacter, animationPlayer);
    }

    private void loadAnimsFromDir(String string, ModelMesh modelMesh) {
        File file = new File(ZomboidFileSystem.instance.base, string);
        this.loadAnimsFromDir(ZomboidFileSystem.instance.baseURI, ZomboidFileSystem.instance.getMediaRootFile().toURI(), file, modelMesh, this.m_gameAnimations);
    }

    private void loadAnimsFromDir(URI uRI, URI uRI2, File file, ModelMesh modelMesh, ModAnimations modAnimations) {
        Object object;
        if (!file.exists()) {
            DebugLog.General.error("ERROR: %s", file.getPath());
            for (object = file.getParentFile(); object != null; object = ((File)object).getParentFile()) {
                DebugLog.General.error(" - Parent exists: %B, %s", ((File)object).exists(), ((File)object).getPath());
            }
        }
        if (!file.isDirectory()) {
            return;
        }
        object = file.listFiles();
        if (object == null) {
            return;
        }
        boolean bl = false;
        for (File file2 : object) {
            if (file2.isDirectory()) {
                this.loadAnimsFromDir(uRI, uRI2, file2, modelMesh, modAnimations);
                continue;
            }
            String string = ZomboidFileSystem.instance.getAnimName(uRI2, file2);
            this.loadAnim(string, modelMesh, modAnimations);
            bl = true;
            if (NoOpenGL || RenderThread.RenderThread != null) continue;
            Display.processMessages();
        }
        if (bl) {
            DebugFileWatcher.instance.add(new AnimDirReloader(uRI, uRI2, file.getPath(), modelMesh, modAnimations).GetFileWatcher());
        }
    }

    public void RenderSkyBox(TextureDraw textureDraw, int n, int n2, int n3, int n4) {
        int n5 = TextureFBO.getCurrentID();
        switch (n3) {
            case 1: {
                GL30.glBindFramebuffer((int)36160, (int)n4);
                break;
            }
            case 2: {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)n4);
                break;
            }
            case 3: {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)n4);
            }
        }
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)1.0, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glViewport((int)0, (int)0, (int)512, (int)512);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ARBShaderObjects.glUseProgramObjectARB((int)n);
        if (Shader.ShaderMap.containsKey(n)) {
            Shader.ShaderMap.get(n).startRenderThread(textureDraw);
        }
        GL11.glColor4f((float)0.13f, (float)0.96f, (float)0.13f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)1.0f, (float)1.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)1.0f, (float)0.0f);
        GL11.glEnd();
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n2);
        GL11.glViewport((int)0, (int)0, (int)playerCamera.OffscreenWidth, (int)playerCamera.OffscreenHeight);
        switch (n3) {
            case 1: {
                GL30.glBindFramebuffer((int)36160, (int)n5);
                break;
            }
            case 2: {
                ARBFramebufferObject.glBindFramebuffer((int)36160, (int)n5);
                break;
            }
            case 3: {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)n5);
            }
        }
        SkyBox.getInstance().swapTextureFBO();
    }

    public void RenderWater(TextureDraw textureDraw, int n, int n2, boolean bl) {
        try {
            Util.checkGLError();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        IsoWater.getInstance().waterProjection();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n2);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ARBShaderObjects.glUseProgramObjectARB((int)n);
        Shader shader = Shader.ShaderMap.get(n);
        if (shader instanceof WaterShader) {
            ((WaterShader)shader).updateWaterParams(textureDraw, n2);
        }
        IsoWater.getInstance().waterGeometry(bl);
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        if (!PZGLUtil.checkGLError(true)) {
            DebugLog.General.println("DEBUG: EXCEPTION RenderWater");
            PZGLUtil.printGLState(DebugLog.General);
        }
    }

    public void RenderPuddles(int n, int n2, int n3) {
        PZGLUtil.checkGLError(true);
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        IsoPuddles.getInstance().puddlesProjection();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        ARBShaderObjects.glUseProgramObjectARB((int)n);
        Shader shader = Shader.ShaderMap.get(n);
        if (shader instanceof PuddlesShader) {
            ((PuddlesShader)shader).updatePuddlesParams(n2, n3);
        }
        IsoPuddles.getInstance().puddlesGeometry(n3);
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        if (!PZGLUtil.checkGLError(true)) {
            DebugLog.General.println("DEBUG: EXCEPTION RenderPuddles");
            PZGLUtil.printGLState(DebugLog.General);
        }
    }

    public void RenderParticles(TextureDraw textureDraw, int n, int n2) {
        int n3 = ParticlesFire.getInstance().getFireShaderID();
        int n4 = ParticlesFire.getInstance().getSmokeShaderID();
        int n5 = ParticlesFire.getInstance().getVapeShaderID();
        try {
            Util.checkGLError();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushAttrib((int)1048575);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)SpriteRenderer.instance.getRenderingPlayerCamera((int)n).OffscreenWidth, (int)SpriteRenderer.instance.getRenderingPlayerCamera((int)n).OffscreenHeight);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float f = ParticlesFire.getInstance().getShaderTime();
        GL11.glBlendFunc((int)770, (int)1);
        ARBShaderObjects.glUseProgramObjectARB((int)n3);
        Shader shader = Shader.ShaderMap.get(n3);
        if (shader instanceof FireShader) {
            ((FireShader)shader).updateFireParams(textureDraw, n, f);
        }
        ParticlesFire.getInstance().getGeometryFire(n2);
        GL11.glBlendFunc((int)770, (int)771);
        ARBShaderObjects.glUseProgramObjectARB((int)n4);
        shader = Shader.ShaderMap.get(n4);
        if (shader instanceof SmokeShader) {
            ((SmokeShader)shader).updateSmokeParams(textureDraw, n, f);
        }
        ParticlesFire.getInstance().getGeometry(n2);
        ARBShaderObjects.glUseProgramObjectARB((int)0);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopClientAttrib();
        Texture.lastTextureID = -1;
        GL11.glViewport((int)0, (int)0, (int)SpriteRenderer.instance.getRenderingPlayerCamera((int)n).OffscreenWidth, (int)SpriteRenderer.instance.getRenderingPlayerCamera((int)n).OffscreenHeight);
        if (!PZGLUtil.checkGLError(true)) {
            DebugLog.General.println("DEBUG: EXCEPTION RenderParticles");
            PZGLUtil.printGLState(DebugLog.General);
        }
    }

    public void Reset(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.legsSprite == null || isoGameCharacter.legsSprite.modelSlot == null) {
            return;
        }
        ModelSlot modelSlot = isoGameCharacter.legsSprite.modelSlot;
        this.resetModelInstance(modelSlot.model, modelSlot);
        for (int i = 0; i < modelSlot.sub.size(); ++i) {
            ModelInstance modelInstance = modelSlot.sub.get(i);
            if (modelInstance == isoGameCharacter.primaryHandModel || modelInstance == isoGameCharacter.secondaryHandModel || modelSlot.attachedModels.contains(modelInstance)) continue;
            this.resetModelInstanceRecurse(modelInstance, modelSlot);
        }
        this.derefModelInstances(isoGameCharacter.getReadyModelData());
        isoGameCharacter.getReadyModelData().clear();
        this.dressInRandomOutfit(isoGameCharacter);
        Model model = this.getBodyModel(isoGameCharacter);
        modelSlot.model = this.newInstance(model, isoGameCharacter, isoGameCharacter.getAnimationPlayer());
        modelSlot.model.setOwner(modelSlot);
        modelSlot.model.m_modelScript = ScriptManager.instance.getModelScript(isoGameCharacter.isFemale() ? "FemaleBody" : "MaleBody");
        this.DoCharacterModelParts(isoGameCharacter, modelSlot);
    }

    public void reloadAllOutfits() {
        for (IsoGameCharacter isoGameCharacter : this.m_contains) {
            isoGameCharacter.reloadOutfit();
        }
    }

    public void Add(IsoGameCharacter isoGameCharacter) {
        if (!this.m_bCreated) {
            return;
        }
        if (!isoGameCharacter.isSceneCulled()) {
            return;
        }
        if (this.ToRemove.contains(isoGameCharacter)) {
            this.ToRemove.remove(isoGameCharacter);
            isoGameCharacter.legsSprite.modelSlot.bRemove = false;
            return;
        }
        ModelSlot modelSlot = this.getSlot(isoGameCharacter);
        modelSlot.framesSinceStart = 0;
        if (modelSlot.model != null) {
            RenderThread.invokeOnRenderContext(modelSlot.model::destroySmartTextures);
        }
        this.dressInRandomOutfit(isoGameCharacter);
        Model model = this.getBodyModel(isoGameCharacter);
        modelSlot.model = this.newInstance(model, isoGameCharacter, isoGameCharacter.getAnimationPlayer());
        modelSlot.model.setOwner(modelSlot);
        modelSlot.model.m_modelScript = ScriptManager.instance.getModelScript(isoGameCharacter.isFemale() ? "FemaleBody" : "MaleBody");
        this.DoCharacterModelParts(isoGameCharacter, modelSlot);
        modelSlot.active = true;
        modelSlot.character = isoGameCharacter;
        modelSlot.model.character = isoGameCharacter;
        modelSlot.model.object = isoGameCharacter;
        modelSlot.model.SetForceDir(modelSlot.model.character.getForwardDirection());
        for (int i = 0; i < modelSlot.sub.size(); ++i) {
            ModelInstance modelInstance = modelSlot.sub.get(i);
            modelInstance.character = isoGameCharacter;
            modelInstance.object = isoGameCharacter;
        }
        isoGameCharacter.legsSprite.modelSlot = modelSlot;
        this.m_contains.add(isoGameCharacter);
        isoGameCharacter.onCullStateChanged(this, false);
        if (modelSlot.model.AnimPlayer != null && modelSlot.model.AnimPlayer.isBoneTransformsNeedFirstFrame()) {
            try {
                modelSlot.Update();
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        }
    }

    public void dressInRandomOutfit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (isoZombie == null || isoZombie.isReanimatedPlayer() || isoZombie.wasFakeDead()) {
            if (GameClient.bClient && isoZombie != null && !isoGameCharacter.isPersistentOutfitInit() && isoGameCharacter.getPersistentOutfitID() != 0) {
                isoZombie.dressInPersistentOutfitID(isoGameCharacter.getPersistentOutfitID());
            }
            return;
        }
        if (DebugOptions.instance.ZombieOutfitRandom.getValue() && !isoGameCharacter.isPersistentOutfitInit()) {
            isoZombie.bDressInRandomOutfit = true;
        }
        if (isoZombie.bDressInRandomOutfit) {
            isoZombie.bDressInRandomOutfit = false;
            isoZombie.dressInRandomOutfit();
        }
        if (!isoGameCharacter.isPersistentOutfitInit()) {
            isoZombie.dressInPersistentOutfitID(isoGameCharacter.getPersistentOutfitID());
        }
    }

    public Model getBodyModel(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.isZombie() && ((IsoZombie)isoGameCharacter).isSkeleton()) {
            if (isoGameCharacter.isFemale()) {
                return this.m_skeletonFemaleModel;
            }
            return this.m_skeletonMaleModel;
        }
        if (isoGameCharacter.isFemale()) {
            return this.m_femaleModel;
        }
        return this.m_maleModel;
    }

    public boolean ContainsChar(IsoGameCharacter isoGameCharacter) {
        return this.m_contains.contains(isoGameCharacter) && !this.ToRemove.contains(isoGameCharacter);
    }

    public void ResetCharacterEquippedHands(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null || isoGameCharacter.legsSprite == null || isoGameCharacter.legsSprite.modelSlot == null) {
            return;
        }
        this.DoCharacterModelEquipped(isoGameCharacter, isoGameCharacter.legsSprite.modelSlot);
    }

    private void DoCharacterModelEquipped(IsoGameCharacter isoGameCharacter, ModelSlot modelSlot) {
        String string;
        Object object;
        Object object2;
        int n;
        if (isoGameCharacter.primaryHandModel != null) {
            isoGameCharacter.clearVariable("RightHandMask");
            isoGameCharacter.primaryHandModel.maskVariableValue = null;
            this.resetModelInstanceRecurse(isoGameCharacter.primaryHandModel, modelSlot);
            modelSlot.sub.remove(isoGameCharacter.primaryHandModel);
            modelSlot.model.sub.remove(isoGameCharacter.primaryHandModel);
            isoGameCharacter.primaryHandModel = null;
        }
        if (isoGameCharacter.secondaryHandModel != null) {
            isoGameCharacter.clearVariable("LeftHandMask");
            isoGameCharacter.secondaryHandModel.maskVariableValue = null;
            this.resetModelInstanceRecurse(isoGameCharacter.secondaryHandModel, modelSlot);
            modelSlot.sub.remove(isoGameCharacter.secondaryHandModel);
            modelSlot.model.sub.remove(isoGameCharacter.secondaryHandModel);
            isoGameCharacter.secondaryHandModel = null;
        }
        for (n = 0; n < modelSlot.attachedModels.size(); ++n) {
            object2 = (ModelInstance)modelSlot.attachedModels.get(n);
            this.resetModelInstanceRecurse((ModelInstance)object2, modelSlot);
            modelSlot.sub.remove(object2);
            modelSlot.model.sub.remove(object2);
        }
        modelSlot.attachedModels.clear();
        for (n = 0; n < isoGameCharacter.getAttachedItems().size(); ++n) {
            object2 = isoGameCharacter.getAttachedItems().get(n);
            String string2 = ((AttachedItem)object2).getItem().getStaticModel();
            if (StringUtils.isNullOrWhitespace(string2) || (object = this.addStatic(modelSlot.model, string2, string = isoGameCharacter.getAttachedItems().getGroup().getLocation(((AttachedItem)object2).getLocation()).getAttachmentName(), string)) == null) continue;
            ((ModelInstance)object).setOwner(modelSlot);
            modelSlot.sub.add((ModelInstance)object);
            HandWeapon handWeapon = Type.tryCastTo(((AttachedItem)object2).getItem(), HandWeapon.class);
            if (handWeapon != null) {
                this.addWeaponPartModels(modelSlot, handWeapon, (ModelInstance)object);
                if (!Core.getInstance().getOptionSimpleWeaponTextures()) {
                    ModelInstanceTextureInitializer modelInstanceTextureInitializer = ModelInstanceTextureInitializer.alloc();
                    modelInstanceTextureInitializer.init((ModelInstance)object, handWeapon);
                    ((ModelInstance)object).setTextureInitializer(modelInstanceTextureInitializer);
                }
            }
            modelSlot.attachedModels.add(object);
        }
        if (isoGameCharacter instanceof IsoZombie) {
            // empty if block
        }
        InventoryItem inventoryItem = isoGameCharacter.getPrimaryHandItem();
        object2 = isoGameCharacter.getSecondaryHandItem();
        if (isoGameCharacter.isHideWeaponModel()) {
            inventoryItem = null;
            object2 = null;
        }
        if (isoGameCharacter instanceof IsoPlayer && isoGameCharacter.forceNullOverride) {
            inventoryItem = null;
            object2 = null;
            isoGameCharacter.forceNullOverride = false;
        }
        boolean bl = false;
        String string3 = string = isoGameCharacter.getCharacterActions().isEmpty() ? null : (BaseAction)isoGameCharacter.getCharacterActions().get(0);
        if (string != null && ((BaseAction)((Object)string)).overrideHandModels) {
            bl = true;
            inventoryItem = null;
            if (((BaseAction)((Object)string)).getPrimaryHandItem() != null) {
                inventoryItem = ((BaseAction)((Object)string)).getPrimaryHandItem();
            } else if (((BaseAction)((Object)string)).getPrimaryHandMdl() != null) {
                isoGameCharacter.primaryHandModel = this.addStatic(modelSlot, ((BaseAction)((Object)string)).getPrimaryHandMdl(), "Bip01_Prop1");
            }
            object2 = null;
            if (((BaseAction)((Object)string)).getSecondaryHandItem() != null) {
                object2 = ((BaseAction)((Object)string)).getSecondaryHandItem();
            } else if (((BaseAction)((Object)string)).getSecondaryHandMdl() != null) {
                isoGameCharacter.secondaryHandModel = this.addStatic(modelSlot, ((BaseAction)((Object)string)).getSecondaryHandMdl(), "Bip01_Prop2");
            }
        }
        if (!StringUtils.isNullOrEmpty(isoGameCharacter.overridePrimaryHandModel)) {
            bl = true;
            isoGameCharacter.primaryHandModel = this.addStatic(modelSlot, isoGameCharacter.overridePrimaryHandModel, "Bip01_Prop1");
        }
        if (!StringUtils.isNullOrEmpty(isoGameCharacter.overrideSecondaryHandModel)) {
            bl = true;
            isoGameCharacter.secondaryHandModel = this.addStatic(modelSlot, isoGameCharacter.overrideSecondaryHandModel, "Bip01_Prop2");
        }
        if (inventoryItem != null) {
            object = inventoryItem.getItemReplacementPrimaryHand();
            isoGameCharacter.primaryHandModel = this.addEquippedModelInstance(isoGameCharacter, modelSlot, inventoryItem, "Bip01_Prop1", (ItemReplacement)object, bl);
        }
        if (object2 != null && inventoryItem != object2) {
            object = ((InventoryItem)object2).getItemReplacementSecondHand();
            isoGameCharacter.secondaryHandModel = this.addEquippedModelInstance(isoGameCharacter, modelSlot, (InventoryItem)object2, "Bip01_Prop2", (ItemReplacement)object, bl);
        }
    }

    private ModelInstance addEquippedModelInstance(IsoGameCharacter isoGameCharacter, ModelSlot modelSlot, InventoryItem inventoryItem, String string, ItemReplacement itemReplacement, boolean bl) {
        HandWeapon handWeapon = Type.tryCastTo(inventoryItem, HandWeapon.class);
        if (handWeapon != null) {
            String string2 = handWeapon.getStaticModel();
            ModelInstance modelInstance = this.addStatic(modelSlot, string2, string);
            this.addWeaponPartModels(modelSlot, handWeapon, modelInstance);
            if (Core.getInstance().getOptionSimpleWeaponTextures()) {
                return modelInstance;
            }
            ModelInstanceTextureInitializer modelInstanceTextureInitializer = ModelInstanceTextureInitializer.alloc();
            modelInstanceTextureInitializer.init(modelInstance, handWeapon);
            modelInstance.setTextureInitializer(modelInstanceTextureInitializer);
            return modelInstance;
        }
        if (inventoryItem != null) {
            if (!(itemReplacement == null || StringUtils.isNullOrEmpty(itemReplacement.maskVariableValue) || itemReplacement.clothingItem == null && StringUtils.isNullOrWhitespace(inventoryItem.getStaticModel()))) {
                ModelInstance modelInstance = this.addMaskingModel(modelSlot, isoGameCharacter, inventoryItem, itemReplacement, itemReplacement.maskVariableValue, itemReplacement.attachment, string);
                return modelInstance;
            }
            if (bl && !StringUtils.isNullOrWhitespace(inventoryItem.getStaticModel())) {
                ModelInstance modelInstance = this.addStatic(modelSlot, inventoryItem.getStaticModel(), string);
                return modelInstance;
            }
        }
        return null;
    }

    private ModelInstance addMaskingModel(ModelSlot modelSlot, IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem, ItemReplacement itemReplacement, String string, String string2, String string3) {
        ModelInstance modelInstance = null;
        ItemVisual itemVisual = inventoryItem.getVisual();
        if (itemReplacement.clothingItem != null && itemVisual != null) {
            modelInstance = PopTemplateManager.instance.addClothingItem(isoGameCharacter, modelSlot, itemVisual, itemReplacement.clothingItem);
        } else {
            if (StringUtils.isNullOrWhitespace(inventoryItem.getStaticModel())) {
                return null;
            }
            String string4 = null;
            if (itemVisual != null && inventoryItem.getClothingItem() != null) {
                string4 = inventoryItem.getClothingItem().getTextureChoices().get(itemVisual.getTextureChoice());
            }
            modelInstance = !StringUtils.isNullOrEmpty(string2) ? this.addStaticForcedTex(modelSlot.model, inventoryItem.getStaticModel(), string2, string2, string4) : this.addStaticForcedTex(modelSlot, inventoryItem.getStaticModel(), string3, string4);
            modelInstance.maskVariableValue = string;
            if (itemVisual != null) {
                modelInstance.tintR = itemVisual.m_Tint.r;
                modelInstance.tintG = itemVisual.m_Tint.g;
                modelInstance.tintB = itemVisual.m_Tint.b;
            }
        }
        if (!StringUtils.isNullOrEmpty(string)) {
            isoGameCharacter.setVariable(itemReplacement.maskVariableName, string);
            isoGameCharacter.bUpdateEquippedTextures = true;
        }
        return modelInstance;
    }

    private void addWeaponPartModels(ModelSlot modelSlot, HandWeapon handWeapon, ModelInstance modelInstance) {
        ArrayList<ModelWeaponPart> arrayList = handWeapon.getModelWeaponPart();
        if (arrayList != null) {
            ArrayList<WeaponPart> arrayList2 = handWeapon.getAllWeaponParts(this.m_tempWeaponPartList);
            for (int i = 0; i < arrayList2.size(); ++i) {
                WeaponPart weaponPart = arrayList2.get(i);
                for (int j = 0; j < arrayList.size(); ++j) {
                    ModelWeaponPart modelWeaponPart = arrayList.get(j);
                    if (!weaponPart.getFullType().equals(modelWeaponPart.partType)) continue;
                    ModelInstance modelInstance2 = this.addStatic(modelInstance, modelWeaponPart.modelName, modelWeaponPart.attachmentNameSelf, modelWeaponPart.attachmentParent);
                    modelInstance2.setOwner(modelSlot);
                }
            }
        }
    }

    public void resetModelInstance(ModelInstance modelInstance, Object object) {
        if (modelInstance == null) {
            return;
        }
        modelInstance.clearOwner(object);
        if (modelInstance.isRendering()) {
            modelInstance.bResetAfterRender = true;
        } else {
            if (modelInstance instanceof VehicleModelInstance) {
                return;
            }
            if (modelInstance instanceof VehicleSubModelInstance) {
                return;
            }
            modelInstance.reset();
            this.m_modelInstancePool.release(modelInstance);
        }
    }

    public void resetModelInstanceRecurse(ModelInstance modelInstance, Object object) {
        if (modelInstance == null) {
            return;
        }
        this.resetModelInstancesRecurse(modelInstance.sub, object);
        this.resetModelInstance(modelInstance, object);
    }

    public void resetModelInstancesRecurse(ArrayList<ModelInstance> arrayList, Object object) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ModelInstance modelInstance = arrayList.get(i);
            this.resetModelInstance(modelInstance, object);
        }
    }

    public void derefModelInstance(ModelInstance modelInstance) {
        if (modelInstance == null) {
            return;
        }
        assert (modelInstance.renderRefCount > 0);
        --modelInstance.renderRefCount;
        if (modelInstance.bResetAfterRender && !modelInstance.isRendering()) {
            assert (modelInstance.getOwner() == null);
            if (modelInstance instanceof VehicleModelInstance) {
                return;
            }
            if (modelInstance instanceof VehicleSubModelInstance) {
                return;
            }
            modelInstance.reset();
            this.m_modelInstancePool.release(modelInstance);
        }
    }

    public void derefModelInstances(ArrayList<ModelInstance> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ModelInstance modelInstance = arrayList.get(i);
            this.derefModelInstance(modelInstance);
        }
    }

    private void DoCharacterModelParts(IsoGameCharacter isoGameCharacter, ModelSlot modelSlot) {
        if (modelSlot.isRendering()) {
            boolean bl = false;
        }
        if (DebugLog.isEnabled(DebugType.Clothing)) {
            DebugLog.Clothing.debugln("Char: " + isoGameCharacter + " Slot: " + modelSlot);
        }
        modelSlot.sub.clear();
        PopTemplateManager.instance.populateCharacterModelSlot(isoGameCharacter, modelSlot);
        this.DoCharacterModelEquipped(isoGameCharacter, modelSlot);
    }

    public void update() {
        Object object;
        Object object2;
        int n;
        for (n = 0; n < this.ToResetNextFrame.size(); ++n) {
            object2 = this.ToResetNextFrame.get(n);
            this.Reset((IsoGameCharacter)object2);
        }
        this.ToResetNextFrame.clear();
        for (n = 0; n < this.ToResetEquippedNextFrame.size(); ++n) {
            object2 = this.ToResetEquippedNextFrame.get(n);
            this.ResetCharacterEquippedHands((IsoGameCharacter)object2);
        }
        this.ToResetEquippedNextFrame.clear();
        for (n = 0; n < this.ToRemove.size(); ++n) {
            object2 = this.ToRemove.get(n);
            this.DoRemove((IsoGameCharacter)object2);
        }
        this.ToRemove.clear();
        for (n = 0; n < this.m_resetAfterRender.size(); ++n) {
            object2 = this.m_resetAfterRender.get(n);
            if (((ModelSlot)object2).isRendering()) continue;
            ((ModelSlot)object2).reset();
            this.m_resetAfterRender.remove(n--);
        }
        this.m_lights.clear();
        if (IsoWorld.instance != null && IsoWorld.instance.CurrentCell != null) {
            this.m_lights.addAll(IsoWorld.instance.CurrentCell.getLamppostPositions());
            ArrayList<BaseVehicle> arrayList = IsoWorld.instance.CurrentCell.getVehicles();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = arrayList.get(i);
                if (((BaseVehicle)object).sprite == null || !((BaseVehicle)object).sprite.hasActiveModel()) continue;
                ((VehicleModelInstance)((BaseVehicle)object).sprite.modelSlot.model).UpdateLights();
            }
        }
        this.m_freeLights.addAll(this.m_torchLights);
        this.m_torchLights.clear();
        this.m_torches.clear();
        LightingJNI.getTorches(this.m_torches);
        for (int i = 0; i < this.m_torches.size(); ++i) {
            IsoGameCharacter.TorchInfo torchInfo = this.m_torches.get(i);
            object = this.m_freeLights.isEmpty() ? new IsoLightSource(0, 0, 0, 1.0f, 1.0f, 1.0f, 1) : this.m_freeLights.pop();
            ((IsoLightSource)object).x = (int)torchInfo.x;
            ((IsoLightSource)object).y = (int)torchInfo.y;
            ((IsoLightSource)object).z = (int)torchInfo.z;
            ((IsoLightSource)object).r = 1.0f;
            ((IsoLightSource)object).g = 0.85f;
            ((IsoLightSource)object).b = 0.6f;
            ((IsoLightSource)object).radius = (int)Math.ceil(torchInfo.dist);
            this.m_torchLights.add((IsoLightSource)object);
        }
    }

    private ModelSlot addNewSlot(IsoGameCharacter isoGameCharacter) {
        ModelSlot modelSlot = new ModelSlot(this.m_modelSlots.size(), null, isoGameCharacter);
        this.m_modelSlots.add(modelSlot);
        return modelSlot;
    }

    public ModelSlot getSlot(IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < this.m_modelSlots.size(); ++i) {
            ModelSlot modelSlot = this.m_modelSlots.get(i);
            if (modelSlot.bRemove || modelSlot.isRendering() || modelSlot.active) continue;
            return modelSlot;
        }
        return this.addNewSlot(isoGameCharacter);
    }

    private boolean DoRemove(IsoGameCharacter isoGameCharacter) {
        if (!this.m_contains.contains(isoGameCharacter)) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.m_modelSlots.size(); ++i) {
            ModelSlot modelSlot = this.m_modelSlots.get(i);
            if (modelSlot.character != isoGameCharacter) continue;
            isoGameCharacter.legsSprite.modelSlot = null;
            this.m_contains.remove(isoGameCharacter);
            if (!isoGameCharacter.isSceneCulled()) {
                isoGameCharacter.onCullStateChanged(this, true);
            }
            if (!this.m_resetAfterRender.contains(modelSlot)) {
                this.m_resetAfterRender.add(modelSlot);
            }
            bl = true;
        }
        return bl;
    }

    public void Remove(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.isSceneCulled()) {
            return;
        }
        if (!this.ToRemove.contains(isoGameCharacter)) {
            isoGameCharacter.legsSprite.modelSlot.bRemove = true;
            this.ToRemove.add(isoGameCharacter);
            isoGameCharacter.onCullStateChanged(this, true);
        } else if (this.ContainsChar(isoGameCharacter)) {
            throw new IllegalStateException("IsoGameCharacter.isSceneCulled() = true inconsistent with ModelManager.ContainsChar() = true");
        }
    }

    public void Remove(BaseVehicle baseVehicle) {
        if (baseVehicle.sprite != null && baseVehicle.sprite.modelSlot != null) {
            ModelSlot modelSlot = baseVehicle.sprite.modelSlot;
            if (!this.m_resetAfterRender.contains(modelSlot)) {
                this.m_resetAfterRender.add(modelSlot);
            }
            baseVehicle.sprite.modelSlot = null;
        }
    }

    public void ResetNextFrame(IsoGameCharacter isoGameCharacter) {
        if (this.ToResetNextFrame.contains(isoGameCharacter)) {
            return;
        }
        this.ToResetNextFrame.add(isoGameCharacter);
    }

    public void ResetEquippedNextFrame(IsoGameCharacter isoGameCharacter) {
        if (this.ToResetEquippedNextFrame.contains(isoGameCharacter)) {
            return;
        }
        this.ToResetEquippedNextFrame.add(isoGameCharacter);
    }

    public void Reset() {
        RenderThread.invokeOnRenderContext(() -> {
            IsoGameCharacter[] isoGameCharacterArray = this.ToRemove.iterator();
            while (isoGameCharacterArray.hasNext()) {
                IsoGameCharacter[] isoGameCharacterArray2 = isoGameCharacterArray.next();
                this.DoRemove((IsoGameCharacter)isoGameCharacterArray2);
            }
            this.ToRemove.clear();
            try {
                if (!this.m_contains.isEmpty()) {
                    for (IsoGameCharacter isoGameCharacter : isoGameCharacterArray = this.m_contains.toArray(new IsoGameCharacter[0])) {
                        this.DoRemove(isoGameCharacter);
                    }
                }
                this.m_modelSlots.clear();
            }
            catch (Exception exception) {
                DebugLog.Animation.error("Exception thrown removing Models.");
                exception.printStackTrace();
            }
        });
        this.m_lights.clear();
        this.m_lightsTemp.clear();
    }

    public void getClosestThreeLights(IsoMovingObject isoMovingObject2, IsoLightSource[] isoLightSourceArray) {
        this.m_lightsTemp.clear();
        for (IsoLightSource object : this.m_lights) {
            if (!object.bActive || object.life == 0 || object.localToBuilding != null && isoMovingObject2.getCurrentBuilding() != object.localToBuilding || IsoUtils.DistanceTo(isoMovingObject2.x, isoMovingObject2.y, (float)object.x + 0.5f, (float)object.y + 0.5f) >= (float)object.radius || LosUtil.lineClear(IsoWorld.instance.CurrentCell, (int)isoMovingObject2.x, (int)isoMovingObject2.y, (int)isoMovingObject2.z, object.x, object.y, object.z, false) == LosUtil.TestResults.Blocked) continue;
            this.m_lightsTemp.add(object);
        }
        if (isoMovingObject2 instanceof BaseVehicle) {
            for (int i = 0; i < this.m_torches.size(); ++i) {
                IsoGameCharacter.TorchInfo torchInfo = this.m_torches.get(i);
                if (IsoUtils.DistanceTo(isoMovingObject2.x, isoMovingObject2.y, torchInfo.x, torchInfo.y) >= torchInfo.dist || LosUtil.lineClear(IsoWorld.instance.CurrentCell, (int)isoMovingObject2.x, (int)isoMovingObject2.y, (int)isoMovingObject2.z, (int)torchInfo.x, (int)torchInfo.y, (int)torchInfo.z, false) == LosUtil.TestResults.Blocked) continue;
                if (torchInfo.bCone) {
                    Vector2 vector22 = this.m_tempVec2;
                    vector22.x = torchInfo.x - isoMovingObject2.x;
                    vector22.y = torchInfo.y - isoMovingObject2.y;
                    vector22.normalize();
                    Vector2 vector23 = this.m_tempVec2_2;
                    vector23.x = torchInfo.angleX;
                    vector23.y = torchInfo.angleY;
                    vector23.normalize();
                    float f = vector22.dot(vector23);
                    if (f >= -0.92f) continue;
                }
                this.m_lightsTemp.add(this.m_torchLights.get(i));
            }
        }
        PZArrayUtil.sort(this.m_lightsTemp, Lambda.comparator(isoMovingObject2, (isoLightSource, isoLightSource2, isoMovingObject) -> {
            float f;
            float f2 = isoMovingObject.DistTo(isoLightSource.x, isoLightSource.y);
            if (f2 > (f = isoMovingObject.DistTo(isoLightSource2.x, isoLightSource2.y))) {
                return 1;
            }
            if (f2 < f) {
                return -1;
            }
            return 0;
        }));
        isoLightSourceArray[2] = null;
        isoLightSourceArray[1] = null;
        isoLightSourceArray[0] = null;
        if (this.m_lightsTemp.size() > 0) {
            isoLightSourceArray[0] = (IsoLightSource)this.m_lightsTemp.get(0);
        }
        if (this.m_lightsTemp.size() > 1) {
            isoLightSourceArray[1] = (IsoLightSource)this.m_lightsTemp.get(1);
        }
        if (this.m_lightsTemp.size() > 2) {
            isoLightSourceArray[2] = (IsoLightSource)this.m_lightsTemp.get(2);
        }
    }

    public void addVehicle(BaseVehicle baseVehicle) {
        if (!this.m_bCreated) {
            return;
        }
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return;
        }
        if (baseVehicle == null || baseVehicle.getScript() == null) {
            return;
        }
        VehicleScript vehicleScript = baseVehicle.getScript();
        String string = baseVehicle.getScript().getModel().file;
        Model model = this.getLoadedModel(string);
        if (model == null) {
            DebugLog.Animation.error("Failed to find vehicle model: %s", string);
            return;
        }
        if (DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.debugln("%s", string);
        }
        VehicleModelInstance vehicleModelInstance = new VehicleModelInstance();
        vehicleModelInstance.init(model, null, baseVehicle.getAnimationPlayer());
        vehicleModelInstance.applyModelScriptScale(string);
        baseVehicle.getSkin();
        VehicleScript.Skin skin = vehicleScript.getTextures();
        if (baseVehicle.getSkinIndex() >= 0 && baseVehicle.getSkinIndex() < vehicleScript.getSkinCount()) {
            skin = vehicleScript.getSkin(baseVehicle.getSkinIndex());
        }
        vehicleModelInstance.LoadTexture(skin.texture);
        vehicleModelInstance.tex = skin.textureData;
        vehicleModelInstance.textureMask = skin.textureDataMask;
        vehicleModelInstance.textureDamage1Overlay = skin.textureDataDamage1Overlay;
        vehicleModelInstance.textureDamage1Shell = skin.textureDataDamage1Shell;
        vehicleModelInstance.textureDamage2Overlay = skin.textureDataDamage2Overlay;
        vehicleModelInstance.textureDamage2Shell = skin.textureDataDamage2Shell;
        vehicleModelInstance.textureLights = skin.textureDataLights;
        vehicleModelInstance.textureRust = skin.textureDataRust;
        if (vehicleModelInstance.tex != null) {
            vehicleModelInstance.tex.bindAlways = true;
        } else {
            DebugLog.Animation.error("texture not found:", baseVehicle.getSkin());
        }
        ModelSlot modelSlot = this.getSlot(null);
        modelSlot.model = vehicleModelInstance;
        vehicleModelInstance.setOwner(modelSlot);
        vehicleModelInstance.object = baseVehicle;
        modelSlot.sub.clear();
        for (int i = 0; i < baseVehicle.models.size(); ++i) {
            BaseVehicle.ModelInfo modelInfo = baseVehicle.models.get(i);
            Model model2 = this.getLoadedModel(modelInfo.scriptModel.file);
            if (model2 == null) {
                DebugLog.Animation.error("vehicle.models[%d] not found: %s", i, modelInfo.scriptModel.file);
                continue;
            }
            VehicleSubModelInstance vehicleSubModelInstance = new VehicleSubModelInstance();
            vehicleSubModelInstance.init(model2, null, modelInfo.getAnimationPlayer());
            vehicleSubModelInstance.setOwner(modelSlot);
            vehicleSubModelInstance.applyModelScriptScale(modelInfo.scriptModel.file);
            vehicleSubModelInstance.object = baseVehicle;
            vehicleSubModelInstance.parent = vehicleModelInstance;
            vehicleModelInstance.sub.add(vehicleSubModelInstance);
            vehicleSubModelInstance.modelInfo = modelInfo;
            if (vehicleSubModelInstance.tex == null) {
                vehicleSubModelInstance.tex = vehicleModelInstance.tex;
            }
            modelSlot.sub.add(vehicleSubModelInstance);
            modelInfo.modelInstance = vehicleSubModelInstance;
        }
        modelSlot.active = true;
        baseVehicle.sprite.modelSlot = modelSlot;
    }

    public ModelInstance addStatic(ModelSlot modelSlot, String string, String string2, String string3, String string4) {
        ModelInstance modelInstance = this.newStaticInstance(modelSlot, string, string2, string3, string4);
        if (modelInstance == null) {
            return null;
        }
        modelSlot.sub.add(modelInstance);
        modelInstance.setOwner(modelSlot);
        modelSlot.model.sub.add(modelInstance);
        return modelInstance;
    }

    public ModelInstance newStaticInstance(ModelSlot modelSlot, String string, String string2, String string3, String string4) {
        Model model;
        if (DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.debugln("Adding Static Model:" + string);
        }
        if ((model = this.tryGetLoadedModel(string, string2, true, string4, false)) == null && string != null) {
            this.loadStaticModel(string, string2, string4);
            model = this.getLoadedModel(string, string2, true, string4);
            if (model == null) {
                if (DebugLog.isEnabled(DebugType.Animation)) {
                    DebugLog.Animation.error("Model not found. model:" + string + " tex:" + string2);
                }
                return null;
            }
        }
        if (string == null) {
            model = this.tryGetLoadedModel("vehicles_wheel02", "vehicles/vehicle_wheel02", true, "vehiclewheel", false);
        }
        ModelInstance modelInstance = this.newInstance(model, modelSlot.character, modelSlot.model.AnimPlayer);
        modelInstance.parent = modelSlot.model;
        if (modelSlot.model.AnimPlayer != null) {
            modelInstance.parentBone = modelSlot.model.AnimPlayer.getSkinningBoneIndex(string3, modelInstance.parentBone);
            modelInstance.parentBoneName = string3;
        }
        modelInstance.AnimPlayer = modelSlot.model.AnimPlayer;
        return modelInstance;
    }

    private ModelInstance addStatic(ModelSlot modelSlot, String string, String string2) {
        return this.addStaticForcedTex(modelSlot, string, string2, null);
    }

    private ModelInstance addStaticForcedTex(ModelSlot modelSlot, String string, String string2, String string3) {
        ModelScript modelScript;
        String string4 = ScriptManager.getItemName(string);
        String string5 = ScriptManager.getItemName(string);
        String string6 = null;
        ModelMetaData modelMetaData = ModelManager.modelMetaData.get(string);
        if (modelMetaData != null) {
            if (!StringUtils.isNullOrWhitespace(modelMetaData.meshName)) {
                string4 = modelMetaData.meshName;
            }
            if (!StringUtils.isNullOrWhitespace(modelMetaData.textureName)) {
                string5 = modelMetaData.textureName;
            }
            if (!StringUtils.isNullOrWhitespace(modelMetaData.shaderName)) {
                string6 = modelMetaData.shaderName;
            }
        }
        if (!StringUtils.isNullOrEmpty(string3)) {
            string5 = string3;
        }
        if ((modelScript = ScriptManager.instance.getModelScript(string)) != null) {
            string4 = modelScript.getMeshName();
            ModelInstance modelInstance = this.addStatic(modelSlot, string4, string5 = modelScript.getTextureName(), string2, string6 = modelScript.getShaderName());
            if (modelInstance != null) {
                modelInstance.applyModelScriptScale(string);
            }
            return modelInstance;
        }
        return this.addStatic(modelSlot, string4, string5, string2, string6);
    }

    public ModelInstance addStatic(ModelInstance modelInstance, String string, String string2, String string3) {
        return this.addStaticForcedTex(modelInstance, string, string2, string3, null);
    }

    public ModelInstance addStaticForcedTex(ModelInstance modelInstance, String string, String string2, String string3, String string4) {
        Model model;
        String string5 = ScriptManager.getItemName(string);
        String string6 = ScriptManager.getItemName(string);
        String string7 = null;
        ModelScript modelScript = ScriptManager.instance.getModelScript(string);
        if (modelScript != null) {
            string5 = modelScript.getMeshName();
            string6 = modelScript.getTextureName();
            string7 = modelScript.getShaderName();
        }
        if (!StringUtils.isNullOrEmpty(string4)) {
            string6 = string4;
        }
        if ((model = this.tryGetLoadedModel(string5, string6, true, string7, false)) == null && string5 != null) {
            this.loadStaticModel(string5, string6, string7);
            model = this.getLoadedModel(string5, string6, true, string7);
            if (model == null) {
                if (DebugLog.isEnabled(DebugType.Animation)) {
                    DebugLog.Animation.error("Model not found. model:" + string5 + " tex:" + string6);
                }
                return null;
            }
        }
        if (string5 == null) {
            model = this.tryGetLoadedModel("vehicles_wheel02", "vehicles/vehicle_wheel02", true, "vehiclewheel", false);
        }
        if (model == null) {
            return null;
        }
        ModelInstance modelInstance2 = this.m_modelInstancePool.alloc();
        if (modelInstance != null) {
            modelInstance2.init(model, modelInstance.character, modelInstance.AnimPlayer);
            modelInstance2.parent = modelInstance;
            modelInstance.sub.add(modelInstance2);
        } else {
            modelInstance2.init(model, null, null);
        }
        if (modelScript != null) {
            modelInstance2.applyModelScriptScale(string);
        }
        modelInstance2.attachmentNameSelf = string2;
        modelInstance2.attachmentNameParent = string3;
        return modelInstance2;
    }

    private String modifyShaderName(String object) {
        if ((StringUtils.equals((String)object, "vehicle") || StringUtils.equals((String)object, "vehicle_multiuv") || StringUtils.equals((String)object, "vehicle_norandom_multiuv")) && !Core.getInstance().getPerfReflectionsOnLoad()) {
            object = (String)object + "_noreflect";
        }
        return object;
    }

    private Model loadModelInternal(String string, String string2, String string3, ModelMesh modelMesh, boolean bl) {
        string3 = this.modifyShaderName(string3);
        Model.ModelAssetParams modelAssetParams = new Model.ModelAssetParams();
        modelAssetParams.animationsModel = modelMesh;
        modelAssetParams.bStatic = bl;
        modelAssetParams.meshName = string;
        modelAssetParams.shaderName = string3;
        modelAssetParams.textureName = string2;
        if (string3 != null && StringUtils.startsWithIgnoreCase(string3, "vehicle")) {
            modelAssetParams.textureFlags = TextureID.bUseCompression ? 4 : 0;
            modelAssetParams.textureFlags |= 0x100;
        } else {
            modelAssetParams.textureFlags = this.getTextureFlags();
        }
        String string4 = this.createModelKey(string, string2, bl, string3);
        Model model = (Model)ModelAssetManager.instance.load(new AssetPath(string4), modelAssetParams);
        if (model != null) {
            this.putLoadedModel(string, string2, bl, string3, model);
        }
        return model;
    }

    public int getTextureFlags() {
        int n;
        int n2 = n = TextureID.bUseCompression ? 4 : 0;
        if (Core.OptionModelTextureMipmaps) {
            // empty if block
        }
        return n |= 0x80;
    }

    public void setModelMetaData(String string, String string2, String string3, boolean bl) {
        this.setModelMetaData(string, string, string2, string3, bl);
    }

    public void setModelMetaData(String string, String string2, String string3, String string4, boolean bl) {
        ModelMetaData modelMetaData = new ModelMetaData();
        modelMetaData.meshName = string2;
        modelMetaData.textureName = string3;
        modelMetaData.shaderName = string4;
        modelMetaData.bStatic = bl;
        ModelManager.modelMetaData.put(string, modelMetaData);
    }

    public Model loadStaticModel(String string, String string2, String string3) {
        String string4 = this.modifyShaderName(string3);
        return this.loadModelInternal(string, string2, string4, null, true);
    }

    private Model loadModel(String string, String string2, ModelMesh modelMesh) {
        return this.loadModelInternal(string, string2, "basicEffect", modelMesh, false);
    }

    public Model getLoadedModel(String string) {
        ModelScript modelScript = ScriptManager.instance.getModelScript(string);
        if (modelScript != null) {
            if (modelScript.loadedModel != null) {
                return modelScript.loadedModel;
            }
            modelScript.shaderName = this.modifyShaderName(modelScript.shaderName);
            Model model = this.tryGetLoadedModel(modelScript.getMeshName(), modelScript.getTextureName(), modelScript.bStatic, modelScript.getShaderName(), false);
            if (model != null) {
                modelScript.loadedModel = model;
                return model;
            }
            AnimationsMesh animationsMesh = modelScript.animationsMesh == null ? null : ScriptManager.instance.getAnimationsMesh(modelScript.animationsMesh);
            ModelMesh modelMesh = animationsMesh == null ? null : animationsMesh.modelMesh;
            modelScript.loadedModel = model = modelScript.bStatic ? this.loadModelInternal(modelScript.getMeshName(), modelScript.getTextureName(), modelScript.getShaderName(), null, true) : this.loadModelInternal(modelScript.getMeshName(), modelScript.getTextureName(), modelScript.getShaderName(), modelMesh, false);
            return model;
        }
        ModelMetaData modelMetaData = ModelManager.modelMetaData.get(string);
        if (modelMetaData != null) {
            modelMetaData.shaderName = this.modifyShaderName(modelMetaData.shaderName);
            Model model = this.tryGetLoadedModel(modelMetaData.meshName, modelMetaData.textureName, modelMetaData.bStatic, modelMetaData.shaderName, false);
            if (model != null) {
                return model;
            }
            return modelMetaData.bStatic ? this.loadStaticModel(modelMetaData.meshName, modelMetaData.textureName, modelMetaData.shaderName) : this.loadModel(modelMetaData.meshName, modelMetaData.textureName, this.m_animModel);
        }
        Model model = this.tryGetLoadedModel(string, null, false, null, false);
        if (model != null) {
            return model;
        }
        String string2 = string.toLowerCase().trim();
        for (Map.Entry<String, Model> entry : this.m_modelMap.entrySet()) {
            Model model2;
            String string3 = entry.getKey();
            if (!string3.startsWith(string2) || (model2 = entry.getValue()) == null || string3.length() != string2.length() && string3.charAt(string2.length()) != '&') continue;
            model = model2;
            break;
        }
        if (model == null && DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.error("ModelManager.getLoadedModel> Model missing for key=\"" + string2 + "\"");
        }
        return model;
    }

    public Model getLoadedModel(String string, String string2, boolean bl, String string3) {
        return this.tryGetLoadedModel(string, string2, bl, string3, true);
    }

    public Model tryGetLoadedModel(String string, String string2, boolean bl, String string3, boolean bl2) {
        String string4 = this.createModelKey(string, string2, bl, string3);
        if (string4 == null) {
            return null;
        }
        Model model = this.m_modelMap.get(string4);
        if (model == null && bl2 && DebugLog.isEnabled(DebugType.Animation)) {
            DebugLog.Animation.error("ModelManager.getLoadedModel> Model missing for key=\"" + string4 + "\"");
        }
        return model;
    }

    public void putLoadedModel(String string, String string2, boolean bl, String string3, Model model) {
        String string4 = this.createModelKey(string, string2, bl, string3);
        if (string4 == null) {
            return;
        }
        Model model2 = this.m_modelMap.get(string4);
        if (model2 == model) {
            return;
        }
        if (model2 != null) {
            DebugLog.Animation.debugln("Override key=\"%s\" old=%s new=%s", string4, model2, model);
        } else {
            DebugLog.Animation.debugln("key=\"%s\" model=%s", string4, model);
        }
        this.m_modelMap.put(string4, model);
        model.Name = string4;
    }

    private String createModelKey(String string, String string2, boolean bl, String string3) {
        builder.delete(0, builder.length());
        if (string == null) {
            return null;
        }
        if (!toLowerKeyRoot.containsKey(string)) {
            toLowerKeyRoot.put(string, string.toLowerCase(Locale.ENGLISH).trim());
        }
        builder.append(toLowerKeyRoot.get(string));
        builder.append(amp);
        if (StringUtils.isNullOrWhitespace(string3)) {
            string3 = basicEffect;
        }
        builder.append(shaderEquals);
        if (!toLower.containsKey(string3)) {
            toLower.put(string3, string3.toLowerCase().trim());
        }
        builder.append(toLower.get(string3));
        if (!StringUtils.isNullOrWhitespace(string2)) {
            builder.append(texA);
            if (!toLowerTex.containsKey(string2)) {
                toLowerTex.put(string2, string2.toLowerCase().trim());
            }
            builder.append(toLowerTex.get(string2));
        }
        if (bl) {
            builder.append(isStaticTrue);
        }
        return builder.toString();
    }

    private String createModelKey2(String string, String string2, boolean bl, String string3) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isNullOrWhitespace(string3)) {
            string3 = "basicEffect";
        }
        String string4 = "shader=" + string3.toLowerCase().trim();
        if (!StringUtils.isNullOrWhitespace(string2)) {
            string4 = string4 + ";tex=" + string2.toLowerCase().trim();
        }
        if (bl) {
            string4 = string4 + ";isStatic=true";
        }
        String string5 = string.toLowerCase(Locale.ENGLISH).trim();
        return string5 + "&" + string4;
    }

    private AnimationAsset loadAnim(String string, ModelMesh modelMesh, ModAnimations modAnimations) {
        DebugLog.Animation.debugln("Adding asset to queue: %s", string);
        AnimationAsset.AnimationAssetParams animationAssetParams = new AnimationAsset.AnimationAssetParams();
        animationAssetParams.animationsMesh = modelMesh;
        AnimationAsset animationAsset = (AnimationAsset)AnimationAssetManager.instance.load(new AssetPath(string), animationAssetParams);
        animationAsset.skinningData = modelMesh.skinningData;
        this.putAnimationAsset(string, animationAsset, modAnimations);
        return animationAsset;
    }

    private void putAnimationAsset(String string, AnimationAsset animationAsset, ModAnimations modAnimations) {
        String string2 = string.toLowerCase();
        AnimationAsset animationAsset2 = modAnimations.m_animationAssetMap.getOrDefault(string2, null);
        if (animationAsset2 != null) {
            DebugLog.Animation.debugln("Overwriting asset: %s", this.animAssetToString(animationAsset2));
            DebugLog.Animation.debugln("New asset        : %s", this.animAssetToString(animationAsset));
            modAnimations.m_animationAssetList.remove(animationAsset2);
        }
        animationAsset.modelManagerKey = string2;
        animationAsset.modAnimations = modAnimations;
        modAnimations.m_animationAssetMap.put(string2, animationAsset);
        modAnimations.m_animationAssetList.add(animationAsset);
    }

    private String animAssetToString(AnimationAsset animationAsset) {
        if (animationAsset == null) {
            return "null";
        }
        AssetPath assetPath = animationAsset.getPath();
        if (assetPath == null) {
            return "null-path";
        }
        return String.valueOf(assetPath.getPath());
    }

    private AnimationAsset getAnimationAsset(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return this.m_animationAssets.get(string2);
    }

    private AnimationAsset getAnimationAssetRequired(String string) {
        AnimationAsset animationAsset = this.getAnimationAsset(string);
        if (animationAsset == null) {
            throw new NullPointerException("Required Animation Asset not found: " + string);
        }
        return animationAsset;
    }

    public void addAnimationClip(String string, AnimationClip animationClip) {
        this.m_animModel.skinningData.AnimationClips.put(string, animationClip);
    }

    public AnimationClip getAnimationClip(String string) {
        return this.m_animModel.skinningData.AnimationClips.get(string);
    }

    public Collection<AnimationClip> getAllAnimationClips() {
        return this.m_animModel.skinningData.AnimationClips.values();
    }

    public ModelInstance newInstance(Model model, IsoGameCharacter isoGameCharacter, AnimationPlayer animationPlayer) {
        if (model == null) {
            System.err.println("ModelManager.newInstance> Model is null.");
            return null;
        }
        ModelInstance modelInstance = this.m_modelInstancePool.alloc();
        modelInstance.init(model, isoGameCharacter, animationPlayer);
        return modelInstance;
    }

    public boolean isLoadingAnimations() {
        for (AnimationAsset animationAsset : this.m_animationAssets.values()) {
            if (!animationAsset.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void reloadModelsMatching(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        Set<String> set = this.m_modelMap.keySet();
        for (String string2 : set) {
            Model model;
            if (!string2.contains(string) || (model = this.m_modelMap.get(string2)).isEmpty()) continue;
            DebugLog.General.printf("reloading model %s\n", string2);
            ModelMesh.MeshAssetParams meshAssetParams = new ModelMesh.MeshAssetParams();
            meshAssetParams.animationsMesh = null;
            meshAssetParams.bStatic = model.Mesh.vb == null ? string2.contains(";isStatic=true") : model.Mesh.vb.bStatic;
            MeshAssetManager.instance.reload(model.Mesh, meshAssetParams);
        }
    }

    public void loadModAnimations() {
        for (ModAnimations object2 : this.m_modAnimations.values()) {
            object2.setPriority(object2 == this.m_gameAnimations ? 0 : -1);
        }
        ArrayList<AnimationsMesh> arrayList = ScriptManager.instance.getAllAnimationsMeshes();
        ArrayList<String> arrayList2 = ZomboidFileSystem.instance.getModIDs();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = arrayList2.get(i);
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
            if (mod == null || !mod.animsXFile.isDirectory()) continue;
            ModAnimations modAnimations = this.m_modAnimations.get(string);
            if (modAnimations != null) {
                modAnimations.setPriority(i + 1);
                continue;
            }
            modAnimations = new ModAnimations(string);
            modAnimations.setPriority(i + 1);
            this.m_modAnimations.put(string, modAnimations);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AnimationsMesh animationsMesh = (AnimationsMesh)iterator.next();
                for (String string2 : animationsMesh.animationDirectories) {
                    File file;
                    if (!animationsMesh.modelMesh.isReady() || !(file = new File(mod.animsXFile, string2)).exists()) continue;
                    this.loadAnimsFromDir(mod.baseFile.toURI(), mod.mediaFile.toURI(), file, animationsMesh.modelMesh, modAnimations);
                }
            }
            this.loadHumanAnimations(mod, modAnimations);
        }
        this.setActiveAnimations();
    }

    void setActiveAnimations() {
        this.m_animationAssets.clear();
        ArrayList<AnimationsMesh> arrayList = ScriptManager.instance.getAllAnimationsMeshes();
        for (AnimationsMesh object : arrayList) {
            if (!object.modelMesh.isReady()) continue;
            object.modelMesh.skinningData.AnimationClips.clear();
        }
        for (ModAnimations modAnimations : this.m_modAnimations.values()) {
            if (!modAnimations.isActive()) continue;
            for (AnimationAsset animationAsset : modAnimations.m_animationAssetList) {
                AnimationAsset animationAsset2 = this.m_animationAssets.get(animationAsset.modelManagerKey);
                if (animationAsset2 != null && animationAsset2 != animationAsset && animationAsset2.modAnimations.m_priority > modAnimations.m_priority) continue;
                this.m_animationAssets.put(animationAsset.modelManagerKey, animationAsset);
                if (!animationAsset.isReady()) continue;
                animationAsset.skinningData.AnimationClips.putAll(animationAsset.AnimationClips);
            }
        }
    }

    public void animationAssetLoaded(AnimationAsset animationAsset) {
        if (!animationAsset.modAnimations.isActive()) {
            return;
        }
        AnimationAsset animationAsset2 = this.m_animationAssets.get(animationAsset.modelManagerKey);
        if (animationAsset2 != null && animationAsset2 != animationAsset && animationAsset2.modAnimations.m_priority > animationAsset.modAnimations.m_priority) {
            return;
        }
        this.m_animationAssets.put(animationAsset.modelManagerKey, animationAsset);
        animationAsset.skinningData.AnimationClips.putAll(animationAsset.AnimationClips);
    }

    public void initAnimationMeshes(boolean bl) {
        ArrayList<AnimationsMesh> arrayList = ScriptManager.instance.getAllAnimationsMeshes();
        for (AnimationsMesh animationsMesh : arrayList) {
            ModelMesh.MeshAssetParams meshAssetParams = new ModelMesh.MeshAssetParams();
            meshAssetParams.bStatic = false;
            meshAssetParams.animationsMesh = null;
            animationsMesh.modelMesh = (ModelMesh)MeshAssetManager.instance.getAssetTable().get(animationsMesh.meshFile);
            if (animationsMesh.modelMesh == null) {
                animationsMesh.modelMesh = (ModelMesh)MeshAssetManager.instance.load(new AssetPath(animationsMesh.meshFile), meshAssetParams);
            }
            animationsMesh.modelMesh.m_animationsMesh = animationsMesh.modelMesh;
        }
        if (bl) {
            return;
        }
        while (this.isLoadingAnimationMeshes()) {
            GameWindow.fileSystem.updateAsyncTransactions();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (GameServer.bServer) continue;
            Core.getInstance().StartFrame();
            Core.getInstance().EndFrame();
            Core.getInstance().StartFrameUI();
            Core.getInstance().EndFrameUI();
        }
        for (AnimationsMesh animationsMesh : arrayList) {
            for (String string : animationsMesh.animationDirectories) {
                File file;
                if (!animationsMesh.modelMesh.isReady() || !(file = new File(ZomboidFileSystem.instance.base, "media/anims_X/" + string)).exists()) continue;
                this.loadAnimsFromDir("media/anims_X/" + string, animationsMesh.modelMesh);
            }
        }
    }

    private boolean isLoadingAnimationMeshes() {
        ArrayList<AnimationsMesh> arrayList = ScriptManager.instance.getAllAnimationsMeshes();
        for (AnimationsMesh animationsMesh : arrayList) {
            if (animationsMesh.modelMesh.isFailure() || animationsMesh.modelMesh.isReady()) continue;
            return true;
        }
        return false;
    }

    private void loadHumanAnimations(ChooseGameInfo.Mod mod, ModAnimations modAnimations) {
        AnimationsMesh animationsMesh = ScriptManager.instance.getAnimationsMesh("Human");
        if (animationsMesh == null || animationsMesh.modelMesh == null || !animationsMesh.modelMesh.isReady()) {
            return;
        }
        File[] fileArray = mod.animsXFile.listFiles();
        if (fileArray == null) {
            return;
        }
        URI uRI = mod.animsXFile.toURI();
        for (File file : fileArray) {
            if (file.isDirectory()) {
                if (this.isAnimationsMeshDirectory(file.getName())) continue;
                this.loadAnimsFromDir(mod.baseFile.toURI(), mod.mediaFile.toURI(), file, animationsMesh.modelMesh, modAnimations);
                continue;
            }
            String string = ZomboidFileSystem.instance.getAnimName(uRI, file);
            this.loadAnim(string, animationsMesh.modelMesh, modAnimations);
        }
    }

    private boolean isAnimationsMeshDirectory(String string) {
        ArrayList<AnimationsMesh> arrayList = ScriptManager.instance.getAllAnimationsMeshes();
        for (AnimationsMesh animationsMesh : arrayList) {
            if (!animationsMesh.animationDirectories.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static final class ModAnimations {
        public final String m_modID;
        public final ArrayList<AnimationAsset> m_animationAssetList = new ArrayList();
        public final HashMap<String, AnimationAsset> m_animationAssetMap = new HashMap();
        public int m_priority;

        public ModAnimations(String string) {
            this.m_modID = string;
        }

        public void setPriority(int n) {
            assert (n >= -1);
            this.m_priority = n;
        }

        public boolean isActive() {
            return this.m_priority != -1;
        }
    }

    class AnimDirReloader
    implements PredicatedFileWatcher.IPredicatedFileWatcherCallback {
        URI m_baseURI;
        URI m_mediaURI;
        String m_dir;
        String m_dirSecondary;
        String m_dirAbsolute;
        String m_dirSecondaryAbsolute;
        ModelMesh m_animationsModel;
        ModAnimations m_modAnimations;

        public AnimDirReloader(URI uRI, URI uRI2, String string, ModelMesh modelMesh, ModAnimations modAnimations) {
            string = ZomboidFileSystem.instance.getRelativeFile(uRI, string);
            this.m_baseURI = uRI;
            this.m_mediaURI = uRI2;
            this.m_dir = ZomboidFileSystem.instance.normalizeFolderPath(string);
            this.m_dirAbsolute = ZomboidFileSystem.instance.normalizeFolderPath(new File(new File(this.m_baseURI), this.m_dir).toString());
            if (this.m_dir.contains("/anims/")) {
                this.m_dirSecondary = this.m_dir.replace("/anims/", "/anims_X/");
                this.m_dirSecondaryAbsolute = ZomboidFileSystem.instance.normalizeFolderPath(new File(new File(this.m_baseURI), this.m_dirSecondary).toString());
            }
            this.m_animationsModel = modelMesh;
            this.m_modAnimations = modAnimations;
        }

        private boolean IsInDir(String string) {
            string = ZomboidFileSystem.instance.normalizeFolderPath(string);
            try {
                if (this.m_dirSecondary != null) {
                    return string.startsWith(this.m_dirAbsolute) || string.startsWith(this.m_dirSecondaryAbsolute);
                }
                return string.startsWith(this.m_dirAbsolute);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        @Override
        public void call(String string) {
            String string2 = string.toLowerCase();
            if (!(string2.endsWith(".fbx") || string2.endsWith(".x") || string2.endsWith(".txt"))) {
                return;
            }
            String string3 = ZomboidFileSystem.instance.getAnimName(this.m_mediaURI, new File(string));
            AnimationAsset animationAsset = ModelManager.this.getAnimationAsset(string3);
            if (animationAsset != null) {
                if (!animationAsset.isEmpty()) {
                    DebugLog.General.debugln("Reloading animation: %s", ModelManager.this.animAssetToString(animationAsset));
                    assert (animationAsset.getRefCount() == 1);
                    AnimationAsset.AnimationAssetParams animationAssetParams = new AnimationAsset.AnimationAssetParams();
                    animationAssetParams.animationsMesh = this.m_animationsModel;
                    AnimationAssetManager.instance.reload(animationAsset, animationAssetParams);
                }
                return;
            }
            ModelManager.this.loadAnim(string3, this.m_animationsModel, this.m_modAnimations);
        }

        public PredicatedFileWatcher GetFileWatcher() {
            return new PredicatedFileWatcher(this.m_dir, this::IsInDir, this);
        }
    }

    public static class ModelSlot {
        public int ID;
        public ModelInstance model;
        public IsoGameCharacter character;
        public final ArrayList<ModelInstance> sub = new ArrayList();
        protected final AttachedModels attachedModels = new AttachedModels();
        public boolean active;
        public boolean bRemove;
        public int renderRefCount = 0;
        public int framesSinceStart;

        public ModelSlot(int n, ModelInstance modelInstance, IsoGameCharacter isoGameCharacter) {
            this.ID = n;
            this.model = modelInstance;
            this.character = isoGameCharacter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Update() {
            if (this.character == null || this.bRemove) {
                return;
            }
            ++this.framesSinceStart;
            if (this != this.character.legsSprite.modelSlot) {
                boolean bl = false;
            }
            if (this.model.AnimPlayer != this.character.getAnimationPlayer()) {
                this.model.AnimPlayer = this.character.getAnimationPlayer();
            }
            Object object = this.model.m_lock;
            synchronized (object) {
                this.model.UpdateDir();
                this.model.Update();
                for (int i = 0; i < this.sub.size(); ++i) {
                    this.sub.get((int)i).AnimPlayer = this.model.AnimPlayer;
                }
            }
        }

        public boolean isRendering() {
            return this.renderRefCount > 0;
        }

        public void reset() {
            instance.resetModelInstanceRecurse(this.model, this);
            if (this.character != null) {
                this.character.primaryHandModel = null;
                this.character.secondaryHandModel = null;
                instance.derefModelInstances(this.character.getReadyModelData());
                this.character.getReadyModelData().clear();
            }
            this.active = false;
            this.character = null;
            this.bRemove = false;
            this.renderRefCount = 0;
            this.model = null;
            this.sub.clear();
            this.attachedModels.clear();
        }
    }

    private static final class ModelMetaData {
        String meshName;
        String textureName;
        String shaderName;
        boolean bStatic;

        private ModelMetaData() {
        }
    }
}

