/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

import zombie.characters.IsoGameCharacter;
import zombie.core.skinnedmodel.ModelCamera;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.textures.TextureDraw;
import zombie.iso.IsoMovingObject;
import zombie.popman.ObjectPool;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class ModelCameraRenderData
extends TextureDraw.GenericDrawer {
    private ModelCamera m_camera;
    private float m_angle;
    private boolean m_bUseWorldIso;
    private float m_x;
    private float m_y;
    private float m_z;
    private boolean m_bInVehicle;
    public static final ObjectPool<ModelCameraRenderData> s_pool = new ObjectPool<ModelCameraRenderData>(ModelCameraRenderData::new);

    public ModelCameraRenderData init(ModelCamera modelCamera, ModelManager.ModelSlot modelSlot) {
        IsoMovingObject isoMovingObject = modelSlot.model.object;
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        this.m_camera = modelCamera;
        this.m_x = isoMovingObject.x;
        this.m_y = isoMovingObject.y;
        this.m_z = isoMovingObject.z;
        if (isoGameCharacter == null) {
            this.m_angle = 0.0f;
            this.m_bInVehicle = false;
            this.m_bUseWorldIso = !BaseVehicle.RENDER_TO_TEXTURE;
        } else {
            this.m_bInVehicle = isoGameCharacter.isSeatedInVehicle();
            if (this.m_bInVehicle) {
                this.m_angle = 0.0f;
                BaseVehicle baseVehicle = isoGameCharacter.getVehicle();
                this.m_x = baseVehicle.x;
                this.m_y = baseVehicle.y;
                this.m_z = baseVehicle.z;
            } else {
                this.m_angle = isoGameCharacter.getAnimationPlayer().getRenderedAngle();
            }
            this.m_bUseWorldIso = true;
        }
        return this;
    }

    public ModelCameraRenderData init(ModelCamera modelCamera, float f, boolean bl, float f2, float f3, float f4, boolean bl2) {
        this.m_camera = modelCamera;
        this.m_angle = f;
        this.m_bUseWorldIso = bl;
        this.m_x = f2;
        this.m_y = f3;
        this.m_z = f4;
        this.m_bInVehicle = bl2;
        return this;
    }

    @Override
    public void render() {
        this.m_camera.m_useAngle = this.m_angle;
        this.m_camera.m_bUseWorldIso = this.m_bUseWorldIso;
        this.m_camera.m_x = this.m_x;
        this.m_camera.m_y = this.m_y;
        this.m_camera.m_z = this.m_z;
        this.m_camera.m_bInVehicle = this.m_bInVehicle;
        ModelCamera.instance = this.m_camera;
    }

    @Override
    public void postRender() {
        s_pool.release(this);
    }
}

