/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;
import zombie.core.Color;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.Vector3;
import zombie.core.skinnedmodel.model.VertexPositionNormalTangentTextureSkin;
import zombie.debug.DebugLog;
import zombie.popman.ObjectPool;
import zombie.util.list.PZArrayUtil;

public final class HelperFunctions {
    private static final Vector3f s_zero3 = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Quaternion s_identityQ = new Quaternion();
    private static final Stack<Matrix4f> MatrixStack = new Stack();
    private static final AtomicBoolean MatrixLock = new AtomicBoolean(false);
    private static final ObjectPool<Vector3f> VectorPool = new ObjectPool<Vector3f>(Vector3f::new);

    public static int ToRgba(Color color) {
        return (int)color.a << 24 | (int)color.b << 16 | (int)color.g << 8 | (int)color.r;
    }

    public static void returnMatrix(Matrix4f matrix4f) {
        while (true) {
            if (MatrixLock.compareAndSet(false, true)) {
                assert (!MatrixStack.contains(matrix4f));
                break;
            }
            Thread.onSpinWait();
        }
        MatrixStack.push(matrix4f);
        MatrixLock.set(false);
    }

    public static Matrix4f getMatrix() {
        Matrix4f matrix4f = null;
        while (true) {
            if (MatrixLock.compareAndSet(false, true)) break;
            Thread.onSpinWait();
        }
        matrix4f = MatrixStack.isEmpty() ? new Matrix4f() : MatrixStack.pop();
        MatrixLock.set(false);
        return matrix4f;
    }

    public static Matrix4f getMatrix(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = HelperFunctions.getMatrix();
        matrix4f2.load(matrix4f);
        return matrix4f2;
    }

    public static Vector3f getVector3f() {
        while (true) {
            if (MatrixLock.compareAndSet(false, true)) {
                Vector3f vector3f = VectorPool.alloc();
                MatrixLock.set(false);
                return vector3f;
            }
            Thread.onSpinWait();
        }
    }

    public static void returnVector3f(Vector3f vector3f) {
        while (true) {
            if (MatrixLock.compareAndSet(false, true)) {
                VectorPool.release(vector3f);
                MatrixLock.set(false);
                return;
            }
            Thread.onSpinWait();
        }
    }

    public static Matrix4f CreateFromQuaternion(Quaternion quaternion) {
        Matrix4f matrix4f = HelperFunctions.getMatrix();
        HelperFunctions.CreateFromQuaternion(quaternion, matrix4f);
        return matrix4f;
    }

    public static Matrix4f CreateFromQuaternion(Quaternion quaternion, Matrix4f matrix4f) {
        float f;
        float f2;
        matrix4f.setIdentity();
        float f3 = quaternion.lengthSquared();
        if (f3 > 0.0f && f3 < 0.99999f || f3 > 1.00001f) {
            f2 = (float)Math.sqrt(f3);
            f = 1.0f / f2;
            quaternion.scale(f);
        }
        f2 = quaternion.x * quaternion.x;
        f = quaternion.x * quaternion.y;
        float f4 = quaternion.x * quaternion.z;
        float f5 = quaternion.x * quaternion.w;
        float f6 = quaternion.y * quaternion.y;
        float f7 = quaternion.y * quaternion.z;
        float f8 = quaternion.y * quaternion.w;
        float f9 = quaternion.z * quaternion.z;
        float f10 = quaternion.z * quaternion.w;
        matrix4f.m00 = 1.0f - 2.0f * (f6 + f9);
        matrix4f.m10 = 2.0f * (f - f10);
        matrix4f.m20 = 2.0f * (f4 + f8);
        matrix4f.m30 = 0.0f;
        matrix4f.m01 = 2.0f * (f + f10);
        matrix4f.m11 = 1.0f - 2.0f * (f2 + f9);
        matrix4f.m21 = 2.0f * (f7 - f5) * 1.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m02 = 2.0f * (f4 - f8);
        matrix4f.m12 = 2.0f * (f7 + f5);
        matrix4f.m22 = 1.0f - 2.0f * (f2 + f6);
        matrix4f.m32 = 0.0f;
        matrix4f.m03 = 0.0f;
        matrix4f.m13 = 0.0f;
        matrix4f.m23 = 0.0f;
        matrix4f.m33 = 1.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m32 = 0.0f;
        matrix4f.transpose();
        return matrix4f;
    }

    public static Matrix4f CreateFromQuaternionPositionScale(Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2, Matrix4f matrix4f) {
        Matrix4f matrix4f2 = HelperFunctions.getMatrix();
        Matrix4f matrix4f3 = HelperFunctions.getMatrix();
        Matrix4f matrix4f4 = HelperFunctions.getMatrix();
        HelperFunctions.CreateFromQuaternionPositionScale(vector3f, quaternion, vector3f2, matrix4f, matrix4f3, matrix4f4, matrix4f2);
        HelperFunctions.returnMatrix(matrix4f2);
        HelperFunctions.returnMatrix(matrix4f3);
        HelperFunctions.returnMatrix(matrix4f4);
        return matrix4f;
    }

    public static void CreateFromQuaternionPositionScale(Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2, TransformResult_QPS transformResult_QPS) {
        HelperFunctions.CreateFromQuaternionPositionScale(vector3f, quaternion, vector3f2, transformResult_QPS.result, transformResult_QPS.trans, transformResult_QPS.rot, transformResult_QPS.scl);
    }

    private static void CreateFromQuaternionPositionScale(Vector3f vector3f, Quaternion quaternion, Vector3f vector3f2, Matrix4f matrix4f, Matrix4f matrix4f2, Matrix4f matrix4f3, Matrix4f matrix4f4) {
        Matrix4f matrix4f5 = matrix4f4;
        Matrix4f matrix4f6 = matrix4f2;
        Matrix4f matrix4f7 = matrix4f3;
        matrix4f5.setIdentity();
        matrix4f5.scale(vector3f2);
        matrix4f6.setIdentity();
        matrix4f6.translate(vector3f);
        matrix4f6.transpose();
        HelperFunctions.CreateFromQuaternion(quaternion, matrix4f7);
        Matrix4f.mul((Matrix4f)matrix4f5, (Matrix4f)matrix4f7, (Matrix4f)matrix4f7);
        Matrix4f.mul((Matrix4f)matrix4f7, (Matrix4f)matrix4f6, (Matrix4f)matrix4f);
    }

    public static void TransformVertices(VertexPositionNormalTangentTextureSkin[] vertexPositionNormalTangentTextureSkinArray, List<Matrix4f> list) {
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector4f vector4f = new Vector4f();
        for (VertexPositionNormalTangentTextureSkin vertexPositionNormalTangentTextureSkin : vertexPositionNormalTangentTextureSkinArray) {
            vector3.reset();
            vector32.reset();
            Vector3 vector33 = vertexPositionNormalTangentTextureSkin.Position;
            Vector3 vector34 = vertexPositionNormalTangentTextureSkin.Normal;
            HelperFunctions.ApplyBlendBone(vertexPositionNormalTangentTextureSkin.BlendWeights.x, list.get(vertexPositionNormalTangentTextureSkin.BlendIndices.X), vector33, vector34, vector4f, vector3, vector32);
            HelperFunctions.ApplyBlendBone(vertexPositionNormalTangentTextureSkin.BlendWeights.y, list.get(vertexPositionNormalTangentTextureSkin.BlendIndices.Y), vector33, vector34, vector4f, vector3, vector32);
            HelperFunctions.ApplyBlendBone(vertexPositionNormalTangentTextureSkin.BlendWeights.z, list.get(vertexPositionNormalTangentTextureSkin.BlendIndices.Z), vector33, vector34, vector4f, vector3, vector32);
            HelperFunctions.ApplyBlendBone(vertexPositionNormalTangentTextureSkin.BlendWeights.w, list.get(vertexPositionNormalTangentTextureSkin.BlendIndices.W), vector33, vector34, vector4f, vector3, vector32);
            vector33.set(vector3);
            vector34.set(vector32);
        }
    }

    public static void ApplyBlendBone(float f, Matrix4f matrix4f, Vector3 vector3, Vector3 vector32, Vector4f vector4f, Vector3 vector33, Vector3 vector34) {
        if (f > 0.0f) {
            float f2 = vector3.x();
            float f3 = vector3.y();
            float f4 = vector3.z();
            float f5 = matrix4f.m00 * f2 + matrix4f.m01 * f3 + matrix4f.m02 * f4 + matrix4f.m03;
            float f6 = matrix4f.m10 * f2 + matrix4f.m11 * f3 + matrix4f.m12 * f4 + matrix4f.m13;
            float f7 = matrix4f.m20 * f2 + matrix4f.m21 * f3 + matrix4f.m22 * f4 + matrix4f.m23;
            vector33.add(f5 * f, f6 * f, f7 * f);
            f2 = vector32.x();
            f3 = vector32.y();
            f4 = vector32.z();
            f5 = matrix4f.m00 * f2 + matrix4f.m01 * f3 + matrix4f.m02 * f4;
            f6 = matrix4f.m10 * f2 + matrix4f.m11 * f3 + matrix4f.m12 * f4;
            f7 = matrix4f.m20 * f2 + matrix4f.m21 * f3 + matrix4f.m22 * f4;
            vector34.add(f5 * f, f6 * f, f7 * f);
        }
    }

    public static Vector3f getPosition(Matrix4f matrix4f, Vector3f vector3f) {
        vector3f.set(matrix4f.m03, matrix4f.m13, matrix4f.m23);
        return vector3f;
    }

    public static void setPosition(Matrix4f matrix4f, Vector3f vector3f) {
        matrix4f.m03 = vector3f.x;
        matrix4f.m13 = vector3f.y;
        matrix4f.m23 = vector3f.z;
    }

    public static Quaternion getRotation(Matrix4f matrix4f, Quaternion quaternion) {
        return Quaternion.setFromMatrix((Matrix4f)matrix4f, (Quaternion)quaternion);
    }

    public static void transform(Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2) {
        quaternion.normalise();
        float f = quaternion.w;
        float f2 = quaternion.x;
        float f3 = quaternion.y;
        float f4 = quaternion.z;
        float f5 = f * f;
        float f6 = f2 * f2 + f3 * f3 + f4 * f4;
        float f7 = vector3f.x;
        float f8 = vector3f.y;
        float f9 = vector3f.z;
        float f10 = f3 * f9 - f4 * f8;
        float f11 = f4 * f7 - f2 * f9;
        float f12 = f2 * f8 - f3 * f7;
        float f13 = f7 * f2 + f8 * f3 + f9 * f4;
        float f14 = (f5 - f6) * f7 + 2.0f * f * f10 + 2.0f * f2 * f13;
        float f15 = (f5 - f6) * f8 + 2.0f * f * f11 + 2.0f * f3 * f13;
        float f16 = (f5 - f6) * f9 + 2.0f * f * f12 + 2.0f * f4 * f13;
        vector3f2.set(f14, f15, f16);
    }

    private static Vector4f transform(Matrix4f matrix4f, Vector4f vector4f, Vector4f vector4f2) {
        float f = matrix4f.m00 * vector4f.x + matrix4f.m01 * vector4f.y + matrix4f.m02 * vector4f.z + matrix4f.m30 * vector4f.w;
        float f2 = matrix4f.m10 * vector4f.x + matrix4f.m11 * vector4f.y + matrix4f.m12 * vector4f.z + matrix4f.m31 * vector4f.w;
        float f3 = matrix4f.m20 * vector4f.x + matrix4f.m21 * vector4f.y + matrix4f.m22 * vector4f.z + matrix4f.m32 * vector4f.w;
        float f4 = matrix4f.m03 * vector4f.x + matrix4f.m13 * vector4f.y + matrix4f.m23 * vector4f.z + matrix4f.m33 * vector4f.w;
        vector4f2.x = f;
        vector4f2.y = f2;
        vector4f2.z = f3;
        vector4f2.w = f4;
        return vector4f2;
    }

    public static float getRotationY(Quaternion quaternion) {
        quaternion.normalise();
        float f = quaternion.w;
        float f2 = quaternion.x;
        float f3 = quaternion.y;
        float f4 = quaternion.z;
        float f5 = f * f;
        float f6 = f2 * f2 + f3 * f3 + f4 * f4;
        float f7 = f3 * 0.0f - f4 * 0.0f;
        float f8 = f2 * 0.0f - f3 * 1.0f;
        float f9 = 1.0f * f2 + 0.0f * f3 + 0.0f * f4;
        float f10 = (f5 - f6) * 1.0f + 2.0f * f * f7 + 2.0f * f2 * f9;
        float f11 = (f5 - f6) * 0.0f + 2.0f * f * f8 + 2.0f * f4 * f9;
        float f12 = (float)Math.atan2(-f11, f10);
        return PZMath.wrap(f12, (float)(-Math.PI), (float)Math.PI);
    }

    public static float getRotationZ(Quaternion quaternion) {
        float f = quaternion.w;
        float f2 = quaternion.x;
        float f3 = quaternion.y;
        float f4 = quaternion.z;
        float f5 = f * f;
        float f6 = f2 * f2 + f3 * f3 + f4 * f4;
        float f7 = f4 * 1.0f;
        float f8 = 1.0f * f2;
        float f9 = (f5 - f6) * 1.0f + 2.0f * f2 * f8;
        float f10 = 2.0f * f * f7 + 2.0f * f3 * f8;
        float f11 = (float)Math.atan2(f10, f9);
        return f11;
    }

    public static Vector3f ToEulerAngles(Quaternion quaternion, Vector3f vector3f) {
        double d = 2.0 * (double)(quaternion.w * quaternion.x + quaternion.y * quaternion.z);
        double d2 = 1.0 - 2.0 * (double)(quaternion.x * quaternion.x + quaternion.y * quaternion.y);
        vector3f.x = (float)Math.atan2(d, d2);
        double d3 = 2.0 * (double)(quaternion.w * quaternion.y - quaternion.z * quaternion.x);
        vector3f.y = Math.abs(d3) >= 1.0 ? (float)Math.copySign(1.5707963705062866, d3) : (float)Math.asin(d3);
        double d4 = 2.0 * (double)(quaternion.w * quaternion.z + quaternion.x * quaternion.y);
        double d5 = 1.0 - 2.0 * (double)(quaternion.y * quaternion.y + quaternion.z * quaternion.z);
        vector3f.z = (float)Math.atan2(d4, d5);
        return vector3f;
    }

    public static Quaternion ToQuaternion(double d, double d2, double d3, Quaternion quaternion) {
        double d4 = Math.cos(d3 * 0.5);
        double d5 = Math.sin(d3 * 0.5);
        double d6 = Math.cos(d2 * 0.5);
        double d7 = Math.sin(d2 * 0.5);
        double d8 = Math.cos(d * 0.5);
        double d9 = Math.sin(d * 0.5);
        quaternion.w = (float)(d4 * d6 * d8 + d5 * d7 * d9);
        quaternion.x = (float)(d4 * d6 * d9 - d5 * d7 * d8);
        quaternion.y = (float)(d5 * d6 * d9 + d4 * d7 * d8);
        quaternion.z = (float)(d5 * d6 * d8 - d4 * d7 * d9);
        return quaternion;
    }

    public static Vector3f getZero3() {
        s_zero3.set(0.0f, 0.0f, 0.0f);
        return s_zero3;
    }

    public static Quaternion getIdentityQ() {
        s_identityQ.setIdentity();
        return s_identityQ;
    }

    static {
        UnitTests.runAll();
    }

    public static class TransformResult_QPS {
        public final Matrix4f result;
        final Matrix4f trans;
        final Matrix4f rot;
        final Matrix4f scl;

        public TransformResult_QPS() {
            this.result = new Matrix4f();
            this.trans = new Matrix4f();
            this.rot = new Matrix4f();
            this.scl = new Matrix4f();
        }

        public TransformResult_QPS(Matrix4f matrix4f) {
            this.result = matrix4f;
            this.trans = new Matrix4f();
            this.rot = new Matrix4f();
            this.scl = new Matrix4f();
        }
    }

    private static final class UnitTests {
        private static final Runnable[] s_unitTests = new Runnable[0];

        private UnitTests() {
        }

        private static void runAll() {
            PZArrayUtil.forEach(s_unitTests, Runnable::run);
        }

        private static final class transformQuaternion {
            private transformQuaternion() {
            }

            public static void run() {
                DebugLog.UnitTests.println("UnitTest_transformQuaternion");
                DebugLog.UnitTests.println("roll, pitch, yaw, out.x, out.y, out.z, cout.x, cout.y, cout.z, result");
                Quaternion quaternion = new Quaternion();
                Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f vector3f2 = new Vector3f(1.0f, 1.0f, 1.0f);
                Vector3f vector3f3 = new Vector3f();
                Vector3f vector3f4 = new Vector3f();
                Matrix4f matrix4f = new Matrix4f();
                Vector4f vector4f = new Vector4f();
                Vector4f vector4f2 = new Vector4f();
                Vector3f vector3f5 = new Vector3f(1.0f, 0.0f, 0.0f);
                Vector3f vector3f6 = new Vector3f(0.0f, 1.0f, 0.0f);
                Vector3f vector3f7 = new Vector3f(0.0f, 0.0f, 1.0f);
                transformQuaternion.runTest(0.0f, 0.0f, 90.0f, quaternion, vector3f3, vector3f4, matrix4f, vector4f, vector4f2, vector3f5, vector3f6, vector3f7);
                transformQuaternion.runTest(0.0f, 0.0f, 5.0f, quaternion, vector3f3, vector3f4, matrix4f, vector4f, vector4f2, vector3f5, vector3f6, vector3f7);
                for (int i = 0; i < 10; ++i) {
                    float f = PZMath.wrap((float)i / 10.0f * 360.0f, -180.0f, 180.0f);
                    for (int j = 0; j < 10; ++j) {
                        float f2 = PZMath.wrap((float)j / 10.0f * 360.0f, -180.0f, 180.0f);
                        for (int k = 0; k < 10; ++k) {
                            float f3 = PZMath.wrap((float)k / 10.0f * 360.0f, -180.0f, 180.0f);
                            transformQuaternion.runTest(f, f2, f3, quaternion, vector3f3, vector3f4, matrix4f, vector4f, vector4f2, vector3f5, vector3f6, vector3f7);
                        }
                    }
                }
                DebugLog.UnitTests.println("UnitTest_transformQuaternion. Complete");
            }

            public static void runTest(float f, float f2, float f3, Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2, Matrix4f matrix4f, Vector4f vector4f, Vector4f vector4f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5) {
                Vector3f vector3f6 = new Vector3f(15.0f, 0.0f, 0.0f);
                matrix4f.setIdentity();
                matrix4f.translate(vector3f6);
                matrix4f.rotate(f * ((float)Math.PI / 180), vector3f3);
                matrix4f.rotate(f2 * ((float)Math.PI / 180), vector3f4);
                matrix4f.rotate(f3 * ((float)Math.PI / 180), vector3f5);
                HelperFunctions.getRotation(matrix4f, quaternion);
                vector3f.set(1.0f, 0.0f, 0.0f);
                vector4f.set(vector3f.x, vector3f.y, vector3f.z, 1.0f);
                HelperFunctions.transform(matrix4f, vector4f, vector4f2);
                HelperFunctions.transform(quaternion, vector3f, vector3f2);
                vector3f2.x += vector3f6.x;
                vector3f2.y += vector3f6.y;
                vector3f2.z += vector3f6.z;
                boolean bl = PZMath.equal(vector3f2.x, vector4f2.x, 0.01f) && PZMath.equal(vector3f2.y, vector4f2.y, 0.01f) && PZMath.equal(vector3f2.z, vector4f2.z, 0.01f);
                DebugLog.UnitTests.printUnitTest("%f,%f,%f,%f,%f,%f,%f,%f,%f", bl, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(vector3f2.x), Float.valueOf(vector3f2.y), Float.valueOf(vector3f2.z), Float.valueOf(vector4f2.x), Float.valueOf(vector4f2.y), Float.valueOf(vector4f2.z));
            }
        }

        private static final class getRotationMatrix {
            private getRotationMatrix() {
            }

            public static void run() {
                DebugLog.UnitTests.println("UnitTest_getRotationMatrix");
                DebugLog.UnitTests.println("q.x, q.y, q.z, q.w, q_out.x, q_out.y, q_out.z, q_out.w");
                Quaternion quaternion = new Quaternion();
                Vector4f vector4f = new Vector4f();
                Matrix4f matrix4f = new Matrix4f();
                Quaternion quaternion2 = new Quaternion();
                Quaternion quaternion3 = new Quaternion();
                for (int i = 0; i < 360; i += 10) {
                    float f = PZMath.wrap(i, -180.0f, 180.0f);
                    vector4f.set(1.0f, 0.0f, 0.0f, f * ((float)Math.PI / 180));
                    quaternion.setFromAxisAngle(vector4f);
                    HelperFunctions.CreateFromQuaternion(quaternion, matrix4f);
                    HelperFunctions.getRotation(matrix4f, quaternion2);
                    quaternion3.set(-quaternion2.x, -quaternion2.y, -quaternion2.z, -quaternion2.w);
                    boolean bl = PZMath.equal(quaternion.x, quaternion2.x, 0.01f) && PZMath.equal(quaternion.y, quaternion2.y, 0.01f) && PZMath.equal(quaternion.z, quaternion2.z, 0.01f) && PZMath.equal(quaternion.w, quaternion2.w, 0.01f) || PZMath.equal(quaternion.x, quaternion3.x, 0.01f) && PZMath.equal(quaternion.y, quaternion3.y, 0.01f) && PZMath.equal(quaternion.z, quaternion3.z, 0.01f) && PZMath.equal(quaternion.w, quaternion3.w, 0.01f);
                    DebugLog.UnitTests.printUnitTest("%f,%f,%f,%f, %f,%f,%f,%f", bl, Float.valueOf(quaternion.x), Float.valueOf(quaternion.y), Float.valueOf(quaternion.z), Float.valueOf(quaternion.w), Float.valueOf(quaternion2.x), Float.valueOf(quaternion2.y), Float.valueOf(quaternion2.z), Float.valueOf(quaternion2.w));
                }
                DebugLog.UnitTests.println("UnitTest_getRotationMatrix. Complete");
            }
        }

        private static final class getRotationY {
            private getRotationY() {
            }

            public static void run() {
                DebugLog.UnitTests.println("UnitTest_getRotationY");
                DebugLog.UnitTests.println("in, out, result");
                Quaternion quaternion = new Quaternion();
                for (int i = 0; i < 360; ++i) {
                    float f = PZMath.wrap(i, -180.0f, 180.0f);
                    quaternion.setFromAxisAngle(new Vector4f(0.0f, 1.0f, 0.0f, f * ((float)Math.PI / 180)));
                    float f2 = HelperFunctions.getRotationY(quaternion) * 57.295776f;
                    boolean bl = PZMath.equal(f, f2, 0.001f);
                    DebugLog.UnitTests.printUnitTest("%f,%f", bl, Float.valueOf(f), Float.valueOf(f2));
                }
                DebugLog.UnitTests.println("UnitTest_getRotationY. Complete");
            }
        }

        private static final class getRotationZ {
            private getRotationZ() {
            }

            public static void run() {
                DebugLog.UnitTests.println("UnitTest_getRotationZ");
                DebugLog.UnitTests.println("in, out, result");
                Quaternion quaternion = new Quaternion();
                for (int i = 0; i < 360; ++i) {
                    float f = PZMath.wrap(i, -180.0f, 180.0f);
                    quaternion.setFromAxisAngle(new Vector4f(0.0f, 0.0f, 1.0f, f * ((float)Math.PI / 180)));
                    float f2 = HelperFunctions.getRotationZ(quaternion) * 57.295776f;
                    boolean bl = PZMath.equal(f, f2, 0.001f);
                    DebugLog.UnitTests.printUnitTest("%f,%f", bl, Float.valueOf(f), Float.valueOf(f2));
                }
                DebugLog.UnitTests.println("UnitTest_getRotationZ. Complete");
            }
        }
    }
}

