/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.skinnedmodel;

import java.util.ArrayList;
import zombie.core.skinnedmodel.DeadBodyAtlas;
import zombie.iso.IsoDirections;

public final class CharacterTextures {
    final ArrayList<CTAnimSet> m_animSets = new ArrayList();

    CTAnimSet getAnimSet(String string) {
        for (int i = 0; i < this.m_animSets.size(); ++i) {
            CTAnimSet cTAnimSet = this.m_animSets.get(i);
            if (!cTAnimSet.m_name.equals(string)) continue;
            return cTAnimSet;
        }
        return null;
    }

    DeadBodyAtlas.BodyTexture getTexture(String string, String string2, IsoDirections isoDirections, int n) {
        CTAnimSet cTAnimSet = this.getAnimSet(string);
        if (cTAnimSet == null) {
            return null;
        }
        CTState cTState = cTAnimSet.getState(string2);
        if (cTState == null) {
            return null;
        }
        CTEntry cTEntry = cTState.getEntry(isoDirections, n);
        if (cTEntry == null) {
            return null;
        }
        return cTEntry.m_texture;
    }

    void addTexture(String string, String string2, IsoDirections isoDirections, int n, DeadBodyAtlas.BodyTexture bodyTexture) {
        CTAnimSet cTAnimSet = this.getAnimSet(string);
        if (cTAnimSet == null) {
            cTAnimSet = new CTAnimSet();
            cTAnimSet.m_name = string;
            this.m_animSets.add(cTAnimSet);
        }
        cTAnimSet.addEntry(string2, isoDirections, n, bodyTexture);
    }

    void clear() {
        this.m_animSets.clear();
    }

    private static final class CTAnimSet {
        String m_name;
        final ArrayList<CTState> m_states = new ArrayList();

        private CTAnimSet() {
        }

        CTState getState(String string) {
            for (int i = 0; i < this.m_states.size(); ++i) {
                CTState cTState = this.m_states.get(i);
                if (!cTState.m_name.equals(string)) continue;
                return cTState;
            }
            return null;
        }

        void addEntry(String string, IsoDirections isoDirections, int n, DeadBodyAtlas.BodyTexture bodyTexture) {
            CTState cTState = this.getState(string);
            if (cTState == null) {
                cTState = new CTState();
                cTState.m_name = string;
                this.m_states.add(cTState);
            }
            cTState.addEntry(isoDirections, n, bodyTexture);
        }
    }

    private static final class CTState {
        String m_name;
        final CTEntryList[] m_entries = new CTEntryList[IsoDirections.values().length];

        CTState() {
            for (int i = 0; i < this.m_entries.length; ++i) {
                this.m_entries[i] = new CTEntryList();
            }
        }

        CTEntry getEntry(IsoDirections isoDirections, int n) {
            CTEntryList cTEntryList = this.m_entries[isoDirections.index()];
            for (int i = 0; i < cTEntryList.size(); ++i) {
                CTEntry cTEntry = (CTEntry)cTEntryList.get(i);
                if (cTEntry.m_frame != n) continue;
                return cTEntry;
            }
            return null;
        }

        void addEntry(IsoDirections isoDirections, int n, DeadBodyAtlas.BodyTexture bodyTexture) {
            CTEntryList cTEntryList = this.m_entries[isoDirections.index()];
            CTEntry cTEntry = new CTEntry();
            cTEntry.m_frame = n;
            cTEntry.m_texture = bodyTexture;
            cTEntryList.add(cTEntry);
        }
    }

    private static final class CTEntry {
        int m_frame;
        DeadBodyAtlas.BodyTexture m_texture;

        private CTEntry() {
        }
    }

    private static final class CTEntryList
    extends ArrayList<CTEntry> {
        private CTEntryList() {
        }
    }
}

