/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.raknet;

import java.nio.ByteBuffer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.raknet.RakNetPeerInterface;
import zombie.core.raknet.VoiceManager;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.network.GameServer;

public class VoiceTest {
    protected static boolean bQuit = false;
    protected static ByteBuffer serverBuf = ByteBuffer.allocate(500000);
    protected static ByteBuffer clientBuf = ByteBuffer.allocate(500000);
    protected static RakNetPeerInterface rnclientPeer;
    protected static RakNetPeerInterface rnserverPeer;

    protected static void rakNetServer(int n) {
        int n2 = 2;
        String string = "test";
        rnserverPeer = new RakNetPeerInterface();
        DebugLog.log("Initialising RakNet...");
        rnserverPeer.Init(false);
        rnserverPeer.SetMaximumIncomingConnections(n2);
        if (GameServer.IPCommandline != null) {
            rnserverPeer.SetServerIP(GameServer.IPCommandline);
        }
        rnserverPeer.SetServerPort(n, n + 1);
        rnserverPeer.SetIncomingPassword(string);
        rnserverPeer.SetOccasionalPing(true);
        int n3 = rnserverPeer.Startup(n2);
        System.out.println("RakNet.Startup() return code: " + n3 + " (0 means success)");
    }

    public static ByteBuffer rakNetServerReceive() {
        boolean bl = false;
        do {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            bl = rnserverPeer.Receive(serverBuf);
        } while (!bQuit && !bl);
        return serverBuf;
    }

    private static void rakNetServerDecode(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 19: {
                System.out.println("ID_NEW_INCOMING_CONNECTION");
                int n2 = byteBuffer.get() & 0xFF;
                long l = rnserverPeer.getGuidOfPacket();
                System.out.println("id=" + n2 + " guid=" + l);
                VoiceManager.instance.VoiceConnectReq(l);
                break;
            }
            case 16: {
                System.out.println("Connection Request Accepted");
                int n3 = byteBuffer.get() & 0xFF;
                long l = rnserverPeer.getGuidOfPacket();
                VoiceManager.instance.VoiceConnectReq(l);
                break;
            }
            case 0: 
            case 1: {
                System.out.println("PING");
                break;
            }
            default: {
                System.out.println("Received: " + n);
            }
        }
    }

    protected static void rakNetClient() {
        int n = 2;
        String string = "test";
        rnclientPeer = new RakNetPeerInterface();
        DebugLog.log("Initialising RakNet...");
        rnclientPeer.Init(false);
        rnclientPeer.SetMaximumIncomingConnections(n);
        rnclientPeer.SetClientPort(GameServer.DEFAULT_PORT + Rand.Next(10000) + 1234);
        rnclientPeer.SetOccasionalPing(true);
        int n2 = rnclientPeer.Startup(n);
        System.out.println("RakNet.Startup() return code: " + n2 + " (0 means success)");
    }

    public static ByteBuffer rakNetClientReceive() {
        boolean bl = false;
        do {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            bl = rnclientPeer.Receive(clientBuf);
        } while (!bQuit && !bl);
        return clientBuf;
    }

    private static void rakNetClientDecode(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 19: {
                System.out.println("ID_NEW_INCOMING_CONNECTION");
                int n2 = byteBuffer.get() & 0xFF;
                long l = rnclientPeer.getGuidOfPacket();
                System.out.println("id=" + n2 + " guid=" + l);
                VoiceManager.instance.VoiceConnectReq(l);
                break;
            }
            case 16: {
                System.out.println("Connection Request Accepted");
                int n3 = byteBuffer.get() & 0xFF;
                long l = rnclientPeer.getGuidOfPacket();
                VoiceManager.instance.VoiceConnectReq(l);
                break;
            }
            case 0: 
            case 1: {
                System.out.println("PING");
                break;
            }
            default: {
                System.out.println("Received: " + n);
            }
        }
    }

    public static void main(String[] stringArray) {
        DebugLog.log("VoiceTest: START");
        DebugLog.log("version=" + Core.getInstance().getVersion() + " demo=false");
        DebugLog.log("VoiceTest: SteamUtils.init - EXEC");
        SteamUtils.init();
        DebugLog.log("VoiceTest: SteamUtils.init - OK");
        DebugLog.log("VoiceTest: RakNetPeerInterface - EXEC");
        RakNetPeerInterface.init();
        DebugLog.log("VoiceTest: RakNetPeerInterface - OK");
        DebugLog.log("VoiceTest: VoiceManager.InitVMServer - EXEC");
        VoiceManager.instance.InitVMServer();
        DebugLog.log("VoiceTest: VoiceManager.InitVMServer - OK");
        DebugLog.log("VoiceTest: rakNetServer - EXEC");
        VoiceTest.rakNetServer(16000);
        DebugLog.log("VoiceTest: rakNetServer - OK");
        DebugLog.log("VoiceTest: rakNetClient - EXEC");
        VoiceTest.rakNetClient();
        DebugLog.log("VoiceTest: rakNetClient - OK");
        DebugLog.log("VoiceTest: rnclientPeer.Connect - EXEC");
        rnclientPeer.Connect("127.0.0.1", 16000, "test", false);
        DebugLog.log("VoiceTest: rnclientPeer.Connect - OK");
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!bQuit && !bQuit) {
                    ByteBuffer byteBuffer = VoiceTest.rakNetServerReceive();
                    try {
                        VoiceTest.rakNetServerDecode(byteBuffer);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        thread.setName("serverThread");
        thread.start();
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                while (!bQuit && !bQuit) {
                    ByteBuffer byteBuffer = VoiceTest.rakNetClientReceive();
                    try {
                        VoiceTest.rakNetClientDecode(byteBuffer);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        thread2.setName("clientThread");
        thread2.start();
        DebugLog.log("VoiceTest: sleep 10 sec");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

