/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.raknet;

import fmod.FMODSoundBuffer;
import fmod.SoundBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class VoiceDebug
extends JPanel {
    private static final int PREF_W = 400;
    private static final int PREF_H = 200;
    private static final int BORDER_GAP = 30;
    private static final Color LINE_CURRENT_COLOR = Color.blue;
    private static final Color LINE_LAST_COLOR = Color.red;
    private static final Color GRAPH_COLOR = Color.green;
    private static final Color GRAPH_POINT_COLOR = new Color(150, 50, 50, 180);
    private static final Stroke GRAPH_STROKE = new BasicStroke(3.0f);
    private static final int GRAPH_POINT_WIDTH = 12;
    private static final int Y_HATCH_CNT = 10;
    public List<Integer> scores;
    public int scores_max;
    public String title;
    public int psize;
    public int last;
    public int current;
    private static VoiceDebug mainPanel;
    private static VoiceDebug mainPanel2;
    private static VoiceDebug mainPanel3;
    private static VoiceDebug mainPanel4;
    private static JFrame frame;

    public VoiceDebug(List<Integer> list, String string) {
        this.scores = list;
        this.title = string;
        this.psize = list.size();
        this.last = 5;
        this.current = 8;
        this.scores_max = 100;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d = ((double)this.getWidth() - 60.0) / (double)(this.scores.size() - 1);
        double d2 = ((double)this.getHeight() - 60.0) / (double)(this.scores_max - 1);
        int n6 = (int)(((double)this.getHeight() - 60.0) / 2.0);
        int n7 = (int)(1.0 / d);
        if (n7 == 0) {
            n7 = 1;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (n5 = 0; n5 < this.scores.size(); n5 += n7) {
            n4 = (int)((double)n5 * d + 30.0);
            n3 = (int)((double)(this.scores_max - this.scores.get(n5)) * d2 + 30.0 - (double)n6);
            arrayList.add(new Point(n4, n3));
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(30, this.getHeight() - 30, 30, 30);
        graphics2D.drawLine(30, this.getHeight() - 30, this.getWidth() - 30, this.getHeight() - 30);
        for (n5 = 0; n5 < 10; ++n5) {
            n4 = 30;
            n3 = 42;
            n = n2 = this.getHeight() - ((n5 + 1) * (this.getHeight() - 60) / 10 + 30);
            graphics2D.drawLine(n4, n2, n3, n);
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(GRAPH_COLOR);
        graphics2D.setStroke(GRAPH_STROKE);
        for (n4 = 0; n4 < arrayList.size() - 1; ++n4) {
            n3 = ((Point)arrayList.get((int)n4)).x;
            n2 = ((Point)arrayList.get((int)n4)).y;
            n = ((Point)arrayList.get((int)(n4 + 1))).x;
            int n8 = ((Point)arrayList.get((int)(n4 + 1))).y;
            graphics2D.drawLine(n3, n2, n, n8);
        }
        double d3 = ((double)this.getWidth() - 60.0) / (double)(this.psize - 1);
        graphics2D.setColor(LINE_CURRENT_COLOR);
        n2 = (int)((double)this.current * d3 + 30.0);
        graphics2D.drawLine(n2, this.getHeight() - 30, n2, 30);
        graphics2D.drawString("Current", n2, this.getHeight() - 30);
        graphics2D.setColor(LINE_LAST_COLOR);
        n = (int)((double)this.last * d3 + 30.0);
        graphics2D.drawLine(n, this.getHeight() - 30, n, 30);
        graphics2D.drawString("Last", n, this.getHeight() - 30);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(this.title, this.getWidth() / 2, 15);
        graphics2D.drawString("Size: " + this.scores.size(), 30, 15);
        graphics2D.drawString("Current/Write: " + this.current, 30, 30);
        graphics2D.drawString("Last/Read: " + this.last, 30, 45);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 200);
    }

    public static void createAndShowGui() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        mainPanel = new VoiceDebug(arrayList, "SoundBuffer");
        VoiceDebug.mainPanel.scores_max = 32000;
        mainPanel2 = new VoiceDebug(arrayList2, "SoundBuffer - first 100 sample");
        VoiceDebug.mainPanel2.scores_max = 32000;
        mainPanel3 = new VoiceDebug(arrayList3, "FMODSoundBuffer");
        VoiceDebug.mainPanel3.scores_max = 32000;
        mainPanel4 = new VoiceDebug(arrayList4, "FMODSoundBuffer - first 100 sample");
        VoiceDebug.mainPanel4.scores_max = 32000;
        frame = new JFrame("DrawGraph");
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new GridLayout(2, 2));
        frame.getContentPane().add(mainPanel);
        frame.getContentPane().add(mainPanel2);
        frame.getContentPane().add(mainPanel3);
        frame.getContentPane().add(mainPanel4);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void updateGui(SoundBuffer soundBuffer, FMODSoundBuffer fMODSoundBuffer) {
        int n;
        VoiceDebug.mainPanel.scores.clear();
        if (soundBuffer != null) {
            for (n = 0; n < soundBuffer.buf().length; ++n) {
                VoiceDebug.mainPanel.scores.add(Integer.valueOf(soundBuffer.buf()[n]));
            }
            VoiceDebug.mainPanel.current = soundBuffer.Buf_Write;
            VoiceDebug.mainPanel.last = soundBuffer.Buf_Read;
            VoiceDebug.mainPanel.psize = soundBuffer.Buf_Size;
            VoiceDebug.mainPanel2.scores.clear();
            for (n = 0; n < 100; ++n) {
                VoiceDebug.mainPanel2.scores.add(Integer.valueOf(soundBuffer.buf()[n]));
            }
        }
        VoiceDebug.mainPanel3.scores.clear();
        VoiceDebug.mainPanel4.scores.clear();
        for (n = 0; n < fMODSoundBuffer.buf().length / 2; n += 2) {
            VoiceDebug.mainPanel4.scores.add(fMODSoundBuffer.buf()[n + 1] * 256 + fMODSoundBuffer.buf()[n]);
        }
        frame.repaint();
    }
}

