/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.raknet;

import gnu.trove.list.array.TShortArrayList;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zombie.SystemDisabler;
import zombie.characters.IsoPlayer;
import zombie.commands.PlayerType;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.RakNetPeerInterface;
import zombie.core.raknet.UdpEngine;
import zombie.core.utils.UpdateTimer;
import zombie.core.znet.ZNetStatistics;
import zombie.iso.IsoUtils;
import zombie.iso.Vector3;
import zombie.network.ClientServerMap;
import zombie.network.ConnectionManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistic;
import zombie.network.PacketValidator;
import zombie.network.PlayerDownloadServer;

public class UdpConnection {
    Lock bufferLock = new ReentrantLock();
    private ByteBuffer bb = ByteBuffer.allocate(1000000);
    private ByteBufferWriter bbw = new ByteBufferWriter(this.bb);
    Lock bufferLockPing = new ReentrantLock();
    private ByteBuffer bbPing = ByteBuffer.allocate(50);
    private ByteBufferWriter bbwPing = new ByteBufferWriter(this.bbPing);
    long connectedGUID = 0L;
    UdpEngine engine;
    public int index;
    public boolean allChatMuted = false;
    public String username;
    public String[] usernames = new String[4];
    public byte ReleventRange;
    public byte accessLevel = 1;
    public long lastUnauthorizedPacket = 0L;
    public String ip;
    public boolean preferredInQueue;
    public boolean wasInLoadingQueue;
    public String password;
    public boolean ping = false;
    public Vector3[] ReleventPos = new Vector3[4];
    public short[] playerIDs = new short[4];
    public IsoPlayer[] players = new IsoPlayer[4];
    public Vector3[] connectArea = new Vector3[4];
    public int ChunkGridWidth;
    public ClientServerMap[] loadedCells = new ClientServerMap[4];
    public PlayerDownloadServer playerDownloadServer;
    public ChecksumState checksumState = ChecksumState.Init;
    public long checksumTime;
    public boolean awaitingCoopApprove = false;
    public long steamID;
    public long ownerID;
    public String idStr;
    public boolean isCoopHost;
    public int maxPlayers;
    public final TShortArrayList chunkObjectState = new TShortArrayList();
    public MPClientStatistic statistic = new MPClientStatistic();
    public ZNetStatistics netStatistics;
    public final Deque<Long> pingHistory = new ArrayDeque<Long>();
    public final PacketValidator validator = new PacketValidator(this);
    private static final long CONNECTION_ATTEMPT_TIMEOUT = 5000L;
    public static final long CONNECTION_GRACE_INTERVAL = 60000L;
    public long connectionTimestamp;
    public UpdateTimer timerSendZombie = new UpdateTimer();
    private boolean bFullyConnected = false;
    public boolean isNeighborPlayer = false;

    public UdpConnection(UdpEngine udpEngine, long l, int n) {
        this.engine = udpEngine;
        this.connectedGUID = l;
        this.index = n;
        this.ReleventPos[0] = new Vector3();
        for (int i = 0; i < 4; ++i) {
            this.playerIDs[i] = -1;
        }
        this.connectionTimestamp = System.currentTimeMillis();
        this.wasInLoadingQueue = false;
    }

    public RakNetPeerInterface getPeer() {
        return this.engine.peer;
    }

    public long getConnectedGUID() {
        return this.connectedGUID;
    }

    public String getServerIP() {
        return this.engine.getServerIP();
    }

    public ByteBufferWriter startPacket() {
        this.bufferLock.lock();
        this.bb.clear();
        return this.bbw;
    }

    public ByteBufferWriter startPingPacket() {
        this.bufferLockPing.lock();
        this.bbPing.clear();
        return this.bbwPing;
    }

    public boolean RelevantTo(float f, float f2) {
        for (int i = 0; i < 4; ++i) {
            if (this.connectArea[i] != null) {
                int n = (int)this.connectArea[i].z;
                int n2 = (int)(this.connectArea[i].x - (float)(n / 2)) * 10;
                int n3 = (int)(this.connectArea[i].y - (float)(n / 2)) * 10;
                int n4 = n2 + n * 10;
                int n5 = n3 + n * 10;
                if (f >= (float)n2 && f < (float)n4 && f2 >= (float)n3 && f2 < (float)n5) {
                    return true;
                }
            }
            if (this.ReleventPos[i] == null || !(Math.abs(this.ReleventPos[i].x - f) <= (float)(this.ReleventRange * 10)) || !(Math.abs(this.ReleventPos[i].y - f2) <= (float)(this.ReleventRange * 10))) continue;
            return true;
        }
        return false;
    }

    public float getRelevantAndDistance(float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            if (this.ReleventPos[i] == null || !(Math.abs(this.ReleventPos[i].x - f) <= (float)(this.ReleventRange * 10)) || !(Math.abs(this.ReleventPos[i].y - f2) <= (float)(this.ReleventRange * 10))) continue;
            return IsoUtils.DistanceTo(this.ReleventPos[i].x, this.ReleventPos[i].y, f, f2);
        }
        return Float.POSITIVE_INFINITY;
    }

    public boolean RelevantToPlayerIndex(int n, float f, float f2) {
        if (this.connectArea[n] != null) {
            int n2 = (int)this.connectArea[n].z;
            int n3 = (int)(this.connectArea[n].x - (float)(n2 / 2)) * 10;
            int n4 = (int)(this.connectArea[n].y - (float)(n2 / 2)) * 10;
            int n5 = n3 + n2 * 10;
            int n6 = n4 + n2 * 10;
            if (f >= (float)n3 && f < (float)n5 && f2 >= (float)n4 && f2 < (float)n6) {
                return true;
            }
        }
        return this.ReleventPos[n] != null && Math.abs(this.ReleventPos[n].x - f) <= (float)(this.ReleventRange * 10) && Math.abs(this.ReleventPos[n].y - f2) <= (float)(this.ReleventRange * 10);
    }

    public boolean RelevantTo(float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            if (this.connectArea[i] != null) {
                int n = (int)this.connectArea[i].z;
                int n2 = (int)(this.connectArea[i].x - (float)(n / 2)) * 10;
                int n3 = (int)(this.connectArea[i].y - (float)(n / 2)) * 10;
                int n4 = n2 + n * 10;
                int n5 = n3 + n * 10;
                if (f >= (float)n2 && f < (float)n4 && f2 >= (float)n3 && f2 < (float)n5) {
                    return true;
                }
            }
            if (this.ReleventPos[i] == null || !(Math.abs(this.ReleventPos[i].x - f) <= f3) || !(Math.abs(this.ReleventPos[i].y - f2) <= f3)) continue;
            return true;
        }
        return false;
    }

    public void cancelPacket() {
        this.bufferLock.unlock();
    }

    public int getBufferPosition() {
        return this.bb.position();
    }

    public void endPacket(int n, int n2, byte by) {
        int n3;
        if (GameServer.bServer) {
            n3 = this.bb.position();
            this.bb.position(1);
            MPStatistic.getInstance().addOutcomePacket(this.bb.getShort(), n3);
            this.bb.position(n3);
        }
        this.bb.flip();
        n3 = this.engine.peer.Send(this.bb, n, n2, by, this.connectedGUID, false);
        this.bufferLock.unlock();
    }

    public void endPacket() {
        int n;
        if (GameServer.bServer) {
            n = this.bb.position();
            this.bb.position(1);
            MPStatistic.getInstance().addOutcomePacket(this.bb.getShort(), n);
            this.bb.position(n);
        }
        this.bb.flip();
        n = this.engine.peer.Send(this.bb, 1, 3, (byte)0, this.connectedGUID, false);
        this.bufferLock.unlock();
    }

    public void endPacketImmediate() {
        int n;
        if (GameServer.bServer) {
            n = this.bb.position();
            this.bb.position(1);
            MPStatistic.getInstance().addOutcomePacket(this.bb.getShort(), n);
            this.bb.position(n);
        }
        this.bb.flip();
        n = this.engine.peer.Send(this.bb, 0, 3, (byte)0, this.connectedGUID, false);
        this.bufferLock.unlock();
    }

    public void endPacketUnordered() {
        int n;
        if (GameServer.bServer) {
            n = this.bb.position();
            this.bb.position(1);
            MPStatistic.getInstance().addOutcomePacket(this.bb.getShort(), n);
            this.bb.position(n);
        }
        this.bb.flip();
        n = this.engine.peer.Send(this.bb, 2, 2, (byte)0, this.connectedGUID, false);
        this.bufferLock.unlock();
    }

    public void endPacketUnreliable() {
        this.bb.flip();
        int n = this.engine.peer.Send(this.bb, 2, 1, (byte)0, this.connectedGUID, false);
        this.bufferLock.unlock();
    }

    public void endPacketSuperHighUnreliable() {
        int n;
        if (GameServer.bServer) {
            n = this.bb.position();
            this.bb.position(1);
            MPStatistic.getInstance().addOutcomePacket(this.bb.getShort(), n);
            this.bb.position(n);
        }
        this.bb.flip();
        n = this.engine.peer.Send(this.bb, 0, 1, (byte)0, this.connectedGUID, false);
        this.bufferLock.unlock();
    }

    public void endPingPacket() {
        if (GameServer.bServer) {
            int n = this.bb.position();
            this.bb.position(1);
            MPStatistic.getInstance().addOutcomePacket(this.bb.getShort(), n);
            this.bb.position(n);
        }
        this.bbPing.flip();
        this.engine.peer.Send(this.bbPing, 0, 1, (byte)0, this.connectedGUID, false);
        this.bufferLockPing.unlock();
    }

    public InetSocketAddress getInetSocketAddress() {
        String string = this.engine.peer.getIPFromGUID(this.connectedGUID);
        if ("UNASSIGNED_SYSTEM_ADDRESS".equals(string)) {
            return null;
        }
        string = string.replace("|", "\u00c2\u00a3");
        String[] stringArray = string.split("\u00c2\u00a3");
        InetSocketAddress inetSocketAddress = new InetSocketAddress(stringArray[0], Integer.parseInt(stringArray[1]));
        return inetSocketAddress;
    }

    public void forceDisconnect(String string) {
        if (!GameServer.bServer) {
            GameClient.instance.disconnect();
        }
        this.engine.forceDisconnect(this.getConnectedGUID(), string);
        ConnectionManager.log("force-disconnect", string, this);
    }

    public void setFullyConnected() {
        this.validator.reset();
        this.bFullyConnected = true;
        this.setConnectionTimestamp();
        ConnectionManager.log("fully-connected", "", this);
    }

    public void setConnectionTimestamp() {
        this.connectionTimestamp = System.currentTimeMillis();
    }

    public boolean isConnectionAttemptTimeout() {
        return System.currentTimeMillis() > this.connectionTimestamp + 5000L;
    }

    public boolean isConnectionGraceIntervalTimeout() {
        return System.currentTimeMillis() > this.connectionTimestamp + 60000L || Core.bDebug && SystemDisabler.doKickInDebug;
    }

    public boolean isFullyConnected() {
        return this.bFullyConnected;
    }

    public void calcCountPlayersInRelevantPosition() {
        if (!this.isFullyConnected()) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.isFullyConnected() || udpConnection == this) continue;
            for (int j = 0; j < udpConnection.players.length; ++j) {
                IsoPlayer isoPlayer = udpConnection.players[j];
                if (isoPlayer == null || !this.RelevantTo(isoPlayer.x, isoPlayer.y, 120.0f)) continue;
                bl = true;
            }
            if (bl) break;
        }
        this.isNeighborPlayer = bl;
    }

    public ZNetStatistics getStatistics() {
        try {
            this.netStatistics = this.engine.peer.GetNetStatistics(this.connectedGUID);
            return this.netStatistics;
        }
        catch (Exception exception) {
            this.netStatistics = null;
            return this.netStatistics;
        }
        finally {
            return this.netStatistics;
        }
    }

    public int getAveragePing() {
        return this.engine.peer.GetAveragePing(this.connectedGUID);
    }

    public int getLastPing() {
        return this.engine.peer.GetLastPing(this.connectedGUID);
    }

    public int getLowestPing() {
        return this.engine.peer.GetLowestPing(this.connectedGUID);
    }

    public int getMTUSize() {
        return this.engine.peer.GetMTUSize(this.connectedGUID);
    }

    public ConnectionType getConnectionType() {
        return ConnectionType.values()[this.engine.peer.GetConnectionType(this.connectedGUID)];
    }

    public String toString() {
        if (GameClient.bClient) {
            return String.format("guid=%s ip=%s steam-id=%s access=\"%s\" username=\"%s\" connection-type=\"%s\"", this.connectedGUID, this.ip == null ? GameClient.ip : this.ip, this.steamID == 0L ? GameClient.steamID : this.steamID, PlayerType.toString(this.accessLevel), this.username == null ? GameClient.username : this.username, this.getConnectionType().name());
        }
        return String.format("guid=%s ip=%s steam-id=%s access=%s username=\"%s\" connection-type=\"%s\"", this.connectedGUID, this.ip, this.steamID, PlayerType.toString(this.accessLevel), this.username, this.getConnectionType().name());
    }

    public boolean havePlayer(IsoPlayer isoPlayer) {
        if (isoPlayer == null) {
            return false;
        }
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] != isoPlayer) continue;
            return true;
        }
        return false;
    }

    public static enum ChecksumState {
        Init,
        Different,
        Done;

    }

    public class MPClientStatistic {
        public byte enable = 0;
        public int diff = 0;
        public float pingAVG = 0.0f;
        public int zombiesCount = 0;
        public int zombiesLocalOwnership = 0;
        public float zombiesDesyncAVG = 0.0f;
        public float zombiesDesyncMax = 0.0f;
        public int zombiesTeleports = 0;
        public int remotePlayersCount = 0;
        public float remotePlayersDesyncAVG = 0.0f;
        public float remotePlayersDesyncMax = 0.0f;
        public int remotePlayersTeleports = 0;
        public float FPS = 0.0f;
        public float FPSMin = 0.0f;
        public float FPSAvg = 0.0f;
        public float FPSMax = 0.0f;
        public short[] FPSHistogramm = new short[32];

        public void parse(ByteBuffer byteBuffer) {
            long l = byteBuffer.getLong();
            long l2 = System.currentTimeMillis();
            this.diff = (int)(l2 - l);
            this.pingAVG += ((float)this.diff * 0.5f - this.pingAVG) * 0.1f;
            this.zombiesCount = byteBuffer.getInt();
            this.zombiesLocalOwnership = byteBuffer.getInt();
            this.zombiesDesyncAVG = byteBuffer.getFloat();
            this.zombiesDesyncMax = byteBuffer.getFloat();
            this.zombiesTeleports = byteBuffer.getInt();
            this.remotePlayersCount = byteBuffer.getInt();
            this.remotePlayersDesyncAVG = byteBuffer.getFloat();
            this.remotePlayersDesyncMax = byteBuffer.getFloat();
            this.remotePlayersTeleports = byteBuffer.getInt();
            this.FPS = byteBuffer.getFloat();
            this.FPSMin = byteBuffer.getFloat();
            this.FPSAvg = byteBuffer.getFloat();
            this.FPSMax = byteBuffer.getFloat();
            for (int i = 0; i < 32; ++i) {
                this.FPSHistogramm[i] = byteBuffer.getShort();
            }
        }
    }

    public static enum ConnectionType {
        Disconnected,
        UDPRakNet,
        Steam;

    }
}

