/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.properties;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import zombie.core.Collections.NonBlockingHashMap;
import zombie.core.TilePropertyAliasMap;
import zombie.iso.SpriteDetails.IsoFlagType;

public final class PropertyContainer {
    private long SpriteFlags1 = 0L;
    private long SpriteFlags2 = 0L;
    private final TIntIntHashMap Properties = new TIntIntHashMap();
    private int[] keyArray;
    public static NonBlockingHashMap<IsoFlagType, MostTested> test = new NonBlockingHashMap();
    public static List<Object> sorted = Collections.synchronizedList(new ArrayList());
    private byte Surface;
    private byte SurfaceFlags;
    private short StackReplaceTileOffset;
    private byte ItemHeight;
    private static final byte SURFACE_VALID = 1;
    private static final byte SURFACE_ISOFFSET = 2;
    private static final byte SURFACE_ISTABLE = 4;
    private static final byte SURFACE_ISTABLETOP = 8;

    public void CreateKeySet() {
        TIntSet tIntSet = this.Properties.keySet();
        this.keyArray = tIntSet.toArray();
    }

    public void AddProperties(PropertyContainer propertyContainer) {
        if (propertyContainer.keyArray == null) {
            return;
        }
        for (int i = 0; i < propertyContainer.keyArray.length; ++i) {
            int n = propertyContainer.keyArray[i];
            this.Properties.put(n, propertyContainer.Properties.get(n));
        }
        this.SpriteFlags1 |= propertyContainer.SpriteFlags1;
        this.SpriteFlags2 |= propertyContainer.SpriteFlags2;
    }

    public void Clear() {
        this.SpriteFlags1 = 0L;
        this.SpriteFlags2 = 0L;
        this.Properties.clear();
        this.SurfaceFlags = (byte)(this.SurfaceFlags & 0xFFFFFFFE);
    }

    public boolean Is(IsoFlagType isoFlagType) {
        long l = isoFlagType.index() / 64 == 0 ? this.SpriteFlags1 : this.SpriteFlags2;
        return (l & 1L << isoFlagType.index() % 64) != 0L;
    }

    public boolean Is(Double d) {
        return this.Is(IsoFlagType.fromIndex(d.intValue()));
    }

    public void Set(String string, String string2) {
        this.Set(string, string2, true);
    }

    public void Set(String string, String string2, boolean bl) {
        IsoFlagType isoFlagType;
        if (string == null) {
            return;
        }
        if (bl && (isoFlagType = IsoFlagType.FromString(string)) != IsoFlagType.MAX) {
            this.Set(isoFlagType);
            return;
        }
        int n = TilePropertyAliasMap.instance.getIDFromPropertyName(string);
        if (n == -1) {
            return;
        }
        int n2 = TilePropertyAliasMap.instance.getIDFromPropertyValue(n, string2);
        this.SurfaceFlags = (byte)(this.SurfaceFlags & 0xFFFFFFFE);
        this.Properties.put(n, n2);
    }

    public void Set(IsoFlagType isoFlagType) {
        if (isoFlagType.index() / 64 == 0) {
            this.SpriteFlags1 |= 1L << isoFlagType.index() % 64;
        } else {
            this.SpriteFlags2 |= 1L << isoFlagType.index() % 64;
        }
    }

    public void Set(IsoFlagType isoFlagType, String string) {
        this.Set(isoFlagType);
    }

    public void UnSet(String string) {
        int n = TilePropertyAliasMap.instance.getIDFromPropertyName(string);
        this.Properties.remove(n);
    }

    public void UnSet(IsoFlagType isoFlagType) {
        if (isoFlagType.index() / 64 == 0) {
            this.SpriteFlags1 &= 1L << isoFlagType.index() % 64 ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.SpriteFlags2 &= 1L << isoFlagType.index() % 64 ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public String Val(String string) {
        int n = TilePropertyAliasMap.instance.getIDFromPropertyName(string);
        if (!this.Properties.containsKey(n)) {
            return null;
        }
        return TilePropertyAliasMap.instance.getPropertyValueString(n, this.Properties.get(n));
    }

    public boolean Is(String string) {
        int n = TilePropertyAliasMap.instance.getIDFromPropertyName(string);
        return this.Properties.containsKey(n);
    }

    public ArrayList<IsoFlagType> getFlagsList() {
        int n;
        ArrayList<IsoFlagType> arrayList = new ArrayList<IsoFlagType>();
        for (n = 0; n < 64; ++n) {
            if ((this.SpriteFlags1 & 1L << n) == 0L) continue;
            arrayList.add(IsoFlagType.fromIndex(n));
        }
        for (n = 0; n < 64; ++n) {
            if ((this.SpriteFlags2 & 1L << n) == 0L) continue;
            arrayList.add(IsoFlagType.fromIndex(64 + n));
        }
        return arrayList;
    }

    public ArrayList<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TIntSet tIntSet = this.Properties.keySet();
        tIntSet.forEach(n -> {
            arrayList.add(TilePropertyAliasMap.instance.Properties.get((int)n).propertyName);
            return true;
        });
        Collections.sort(arrayList);
        return arrayList;
    }

    private void initSurface() {
        if ((this.SurfaceFlags & 1) != 0) {
            return;
        }
        this.Surface = 0;
        this.StackReplaceTileOffset = 0;
        this.SurfaceFlags = 1;
        this.ItemHeight = 0;
        this.Properties.forEachEntry((n, n2) -> {
            TilePropertyAliasMap.TileProperty tileProperty = TilePropertyAliasMap.instance.Properties.get(n);
            String string = tileProperty.propertyName;
            String string2 = tileProperty.possibleValues.get(n2);
            if ("Surface".equals(string) && string2 != null) {
                try {
                    int n3 = Integer.parseInt(string2);
                    if (n3 >= 0 && n3 <= 127) {
                        this.Surface = (byte)n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("IsSurfaceOffset".equals(string)) {
                this.SurfaceFlags = (byte)(this.SurfaceFlags | 2);
            } else if ("IsTable".equals(string)) {
                this.SurfaceFlags = (byte)(this.SurfaceFlags | 4);
            } else if ("IsTableTop".equals(string)) {
                this.SurfaceFlags = (byte)(this.SurfaceFlags | 8);
            } else if ("StackReplaceTileOffset".equals(string)) {
                try {
                    this.StackReplaceTileOffset = (short)Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("ItemHeight".equals(string)) {
                try {
                    int n4 = Integer.parseInt(string2);
                    if (n4 >= 0 && n4 <= 127) {
                        this.ItemHeight = (byte)n4;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        });
    }

    public int getSurface() {
        this.initSurface();
        return this.Surface;
    }

    public boolean isSurfaceOffset() {
        this.initSurface();
        return (this.SurfaceFlags & 2) != 0;
    }

    public boolean isTable() {
        this.initSurface();
        return (this.SurfaceFlags & 4) != 0;
    }

    public boolean isTableTop() {
        this.initSurface();
        return (this.SurfaceFlags & 8) != 0;
    }

    public int getStackReplaceTileOffset() {
        this.initSurface();
        return this.StackReplaceTileOffset;
    }

    public int getItemHeight() {
        this.initSurface();
        return this.ItemHeight;
    }

    public static class MostTested {
        public IsoFlagType flag;
        public int count;
    }

    private static class ProfileEntryComparitor
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            double d = ((MostTested)object).count;
            double d2 = ((MostTested)object2).count;
            if (d > d2) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
    }
}

