/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.profiling;

import zombie.GameProfiler;
import zombie.util.Lambda;
import zombie.util.lambda.Invokers;

public abstract class AbstractPerformanceProfileProbe {
    public final String Name;
    private boolean m_isEnabled = true;
    private boolean m_isRunning = false;
    private boolean m_isProfilerRunning = false;

    protected AbstractPerformanceProfileProbe(String string) {
        this.Name = string;
    }

    protected abstract void onStart();

    protected abstract void onEnd();

    public void start() {
        if (this.m_isRunning) {
            throw new RuntimeException("start() already called. " + this.getClass().getSimpleName() + " is Non-reentrant. Please call end() first.");
        }
        boolean bl = this.m_isProfilerRunning = this.isEnabled() && GameProfiler.isRunning();
        if (!this.m_isProfilerRunning) {
            return;
        }
        this.m_isRunning = true;
        this.onStart();
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.m_isEnabled = bl;
    }

    public void end() {
        if (!this.m_isProfilerRunning) {
            return;
        }
        if (!this.m_isRunning) {
            throw new RuntimeException("end() called without calling start().");
        }
        this.onEnd();
        this.m_isRunning = false;
    }

    public void invokeAndMeasure(Runnable runnable) {
        try {
            this.start();
            runnable.run();
        }
        finally {
            this.end();
        }
    }

    public <T1> void invokeAndMeasure(T1 T1, Invokers.Params1.ICallback<T1> iCallback2) {
        Lambda.capture(this, T1, iCallback2, (genericStack, abstractPerformanceProfileProbe, object, iCallback) -> abstractPerformanceProfileProbe.invokeAndMeasure(genericStack.invoker(object, iCallback)));
    }

    public <T1, T2> void invokeAndMeasure(T1 T1, T2 T2, Invokers.Params2.ICallback<T1, T2> iCallback2) {
        Lambda.capture(this, T1, T2, iCallback2, (genericStack, abstractPerformanceProfileProbe, object, object2, iCallback) -> abstractPerformanceProfileProbe.invokeAndMeasure(genericStack.invoker(object, object2, iCallback)));
    }
}

