/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.physics;

import java.util.ArrayList;
import java.util.HashMap;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.physics.Bullet;
import zombie.core.physics.PhysicsDebugRenderer;
import zombie.core.physics.Transform;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.textures.TextureDraw;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistic;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleManager;

public final class WorldSimulation {
    public static WorldSimulation instance = new WorldSimulation();
    public static final boolean LEVEL_ZERO_ONLY = true;
    public HashMap<Integer, IsoMovingObject> physicsObjectMap = new HashMap();
    public boolean created = false;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public long time;
    private final ArrayList<BaseVehicle> collideVehicles = new ArrayList(4);
    private final Vector3f tempVector3f = new Vector3f();
    private final Vector3f tempVector3f_2 = new Vector3f();
    private final Transform tempTransform = new Transform();
    private final Quaternionf javaxQuat4f = new Quaternionf();
    private final float[] ff = new float[8192];
    private final float[] wheelSteer = new float[4];
    private final float[] wheelRotation = new float[4];
    private final float[] wheelSkidInfo = new float[4];
    private final float[] wheelSuspensionLength = new float[4];

    public void create() {
        if (this.created) {
            return;
        }
        this.offsetX = IsoWorld.instance.MetaGrid.getMinX() * 300;
        this.offsetY = IsoWorld.instance.MetaGrid.getMinY() * 300;
        this.time = GameTime.getServerTimeMills();
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[0];
        Bullet.initWorld((int)this.offsetX, (int)this.offsetY, isoChunkMap.getWorldXMin(), isoChunkMap.getWorldYMin(), IsoChunkMap.ChunkGridWidth);
        for (int i = 0; i < 4; ++i) {
            this.wheelSteer[i] = 0.0f;
            this.wheelRotation[i] = 0.0f;
            this.wheelSkidInfo[i] = 0.0f;
            this.wheelSuspensionLength[i] = 0.0f;
        }
        this.created = true;
    }

    public void destroy() {
        Bullet.destroyWorld();
    }

    private void updatePhysic(float f) {
        MPStatistic.getInstance().Bullet.Start();
        Bullet.stepSimulation(f, 2, 0.016666668f);
        MPStatistic.getInstance().Bullet.End();
        this.time = GameTime.getServerTimeMills();
    }

    public void update() {
        s_performance.worldSimulationUpdate.invokeAndMeasure(this, WorldSimulation::updateInternal);
    }

    private void updateInternal() {
        BaseVehicle baseVehicle;
        IsoPlayer isoPlayer;
        float f;
        float f2;
        float f3;
        int n;
        if (!this.created) {
            return;
        }
        this.updatePhysic(GameTime.instance.getRealworldSecondsSinceLastUpdate());
        this.collideVehicles.clear();
        int n2 = Bullet.getVehicleCount();
        int n3 = 0;
        while (n3 < n2) {
            MPStatistic.getInstance().Bullet.Start();
            n = Bullet.getVehiclePhysics(n3, this.ff);
            MPStatistic.getInstance().Bullet.End();
            if (n <= 0) break;
            n3 += n;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                int n5;
                int n6 = (int)this.ff[n4++];
                f3 = this.ff[n4++];
                f2 = this.ff[n4++];
                f = this.ff[n4++];
                this.tempTransform.origin.set(f3, f2, f);
                float f4 = this.ff[n4++];
                float f5 = this.ff[n4++];
                float f6 = this.ff[n4++];
                float f7 = this.ff[n4++];
                this.javaxQuat4f.set(f4, f5, f6, f7);
                this.tempTransform.setRotation(this.javaxQuat4f);
                float f8 = this.ff[n4++];
                float f9 = this.ff[n4++];
                float f10 = this.ff[n4++];
                this.tempVector3f.set(f8, f9, f10);
                float f11 = this.ff[n4++];
                float f12 = this.ff[n4++];
                int n7 = (int)this.ff[n4++];
                for (n5 = 0; n5 < n7; ++n5) {
                    this.wheelSteer[n5] = this.ff[n4++];
                    this.wheelRotation[n5] = this.ff[n4++];
                    this.wheelSkidInfo[n5] = this.ff[n4++];
                    this.wheelSuspensionLength[n5] = this.ff[n4++];
                }
                n5 = (int)(f3 * 100.0f + f2 * 100.0f + f * 100.0f + f4 * 100.0f + f5 * 100.0f + f6 * 100.0f + f7 * 100.0f);
                BaseVehicle baseVehicle2 = VehicleManager.instance.getVehicleByID((short)n6);
                if (baseVehicle2 == null || GameClient.bClient && (baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.Remote) || baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.RemoteCollide))) continue;
                if (baseVehicle2.VehicleID == n6 && f12 > 0.5f) {
                    this.collideVehicles.add(baseVehicle2);
                    baseVehicle2.authSimulationHash = n5;
                }
                if (GameClient.bClient && baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.LocalCollide)) {
                    if (baseVehicle2.authSimulationHash != n5) {
                        baseVehicle2.authSimulationTime = System.currentTimeMillis();
                        baseVehicle2.authSimulationHash = n5;
                    }
                    if (System.currentTimeMillis() - baseVehicle2.authSimulationTime > 1000L) {
                        VehicleManager.instance.sendCollide(baseVehicle2, baseVehicle2.getDriver(), false);
                        baseVehicle2.authSimulationTime = 0L;
                    }
                }
                if (!baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.Remote) || !baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.RemoteCollide)) {
                    baseVehicle2.jniSpeed = GameClient.bClient && baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.Server) ? 0.0f : f11;
                }
                if (GameClient.bClient && (baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.Server) || baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.Remote) || baseVehicle2.isNetPlayerAuthorization(BaseVehicle.Authorization.RemoteCollide))) continue;
                if (this.compareTransform(this.tempTransform, baseVehicle2.getPoly().t)) {
                    baseVehicle2.polyDirty = true;
                }
                baseVehicle2.jniTransform.set(this.tempTransform);
                baseVehicle2.jniLinearVelocity.set(this.tempVector3f);
                baseVehicle2.jniIsCollide = f12 > 0.5f;
                for (int j = 0; j < n7; ++j) {
                    baseVehicle2.wheelInfo[j].steering = this.wheelSteer[j];
                    baseVehicle2.wheelInfo[j].rotation = this.wheelRotation[j];
                    baseVehicle2.wheelInfo[j].skidInfo = this.wheelSkidInfo[j];
                    baseVehicle2.wheelInfo[j].suspensionLength = this.wheelSuspensionLength[j];
                }
            }
        }
        if (GameClient.bClient && (isoPlayer = IsoPlayer.players[IsoPlayer.getPlayerIndex()]) != null && (baseVehicle = isoPlayer.getVehicle()) != null && baseVehicle.isNetPlayerId(isoPlayer.getOnlineID()) && this.collideVehicles.contains(baseVehicle)) {
            for (BaseVehicle baseVehicle3 : this.collideVehicles) {
                if (!(baseVehicle3.DistTo(baseVehicle) < 8.0f) || !baseVehicle3.isNetPlayerAuthorization(BaseVehicle.Authorization.Server)) continue;
                VehicleManager.instance.sendCollide(baseVehicle3, isoPlayer, true);
                baseVehicle3.authorizationClientCollide(isoPlayer);
            }
        }
        MPStatistic.getInstance().Bullet.Start();
        n = Bullet.getObjectPhysics(this.ff);
        MPStatistic.getInstance().Bullet.End();
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            int n9 = (int)this.ff[n8++];
            f3 = this.ff[n8++];
            f2 = this.ff[n8++];
            f = this.ff[n8++];
            f3 += this.offsetX;
            f += this.offsetY;
            IsoMovingObject isoMovingObject = this.physicsObjectMap.get(n9);
            if (isoMovingObject == null) continue;
            isoMovingObject.removeFromSquare();
            isoMovingObject.setX(f3 + 0.18f);
            isoMovingObject.setY(f);
            isoMovingObject.setZ(Math.max(0.0f, f2 / 3.0f / 0.82f));
            isoMovingObject.setCurrent(IsoWorld.instance.getCell().getGridSquare(isoMovingObject.getX(), isoMovingObject.getY(), isoMovingObject.getZ()));
        }
    }

    private boolean compareTransform(Transform transform, Transform transform2) {
        if (Math.abs(transform.origin.x - transform2.origin.x) > 0.01f || Math.abs(transform.origin.z - transform2.origin.z) > 0.01f || (int)transform.origin.y != (int)transform2.origin.y) {
            return true;
        }
        int n = 2;
        transform.basis.getColumn(n, this.tempVector3f_2);
        float f = this.tempVector3f_2.x;
        float f2 = this.tempVector3f_2.z;
        transform2.basis.getColumn(n, this.tempVector3f_2);
        float f3 = this.tempVector3f_2.x;
        float f4 = this.tempVector3f_2.z;
        return Math.abs(f - f3) > 0.001f || Math.abs(f2 - f4) > 0.001f;
    }

    public int setOwnVehiclePhysics(int n, float[] fArray) {
        return Bullet.setOwnVehiclePhysics(n, fArray);
    }

    public void activateChunkMap(int n) {
        this.create();
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[n];
        if (GameServer.bServer) {
            return;
        }
        Bullet.activateChunkMap(n, isoChunkMap.getWorldXMin(), isoChunkMap.getWorldYMin(), IsoChunkMap.ChunkGridWidth);
    }

    public void deactivateChunkMap(int n) {
        if (!this.created) {
            return;
        }
        Bullet.deactivateChunkMap(n);
    }

    public void scrollGroundLeft(int n) {
        if (!this.created) {
            return;
        }
        Bullet.scrollChunkMapLeft(n);
    }

    public void scrollGroundRight(int n) {
        if (!this.created) {
            return;
        }
        Bullet.scrollChunkMapRight(n);
    }

    public void scrollGroundUp(int n) {
        if (!this.created) {
            return;
        }
        Bullet.scrollChunkMapUp(n);
    }

    public void scrollGroundDown(int n) {
        if (!this.created) {
            return;
        }
        Bullet.scrollChunkMapDown(n);
    }

    public static TextureDraw.GenericDrawer getDrawer(int n) {
        PhysicsDebugRenderer physicsDebugRenderer = PhysicsDebugRenderer.alloc();
        physicsDebugRenderer.init(IsoPlayer.players[n]);
        return physicsDebugRenderer;
    }

    private static class s_performance {
        static final PerformanceProfileProbe worldSimulationUpdate = new PerformanceProfileProbe("WorldSimulation.update");

        private s_performance() {
        }
    }
}

