/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.opengl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.lwjgl.opengl.ARBShaderObjects;
import zombie.core.IndieFileLoader;
import zombie.core.opengl.PZGLUtil;
import zombie.core.opengl.ShaderProgram;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.util.StringUtils;

public final class ShaderUnit {
    private final ShaderProgram m_parentProgram;
    private final String m_fileName;
    private final Type m_unitType;
    private int m_glID;
    private boolean m_isAttached;

    public ShaderUnit(ShaderProgram shaderProgram, String string, Type type) {
        this.m_parentProgram = shaderProgram;
        this.m_fileName = string;
        this.m_unitType = type;
        this.m_glID = 0;
        this.m_isAttached = false;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public boolean isCompiled() {
        return this.m_glID != 0;
    }

    public boolean compile() {
        int n;
        if (DebugLog.isEnabled(DebugType.Shader)) {
            DebugLog.Shader.debugln(this.getFileName());
        }
        int n2 = ShaderUnit.getGlType(this.m_unitType);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.loadShaderFile(this.m_fileName, arrayList);
        if (string == null) {
            return false;
        }
        for (String string2 : arrayList) {
            ShaderUnit shaderUnit;
            if (this.m_parentProgram == null) {
                DebugLog.Shader.error(this.getFileName() + "> Cannot include additional shader file. Parent program is null. " + string2);
                break;
            }
            String string3 = string2 + ".glsl";
            if (DebugLog.isEnabled(DebugType.Shader)) {
                DebugLog.Shader.debugln(this.getFileName() + "> Loading additional shader unit: " + string3);
            }
            if ((shaderUnit = this.m_parentProgram.addShader(string3, this.m_unitType)).isCompiled() || shaderUnit.compile()) continue;
            DebugLog.Shader.error(this.getFileName() + "> Included shader unit failed to compile: " + string3);
            return false;
        }
        if ((n = ARBShaderObjects.glCreateShaderObjectARB((int)n2)) == 0) {
            DebugLog.Shader.error(this.getFileName() + "> Failed to generate shaderID. Shader code:\n" + string);
            return false;
        }
        ARBShaderObjects.glShaderSourceARB((int)n, (CharSequence)string);
        ARBShaderObjects.glCompileShaderARB((int)n);
        ShaderProgram.printLogInfo(n);
        this.m_glID = n;
        return true;
    }

    public boolean attach() {
        if (DebugLog.isEnabled(DebugType.Shader)) {
            DebugLog.Shader.debugln(this.getFileName());
        }
        if (this.getParentShaderProgramGLID() == 0) {
            DebugLog.Shader.error("Parent program does not exist.");
            return false;
        }
        if (!this.isCompiled()) {
            this.compile();
        }
        if (!this.isCompiled()) {
            return false;
        }
        ARBShaderObjects.glAttachObjectARB((int)this.getParentShaderProgramGLID(), (int)this.getGLID());
        if (!PZGLUtil.checkGLError(false)) {
            this.destroy();
            return false;
        }
        this.m_isAttached = true;
        return true;
    }

    public void destroy() {
        if (this.m_glID == 0) {
            this.m_isAttached = false;
            return;
        }
        DebugLog.Shader.debugln(this.getFileName());
        try {
            if (this.m_isAttached && this.getParentShaderProgramGLID() != 0) {
                ARBShaderObjects.glDetachObjectARB((int)this.getParentShaderProgramGLID(), (int)this.m_glID);
                if (!PZGLUtil.checkGLError(false)) {
                    DebugLog.Shader.error("ShaderUnit failed to detach: " + this.getFileName());
                    return;
                }
            }
            ARBShaderObjects.glDeleteObjectARB((int)this.m_glID);
            PZGLUtil.checkGLError(false);
        }
        finally {
            this.m_glID = 0;
            this.m_isAttached = false;
        }
    }

    public int getGLID() {
        return this.m_glID;
    }

    public int getParentShaderProgramGLID() {
        return this.m_parentProgram != null ? this.m_parentProgram.getShaderID() : 0;
    }

    private static int getGlType(Type type) {
        return type == Type.Vert ? 35633 : 35632;
    }

    private String loadShaderFile(String string, ArrayList<String> arrayList) {
        arrayList.clear();
        String string2 = this.preProcessShaderFile(string, arrayList);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf("#");
        if (n > 0) {
            string2 = string2.substring(n);
        }
        return string2;
    }

    private String preProcessShaderFile(String string, ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = IndieFileLoader.getStreamReader(string, false);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string2 = System.getProperty("line.separator");
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                String string4 = string3.trim();
                if (!string4.startsWith("#include ") || !this.processIncludeLine(string, stringBuilder, string4, string2, arrayList)) {
                    stringBuilder.append(string4).append(string2);
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            DebugLog.Shader.error("Failed reading shader code. fileName:" + string);
            exception.printStackTrace(DebugLog.Shader);
            return null;
        }
        return stringBuilder.toString();
    }

    private boolean processIncludeLine(String string, StringBuilder stringBuilder, String string2, String string3, ArrayList<String> arrayList) {
        String string42;
        String string5 = string2.substring("#include ".length());
        if (!string5.startsWith("\"") || !string5.endsWith("\"")) {
            DebugLog.Shader.error(string + "> include needs to be in quotes: " + string5);
            return false;
        }
        String string6 = this.getParentFolder(string);
        String string7 = string5.substring(1, string5.length() - 1);
        string7 = string7.trim();
        string7 = string7.replace('\\', '/');
        if ((string7 = string7.toLowerCase()).contains(":")) {
            DebugLog.Shader.error(string + "> include cannot have ':' characters. " + string5);
            return false;
        }
        if (string7.startsWith("/")) {
            DebugLog.Shader.error(string + "> include cannot start with '/' or '\\' characters. " + string5);
            return false;
        }
        String string8 = string6 + "/" + string7;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string42 : string8.split("/")) {
            if (string42.equals(".") || string42.isEmpty()) continue;
            if (StringUtils.isNullOrWhitespace(string42)) {
                DebugLog.Shader.error(string + "> include path cannot have whitespace-only folders. " + string5);
                return false;
            }
            if (string42.equals("..")) {
                if (arrayList2.isEmpty()) {
                    DebugLog.Shader.error(string + "> include cannot go out of bounds with '..' parameters. " + string5);
                    return false;
                }
                arrayList2.remove(arrayList2.size() - 1);
                continue;
            }
            arrayList2.add(string42);
        }
        StringBuilder stringBuilder2 = new StringBuilder(string8.length());
        for (String string9 : arrayList2) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append('/');
            }
            stringBuilder2.append(string9);
        }
        String string10 = stringBuilder2.toString();
        if (arrayList.contains(string10)) {
            stringBuilder.append("// Duplicate Include, skipped. ").append(string2).append(string3);
            return true;
        }
        arrayList.add(string10);
        String string11 = (String)string10 + ".h";
        string42 = this.preProcessShaderFile(string11, arrayList);
        stringBuilder.append(string3);
        stringBuilder.append("// Include begin ").append(string2).append(string3);
        stringBuilder.append(string42).append(string3);
        stringBuilder.append("// Include end   ").append(string2).append(string3);
        stringBuilder.append(string3);
        return true;
    }

    private String getParentFolder(String string) {
        int n = string.lastIndexOf("/");
        if (n > -1) {
            return string.substring(0, n);
        }
        n = string.lastIndexOf("\\");
        if (n > -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static enum Type {
        Vert,
        Frag;

    }
}

