/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.opengl;

import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjglx.LWJGLException;
import org.lwjglx.input.Controllers;
import org.lwjglx.opengl.Display;
import org.lwjglx.opengl.OpenGLException;
import org.lwjglx.opengl.Util;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.core.Clipboard;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.ThreadGroups;
import zombie.core.opengl.RenderContextQueueException;
import zombie.core.opengl.RenderContextQueueItem;
import zombie.core.profiling.PerformanceProfileFrameProbe;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.sprite.SpriteRenderState;
import zombie.core.textures.TextureID;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.network.GameServer;
import zombie.network.MPStatisticClient;
import zombie.ui.FPSGraph;
import zombie.util.Lambda;
import zombie.util.lambda.Invokers;
import zombie.util.list.PZArrayUtil;

public class RenderThread {
    private static Thread MainThread;
    public static Thread RenderThread;
    private static Thread ContextThread;
    private static boolean m_isDisplayCreated;
    private static int m_contextLockReentrantDepth;
    public static final Object m_contextLock;
    private static final ArrayList<RenderContextQueueItem> invokeOnRenderQueue;
    private static final ArrayList<RenderContextQueueItem> invokeOnRenderQueue_Invoking;
    private static boolean m_isInitialized;
    private static final Object m_initLock;
    private static volatile boolean m_isCloseRequested;
    private static volatile int m_displayWidth;
    private static volatile int m_displayHeight;
    private static volatile boolean m_renderingEnabled;
    private static volatile boolean m_waitForRenderState;
    private static volatile boolean m_hasContext;
    private static boolean m_cursorVisible;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object = m_initLock;
        synchronized (object) {
            if (m_isInitialized) {
                return;
            }
            MainThread = Thread.currentThread();
            RenderThread = Thread.currentThread();
            m_displayWidth = Display.getWidth();
            m_displayHeight = Display.getHeight();
            m_isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initServerGUI() {
        Object object = m_initLock;
        synchronized (object) {
            if (m_isInitialized) {
                return;
            }
            MainThread = Thread.currentThread();
            RenderThread = new Thread(ThreadGroups.Main, RenderThread::renderLoop, "RenderThread Main Loop");
            RenderThread.setName("Render Thread");
            RenderThread.setUncaughtExceptionHandler(RenderThread::uncaughtException);
            m_displayWidth = Display.getWidth();
            m_displayHeight = Display.getHeight();
            m_isInitialized = true;
        }
        RenderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderLoop() {
        if (!GameServer.bServer) {
            Object object = m_initLock;
            synchronized (object) {
                try {
                    m_isInitialized = false;
                    GameWindow.InitDisplay();
                    Controllers.create();
                    Clipboard.initMainThread();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                finally {
                    m_isInitialized = true;
                }
            }
        }
        zombie.core.opengl.RenderThread.acquireContextReentrant();
        boolean bl = true;
        while (bl) {
            Object object = m_contextLock;
            synchronized (object) {
                if (!m_hasContext) {
                    zombie.core.opengl.RenderThread.acquireContextReentrant();
                }
                m_displayWidth = Display.getWidth();
                m_displayHeight = Display.getHeight();
                if (m_renderingEnabled) {
                    s_performance.renderStep.invokeAndMeasure(RenderThread::renderStep);
                } else if (m_isDisplayCreated && m_hasContext) {
                    Display.processMessages();
                }
                zombie.core.opengl.RenderThread.flushInvokeQueue();
                if (m_renderingEnabled) {
                    GameWindow.GameInput.poll();
                    Mouse.poll();
                    GameKeyboard.poll();
                    m_isCloseRequested = m_isCloseRequested || Display.isCloseRequested();
                } else {
                    m_isCloseRequested = false;
                }
                if (!GameServer.bServer) {
                    Clipboard.updateMainThread();
                }
                DebugOptions.testThreadCrash(0);
                bl = !GameWindow.bGameThreadExited;
            }
            Thread.yield();
        }
        zombie.core.opengl.RenderThread.releaseContextReentrant();
        Object object = m_initLock;
        synchronized (object) {
            RenderThread = null;
            m_isInitialized = false;
        }
        zombie.core.opengl.RenderThread.shutdown();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            DebugLog.General.println("Render Thread exited: ", thread.getName());
            return;
        }
        try {
            GameWindow.uncaughtException(thread, throwable);
        }
        finally {
            Runnable runnable = () -> {
                long l;
                long l2 = 120000L;
                long l3 = 0L;
                long l4 = l = System.currentTimeMillis();
                if (!GameWindow.bGameThreadExited) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    DebugLog.General.error("  Waiting for GameThread to exit...");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    while (!GameWindow.bGameThreadExited) {
                        Thread.yield();
                        l = System.currentTimeMillis();
                        long l5 = l - l4;
                        if ((l3 += l5) >= 120000L) {
                            DebugLog.General.error("  GameThread failed to exit within time limit.");
                            break;
                        }
                        l4 = l;
                    }
                }
                DebugLog.General.error("  Shutting down...");
                System.exit(1);
            };
            Thread thread2 = new Thread(runnable, "ForceCloseThread");
            thread2.start();
            DebugLog.General.error("Shutting down sequence starts.");
            m_isCloseRequested = true;
            DebugLog.General.error("  Notifying render state queue...");
            zombie.core.opengl.RenderThread.notifyRenderStateQueue();
            DebugLog.General.error("  Notifying InvokeOnRenderQueue...");
            ArrayList<RenderContextQueueItem> arrayList = invokeOnRenderQueue;
            synchronized (arrayList) {
                invokeOnRenderQueue_Invoking.addAll(invokeOnRenderQueue);
                invokeOnRenderQueue.clear();
            }
            PZArrayUtil.forEach(invokeOnRenderQueue_Invoking, RenderContextQueueItem::notifyWaitingListeners);
        }
    }

    private static boolean renderStep() {
        boolean bl = false;
        try {
            bl = zombie.core.opengl.RenderThread.lockStepRenderStep();
        }
        catch (OpenGLException openGLException) {
            zombie.core.opengl.RenderThread.logGLException(openGLException);
        }
        catch (Exception exception) {
            DebugLog.General.error("Thrown an " + exception.getClass().getTypeName() + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    private static boolean lockStepRenderStep() {
        SpriteRenderState spriteRenderState = SpriteRenderer.instance.acquireStateForRendering(RenderThread::waitForRenderStateCallback);
        if (spriteRenderState == null) {
            zombie.core.opengl.RenderThread.notifyRenderStateQueue();
            if (!m_waitForRenderState || LuaManager.thread != null && LuaManager.thread.bStep) {
                s_performance.displayUpdate.invokeAndMeasure(() -> Display.processMessages());
            }
            return true;
        }
        m_cursorVisible = spriteRenderState.bCursorVisible;
        s_performance.spriteRendererPostRender.invokeAndMeasure(() -> SpriteRenderer.instance.postRender());
        s_performance.displayUpdate.invokeAndMeasure(() -> {
            Display.update(true);
            zombie.core.opengl.RenderThread.checkControllers();
        });
        if (Core.bDebug && FPSGraph.instance != null) {
            FPSGraph.instance.addRender(System.currentTimeMillis());
        }
        MPStatisticClient.getInstance().fpsProcess();
        return true;
    }

    private static void checkControllers() {
    }

    private static boolean waitForRenderStateCallback() {
        zombie.core.opengl.RenderThread.flushInvokeQueue();
        return zombie.core.opengl.RenderThread.shouldContinueWaiting();
    }

    private static boolean shouldContinueWaiting() {
        return !m_isCloseRequested && !GameWindow.bGameThreadExited && (m_waitForRenderState || SpriteRenderer.instance.isWaitingForRenderState());
    }

    public static boolean isWaitForRenderState() {
        return m_waitForRenderState;
    }

    public static void setWaitForRenderState(boolean bl) {
        m_waitForRenderState = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushInvokeQueue() {
        ArrayList<RenderContextQueueItem> arrayList = invokeOnRenderQueue;
        synchronized (arrayList) {
            invokeOnRenderQueue_Invoking.addAll(invokeOnRenderQueue);
            invokeOnRenderQueue.clear();
        }
        try {
            if (!invokeOnRenderQueue_Invoking.isEmpty()) {
                long l = System.nanoTime();
                while (!invokeOnRenderQueue_Invoking.isEmpty()) {
                    RenderContextQueueItem renderContextQueueItem = invokeOnRenderQueue_Invoking.remove(0);
                    long l2 = System.nanoTime();
                    renderContextQueueItem.invoke();
                    long l3 = System.nanoTime();
                    if ((double)(l3 - l2) > 1.0E7) {
                        boolean bl = true;
                    }
                    if (!((double)(l3 - l) > 1.0E7)) continue;
                    break;
                }
                for (int i = invokeOnRenderQueue_Invoking.size() - 1; i >= 0; --i) {
                    RenderContextQueueItem renderContextQueueItem = invokeOnRenderQueue_Invoking.get(i);
                    if (!renderContextQueueItem.isWaiting()) continue;
                    while (i >= 0) {
                        RenderContextQueueItem renderContextQueueItem2 = invokeOnRenderQueue_Invoking.remove(0);
                        renderContextQueueItem2.invoke();
                        --i;
                    }
                    break;
                }
            }
            if (TextureID.deleteTextureIDS.position() > 0) {
                TextureID.deleteTextureIDS.flip();
                GL11.glDeleteTextures((IntBuffer)TextureID.deleteTextureIDS);
                TextureID.deleteTextureIDS.clear();
            }
        }
        catch (OpenGLException openGLException) {
            zombie.core.opengl.RenderThread.logGLException(openGLException);
        }
        catch (Exception exception) {
            DebugLog.General.error("Thrown an " + exception.getClass().getTypeName() + ": " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void logGLException(OpenGLException openGLException) {
        zombie.core.opengl.RenderThread.logGLException(openGLException, true);
    }

    public static void logGLException(OpenGLException openGLException, boolean bl) {
        DebugLog.General.error("OpenGLException thrown: " + openGLException.getMessage());
        int n = GL11.glGetError();
        while (n != 0) {
            String string = Util.translateGLErrorString(n);
            DebugLog.General.error("  Also detected error: " + string + " ( code:" + n + ")");
            n = GL11.glGetError();
        }
        if (bl) {
            DebugLog.General.error("Stack trace:");
            openGLException.printStackTrace();
        }
    }

    public static void Ready() {
        SpriteRenderer.instance.pushFrameDown();
        if (!m_isInitialized) {
            zombie.core.opengl.RenderThread.invokeOnRenderContext(RenderThread::renderStep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acquireContextReentrant() {
        Object object = m_contextLock;
        synchronized (object) {
            zombie.core.opengl.RenderThread.acquireContextReentrantInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseContextReentrant() {
        Object object = m_contextLock;
        synchronized (object) {
            zombie.core.opengl.RenderThread.releaseContextReentrantInternal();
        }
    }

    private static void acquireContextReentrantInternal() {
        Thread thread = Thread.currentThread();
        if (ContextThread != null && ContextThread != thread) {
            throw new RuntimeException("Context thread mismatch: " + ContextThread + ", " + thread);
        }
        if (++m_contextLockReentrantDepth > 1) {
            return;
        }
        ContextThread = thread;
        m_isDisplayCreated = Display.isCreated();
        if (m_isDisplayCreated) {
            try {
                m_hasContext = true;
                Display.makeCurrent();
                Display.setVSyncEnabled(Core.OptionVSync);
            }
            catch (LWJGLException lWJGLException) {
                DebugLog.General.error("Exception thrown trying to gain GL context.");
                lWJGLException.printStackTrace();
            }
        }
    }

    private static void releaseContextReentrantInternal() {
        Thread thread = Thread.currentThread();
        if (ContextThread != thread) {
            throw new RuntimeException("Context thread mismatch: " + ContextThread + ", " + thread);
        }
        if (m_contextLockReentrantDepth == 0) {
            throw new RuntimeException("Context thread release overflow: 0: " + ContextThread + ", " + thread);
        }
        if (--m_contextLockReentrantDepth > 0) {
            return;
        }
        if (m_isDisplayCreated && m_hasContext) {
            try {
                m_hasContext = false;
                Display.releaseContext();
            }
            catch (LWJGLException lWJGLException) {
                DebugLog.General.error("Exception thrown trying to release GL context.");
                lWJGLException.printStackTrace();
            }
        }
        ContextThread = null;
    }

    public static void invokeOnRenderContext(Runnable runnable) throws RenderContextQueueException {
        RenderContextQueueItem renderContextQueueItem = RenderContextQueueItem.alloc(runnable);
        renderContextQueueItem.setWaiting();
        zombie.core.opengl.RenderThread.queueInvokeOnRenderContext(renderContextQueueItem);
        try {
            renderContextQueueItem.waitUntilFinished(() -> {
                zombie.core.opengl.RenderThread.notifyRenderStateQueue();
                return !m_isCloseRequested && !GameWindow.bGameThreadExited;
            });
        }
        catch (InterruptedException interruptedException) {
            DebugLog.General.error("Thread Interrupted while waiting for queued item to finish:" + renderContextQueueItem);
            zombie.core.opengl.RenderThread.notifyRenderStateQueue();
        }
        Throwable throwable = renderContextQueueItem.getThrown();
        if (throwable != null) {
            throw new RenderContextQueueException(throwable);
        }
    }

    public static <T1> void invokeOnRenderContext(T1 T1, Invokers.Params1.ICallback<T1> iCallback2) {
        Lambda.capture(T1, iCallback2, (genericStack, object, iCallback) -> zombie.core.opengl.RenderThread.invokeOnRenderContext(genericStack.invoker(object, iCallback)));
    }

    public static <T1, T2> void invokeOnRenderContext(T1 T1, T2 T2, Invokers.Params2.ICallback<T1, T2> iCallback2) {
        Lambda.capture(T1, T2, iCallback2, (genericStack, object, object2, iCallback) -> zombie.core.opengl.RenderThread.invokeOnRenderContext(genericStack.invoker(object, object2, iCallback)));
    }

    public static <T1, T2, T3> void invokeOnRenderContext(T1 T1, T2 T2, T3 T3, Invokers.Params3.ICallback<T1, T2, T3> iCallback2) {
        Lambda.capture(T1, T2, T3, iCallback2, (genericStack, object, object2, object3, iCallback) -> zombie.core.opengl.RenderThread.invokeOnRenderContext(genericStack.invoker(object, object2, object3, iCallback)));
    }

    public static <T1, T2, T3, T4> void invokeOnRenderContext(T1 T1, T2 T2, T3 T3, T4 T4, Invokers.Params4.ICallback<T1, T2, T3, T4> iCallback2) {
        Lambda.capture(T1, T2, T3, T4, iCallback2, (genericStack, object, object2, object3, object4, iCallback) -> zombie.core.opengl.RenderThread.invokeOnRenderContext(genericStack.invoker(object, object2, object3, object4, iCallback)));
    }

    protected static void notifyRenderStateQueue() {
        if (SpriteRenderer.instance != null) {
            SpriteRenderer.instance.notifyRenderStateQueue();
        }
    }

    public static void queueInvokeOnRenderContext(Runnable runnable) {
        zombie.core.opengl.RenderThread.queueInvokeOnRenderContext(RenderContextQueueItem.alloc(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueInvokeOnRenderContext(RenderContextQueueItem renderContextQueueItem) {
        ArrayList<RenderContextQueueItem> arrayList;
        if (!m_isInitialized) {
            arrayList = m_initLock;
            synchronized (arrayList) {
                if (!m_isInitialized) {
                    try {
                        zombie.core.opengl.RenderThread.acquireContextReentrant();
                        renderContextQueueItem.invoke();
                    }
                    finally {
                        zombie.core.opengl.RenderThread.releaseContextReentrant();
                    }
                    return;
                }
            }
        }
        if (ContextThread == Thread.currentThread()) {
            renderContextQueueItem.invoke();
            return;
        }
        arrayList = invokeOnRenderQueue;
        synchronized (arrayList) {
            invokeOnRenderQueue.add(renderContextQueueItem);
        }
    }

    public static void shutdown() {
        GameWindow.GameInput.quit();
        if (m_isInitialized) {
            zombie.core.opengl.RenderThread.queueInvokeOnRenderContext(Display::destroy);
        } else {
            Display.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCloseRequested() {
        if (m_isCloseRequested) {
            DebugLog.log("EXITDEBUG: RenderThread.isCloseRequested 1");
            return m_isCloseRequested;
        }
        if (!m_isInitialized) {
            Object object = m_initLock;
            synchronized (object) {
                if (!m_isInitialized && (m_isCloseRequested = Display.isCloseRequested())) {
                    DebugLog.log("EXITDEBUG: RenderThread.isCloseRequested 2");
                }
            }
        }
        return m_isCloseRequested;
    }

    public static int getDisplayWidth() {
        if (!m_isInitialized) {
            return Display.getWidth();
        }
        return m_displayWidth;
    }

    public static int getDisplayHeight() {
        if (!m_isInitialized) {
            return Display.getHeight();
        }
        return m_displayHeight;
    }

    public static boolean isRunning() {
        return m_isInitialized;
    }

    public static void startRendering() {
        m_renderingEnabled = true;
    }

    public static void onGameThreadExited() {
        DebugLog.General.println("GameThread exited.");
        if (RenderThread != null) {
            RenderThread.interrupt();
        }
    }

    public static boolean isCursorVisible() {
        return m_cursorVisible;
    }

    static {
        ContextThread = null;
        m_isDisplayCreated = false;
        m_contextLockReentrantDepth = 0;
        m_contextLock = "RenderThread borrowContext Lock";
        invokeOnRenderQueue = new ArrayList();
        invokeOnRenderQueue_Invoking = new ArrayList();
        m_isInitialized = false;
        m_initLock = "RenderThread Initialization Lock";
        m_isCloseRequested = false;
        m_renderingEnabled = true;
        m_waitForRenderState = false;
        m_hasContext = false;
        m_cursorVisible = true;
    }

    private static class s_performance {
        static final PerformanceProfileFrameProbe renderStep = new PerformanceProfileFrameProbe("RenderThread.renderStep");
        static final PerformanceProfileProbe displayUpdate = new PerformanceProfileProbe("Display.update(true)");
        static final PerformanceProfileProbe spriteRendererPostRender = new PerformanceProfileProbe("SpriteRenderer.postRender");

        private s_performance() {
        }
    }
}

