/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.opengl;

import java.io.PrintStream;
import java.nio.FloatBuffer;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjglx.opengl.OpenGLException;
import org.lwjglx.opengl.Util;
import zombie.core.opengl.RenderThread;
import zombie.core.skinnedmodel.model.Model;

public class PZGLUtil {
    static int test = 0;

    public static void checkGLErrorThrow(String string, Object ... objectArray) throws OpenGLException {
        int n = GL11.glGetError();
        if (n != 0) {
            ++test;
            throw new OpenGLException(PZGLUtil.createErrorMessage(n, string, objectArray));
        }
    }

    private static String createErrorMessage(int n, String string, Object ... objectArray) {
        String string2 = System.lineSeparator();
        return "  GL Error code (" + n + ") encountered." + string2 + "  Error translation: " + PZGLUtil.createErrorMessage(n) + string2 + "  While performing: " + String.format(string, objectArray);
    }

    private static String createErrorMessage(int n) {
        String string = Util.translateGLErrorString(n);
        return string + " (" + n + ")";
    }

    public static boolean checkGLError(boolean bl) {
        try {
            Util.checkGLError();
            return true;
        }
        catch (OpenGLException openGLException) {
            RenderThread.logGLException(openGLException, bl);
            return false;
        }
    }

    public static void printGLState(PrintStream printStream) {
        int n = GL11.glGetInteger((int)2979);
        printStream.println("DEBUG: GL_MODELVIEW_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)2980);
        printStream.println("DEBUG: GL_PROJECTION_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)2981);
        printStream.println("DEBUG: GL_TEXTURE_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)2992);
        printStream.println("DEBUG: GL_ATTRIB_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)2993);
        printStream.println("DEBUG: GL_CLIENT_ATTRIB_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3381);
        printStream.println("DEBUG: GL_MAX_ATTRIB_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3382);
        printStream.println("DEBUG: GL_MAX_MODELVIEW_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3383);
        printStream.println("DEBUG: GL_MAX_NAME_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3384);
        printStream.println("DEBUG: GL_MAX_PROJECTION_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3385);
        printStream.println("DEBUG: GL_MAX_TEXTURE_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3387);
        printStream.println("DEBUG: GL_MAX_CLIENT_ATTRIB_STACK_DEPTH= " + n);
        n = GL11.glGetInteger((int)3440);
        printStream.println("DEBUG: GL_NAME_STACK_DEPTH= " + n);
    }

    public static void loadMatrix(Matrix4f matrix4f) {
        matrix4f.get(Model.m_staticReusableFloatBuffer);
        Model.m_staticReusableFloatBuffer.position(16);
        Model.m_staticReusableFloatBuffer.flip();
        GL11.glLoadMatrixf((FloatBuffer)Model.m_staticReusableFloatBuffer);
    }

    public static void multMatrix(Matrix4f matrix4f) {
        matrix4f.get(Model.m_staticReusableFloatBuffer);
        Model.m_staticReusableFloatBuffer.position(16);
        Model.m_staticReusableFloatBuffer.flip();
        GL11.glMultMatrixf((FloatBuffer)Model.m_staticReusableFloatBuffer);
    }

    public static void loadMatrix(int n, Matrix4f matrix4f) {
        GL11.glMatrixMode((int)n);
        PZGLUtil.loadMatrix(matrix4f);
    }

    public static void multMatrix(int n, Matrix4f matrix4f) {
        GL11.glMatrixMode((int)n);
        PZGLUtil.multMatrix(matrix4f);
    }

    public static void pushAndLoadMatrix(int n, Matrix4f matrix4f) {
        GL11.glMatrixMode((int)n);
        GL11.glPushMatrix();
        PZGLUtil.loadMatrix(matrix4f);
    }

    public static void pushAndMultMatrix(int n, Matrix4f matrix4f) {
        GL11.glMatrixMode((int)n);
        GL11.glPushMatrix();
        PZGLUtil.multMatrix(matrix4f);
    }

    public static void popMatrix(int n) {
        GL11.glMatrixMode((int)n);
        GL11.glPopMatrix();
    }
}

