/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.logger;

import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ZLogger;
import zombie.debug.DebugLog;

public final class LoggerManager {
    private static boolean s_isInitialized = false;
    private static final HashMap<String, ZLogger> s_loggers = new HashMap();

    public static synchronized ZLogger getLogger(String string) {
        if (!s_loggers.containsKey(string)) {
            LoggerManager.createLogger(string, false);
        }
        return s_loggers.get(string);
    }

    public static synchronized void init() {
        if (s_isInitialized) {
            return;
        }
        DebugLog.General.debugln("Initializing...");
        s_isInitialized = true;
        LoggerManager.backupOldLogFiles();
    }

    private static void backupOldLogFiles() {
        try {
            File file = new File(LoggerManager.getLogsDir());
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            Calendar calendar = LoggerManager.getLogFileLastModifiedTime(stringArray[0]);
            Object object = "logs_";
            object = calendar.get(5) < 9 ? (String)object + "0" + calendar.get(5) : (String)object + calendar.get(5);
            object = calendar.get(2) < 9 ? (String)object + "-0" + (calendar.get(2) + 1) : (String)object + "-" + (calendar.get(2) + 1);
            File file2 = new File(LoggerManager.getLogsDir() + File.separator + (String)object);
            if (!file2.exists()) {
                file2.mkdir();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                File file3 = new File(LoggerManager.getLogsDir() + File.separator + (String)object);
                if (!file3.isFile()) continue;
                file3.renameTo(new File(file2.getAbsolutePath() + File.separator + file3.getName()));
                file3.delete();
            }
        }
        catch (Exception exception) {
            DebugLog.General.error("Exception thrown trying to initialize LoggerManager, trying to copy old log files.");
            DebugLog.General.error("Exception: ");
            DebugLog.General.error(exception);
            exception.printStackTrace();
        }
    }

    private static Calendar getLogFileLastModifiedTime(String string) {
        File file = new File(LoggerManager.getLogsDir() + File.separator + string);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(file.lastModified());
        return calendar;
    }

    public static synchronized void createLogger(String string, boolean bl) {
        LoggerManager.init();
        s_loggers.put(string, new ZLogger(string, bl));
    }

    public static String getLogsDir() {
        String string = ZomboidFileSystem.instance.getCacheDirSub("Logs");
        ZomboidFileSystem.ensureFolderExists(string);
        File file = new File(string);
        return file.getAbsolutePath();
    }

    public static String getPlayerCoords(IsoPlayer isoPlayer) {
        return "(" + (int)isoPlayer.getX() + "," + (int)isoPlayer.getY() + "," + (int)isoPlayer.getZ() + ")";
    }
}

