/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.logger;

import org.lwjglx.opengl.OpenGLException;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderThread;
import zombie.debug.DebugLog;
import zombie.debug.DebugLogStream;
import zombie.debug.LogSeverity;
import zombie.network.GameServer;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.ui.UITransition;
import zombie.util.Type;

public final class ExceptionLogger {
    private static int exceptionCount;
    private static boolean bIgnore;
    private static boolean bExceptionPopup;
    private static long popupFrameMS;
    private static UITransition transition;
    private static boolean bHide;

    public static synchronized void logException(Throwable throwable) {
        ExceptionLogger.logException(throwable, null);
    }

    public static synchronized void logException(Throwable throwable, String string) {
        ExceptionLogger.logException(throwable, string, DebugLog.General, LogSeverity.Error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void logException(Throwable throwable, String string, DebugLogStream debugLogStream, LogSeverity logSeverity) {
        OpenGLException openGLException = Type.tryCastTo(throwable, OpenGLException.class);
        if (openGLException != null) {
            RenderThread.logGLException(openGLException, false);
        }
        debugLogStream.printException(throwable, string, DebugLogStream.generateCallerPrefix(), logSeverity);
        try {
            if (bIgnore) {
                return;
            }
            bIgnore = true;
            ++exceptionCount;
            if (GameServer.bServer) {
                return;
            }
            if (bExceptionPopup) {
                ExceptionLogger.showPopup();
            }
        }
        catch (Throwable throwable2) {
            debugLogStream.printException(throwable2, "Exception thrown while trying to logException.", LogSeverity.Error);
        }
        finally {
            bIgnore = false;
        }
    }

    public static void showPopup() {
        float f = popupFrameMS > 0L ? transition.getElapsed() : 0.0f;
        popupFrameMS = 3000L;
        transition.setIgnoreUpdateTime(true);
        transition.init(500.0f, false);
        transition.setElapsed(f);
        bHide = false;
    }

    public static void render() {
        if (UIManager.useUIFBO && !Core.getInstance().UIRenderThisFrame) {
            return;
        }
        boolean bl = false;
        if (bl) {
            popupFrameMS = 3000L;
        }
        if (popupFrameMS <= 0L) {
            return;
        }
        popupFrameMS = (long)((double)popupFrameMS - UIManager.getMillisSinceLastRender());
        transition.update();
        int n = TextManager.instance.getFontHeight(UIFont.DebugConsole);
        int n2 = 100;
        int n3 = n * 2 + 4;
        int n4 = Core.getInstance().getScreenWidth() - n2;
        int n5 = Core.getInstance().getScreenHeight() - (int)((float)n3 * transition.fraction());
        if (bl) {
            n5 = Core.getInstance().getScreenHeight() - n3;
        }
        SpriteRenderer.instance.renderi(null, n4, n5, n2, n3, 0.8f, 0.0f, 0.0f, 1.0f, null);
        SpriteRenderer.instance.renderi(null, n4 + 1, n5 + 1, n2 - 2, n - 1, 0.0f, 0.0f, 0.0f, 1.0f, null);
        TextManager.instance.DrawStringCentre(UIFont.DebugConsole, n4 + n2 / 2, n5, "ERROR", 1.0, 0.0, 0.0, 1.0);
        TextManager.instance.DrawStringCentre(UIFont.DebugConsole, n4 + n2 / 2, n5 + n, bl ? "999" : Integer.toString(exceptionCount), 0.0, 0.0, 0.0, 1.0);
        if (popupFrameMS <= 0L && !bHide) {
            popupFrameMS = 500L;
            transition.init(500.0f, true);
            bHide = true;
        }
    }

    static {
        bExceptionPopup = true;
        popupFrameMS = 0L;
        transition = new UITransition();
    }
}

