/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.backup;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.debug.DebugLog;
import zombie.iso.IsoChunk;
import zombie.network.CoopSlave;
import zombie.network.GameServer;
import zombie.network.ServerOptions;

public class ZipBackup {
    private static final int compressionMethod = 0;
    static ParallelScatterZipCreator scatterZipCreator = null;
    private static long lastBackupTime = 0L;

    public static void onStartup() {
        lastBackupTime = System.currentTimeMillis();
        if (ServerOptions.getInstance().BackupsOnStart.getValue()) {
            ZipBackup.makeBackupFile(GameServer.ServerName, BackupTypes.startup);
        }
    }

    public static void onVersion() {
        if (!ServerOptions.getInstance().BackupsOnVersionChange.getValue()) {
            return;
        }
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "backups" + File.separator + "last_server_version.txt";
        String string2 = ZipBackup.getStringFromZip(string);
        String string3 = Core.getInstance().getGameVersion().toString();
        if (!string3.equals(string2)) {
            ZipBackup.putTextFile(string, string3);
            ZipBackup.makeBackupFile(GameServer.ServerName, BackupTypes.version);
        }
    }

    public static void onPeriod() {
        int n = ServerOptions.getInstance().BackupsPeriod.getValue();
        if (n <= 0) {
            return;
        }
        if (System.currentTimeMillis() - lastBackupTime > (long)(n * 60000)) {
            lastBackupTime = System.currentTimeMillis();
            ZipBackup.makeBackupFile(GameServer.ServerName, BackupTypes.period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeBackupFile(String string, BackupTypes backupTypes) {
        long l;
        block12: {
            String string2 = ZomboidFileSystem.instance.getCacheDir() + File.separator + "backups" + File.separator + backupTypes.name();
            l = System.currentTimeMillis();
            DebugLog.log("Start making backup to: " + string2);
            scatterZipCreator = new ParallelScatterZipCreator();
            CoopSlave.status("UI_ServerStatus_CreateBackup");
            OutputStream outputStream = null;
            ZipArchiveOutputStream zipArchiveOutputStream = null;
            try {
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                ZipBackup.rotateBackupFile(backupTypes);
                String string3 = string2 + File.separator + "backup_1.zip";
                try {
                    Files.deleteIfExists(Paths.get(string3, new String[0]));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                File file2 = new File(string3);
                file2.delete();
                outputStream = new FileOutputStream(file2);
                zipArchiveOutputStream = new ZipArchiveOutputStream(outputStream);
                zipArchiveOutputStream.setUseZip64(Zip64Mode.AsNeeded);
                zipArchiveOutputStream.setMethod(0);
                zipArchiveOutputStream.setLevel(0);
                ZipBackup.zipTextFile("readme.txt", ZipBackup.getBackupReadme(string));
                zipArchiveOutputStream.setComment(ZipBackup.getBackupReadme(string));
                ZipBackup.zipFile("options.ini", "options.ini");
                ZipBackup.zipFile("popman-options.ini", "popman-options.ini");
                ZipBackup.zipFile("latestSave.ini", "latestSave.ini");
                ZipBackup.zipFile("debug-options.ini", "debug-options.ini");
                ZipBackup.zipFile("sounds.ini", "sounds.ini");
                ZipBackup.zipFile("gamepadBinding.config", "gamepadBinding.config");
                ZipBackup.zipDir("mods", "mods");
                ZipBackup.zipDir("Lua", "Lua");
                ZipBackup.zipDir("db", "db");
                ZipBackup.zipDir("Server", "Server");
                Object object = IsoChunk.WriteLock;
                synchronized (object) {
                    ZipBackup.zipDir("Saves" + File.separator + "Multiplayer" + File.separator + string, "Saves" + File.separator + "Multiplayer" + File.separator + string);
                    try {
                        scatterZipCreator.writeTo(zipArchiveOutputStream);
                        DebugLog.log(scatterZipCreator.getStatisticsMessage().toString());
                        zipArchiveOutputStream.close();
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (outputStream == null) break block12;
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        DebugLog.log("Backup made in " + (System.currentTimeMillis() - l) + " ms");
    }

    private static void rotateBackupFile(BackupTypes backupTypes) {
        int n = ServerOptions.getInstance().BackupsCount.getValue() - 1;
        if (n <= 0) {
            return;
        }
        Path path = Paths.get(ZomboidFileSystem.instance.getCacheDir() + File.separator + "backups" + File.separator + backupTypes + File.separator + "backup_" + (n + 1) + ".zip", new String[0]);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        for (int i = n; i > 0; --i) {
            Path path2 = Paths.get(ZomboidFileSystem.instance.getCacheDir() + File.separator + "backups" + File.separator + backupTypes + File.separator + "backup_" + i + ".zip", new String[0]);
            Path path3 = Paths.get(ZomboidFileSystem.instance.getCacheDir() + File.separator + "backups" + File.separator + backupTypes + File.separator + "backup_" + (i + 1) + ".zip", new String[0]);
            try {
                Files.move(path2, path3, new CopyOption[0]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getBackupReadme(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
        Date date = new Date(System.currentTimeMillis());
        simpleDateFormat.format(date);
        int n = ZipBackup.getWorldVersion(string);
        String string2 = "";
        string2 = n == -2 ? "World isn't exist" : (n == -1 ? "World version cannot be determined" : String.valueOf(n));
        return "Backup time: " + simpleDateFormat.format(date) + "\nServerName: " + string + "\nCurrent server version:" + Core.getInstance().getGameVersion() + "\nCurrent world version:195\nWorld version in this backup is:" + string2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int getWorldVersion(String string) {
        File file = new File(ZomboidFileSystem.instance.getSaveDir() + File.separator + "Multiplayer" + File.separator + string + File.separator + "map_t.bin");
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                DataInputStream dataInputStream;
                block15: {
                    int n;
                    dataInputStream = new DataInputStream(fileInputStream);
                    try {
                        int n2;
                        byte by = dataInputStream.readByte();
                        byte by2 = dataInputStream.readByte();
                        byte by3 = dataInputStream.readByte();
                        byte by4 = dataInputStream.readByte();
                        if (by != 71 || by2 != 77 || by3 != 84 || by4 != 77) break block15;
                        n = n2 = dataInputStream.readInt();
                    }
                    catch (Throwable throwable) {
                        try {
                            dataInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    dataInputStream.close();
                    return n;
                }
                int n = -1;
                dataInputStream.close();
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -2;
    }

    private static void putTextFile(String string, String string2) {
        try {
            Path path = Paths.get(string, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try {
                Files.delete(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.write(path, string2.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getStringFromZip(String string) {
        String string2 = null;
        try {
            Path path = Paths.get(string, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                List<String> list = Files.readAllLines(path);
                string2 = list.get(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private static void zipTextFile(String string, String string2) {
        InputStreamSupplier inputStreamSupplier = () -> {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(StandardCharsets.UTF_8));
            return byteArrayInputStream;
        };
        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(string);
        zipArchiveEntry.setMethod(0);
        scatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
    }

    private static void zipFile(String string, String string2) {
        Path path = Paths.get(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        InputStreamSupplier inputStreamSupplier = () -> {
            InputStream inputStream = null;
            try {
                inputStream = Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return inputStream;
        };
        ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(string);
        zipArchiveEntry.setMethod(0);
        scatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
    }

    private static void zipDir(String string, String string2) {
        Path path = Paths.get(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + string2);
            if (file.isDirectory()) {
                Iterator<File> iterator = Arrays.asList(file.listFiles()).iterator();
                int n = file.getAbsolutePath().length() + 1;
                while (iterator.hasNext()) {
                    File file2 = iterator.next();
                    if (file2.isDirectory()) continue;
                    String string3 = file2.getAbsolutePath().substring(n);
                    InputStreamSupplier inputStreamSupplier = () -> {
                        InputStream inputStream = null;
                        try {
                            inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        return inputStream;
                    };
                    ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(string + File.separator + string3);
                    zipArchiveEntry.setMethod(0);
                    scatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static enum BackupTypes {
        period,
        startup,
        version;

    }
}

