/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Language;
import zombie.core.Languages;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public final class Translator {
    private static ArrayList<Language> availableLanguage = null;
    public static boolean debug = false;
    private static FileWriter debugFile = null;
    private static boolean debugErrors = false;
    private static final HashSet<String> debugItemEvolvedRecipeName = new HashSet();
    private static final HashSet<String> debugItem = new HashSet();
    private static final HashSet<String> debugMultiStageBuild = new HashSet();
    private static final HashSet<String> debugRecipe = new HashSet();
    private static final HashMap<String, String> moodles = new HashMap();
    private static final HashMap<String, String> ui = new HashMap();
    private static final HashMap<String, String> survivalGuide = new HashMap();
    private static final HashMap<String, String> contextMenu = new HashMap();
    private static final HashMap<String, String> farming = new HashMap();
    private static final HashMap<String, String> recipe = new HashMap();
    private static final HashMap<String, String> igui = new HashMap();
    private static final HashMap<String, String> sandbox = new HashMap();
    private static final HashMap<String, String> tooltip = new HashMap();
    private static final HashMap<String, String> challenge = new HashMap();
    private static final HashSet<String> missing = new HashSet();
    private static ArrayList<String> azertyLanguages = null;
    private static final HashMap<String, String> news = new HashMap();
    private static final HashMap<String, String> stash = new HashMap();
    private static final HashMap<String, String> multiStageBuild = new HashMap();
    private static final HashMap<String, String> moveables = new HashMap();
    private static final HashMap<String, String> makeup = new HashMap();
    private static final HashMap<String, String> gameSound = new HashMap();
    private static final HashMap<String, String> dynamicRadio = new HashMap();
    private static final HashMap<String, String> items = new HashMap();
    private static final HashMap<String, String> itemName = new HashMap();
    private static final HashMap<String, String> itemEvolvedRecipeName = new HashMap();
    private static final HashMap<String, String> recordedMedia = new HashMap();
    private static final HashMap<String, String> recordedMedia_EN = new HashMap();
    public static Language language = null;
    private static final String newsHeader = "<IMAGE:media/ui/dot.png> <SIZE:small> ";

    public static void loadFiles() {
        language = null;
        availableLanguage = null;
        File file = new File(ZomboidFileSystem.instance.getCacheDir() + File.separator + "translationProblems.txt");
        if (debug) {
            try {
                if (debugFile != null) {
                    debugFile.close();
                }
                debugFile = new FileWriter(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        moodles.clear();
        ui.clear();
        survivalGuide.clear();
        items.clear();
        itemName.clear();
        contextMenu.clear();
        farming.clear();
        recipe.clear();
        igui.clear();
        sandbox.clear();
        tooltip.clear();
        challenge.clear();
        news.clear();
        missing.clear();
        stash.clear();
        multiStageBuild.clear();
        moveables.clear();
        makeup.clear();
        gameSound.clear();
        dynamicRadio.clear();
        itemEvolvedRecipeName.clear();
        recordedMedia.clear();
        DebugLog.log("translator: language is " + Translator.getLanguage());
        debugErrors = false;
        Translator.fillMapFromFile("Tooltip", tooltip);
        Translator.fillMapFromFile("IG_UI", igui);
        Translator.fillMapFromFile("Recipes", recipe);
        Translator.fillMapFromFile("Farming", farming);
        Translator.fillMapFromFile("ContextMenu", contextMenu);
        Translator.fillMapFromFile("SurvivalGuide", survivalGuide);
        Translator.fillMapFromFile("UI", ui);
        Translator.fillMapFromFile("Items", items);
        Translator.fillMapFromFile("ItemName", itemName);
        Translator.fillMapFromFile("Moodles", moodles);
        Translator.fillMapFromFile("Sandbox", sandbox);
        Translator.fillMapFromFile("Challenge", challenge);
        Translator.fillMapFromFile("Stash", stash);
        Translator.fillMapFromFile("MultiStageBuild", multiStageBuild);
        Translator.fillMapFromFile("Moveables", moveables);
        Translator.fillMapFromFile("MakeUp", makeup);
        Translator.fillMapFromFile("GameSound", gameSound);
        Translator.fillMapFromFile("DynamicRadio", dynamicRadio);
        Translator.fillMapFromFile("EvolvedRecipeName", itemEvolvedRecipeName);
        Translator.fillMapFromFile("Recorded_Media", recordedMedia);
        Translator.fillNewsFromFile(news);
        if (debug) {
            if (debugErrors) {
                DebugLog.log("translator: errors detected, please see " + file.getAbsolutePath());
            }
            debugItemEvolvedRecipeName.clear();
            debugItem.clear();
            debugMultiStageBuild.clear();
            debugRecipe.clear();
        }
        PerkFactory.initTranslations();
    }

    private static void fillNewsFromFile(HashMap<String, String> hashMap) {
        HashMap<String, News> hashMap2 = new HashMap<String, News>();
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = 0; i < arrayList.size(); ++i) {
            String object = ZomboidFileSystem.instance.getModDir(arrayList.get(i));
            if (object == null) continue;
            Translator.tryFillNewsFromFile(object, hashMap, hashMap2, Translator.getLanguage());
            if (Translator.getLanguage() == Translator.getDefaultLanguage()) continue;
            Translator.tryFillNewsFromFile(object, hashMap, hashMap2, Translator.getDefaultLanguage());
        }
        Translator.tryFillNewsFromFile(".", hashMap, hashMap2, Translator.getLanguage());
        if (Translator.getLanguage() != Translator.getDefaultLanguage()) {
            Translator.tryFillNewsFromFile(".", hashMap, hashMap2, Translator.getDefaultLanguage());
        }
        for (News news : hashMap2.values()) {
            hashMap.put("News_" + news.version + "_Disclaimer", news.toRichText());
        }
        hashMap2.clear();
    }

    private static void tryFillNewsFromFile(String string, HashMap<String, String> hashMap, HashMap<String, News> hashMap2, Language language) {
        File file = new File(string + File.separator + "media" + File.separator + "lua" + File.separator + "shared" + File.separator + "Translate" + File.separator + language + File.separator + "News_" + language + ".txt");
        if (file.exists()) {
            Translator.doNews(file, hashMap2, language);
        }
    }

    private static void doNews(File file, HashMap<String, News> hashMap, Language language) {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName(language.charset()));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string;
            News news = null;
            ArrayList<String> arrayList = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (string.trim().isEmpty()) continue;
                if (string.startsWith("[VERSION]")) {
                    string2 = string.replaceFirst("\\[VERSION\\]", "").trim();
                    if (hashMap.containsKey(string2)) {
                        news = null;
                        arrayList = null;
                    } else {
                        news = new News(string2);
                        hashMap.put(string2, news);
                        arrayList = null;
                    }
                }
                if (news == null) continue;
                if (string.startsWith("[SECTION]")) {
                    string2 = string.replaceFirst("\\[SECTION\\]", "").trim();
                    arrayList = news.getOrCreateSectionList(string2);
                    continue;
                }
                if (string.startsWith("[NEWS]")) {
                    arrayList = news.getOrCreateSectionList("[New]");
                    continue;
                }
                if (string.startsWith("[BALANCE]")) {
                    arrayList = news.getOrCreateSectionList("[Balance]");
                    continue;
                }
                if (string.startsWith("[BUG FIX]")) {
                    arrayList = news.getOrCreateSectionList("[Bug Fix]");
                    continue;
                }
                if (arrayList == null) continue;
                Translator.addNewsLine(string, arrayList);
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    private static void addNewsLine(String object, ArrayList<String> arrayList) {
        if (((String)object).startsWith("[BOLD]")) {
            object = ((String)object).replaceFirst("\\[BOLD\\]", "<IMAGE:media/ui/dot.png> <SIZE:medium>");
            arrayList.add((String)object + " <LINE> ");
            return;
        }
        if (((String)object).startsWith("[DOT2]")) {
            object = ((String)object).replaceFirst("\\[DOT2\\]", "<IMAGE:media/ui/dot2.png> <SIZE:small>");
            arrayList.add((String)object + " <LINE> ");
            return;
        }
        if (((String)object).startsWith("[NODOT]")) {
            object = ((String)object).replaceFirst("\\[NODOT\\]", " <SIZE:small> ");
            object = (String)object + " <LINE> ";
            arrayList.add((String)object);
            return;
        }
        int n = 7;
        arrayList.add(newsHeader + " <INDENT:%d> ".formatted(21 - n) + (String)object + " <INDENT:0> <LINE> ");
    }

    public static ArrayList<String> getNewsVersions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(news.keySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            string = string.replace("News_", "");
            string = string.replace("_Disclaimer", "");
            arrayList.set(i, string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static void tryFillMapFromFile(String string, String string2, HashMap<String, String> hashMap, Language language) {
        File file = new File(string + File.separator + "media" + File.separator + "lua" + File.separator + "shared" + File.separator + "Translate" + File.separator + language + File.separator + string2 + "_" + language + ".txt");
        if (file.exists()) {
            Translator.parseFile(file, hashMap, language);
        }
    }

    private static void tryFillMapFromMods(String string, HashMap<String, String> hashMap, Language language) {
        ArrayList<String> arrayList = ZomboidFileSystem.instance.getModIDs();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string2 = ZomboidFileSystem.instance.getModDir(arrayList.get(i));
            if (string2 == null) continue;
            Translator.tryFillMapFromFile(string2, string, hashMap, language);
        }
    }

    public static void addLanguageToList(Language language, ArrayList<Language> arrayList) {
        if (language == null) {
            return;
        }
        if (arrayList.contains(language)) {
            return;
        }
        arrayList.add(language);
        if (language.base() == null) {
            return;
        }
        language = Languages.instance.getByName(language.base());
        Translator.addLanguageToList(language, arrayList);
    }

    private static void fillMapFromFile(String string, HashMap<String, String> hashMap) {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        Translator.addLanguageToList(Translator.getLanguage(), arrayList);
        Translator.addLanguageToList(Translator.getDefaultLanguage(), arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Language language = arrayList.get(i);
            Translator.tryFillMapFromMods(string, hashMap, language);
            Translator.tryFillMapFromFile(ZomboidFileSystem.instance.base.getPath(), string, hashMap, language);
        }
        arrayList.clear();
    }

    private static void parseFile(File file, HashMap<String, String> hashMap, Language language) {
        String string = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName(language.charset()));
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            bufferedReader.readLine();
            boolean bl = false;
            String string2 = "";
            Object object = "";
            int n = 1;
            String string3 = file.getName().replace("_" + Translator.getDefaultLanguage(), "_" + Translator.getLanguage());
            while ((string = bufferedReader.readLine()) != null) {
                ++n;
                try {
                    Object object2;
                    if (string.contains("=") && string.contains("\"")) {
                        if (string.trim().startsWith("Recipe_")) {
                            string2 = string.split("=")[0].replaceAll("Recipe_", "").replaceAll("_", " ").trim();
                            object = string.split("=")[1];
                            object = ((String)object).substring(((String)object).indexOf("\"") + 1, ((String)object).lastIndexOf("\""));
                        } else if (string.trim().startsWith("DisplayName")) {
                            object2 = string.split("=");
                            string2 = string.trim().startsWith("DisplayName_") ? object2[0].replaceAll("DisplayName_", "").trim() : object2[0].replaceAll("DisplayName", "").trim();
                            if ("Anti_depressants".equals(string2)) {
                                string2 = "Antidepressants";
                            }
                            object = object2[1];
                            object = ((String)object).substring(((String)object).indexOf("\"") + 1, ((String)object).lastIndexOf("\""));
                        } else if (string.trim().startsWith("EvolvedRecipeName_")) {
                            object2 = string.split("=");
                            string2 = object2[0].replaceAll("EvolvedRecipeName_", "").trim();
                            object = object2[1];
                            int n2 = ((String)object).indexOf("\"");
                            var14_24 = ((String)object).lastIndexOf("\"");
                            object = ((String)object).substring(n2 + 1, var14_24);
                        } else if (string.trim().startsWith("ItemName_")) {
                            object2 = string.split("=");
                            string2 = object2[0].replaceAll("ItemName_", "").trim();
                            object = object2[1];
                            int n3 = ((String)object).indexOf("\"");
                            var14_24 = ((String)object).lastIndexOf("\"");
                            object = ((String)object).substring(n3 + 1, var14_24);
                        } else {
                            string2 = string.split("=")[0].trim();
                            object = string.substring(string.indexOf("=") + 1);
                            object = ((String)object).substring(((String)object).indexOf("\"") + 1, ((String)object).lastIndexOf("\""));
                            if (string.contains("..")) {
                                bl = true;
                            }
                        }
                    } else if (!string.contains("--") && !string.trim().isEmpty() && (string.trim().endsWith("..") || bl)) {
                        bl = true;
                        object = (String)object + string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
                    } else {
                        bl = false;
                    }
                    if (bl && string.trim().endsWith("..")) continue;
                    if (!string2.isEmpty()) {
                        if (!hashMap.containsKey(string2)) {
                            hashMap.put(string2, (String)object);
                            if (hashMap == recordedMedia && language == Translator.getDefaultLanguage()) {
                                recordedMedia_EN.put(string2, (String)object);
                            }
                            if (debug && language == Translator.getDefaultLanguage() && Translator.getLanguage() != Translator.getDefaultLanguage()) {
                                if (string3 != null) {
                                    Translator.debugwrite(string3 + "\r\n");
                                    string3 = null;
                                }
                                Translator.debugwrite("\t" + string2 + " = \"" + (String)object + "\",\r\n");
                                debugErrors = true;
                            }
                        } else if (debug && language == Translator.getDefaultLanguage() && Translator.getLanguage() != Translator.getDefaultLanguage()) {
                            object2 = hashMap.get(string2);
                            Object object3 = object;
                            if (Translator.countSubstitutions((String)object2) != Translator.countSubstitutions((String)object3)) {
                                Translator.debugwrite("wrong number of % substitutions in " + string2 + "    " + Translator.getDefaultLanguage() + "=\"" + (String)object3 + "\"    " + Translator.getLanguage() + "=\"" + (String)object2 + "\"\r\n");
                                debugErrors = true;
                            }
                        }
                    }
                    bl = false;
                    object = "";
                    string2 = "";
                }
                catch (Exception exception) {
                    if (!debug) continue;
                    if (string3 != null) {
                        Translator.debugwrite(string3 + "\r\n");
                        string3 = null;
                    }
                    Translator.debugwrite("line " + n + ": " + string2 + " = " + (String)object + "\r\n");
                    if (debugFile != null) {
                        exception.printStackTrace(new PrintWriter(debugFile));
                    }
                    Translator.debugwrite("\r\n");
                    debugErrors = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getText(String string) {
        return Translator.getTextInternal(string, false);
    }

    public static String getTextOrNull(String string) {
        return Translator.getTextInternal(string, true);
    }

    private static String getTextInternal(String string, boolean bl) {
        String string2;
        if (ui == null) {
            Translator.loadFiles();
        }
        String string3 = null;
        if (string.startsWith("UI_")) {
            string3 = ui.get(string);
        } else if (string.startsWith("Moodles_")) {
            string3 = moodles.get(string);
        } else if (string.startsWith("SurvivalGuide_")) {
            string3 = survivalGuide.get(string);
        } else if (string.startsWith("Farming_")) {
            string3 = farming.get(string);
        } else if (string.startsWith("IGUI_")) {
            string3 = igui.get(string);
        } else if (string.startsWith("ContextMenu_")) {
            string3 = contextMenu.get(string);
        } else if (string.startsWith("GameSound_")) {
            string3 = gameSound.get(string);
        } else if (string.startsWith("Sandbox_")) {
            string3 = sandbox.get(string);
        } else if (string.startsWith("Tooltip_")) {
            string3 = tooltip.get(string);
        } else if (string.startsWith("Challenge_")) {
            string3 = challenge.get(string);
        } else if (string.startsWith("MakeUp")) {
            string3 = makeup.get(string);
        } else if (string.startsWith("News_")) {
            string3 = news.get(string);
        } else if (string.startsWith("Stash_")) {
            string3 = stash.get(string);
        } else if (string.startsWith("RM_")) {
            string3 = recordedMedia.get(string);
        }
        String string4 = string2 = Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue() ? "*" : null;
        if (string3 == null) {
            if (bl) {
                return null;
            }
            if (!missing.contains(string)) {
                if (Core.bDebug) {
                    DebugLog.log("ERROR: Missing translation \"" + string + "\"");
                }
                if (debug) {
                    Translator.debugwrite("ERROR: Missing translation \"" + string + "\"\r\n");
                }
                missing.add(string);
            }
            string3 = string;
            String string5 = string2 = Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue() ? "!" : null;
        }
        if (string3.contains("<br>")) {
            return string3.replaceAll("<br>", "\n");
        }
        return string2 == null ? string3 : string2 + string3;
    }

    private static int countSubstitutions(String string) {
        int n = 0;
        if (string.contains("%1")) {
            ++n;
        }
        if (string.contains("%2")) {
            ++n;
        }
        if (string.contains("%3")) {
            ++n;
        }
        if (string.contains("%4")) {
            ++n;
        }
        return n;
    }

    private static String subst(String string, String string2, Object object) {
        if (object != null) {
            double d;
            string = object instanceof Double ? string.replaceAll(string2, (d = ((Double)object).doubleValue()) == (double)((long)d) ? Long.toString((long)d) : object.toString()) : string.replaceAll(string2, Matcher.quoteReplacement(object.toString()));
        }
        return string;
    }

    public static String getText(String string, Object object) {
        String string2 = Translator.getText(string);
        string2 = Translator.subst(string2, "%1", object);
        return string2;
    }

    public static String getText(String string, Object object, Object object2) {
        String string2 = Translator.getText(string);
        string2 = Translator.subst(string2, "%1", object);
        string2 = Translator.subst(string2, "%2", object2);
        return string2;
    }

    public static String getText(String string, Object object, Object object2, Object object3) {
        String string2 = Translator.getText(string);
        string2 = Translator.subst(string2, "%1", object);
        string2 = Translator.subst(string2, "%2", object2);
        string2 = Translator.subst(string2, "%3", object3);
        return string2;
    }

    public static String getText(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = Translator.getText(string);
        string2 = Translator.subst(string2, "%1", object);
        string2 = Translator.subst(string2, "%2", object2);
        string2 = Translator.subst(string2, "%3", object3);
        string2 = Translator.subst(string2, "%4", object4);
        return string2;
    }

    public static String getTextOrNull(String string, Object object) {
        String string2 = Translator.getTextOrNull(string);
        if (string2 == null) {
            return null;
        }
        string2 = Translator.subst(string2, "%1", object);
        return string2;
    }

    public static String getTextOrNull(String string, Object object, Object object2) {
        String string2 = Translator.getTextOrNull(string);
        if (string2 == null) {
            return null;
        }
        string2 = Translator.subst(string2, "%1", object);
        string2 = Translator.subst(string2, "%2", object2);
        return string2;
    }

    public static String getTextOrNull(String string, Object object, Object object2, Object object3) {
        String string2 = Translator.getTextOrNull(string);
        if (string2 == null) {
            return null;
        }
        string2 = Translator.subst(string2, "%1", object);
        string2 = Translator.subst(string2, "%2", object2);
        string2 = Translator.subst(string2, "%3", object3);
        return string2;
    }

    public static String getTextOrNull(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = Translator.getTextOrNull(string);
        if (string2 == null) {
            return null;
        }
        string2 = Translator.subst(string2, "%1", object);
        string2 = Translator.subst(string2, "%2", object2);
        string2 = Translator.subst(string2, "%3", object3);
        string2 = Translator.subst(string2, "%4", object4);
        return string2;
    }

    private static String getDefaultText(String string) {
        return Translator.changeSomeStuff((String)((KahluaTable)LuaManager.env.rawget(string.split("_")[0] + "_" + Translator.getDefaultLanguage().name())).rawget(string));
    }

    private static String changeSomeStuff(String string) {
        String string2 = string;
        return string2;
    }

    public static void setLanguage(Language language) {
        if (language == null) {
            language = Translator.getDefaultLanguage();
        }
        Translator.language = language;
    }

    public static void setLanguage(int n) {
        Language language = Languages.instance.getByIndex(n);
        Translator.setLanguage(language);
    }

    public static Language getLanguage() {
        String string;
        if (language == null && !StringUtils.isNullOrWhitespace(string = Core.getInstance().getOptionLanguageName())) {
            language = Languages.instance.getByName(string);
        }
        if (language == null) {
            language = Languages.instance.getByName(System.getProperty("user.language").toUpperCase());
        }
        if (language == null) {
            language = Translator.getDefaultLanguage();
        }
        return language;
    }

    public static String getCharset() {
        return Translator.getLanguage().charset();
    }

    public static ArrayList<Language> getAvailableLanguage() {
        if (availableLanguage == null) {
            availableLanguage = new ArrayList();
            for (int i = 0; i < Languages.instance.getNumLanguages(); ++i) {
                availableLanguage.add(Languages.instance.getByIndex(i));
            }
        }
        return availableLanguage;
    }

    public static String getDisplayItemName(String string) {
        String string2 = null;
        string2 = items.get(string.replaceAll(" ", "_").replaceAll("-", "_"));
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getItemNameFromFullType(String string) {
        if (!string.contains(".")) {
            throw new IllegalArgumentException("fullType must contain \".\" i.e. module.type");
        }
        String string2 = itemName.get(string);
        if (string2 == null) {
            Item item;
            if (debug && Translator.getLanguage() != Translator.getDefaultLanguage() && !debugItem.contains(string)) {
                debugItem.add(string);
            }
            string2 = (item = ScriptManager.instance.getItem(string)) == null ? string : item.getDisplayName();
            itemName.put(string, string2);
        }
        return string2;
    }

    public static void setDefaultItemEvolvedRecipeName(String string, String string2) {
        if (Translator.getLanguage() != Translator.getDefaultLanguage()) {
            return;
        }
        if (!string.contains(".")) {
            throw new IllegalArgumentException("fullType must contain \".\" i.e. module.type");
        }
        if (itemEvolvedRecipeName.containsKey(string)) {
            return;
        }
        itemEvolvedRecipeName.put(string, string2);
    }

    public static String getItemEvolvedRecipeName(String string) {
        if (!string.contains(".")) {
            throw new IllegalArgumentException("fullType must contain \".\" i.e. module.type");
        }
        String string2 = itemEvolvedRecipeName.get(string);
        if (string2 == null) {
            Item item;
            if (debug && Translator.getLanguage() != Translator.getDefaultLanguage() && !debugItemEvolvedRecipeName.contains(string)) {
                debugItemEvolvedRecipeName.add(string);
            }
            string2 = (item = ScriptManager.instance.getItem(string)) == null ? string : item.getDisplayName();
            itemEvolvedRecipeName.put(string, string2);
        }
        return string2;
    }

    public static String getMoveableDisplayName(String string) {
        String string2 = string.replaceAll(" ", "_").replaceAll("-", "_").replaceAll("'", "").replaceAll("\\.", "");
        String string3 = moveables.get(string2);
        if (string3 == null) {
            if (Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue()) {
                return "!" + string;
            }
            return string;
        }
        if (Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue()) {
            return "*" + string3;
        }
        return string3;
    }

    public static String getMoveableDisplayNameOrNull(String string) {
        String string2 = string.replaceAll(" ", "_").replaceAll("-", "_").replaceAll("'", "").replaceAll("\\.", "");
        String string3 = moveables.get(string2);
        if (string3 == null) {
            return null;
        }
        if (Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue()) {
            return "*" + string3;
        }
        return string3;
    }

    public static String getMultiStageBuild(String string) {
        String string2 = multiStageBuild.get("MultiStageBuild_" + string);
        if (string2 == null) {
            if (debug && Translator.getLanguage() != Translator.getDefaultLanguage() && !debugMultiStageBuild.contains(string)) {
                debugMultiStageBuild.add(string);
            }
            return string;
        }
        return string2;
    }

    public static String getRecipeName(String string) {
        String string2 = null;
        string2 = recipe.get(string);
        if (string2 == null || string2.isEmpty()) {
            if (debug && Translator.getLanguage() != Translator.getDefaultLanguage() && !debugRecipe.contains(string)) {
                debugRecipe.add(string);
            }
            return string;
        }
        return string2;
    }

    public static Language getDefaultLanguage() {
        return Languages.instance.getDefaultLanguage();
    }

    public static void debugItemEvolvedRecipeNames() {
        if (!debug || debugItemEvolvedRecipeName.isEmpty()) {
            return;
        }
        Translator.debugwrite("EvolvedRecipeName_" + Translator.getLanguage() + ".txt\r\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(debugItemEvolvedRecipeName);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Translator.debugwrite("\tEvolvedRecipeName_" + string + " = \"" + itemEvolvedRecipeName.get(string) + "\",\r\n");
        }
        debugItemEvolvedRecipeName.clear();
    }

    public static void debugItemNames() {
        if (!debug || debugItem.isEmpty()) {
            return;
        }
        Translator.debugwrite("ItemName_" + Translator.getLanguage() + ".txt\r\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(debugItem);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Translator.debugwrite("\tItemName_" + string + " = \"" + itemName.get(string) + "\",\r\n");
        }
        debugItem.clear();
    }

    public static void debugMultiStageBuildNames() {
        if (!debug || debugMultiStageBuild.isEmpty()) {
            return;
        }
        Translator.debugwrite("MultiStageBuild_" + Translator.getLanguage() + ".txt\r\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(debugMultiStageBuild);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Translator.debugwrite("\tMultiStageBuild_" + string + " = \"\",\r\n");
        }
        debugMultiStageBuild.clear();
    }

    public static void debugRecipeNames() {
        if (!debug || debugRecipe.isEmpty()) {
            return;
        }
        Translator.debugwrite("Recipes_" + Translator.getLanguage() + ".txt\r\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(debugRecipe);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Translator.debugwrite("\tRecipe_" + string.replace(" ", "_") + " = \"\",\r\n");
        }
        debugRecipe.clear();
    }

    private static void debugwrite(String string) {
        if (debugFile != null) {
            try {
                debugFile.write(string);
                debugFile.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ArrayList<String> getAzertyMap() {
        if (azertyLanguages == null) {
            azertyLanguages = new ArrayList();
            azertyLanguages.add("FR");
        }
        return azertyLanguages;
    }

    public static String getRadioText(String string) {
        String string2 = dynamicRadio.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getTextMediaEN(String string) {
        String string2;
        if (ui == null) {
            Translator.loadFiles();
        }
        String string3 = null;
        if (string.startsWith("RM_")) {
            string3 = recordedMedia_EN.get(string);
        }
        String string4 = string2 = Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue() ? "*" : null;
        if (string3 == null) {
            if (!missing.contains(string) && Core.bDebug) {
                if (Core.bDebug) {
                    DebugLog.log("ERROR: Missing translation \"" + string + "\"");
                }
                if (debug) {
                    Translator.debugwrite("ERROR: Missing translation \"" + string + "\"\r\n");
                }
                missing.add(string);
            }
            string3 = string;
            String string5 = string2 = Core.bDebug && DebugOptions.instance.TranslationPrefix.getValue() ? "!" : null;
        }
        if (string3.contains("<br>")) {
            return string3.replaceAll("<br>", "\n");
        }
        return string2 == null ? string3 : string2 + string3;
    }

    private static final class News {
        String version;
        final ArrayList<String> sectionNames = new ArrayList();
        final HashMap<String, ArrayList<String>> sectionLists = new HashMap();

        News(String string) {
            this.version = string;
        }

        ArrayList<String> getOrCreateSectionList(String string) {
            if (this.sectionNames.contains(string)) {
                return this.sectionLists.get(string);
            }
            this.sectionNames.add(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            this.sectionLists.put(string, arrayList);
            return arrayList;
        }

        String toRichText() {
            StringBuilder stringBuilder = new StringBuilder("");
            for (String string : this.sectionNames) {
                ArrayList<String> arrayList = this.sectionLists.get(string);
                if (arrayList.isEmpty()) continue;
                stringBuilder.append("<LINE> <LEFT> <SIZE:medium> %s <LINE> <LINE> ".formatted(string));
                for (String string2 : arrayList) {
                    stringBuilder.append(string2);
                }
            }
            return stringBuilder.toString();
        }
    }
}

