/*
 * Decompiled with CFR 0.152.
 */
package zombie.core.Styles;

import java.io.Serializable;

public class FloatList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float[] value;
    private int count = 0;
    private final boolean fastExpand;

    public FloatList() {
        this(0);
    }

    public FloatList(int n) {
        this(true, n);
    }

    public FloatList(boolean bl, int n) {
        this.fastExpand = bl;
        this.value = new float[n];
    }

    public float add(float f) {
        if (this.count == this.value.length) {
            float[] fArray = this.value;
            this.value = this.fastExpand ? new float[(fArray.length << 1) + 1] : new float[fArray.length + 1];
            System.arraycopy(fArray, 0, this.value, 0, fArray.length);
        }
        this.value[this.count] = f;
        return this.count++;
    }

    public float remove(int n) {
        if (n >= this.count || n < 0) {
            throw new IndexOutOfBoundsException("Referenced " + n + ", size=" + this.count);
        }
        float f = this.value[n];
        if (n < this.count - 1) {
            System.arraycopy(this.value, n + 1, this.value, n, this.count - n - 1);
        }
        --this.count;
        return f;
    }

    public void addAll(float[] fArray) {
        this.ensureCapacity(this.count + fArray.length);
        System.arraycopy(fArray, 0, this.value, this.count, fArray.length);
        this.count += fArray.length;
    }

    public void addAll(FloatList floatList) {
        this.ensureCapacity(this.count + floatList.count);
        System.arraycopy(floatList.value, 0, this.value, this.count, floatList.count);
        this.count += floatList.count;
    }

    public float[] array() {
        return this.value;
    }

    public int capacity() {
        return this.value.length;
    }

    public void clear() {
        this.count = 0;
    }

    public void ensureCapacity(int n) {
        if (this.value.length >= n) {
            return;
        }
        float[] fArray = this.value;
        this.value = new float[n];
        System.arraycopy(fArray, 0, this.value, 0, fArray.length);
    }

    public float get(int n) {
        return this.value[n];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public void toArray(Object[] objectArray) {
        System.arraycopy(this.value, 0, objectArray, 0, this.count);
    }

    public void trimToSize() {
        if (this.count == this.value.length) {
            return;
        }
        float[] fArray = this.value;
        this.value = new float[this.count];
        System.arraycopy(fArray, 0, this.value, 0, this.count);
    }
}

