/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import zombie.GameProfiler;
import zombie.asset.Asset;
import zombie.core.Core;
import zombie.core.Styles.AbstractStyle;
import zombie.core.Styles.AdditiveStyle;
import zombie.core.Styles.AlphaOp;
import zombie.core.Styles.LightingStyle;
import zombie.core.Styles.Style;
import zombie.core.Styles.TransparentStyle;
import zombie.core.VBO.GLVertexBufferObject;
import zombie.core.math.PZMath;
import zombie.core.opengl.GLState;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.sprite.SpriteRenderState;
import zombie.core.sprite.SpriteRendererStates;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureAssetManager;
import zombie.core.textures.TextureDraw;
import zombie.core.textures.TextureFBO;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoPuddles;
import zombie.iso.PlayerCamera;
import zombie.util.list.PZArrayUtil;

public final class SpriteRenderer {
    public static final SpriteRenderer instance = new SpriteRenderer();
    static final int VERTEX_SIZE = 32;
    static final int TEXTURE0_COORD_OFFSET = 8;
    static final int TEXTURE1_COORD_OFFSET = 16;
    static final int TEXTURE2_ATTRIB_OFFSET = 24;
    static final int COLOR_OFFSET = 28;
    public static final RingBuffer ringBuffer = new RingBuffer();
    public static final int NUM_RENDER_STATES = 3;
    public final SpriteRendererStates m_states = new SpriteRendererStates();
    private volatile boolean m_waitingForRenderState = false;
    public static boolean GL_BLENDFUNC_ENABLED = true;

    public void create() {
        ringBuffer.create();
    }

    public void clearSprites() {
        this.m_states.getPopulating().clear();
    }

    public void glDepthMask(boolean bl) {
        this.m_states.getPopulatingActiveState().glDepthMask(bl);
    }

    public void renderflipped(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        this.m_states.getPopulatingActiveState().renderflipped(texture, f, f2, f3, f4, f5, f6, f7, f8, consumer);
    }

    public void drawModel(ModelManager.ModelSlot modelSlot) {
        this.m_states.getPopulatingActiveState().drawModel(modelSlot);
    }

    public void drawSkyBox(Shader shader, int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().drawSkyBox(shader, n, n2, n3);
    }

    public void drawWater(Shader shader, int n, int n2, boolean bl) {
        this.m_states.getPopulatingActiveState().drawWater(shader, n, n2, bl);
    }

    public void drawPuddles(Shader shader, int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().drawPuddles(shader, n, n2, n3);
    }

    public void drawParticles(int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().drawParticles(n, n2, n3);
    }

    public void drawGeneric(TextureDraw.GenericDrawer genericDrawer) {
        this.m_states.getPopulatingActiveState().drawGeneric(genericDrawer);
    }

    public void glDisable(int n) {
        this.m_states.getPopulatingActiveState().glDisable(n);
    }

    public void glEnable(int n) {
        this.m_states.getPopulatingActiveState().glEnable(n);
    }

    public void glStencilMask(int n) {
        this.m_states.getPopulatingActiveState().glStencilMask(n);
    }

    public void glClear(int n) {
        this.m_states.getPopulatingActiveState().glClear(n);
    }

    public void glClearColor(int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().glClearColor(n, n2, n3, n4);
    }

    public void glStencilFunc(int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().glStencilFunc(n, n2, n3);
    }

    public void glStencilOp(int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().glStencilOp(n, n2, n3);
    }

    public void glColorMask(int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().glColorMask(n, n2, n3, n4);
    }

    public void glAlphaFunc(int n, float f) {
        this.m_states.getPopulatingActiveState().glAlphaFunc(n, f);
    }

    public void glBlendFunc(int n, int n2) {
        this.m_states.getPopulatingActiveState().glBlendFunc(n, n2);
    }

    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().glBlendFuncSeparate(n, n2, n3, n4);
    }

    public void glBlendEquation(int n) {
        this.m_states.getPopulatingActiveState().glBlendEquation(n);
    }

    public void render(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float f, float f2, float f3, float f4, Consumer<TextureDraw> consumer) {
        this.m_states.getPopulatingActiveState().render(texture, d, d2, d3, d4, d5, d6, d7, d8, f, f2, f3, f4, consumer);
    }

    public void render(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Consumer<TextureDraw> consumer) {
        this.m_states.getPopulatingActiveState().render(texture, d, d2, d3, d4, d5, d6, d7, d8, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, consumer);
    }

    public void renderdebug(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, Consumer<TextureDraw> consumer) {
        this.m_states.getPopulatingActiveState().renderdebug(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24, consumer);
    }

    public void renderline(Texture texture, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, int n5) {
        this.m_states.getPopulatingActiveState().renderline(texture, n, n2, n3, n4, f, f2, f3, f4, n5);
    }

    public void renderline(Texture texture, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        this.m_states.getPopulatingActiveState().renderline(texture, n, n2, n3, n4, f, f2, f3, f4);
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().render(texture, f, f2, f3, f4, f5, f6, f7, f8, n, n2, n3, n4);
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, Consumer<TextureDraw> consumer) {
        float f9 = PZMath.floor(f);
        float f10 = PZMath.floor(f2);
        float f11 = PZMath.ceil(f + f3);
        float f12 = PZMath.ceil(f2 + f4);
        this.m_states.getPopulatingActiveState().render(texture, f9, f10, f11 - f9, f12 - f10, f5, f6, f7, f8, consumer);
    }

    public void renderi(Texture texture, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, Consumer<TextureDraw> consumer) {
        this.m_states.getPopulatingActiveState().render(texture, n, n2, n3, n4, f, f2, f3, f4, consumer);
    }

    public void renderClamped(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float f, float f2, float f3, float f4, Consumer<TextureDraw> consumer) {
        int n9 = PZMath.clamp(n, n5, n5 + n7);
        int n10 = PZMath.clamp(n2, n6, n6 + n8);
        int n11 = PZMath.clamp(n + n3, n5, n5 + n7);
        int n12 = PZMath.clamp(n2 + n4, n6, n6 + n8);
        if (n9 == n11 || n10 == n12) {
            return;
        }
        int n13 = n9 - n;
        int n14 = n + n3 - n11;
        int n15 = n10 - n2;
        int n16 = n2 + n4 - n12;
        if (n13 == 0 && n14 == 0 && n15 == 0 && n16 == 0) {
            this.m_states.getPopulatingActiveState().render(texture, n, n2, n3, n4, f, f2, f3, f4, consumer);
            return;
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 1.0f;
        float f8 = 0.0f;
        float f9 = 1.0f;
        float f10 = 1.0f;
        float f11 = 0.0f;
        float f12 = 1.0f;
        if (texture != null) {
            f5 = (float)n13 / (float)n3;
            f6 = (float)n15 / (float)n4;
            f7 = (float)(n3 - n14) / (float)n3;
            f8 = (float)n15 / (float)n4;
            f9 = (float)(n3 - n14) / (float)n3;
            f10 = (float)(n4 - n16) / (float)n4;
            f11 = (float)n13 / (float)n3;
            f12 = (float)(n4 - n16) / (float)n4;
        }
        n = n9;
        n2 = n10;
        n3 = n11 - n9;
        n4 = n12 - n10;
        this.m_states.getPopulatingActiveState().render(texture, n, n2, n3, n4, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, consumer);
    }

    public void renderRect(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        this.m_states.getPopulatingActiveState().renderRect(n, n2, n3, n4, f, f2, f3, f4);
    }

    public void renderPoly(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.m_states.getPopulatingActiveState().renderPoly(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public void renderPoly(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.m_states.getPopulatingActiveState().renderPoly(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public void renderPoly(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        this.m_states.getPopulatingActiveState().renderPoly(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20);
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m_states.getPopulatingActiveState().render(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, null);
    }

    public void render(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Consumer<TextureDraw> consumer) {
        this.m_states.getPopulatingActiveState().render(texture, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, consumer);
    }

    private static void buildDrawBuffer(TextureDraw[] textureDrawArray, Style[] styleArray, int n, RingBuffer ringBuffer) {
        for (int i = 0; i < n; ++i) {
            TextureDraw textureDraw = textureDrawArray[i];
            Style style = styleArray[i];
            TextureDraw textureDraw2 = null;
            if (i > 0) {
                textureDraw2 = textureDrawArray[i - 1];
            }
            ringBuffer.add(textureDraw, textureDraw2, style);
        }
    }

    public void prePopulating() {
        this.m_states.getPopulating().prePopulating();
    }

    public void postRender() {
        SpriteRenderState spriteRenderState = this.m_states.getRendering();
        if (spriteRenderState.numSprites == 0 && spriteRenderState.stateUI.numSprites == 0) {
            spriteRenderState.onRendered();
            return;
        }
        TextureFBO.reset();
        IsoPuddles.VBOs.startFrame();
        GameProfiler.getInstance().invokeAndMeasure("buildStateUIDrawBuffer(UI)", this, spriteRenderState, SpriteRenderer::buildStateUIDrawBuffer);
        GameProfiler.getInstance().invokeAndMeasure("buildStateDrawBuffer", this, spriteRenderState, SpriteRenderer::buildStateDrawBuffer);
        spriteRenderState.onRendered();
        Core.getInstance().setLastRenderedFBO(spriteRenderState.fbo);
        this.notifyRenderStateQueue();
    }

    protected void buildStateDrawBuffer(SpriteRenderState spriteRenderState) {
        ringBuffer.begin();
        SpriteRenderer.buildDrawBuffer(spriteRenderState.sprite, spriteRenderState.style, spriteRenderState.numSprites, ringBuffer);
        GameProfiler.getInstance().invokeAndMeasure("ringBuffer.render", () -> ringBuffer.render());
    }

    protected void buildStateUIDrawBuffer(SpriteRenderState spriteRenderState) {
        if (spriteRenderState.stateUI.numSprites > 0) {
            ringBuffer.begin();
            spriteRenderState.stateUI.bActive = true;
            SpriteRenderer.buildDrawBuffer(spriteRenderState.stateUI.sprite, spriteRenderState.stateUI.style, spriteRenderState.stateUI.numSprites, ringBuffer);
            ringBuffer.render();
        }
        spriteRenderState.stateUI.bActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRenderStateQueue() {
        SpriteRendererStates spriteRendererStates = this.m_states;
        synchronized (spriteRendererStates) {
            this.m_states.notifyAll();
        }
    }

    public void glBuffer(int n, int n2) {
        this.m_states.getPopulatingActiveState().glBuffer(n, n2);
    }

    public void glDoStartFrame(int n, int n2, float f, int n3) {
        this.m_states.getPopulatingActiveState().glDoStartFrame(n, n2, f, n3);
    }

    public void glDoStartFrame(int n, int n2, float f, int n3, boolean bl) {
        this.m_states.getPopulatingActiveState().glDoStartFrame(n, n2, f, n3, bl);
    }

    public void glDoStartFrameFx(int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().glDoStartFrameFx(n, n2, n3);
    }

    public void glIgnoreStyles(boolean bl) {
        this.m_states.getPopulatingActiveState().glIgnoreStyles(bl);
    }

    public void glDoEndFrame() {
        this.m_states.getPopulatingActiveState().glDoEndFrame();
    }

    public void glDoEndFrameFx(int n) {
        this.m_states.getPopulatingActiveState().glDoEndFrameFx(n);
    }

    public void doCoreIntParam(int n, float f) {
        this.m_states.getPopulatingActiveState().doCoreIntParam(n, f);
    }

    public void glTexParameteri(int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().glTexParameteri(n, n2, n3);
    }

    public void StartShader(int n, int n2) {
        this.m_states.getPopulatingActiveState().StartShader(n, n2);
    }

    public void EndShader() {
        this.m_states.getPopulatingActiveState().EndShader();
    }

    public void setCutawayTexture(Texture texture, int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().setCutawayTexture(texture, n, n2, n3, n4);
    }

    public void clearCutawayTexture() {
        this.m_states.getPopulatingActiveState().clearCutawayTexture();
    }

    public void setUseVertColorsArray(byte by, int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().setUseVertColorsArray(by, n, n2, n3, n4);
    }

    public void clearUseVertColorsArray() {
        this.m_states.getPopulatingActiveState().clearUseVertColorsArray();
    }

    public void setExtraWallShaderParams(WallShaderTexRender wallShaderTexRender) {
        this.m_states.getPopulatingActiveState().setExtraWallShaderParams(wallShaderTexRender);
    }

    public void ShaderUpdate1i(int n, int n2, int n3) {
        this.m_states.getPopulatingActiveState().ShaderUpdate1i(n, n2, n3);
    }

    public void ShaderUpdate1f(int n, int n2, float f) {
        this.m_states.getPopulatingActiveState().ShaderUpdate1f(n, n2, f);
    }

    public void ShaderUpdate2f(int n, int n2, float f, float f2) {
        this.m_states.getPopulatingActiveState().ShaderUpdate2f(n, n2, f, f2);
    }

    public void ShaderUpdate3f(int n, int n2, float f, float f2, float f3) {
        this.m_states.getPopulatingActiveState().ShaderUpdate3f(n, n2, f, f2, f3);
    }

    public void ShaderUpdate4f(int n, int n2, float f, float f2, float f3, float f4) {
        this.m_states.getPopulatingActiveState().ShaderUpdate4f(n, n2, f, f2, f3, f4);
    }

    public void glLoadIdentity() {
        this.m_states.getPopulatingActiveState().glLoadIdentity();
    }

    public void glGenerateMipMaps(int n) {
        this.m_states.getPopulatingActiveState().glGenerateMipMaps(n);
    }

    public void glBind(int n) {
        this.m_states.getPopulatingActiveState().glBind(n);
    }

    public void glViewport(int n, int n2, int n3, int n4) {
        this.m_states.getPopulatingActiveState().glViewport(n, n2, n3, n4);
    }

    public void startOffscreenUI() {
        this.m_states.getPopulating().stateUI.bActive = true;
        this.m_states.getPopulating().stateUI.defaultStyle = TransparentStyle.instance;
        GLState.startFrame();
    }

    public void stopOffscreenUI() {
        this.m_states.getPopulating().stateUI.bActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFrameDown() {
        SpriteRendererStates spriteRendererStates = this.m_states;
        synchronized (spriteRendererStates) {
            this.waitForReadySlotToOpen();
            this.m_states.movePopulatingToReady();
            this.notifyRenderStateQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpriteRenderState acquireStateForRendering(BooleanSupplier booleanSupplier) {
        SpriteRendererStates spriteRendererStates = this.m_states;
        synchronized (spriteRendererStates) {
            if (!this.waitForReadyState(booleanSupplier)) {
                return null;
            }
            this.m_states.moveReadyToRendering();
            this.notifyRenderStateQueue();
            return this.m_states.getRendering();
        }
    }

    private boolean waitForReadyState(BooleanSupplier booleanSupplier) {
        try {
            s_performance.waitForReadyState.start();
            boolean bl = this.waitForReadyStateInternal(booleanSupplier);
            return bl;
        }
        finally {
            s_performance.waitForReadyState.end();
        }
    }

    private boolean waitForReadyStateInternal(BooleanSupplier booleanSupplier) {
        if (!RenderThread.isRunning() || this.m_states.getReady() != null) {
            return true;
        }
        if (!RenderThread.isWaitForRenderState() && !this.isWaitingForRenderState()) {
            return false;
        }
        while (this.m_states.getReady() == null) {
            try {
                if (!booleanSupplier.getAsBoolean()) {
                    return false;
                }
                this.m_states.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    private void waitForReadySlotToOpen() {
        try {
            s_performance.waitForReadySlotToOpen.start();
            this.waitForReadySlotToOpenInternal();
        }
        finally {
            s_performance.waitForReadySlotToOpen.end();
        }
    }

    private void waitForReadySlotToOpenInternal() {
        if (this.m_states.getReady() == null || !RenderThread.isRunning()) {
            return;
        }
        this.m_waitingForRenderState = true;
        while (this.m_states.getReady() != null) {
            try {
                this.m_states.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_waitingForRenderState = false;
    }

    public int getMainStateIndex() {
        return this.m_states.getPopulatingActiveState().index;
    }

    public int getRenderStateIndex() {
        return this.m_states.getRenderingActiveState().index;
    }

    public boolean getDoAdditive() {
        return this.m_states.getPopulatingActiveState().defaultStyle == AdditiveStyle.instance;
    }

    public void setDefaultStyle(AbstractStyle abstractStyle) {
        this.m_states.getPopulatingActiveState().defaultStyle = abstractStyle;
    }

    public void setDoAdditive(boolean bl) {
        this.m_states.getPopulatingActiveState().defaultStyle = bl ? AdditiveStyle.instance : TransparentStyle.instance;
    }

    public void initFromIsoCamera(int n) {
        this.m_states.getPopulating().playerCamera[n].initFromIsoCamera(n);
    }

    public void setRenderingPlayerIndex(int n) {
        this.m_states.getRendering().playerIndex = n;
    }

    public int getRenderingPlayerIndex() {
        return this.m_states.getRendering().playerIndex;
    }

    public PlayerCamera getRenderingPlayerCamera(int n) {
        return this.m_states.getRendering().playerCamera[n];
    }

    public SpriteRenderState getRenderingState() {
        return this.m_states.getRendering();
    }

    public SpriteRenderState getPopulatingState() {
        return this.m_states.getPopulating();
    }

    public boolean isMaxZoomLevel() {
        return this.getPlayerZoomLevel() >= this.getPlayerMaxZoom();
    }

    public boolean isMinZoomLevel() {
        return this.getPlayerZoomLevel() <= this.getPlayerMinZoom();
    }

    public float getPlayerZoomLevel() {
        SpriteRenderState spriteRenderState = this.m_states.getRendering();
        int n = spriteRenderState.playerIndex;
        return spriteRenderState.zoomLevel[n];
    }

    public float getPlayerMaxZoom() {
        SpriteRenderState spriteRenderState = this.m_states.getRendering();
        return spriteRenderState.maxZoomLevel;
    }

    public float getPlayerMinZoom() {
        SpriteRenderState spriteRenderState = this.m_states.getRendering();
        return spriteRenderState.minZoomLevel;
    }

    public boolean isWaitingForRenderState() {
        return this.m_waitingForRenderState;
    }

    public static final class RingBuffer {
        GLVertexBufferObject[] vbo;
        GLVertexBufferObject[] ibo;
        long bufferSize;
        long bufferSizeInVertices;
        long indexBufferSize;
        int numBuffers;
        int sequence = -1;
        int mark = -1;
        FloatBuffer currentVertices;
        ShortBuffer currentIndices;
        FloatBuffer[] vertices;
        ByteBuffer[] verticesBytes;
        ShortBuffer[] indices;
        ByteBuffer[] indicesBytes;
        Texture lastRenderedTexture0;
        Texture currentTexture0;
        Texture lastRenderedTexture1;
        Texture currentTexture1;
        boolean shaderChangedTexture1 = false;
        byte lastUseAttribArray;
        byte currentUseAttribArray;
        Style lastRenderedStyle;
        Style currentStyle;
        StateRun[] stateRun;
        public boolean restoreVBOs;
        public boolean restoreBoundTextures;
        int vertexCursor;
        int indexCursor;
        int numRuns;
        StateRun currentRun;
        public static boolean IGNORE_STYLES = false;

        RingBuffer() {
        }

        void create() {
            int n;
            GL11.glEnableClientState((int)32884);
            GL11.glEnableClientState((int)32886);
            GL11.glEnableClientState((int)32888);
            this.bufferSize = 65536L;
            this.numBuffers = Core.bDebug ? 256 : 128;
            this.bufferSizeInVertices = this.bufferSize / 32L;
            this.indexBufferSize = this.bufferSizeInVertices * 3L;
            this.vertices = new FloatBuffer[this.numBuffers];
            this.verticesBytes = new ByteBuffer[this.numBuffers];
            this.indices = new ShortBuffer[this.numBuffers];
            this.indicesBytes = new ByteBuffer[this.numBuffers];
            this.stateRun = new StateRun[5000];
            for (n = 0; n < 5000; ++n) {
                this.stateRun[n] = new StateRun();
            }
            this.vbo = new GLVertexBufferObject[this.numBuffers];
            this.ibo = new GLVertexBufferObject[this.numBuffers];
            for (n = 0; n < this.numBuffers; ++n) {
                this.vbo[n] = new GLVertexBufferObject(this.bufferSize, GLVertexBufferObject.funcs.GL_ARRAY_BUFFER(), GLVertexBufferObject.funcs.GL_STREAM_DRAW());
                this.vbo[n].create();
                this.ibo[n] = new GLVertexBufferObject(this.indexBufferSize, GLVertexBufferObject.funcs.GL_ELEMENT_ARRAY_BUFFER(), GLVertexBufferObject.funcs.GL_STREAM_DRAW());
                this.ibo[n].create();
            }
        }

        void add(TextureDraw textureDraw, TextureDraw textureDraw2, Style style) {
            if (style == null) {
                return;
            }
            if ((long)(this.vertexCursor + 4) > this.bufferSizeInVertices || (long)(this.indexCursor + 6) > this.indexBufferSize) {
                this.render();
                this.next();
            }
            if (!this.prepareCurrentRun(textureDraw, textureDraw2, style)) {
                return;
            }
            FloatBuffer floatBuffer = this.currentVertices;
            AlphaOp alphaOp = style.getAlphaOp();
            floatBuffer.put(textureDraw.x0);
            floatBuffer.put(textureDraw.y0);
            if (textureDraw.tex == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                if (textureDraw.flipped) {
                    floatBuffer.put(textureDraw.u1);
                } else {
                    floatBuffer.put(textureDraw.u0);
                }
                floatBuffer.put(textureDraw.v0);
            }
            if (textureDraw.tex1 == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                floatBuffer.put(textureDraw.tex1_u0);
                floatBuffer.put(textureDraw.tex1_v0);
            }
            floatBuffer.put(Float.intBitsToFloat(textureDraw.useAttribArray != -1 ? textureDraw.tex1_col0 : 0));
            int n = textureDraw.getColor(0);
            alphaOp.op(n, 255, floatBuffer);
            floatBuffer.put(textureDraw.x1);
            floatBuffer.put(textureDraw.y1);
            if (textureDraw.tex == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                if (textureDraw.flipped) {
                    floatBuffer.put(textureDraw.u0);
                } else {
                    floatBuffer.put(textureDraw.u1);
                }
                floatBuffer.put(textureDraw.v1);
            }
            if (textureDraw.tex1 == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                floatBuffer.put(textureDraw.tex1_u1);
                floatBuffer.put(textureDraw.tex1_v1);
            }
            floatBuffer.put(Float.intBitsToFloat(textureDraw.useAttribArray != -1 ? textureDraw.tex1_col1 : 0));
            n = textureDraw.getColor(1);
            alphaOp.op(n, 255, floatBuffer);
            floatBuffer.put(textureDraw.x2);
            floatBuffer.put(textureDraw.y2);
            if (textureDraw.tex == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                if (textureDraw.flipped) {
                    floatBuffer.put(textureDraw.u3);
                } else {
                    floatBuffer.put(textureDraw.u2);
                }
                floatBuffer.put(textureDraw.v2);
            }
            if (textureDraw.tex1 == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                floatBuffer.put(textureDraw.tex1_u2);
                floatBuffer.put(textureDraw.tex1_v2);
            }
            floatBuffer.put(Float.intBitsToFloat(textureDraw.useAttribArray != -1 ? textureDraw.tex1_col2 : 0));
            n = textureDraw.getColor(2);
            alphaOp.op(n, 255, floatBuffer);
            floatBuffer.put(textureDraw.x3);
            floatBuffer.put(textureDraw.y3);
            if (textureDraw.tex == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                if (textureDraw.flipped) {
                    floatBuffer.put(textureDraw.u2);
                } else {
                    floatBuffer.put(textureDraw.u3);
                }
                floatBuffer.put(textureDraw.v3);
            }
            if (textureDraw.tex1 == null) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
            } else {
                floatBuffer.put(textureDraw.tex1_u3);
                floatBuffer.put(textureDraw.tex1_v3);
            }
            floatBuffer.put(Float.intBitsToFloat(textureDraw.useAttribArray != -1 ? textureDraw.tex1_col3 : 0));
            n = textureDraw.getColor(3);
            alphaOp.op(n, 255, floatBuffer);
            this.currentIndices.put((short)this.vertexCursor);
            this.currentIndices.put((short)(this.vertexCursor + 1));
            this.currentIndices.put((short)(this.vertexCursor + 2));
            this.currentIndices.put((short)this.vertexCursor);
            this.currentIndices.put((short)(this.vertexCursor + 2));
            this.currentIndices.put((short)(this.vertexCursor + 3));
            this.indexCursor += 6;
            this.vertexCursor += 4;
            this.currentRun.endIndex += 6;
            this.currentRun.length += 4;
        }

        private boolean prepareCurrentRun(TextureDraw textureDraw, TextureDraw textureDraw2, Style style) {
            Texture texture = textureDraw.tex;
            Texture texture2 = textureDraw.tex1;
            byte by = textureDraw.useAttribArray;
            if (this.isStateChanged(textureDraw, textureDraw2, style, texture, texture2, by)) {
                this.currentRun = this.stateRun[this.numRuns];
                this.currentRun.start = this.vertexCursor;
                this.currentRun.length = 0;
                this.currentRun.style = style;
                this.currentRun.texture0 = texture;
                this.currentRun.texture1 = texture2;
                this.currentRun.useAttribArray = by;
                this.currentRun.indices = this.currentIndices;
                this.currentRun.startIndex = this.indexCursor;
                this.currentRun.endIndex = this.indexCursor;
                ++this.numRuns;
                if (this.numRuns == this.stateRun.length) {
                    this.growStateRuns();
                }
                this.currentStyle = style;
                this.currentTexture0 = texture;
                this.currentTexture1 = texture2;
                this.currentUseAttribArray = by;
            }
            if (textureDraw.type != TextureDraw.Type.glDraw) {
                this.currentRun.ops.add(textureDraw);
                return false;
            }
            return true;
        }

        private boolean isStateChanged(TextureDraw textureDraw, TextureDraw textureDraw2, Style style, Texture texture, Texture texture2, byte by) {
            if (this.currentRun == null) {
                return true;
            }
            if (textureDraw.type == TextureDraw.Type.DrawModel) {
                return true;
            }
            if (by != this.currentUseAttribArray) {
                return true;
            }
            if (texture != this.currentTexture0) {
                return true;
            }
            if (texture2 != this.currentTexture1) {
                return true;
            }
            if (textureDraw2 != null) {
                if (textureDraw2.type == TextureDraw.Type.DrawModel) {
                    return true;
                }
                if (textureDraw.type == TextureDraw.Type.glDraw && textureDraw2.type != TextureDraw.Type.glDraw) {
                    return true;
                }
                if (textureDraw.type != TextureDraw.Type.glDraw && textureDraw2.type == TextureDraw.Type.glDraw) {
                    return true;
                }
            }
            if (style != this.currentStyle) {
                if (this.currentStyle == null) {
                    return true;
                }
                if (style.getStyleID() != this.currentStyle.getStyleID()) {
                    return true;
                }
            }
            return false;
        }

        private void next() {
            ++this.sequence;
            if (this.sequence == this.numBuffers) {
                this.sequence = 0;
            }
            if (this.sequence == this.mark) {
                DebugLog.General.error("Buffer overrun.");
            }
            this.vbo[this.sequence].bind();
            ByteBuffer byteBuffer = this.vbo[this.sequence].map();
            if (this.vertices[this.sequence] == null || this.verticesBytes[this.sequence] != byteBuffer) {
                this.verticesBytes[this.sequence] = byteBuffer;
                this.vertices[this.sequence] = byteBuffer.asFloatBuffer();
            }
            this.ibo[this.sequence].bind();
            ByteBuffer byteBuffer2 = this.ibo[this.sequence].map();
            if (this.indices[this.sequence] == null || this.indicesBytes[this.sequence] != byteBuffer2) {
                this.indicesBytes[this.sequence] = byteBuffer2;
                this.indices[this.sequence] = byteBuffer2.asShortBuffer();
            }
            this.currentVertices = this.vertices[this.sequence];
            this.currentVertices.clear();
            this.currentIndices = this.indices[this.sequence];
            this.currentIndices.clear();
            this.vertexCursor = 0;
            this.indexCursor = 0;
            this.numRuns = 0;
            this.currentRun = null;
        }

        void begin() {
            this.currentStyle = null;
            this.currentTexture0 = null;
            this.currentTexture1 = null;
            this.currentUseAttribArray = (byte)-1;
            this.next();
            this.mark = this.sequence;
        }

        void render() {
            this.vbo[this.sequence].unmap();
            this.ibo[this.sequence].unmap();
            this.restoreVBOs = true;
            for (int i = 0; i < this.numRuns; ++i) {
                this.stateRun[i].render();
            }
        }

        void growStateRuns() {
            StateRun[] stateRunArray = new StateRun[(int)((float)this.stateRun.length * 1.5f)];
            System.arraycopy(this.stateRun, 0, stateRunArray, 0, this.stateRun.length);
            for (int i = this.numRuns; i < stateRunArray.length; ++i) {
                stateRunArray[i] = new StateRun();
            }
            this.stateRun = stateRunArray;
        }

        public void shaderChangedTexture1() {
            this.shaderChangedTexture1 = true;
        }

        public void checkShaderChangedTexture1() {
            if (this.shaderChangedTexture1) {
                this.shaderChangedTexture1 = false;
                this.lastRenderedTexture1 = null;
                GL13.glActiveTexture((int)33985);
                GL13.glClientActiveTexture((int)33985);
                GL11.glDisable((int)3553);
                GL13.glActiveTexture((int)33984);
                GL13.glClientActiveTexture((int)33984);
            }
        }

        public void debugBoundTexture(Texture texture, int n) {
            if (GL11.glGetInteger((int)34016) == n) {
                int n2 = GL11.glGetInteger((int)32873);
                String string = null;
                if (texture == null && n2 != 0) {
                    for (Asset asset : TextureAssetManager.instance.getAssetTable().values()) {
                        Texture texture2 = (Texture)asset;
                        if (texture2.getID() != n2) continue;
                        string = texture2.getPath().getPath();
                        break;
                    }
                    DebugLog.General.error("SpriteRenderer.lastBoundTexture0=null doesn't match OpenGL texture id=" + n2 + " " + string);
                } else if (texture != null && texture.getID() != -1 && n2 != texture.getID()) {
                    for (Asset asset : TextureAssetManager.instance.getAssetTable().values()) {
                        Texture texture3 = (Texture)asset;
                        if (texture3.getID() != n2) continue;
                        string = texture3.getName();
                        break;
                    }
                    DebugLog.General.error("SpriteRenderer.lastBoundTexture0 id=" + texture.getID() + " doesn't match OpenGL texture id=" + n2 + " " + string);
                }
            }
        }

        private class StateRun {
            Texture texture0;
            Texture texture1;
            byte useAttribArray = (byte)-1;
            Style style;
            int start;
            int length;
            ShortBuffer indices;
            int startIndex;
            int endIndex;
            final ArrayList<TextureDraw> ops = new ArrayList();

            private StateRun() {
            }

            public String toString() {
                String string = System.lineSeparator();
                return this.getClass().getSimpleName() + "{ " + string + "  ops:" + PZArrayUtil.arrayToString(this.ops, "{", "}", ", ") + string + "  texture0:" + this.texture0 + string + "  texture1:" + this.texture1 + string + "  useAttribArray:" + this.useAttribArray + string + "  style:" + this.style + string + "  start:" + this.start + string + "  length:" + this.length + string + "  indices:" + this.indices + string + "  startIndex:" + this.startIndex + string + "  endIndex:" + this.endIndex + string + "}";
            }

            void render() {
                int n;
                if (this.style == null) {
                    return;
                }
                int n2 = this.ops.size();
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        this.ops.get(i).run();
                    }
                    this.ops.clear();
                    return;
                }
                if (this.style != RingBuffer.this.lastRenderedStyle) {
                    if (RingBuffer.this.lastRenderedStyle != null && (!IGNORE_STYLES || RingBuffer.this.lastRenderedStyle != AdditiveStyle.instance && RingBuffer.this.lastRenderedStyle != TransparentStyle.instance && RingBuffer.this.lastRenderedStyle != LightingStyle.instance)) {
                        RingBuffer.this.lastRenderedStyle.resetState();
                    }
                    if (this.style != null && (!IGNORE_STYLES || this.style != AdditiveStyle.instance && this.style != TransparentStyle.instance && this.style != LightingStyle.instance)) {
                        this.style.setupState();
                    }
                    RingBuffer.this.lastRenderedStyle = this.style;
                }
                if (RingBuffer.this.lastRenderedTexture0 != null && RingBuffer.this.lastRenderedTexture0.getID() != Texture.lastTextureID) {
                    RingBuffer.this.restoreBoundTextures = true;
                }
                if (RingBuffer.this.restoreBoundTextures) {
                    Texture.lastTextureID = 0;
                    GL11.glBindTexture((int)3553, (int)0);
                    if (this.texture0 == null) {
                        GL11.glDisable((int)3553);
                    }
                    RingBuffer.this.lastRenderedTexture0 = null;
                    RingBuffer.this.lastRenderedTexture1 = null;
                    RingBuffer.this.restoreBoundTextures = false;
                }
                if (this.texture0 != RingBuffer.this.lastRenderedTexture0) {
                    if (this.texture0 != null) {
                        if (RingBuffer.this.lastRenderedTexture0 == null) {
                            GL11.glEnable((int)3553);
                        }
                        this.texture0.bind();
                    } else {
                        GL11.glDisable((int)3553);
                        Texture.lastTextureID = 0;
                        GL11.glBindTexture((int)3553, (int)0);
                    }
                    RingBuffer.this.lastRenderedTexture0 = this.texture0;
                }
                if (DebugOptions.instance.Checks.BoundTextures.getValue()) {
                    RingBuffer.this.debugBoundTexture(RingBuffer.this.lastRenderedTexture0, 33984);
                }
                if (this.texture1 != RingBuffer.this.lastRenderedTexture1) {
                    GL13.glActiveTexture((int)33985);
                    GL13.glClientActiveTexture((int)33985);
                    if (this.texture1 != null) {
                        GL11.glBindTexture((int)3553, (int)this.texture1.getID());
                    } else {
                        GL11.glDisable((int)3553);
                    }
                    GL13.glActiveTexture((int)33984);
                    GL13.glClientActiveTexture((int)33984);
                    RingBuffer.this.lastRenderedTexture1 = this.texture1;
                }
                if (this.useAttribArray != RingBuffer.this.lastUseAttribArray) {
                    if (this.useAttribArray != -1) {
                        if (this.useAttribArray == 1 && (n = IsoGridSquare.CircleStencilShader.instance.a_wallShadeColor) != -1) {
                            GL20.glEnableVertexAttribArray((int)n);
                        }
                        if (this.useAttribArray == 2 && (n = IsoGridSquare.NoCircleStencilShader.instance.a_wallShadeColor) != -1) {
                            GL20.glEnableVertexAttribArray((int)n);
                        }
                    } else {
                        if (RingBuffer.this.lastUseAttribArray == 1 && (n = IsoGridSquare.CircleStencilShader.instance.a_wallShadeColor) != -1) {
                            GL20.glDisableVertexAttribArray((int)n);
                        }
                        if (RingBuffer.this.lastUseAttribArray == 2 && (n = IsoGridSquare.NoCircleStencilShader.instance.a_wallShadeColor) != -1) {
                            GL20.glDisableVertexAttribArray((int)n);
                        }
                    }
                    RingBuffer.this.lastUseAttribArray = this.useAttribArray;
                }
                if (this.length == 0) {
                    return;
                }
                if (this.length == -1) {
                    RingBuffer.this.restoreVBOs = true;
                    return;
                }
                if (RingBuffer.this.restoreVBOs) {
                    RingBuffer.this.restoreVBOs = false;
                    RingBuffer.this.vbo[RingBuffer.this.sequence].bind();
                    RingBuffer.this.ibo[RingBuffer.this.sequence].bind();
                    GL11.glVertexPointer((int)2, (int)5126, (int)32, (long)0L);
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)8L);
                    GL11.glColorPointer((int)4, (int)5121, (int)32, (long)28L);
                    GL13.glActiveTexture((int)33985);
                    GL13.glClientActiveTexture((int)33985);
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)16L);
                    GL11.glEnableClientState((int)32888);
                    n = IsoGridSquare.CircleStencilShader.instance.a_wallShadeColor;
                    if (n != -1) {
                        GL20.glVertexAttribPointer((int)n, (int)4, (int)5121, (boolean)true, (int)32, (long)24L);
                    }
                    if ((n = IsoGridSquare.NoCircleStencilShader.instance.a_wallShadeColor) != -1) {
                        GL20.glVertexAttribPointer((int)n, (int)4, (int)5121, (boolean)true, (int)32, (long)24L);
                    }
                    GL13.glActiveTexture((int)33984);
                    GL13.glClientActiveTexture((int)33984);
                }
                assert (GL11.glGetInteger((int)34964) == RingBuffer.this.vbo[RingBuffer.this.sequence].getID());
                if (this.useAttribArray == 1) {
                    RingBuffer.this.vbo[RingBuffer.this.sequence].enableVertexAttribArray(IsoGridSquare.CircleStencilShader.instance.a_wallShadeColor);
                    assert (GL20.glGetVertexAttribi((int)IsoGridSquare.CircleStencilShader.instance.a_wallShadeColor, (int)34975) != 0);
                } else if (this.useAttribArray == 2) {
                    RingBuffer.this.vbo[RingBuffer.this.sequence].enableVertexAttribArray(IsoGridSquare.NoCircleStencilShader.instance.a_wallShadeColor);
                } else {
                    RingBuffer.this.vbo[RingBuffer.this.sequence].disableVertexAttribArray();
                }
                if (this.style.getRenderSprite()) {
                    GL12.glDrawRangeElements((int)4, (int)this.start, (int)(this.start + this.length), (int)(this.endIndex - this.startIndex), (int)5123, (long)((long)this.startIndex * 2L));
                } else {
                    this.style.render(this.start, this.startIndex);
                }
            }
        }
    }

    public static enum WallShaderTexRender {
        All,
        LeftOnly,
        RightOnly;

    }

    private static class s_performance {
        private static final PerformanceProfileProbe waitForReadyState = new PerformanceProfileProbe("waitForReadyState");
        private static final PerformanceProfileProbe waitForReadySlotToOpen = new PerformanceProfileProbe("waitForReadySlotToOpen");

        private s_performance() {
        }
    }
}

