/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoWater;
import zombie.ui.UIManager;

public final class PerformanceSettings {
    public static int ManualFrameSkips = 0;
    private static int s_lockFPS = 60;
    private static boolean s_uncappedFPS = false;
    public static int LightingFrameSkip = 0;
    public static int WaterQuality = 0;
    public static int PuddlesQuality = 0;
    public static boolean NewRoofHiding = true;
    public static boolean LightingThread = true;
    public static int LightingFPS = 15;
    public static boolean auto3DZombies = false;
    public static final PerformanceSettings instance = new PerformanceSettings();
    public static boolean InterpolateAnims = true;
    public static int AnimationSkip = 1;
    public static boolean ModelLighting = true;
    public static int ZombieAnimationSpeedFalloffCount = 6;
    public static int ZombieBonusFullspeedFalloff = 3;
    public static int BaseStaticAnimFramerate = 60;
    public static boolean UseFBOs = false;
    public static int numberZombiesBlended = 20;
    public static int FogQuality = 0;

    public static int getLockFPS() {
        return s_lockFPS;
    }

    public static void setLockFPS(int n) {
        s_lockFPS = n;
    }

    public static boolean isUncappedFPS() {
        return s_uncappedFPS;
    }

    public static void setUncappedFPS(boolean bl) {
        s_uncappedFPS = bl;
    }

    public int getFramerate() {
        return PerformanceSettings.getLockFPS();
    }

    public void setFramerate(int n) {
        PerformanceSettings.setLockFPS(n);
    }

    public boolean isFramerateUncapped() {
        return PerformanceSettings.isUncappedFPS();
    }

    public void setFramerateUncapped(boolean bl) {
        PerformanceSettings.setUncappedFPS(bl);
    }

    public void setLightingQuality(int n) {
        LightingFrameSkip = n;
    }

    public int getLightingQuality() {
        return LightingFrameSkip;
    }

    public void setWaterQuality(int n) {
        WaterQuality = n;
        IsoWater.getInstance().applyWaterQuality();
    }

    public int getWaterQuality() {
        return WaterQuality;
    }

    public void setPuddlesQuality(int n) {
        PuddlesQuality = n;
        if (n > 2 || n < 0) {
            PuddlesQuality = 0;
        }
        IsoPuddles.getInstance().applyPuddlesQuality();
    }

    public int getPuddlesQuality() {
        return PuddlesQuality;
    }

    public void setNewRoofHiding(boolean bl) {
        NewRoofHiding = bl;
    }

    public boolean getNewRoofHiding() {
        return NewRoofHiding;
    }

    public void setLightingFPS(int n) {
        LightingFPS = n = Math.max(1, Math.min(120, n));
        System.out.println("LightingFPS set to " + LightingFPS);
    }

    public int getLightingFPS() {
        return LightingFPS;
    }

    public int getUIRenderFPS() {
        return UIManager.useUIFBO ? Core.OptionUIRenderFPS : s_lockFPS;
    }

    public int getFogQuality() {
        return FogQuality;
    }

    public void setFogQuality(int n) {
        FogQuality = PZMath.clamp(n, 0, 2);
    }
}

