/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.core.Language;
import zombie.core.LanguageFile;
import zombie.core.LanguageFileData;
import zombie.core.logger.ExceptionLogger;
import zombie.gameStates.ChooseGameInfo;
import zombie.util.Lambda;
import zombie.util.list.PZArrayUtil;

public final class Languages {
    public static final Languages instance = new Languages();
    private final ArrayList<Language> m_languages = new ArrayList();
    private Language m_defaultLanguage = new Language(0, "EN", "English", "UTF-8", null, false);

    public Languages() {
        this.m_languages.add(this.m_defaultLanguage);
    }

    public void init() {
        this.m_languages.clear();
        this.m_defaultLanguage = new Language(0, "EN", "English", "UTF-8", null, false);
        this.m_languages.add(this.m_defaultLanguage);
        this.loadTranslateDirectory(ZomboidFileSystem.instance.getMediaPath("lua/shared/Translate"));
        for (String string : ZomboidFileSystem.instance.getModIDs()) {
            File file;
            ChooseGameInfo.Mod mod = ChooseGameInfo.getAvailableModDetails(string);
            if (mod == null || !(file = new File(mod.getDir(), "media/lua/shared/Translate")).isDirectory()) continue;
            this.loadTranslateDirectory(file.getAbsolutePath());
        }
    }

    public Language getDefaultLanguage() {
        return this.m_defaultLanguage;
    }

    public int getNumLanguages() {
        return this.m_languages.size();
    }

    public Language getByIndex(int n) {
        if (n >= 0 && n < this.m_languages.size()) {
            return this.m_languages.get(n);
        }
        return null;
    }

    public Language getByName(String string2) {
        return PZArrayUtil.find(this.m_languages, Lambda.predicate(string2, (language, string) -> language.name().equalsIgnoreCase((String)string)));
    }

    public int getIndexByName(String string2) {
        return PZArrayUtil.indexOf(this.m_languages, Lambda.predicate(string2, (language, string) -> language.name().equalsIgnoreCase((String)string)));
    }

    private void loadTranslateDirectory(String string) {
        DirectoryStream.Filter<Path> filter = path -> Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("language.txt"), new LinkOption[0]);
        Path path2 = FileSystems.getDefault().getPath(string, new String[0]);
        if (!Files.exists(path2, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, filter);){
            for (Path path3 : directoryStream) {
                Language language;
                LanguageFileData languageFileData = this.loadLanguageDirectory(path3.toAbsolutePath());
                if (languageFileData == null) continue;
                int n = this.getIndexByName(languageFileData.name);
                if (n == -1) {
                    language = new Language(this.m_languages.size(), languageFileData.name, languageFileData.text, languageFileData.charset, languageFileData.base, languageFileData.azerty);
                    this.m_languages.add(language);
                    continue;
                }
                language = new Language(n, languageFileData.name, languageFileData.text, languageFileData.charset, languageFileData.base, languageFileData.azerty);
                this.m_languages.set(n, language);
                if (!languageFileData.name.equals(this.m_defaultLanguage.name())) continue;
                this.m_defaultLanguage = language;
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    private LanguageFileData loadLanguageDirectory(Path path) {
        String string = path.getFileName().toString();
        LanguageFileData languageFileData = new LanguageFileData();
        languageFileData.name = string;
        LanguageFile languageFile = new LanguageFile();
        String string2 = path.resolve("language.txt").toString();
        if (!languageFile.read(string2, languageFileData)) {
            return null;
        }
        return languageFileData;
    }
}

