/*
 * Decompiled with CFR 0.152.
 */
package zombie.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import zombie.core.LanguageFileData;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.scripting.ScriptParser;
import zombie.util.StringUtils;

public final class LanguageFile {
    private static final int VERSION1 = 1;
    private static final int VERSION = 1;

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean read(String string, LanguageFileData languageFileData) {
        try (FileReader fileReader = new FileReader(string);){
            boolean bl;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(string2);
                    string2 = bufferedReader.readLine();
                }
                this.fromString(stringBuilder.toString(), languageFileData);
                bl = true;
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    private void fromString(String string, LanguageFileData languageFileData) {
        ScriptParser.Value value;
        string = ScriptParser.stripComments(string);
        ScriptParser.Block block = ScriptParser.parse(string);
        int n = -1;
        ScriptParser.Value value2 = block.getValue("VERSION");
        if (value2 != null) {
            n = PZMath.tryParseInt(value2.getValue(), -1);
        }
        if (n < 1 || n > 1) {
            throw new RuntimeException("invalid or missing VERSION");
        }
        ScriptParser.Value value3 = block.getValue("text");
        if (value3 == null || StringUtils.isNullOrWhitespace(value3.getValue())) {
            throw new RuntimeException("missing or empty value \"text\"");
        }
        ScriptParser.Value value4 = block.getValue("charset");
        if (value4 == null || StringUtils.isNullOrWhitespace(value4.getValue())) {
            throw new RuntimeException("missing or empty value \"charset\"");
        }
        languageFileData.text = value3.getValue().trim();
        languageFileData.charset = value4.getValue().trim();
        ScriptParser.Value value5 = block.getValue("base");
        if (value5 != null && !StringUtils.isNullOrWhitespace(value5.getValue())) {
            languageFileData.base = value5.getValue().trim();
        }
        if ((value = block.getValue("azerty")) != null) {
            languageFileData.azerty = StringUtils.tryParseBoolean(value.getValue());
        }
    }
}

